/*
 * Decompiled with CFR 0.152.
 */
package bloop.tracing;

import bloop.tracing.BraveTracer;
import bloop.tracing.TraceProperties;
import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public final class BraveTracer$ {
    public static BraveTracer$ MODULE$;
    private final ConcurrentHashMap<String, AsyncReporter<zipkin2.Span>> reporterCache;

    static {
        new BraveTracer$();
    }

    private ConcurrentHashMap<String, AsyncReporter<zipkin2.Span>> reporterCache() {
        return this.reporterCache;
    }

    private AsyncReporter<zipkin2.Span> reporterFor(String url2) {
        return this.reporterCache().computeIfAbsent(url2, url -> BraveTracer$.newReporter$1(url));
    }

    public BraveTracer apply(String name, TraceProperties properties, Seq<Tuple2<String, String>> tags) {
        return this.apply(name, properties, (Option<TraceContext>)None$.MODULE$, tags);
    }

    public BraveTracer apply(String name, TraceProperties properties, Option<TraceContext> ctx, Seq<Tuple2<String, String>> tags) {
        String url = properties.serverUrl();
        AsyncReporter<zipkin2.Span> spanReporter = this.reporterFor(url);
        Tracing tracing = Tracing.newBuilder().localServiceName(properties.localServiceName()).spanReporter(spanReporter).build();
        Tracer tracer = tracing.tracer();
        Span newParentTrace = (Span)ctx.map((Function1 & Serializable & scala.Serializable)c -> tracer.newChild(c)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (properties.debugTracing()) {
                return tracer.nextSpan(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.DEBUG));
            }
            return tracer.newTrace();
        });
        Span rootSpan = (Span)tags.foldLeft((Object)newParentTrace.name(name), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Span span = (Span)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String tagKey = (String)tuple22._1();
                    String tagValue = (String)tuple22._2();
                    return span.tag(tagKey, tagValue);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        rootSpan.start();
        properties.traceStartAnnotation().foreach((Function1 & Serializable & scala.Serializable)x$1 -> rootSpan.annotate(x$1));
        JFunction0.mcV.sp & Serializable & scala.Serializable closeEverything = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            properties.traceEndAnnotation().foreach((Function1 & Serializable & scala.Serializable)x$1 -> rootSpan.annotate(x$1));
            rootSpan.finish();
            tracing.close();
            spanReporter.flush();
        };
        return new BraveTracer(tracer, rootSpan, (Function0<BoxedUnit>)closeEverything, properties);
    }

    private static final AsyncReporter newReporter$1(String url) {
        URLConnectionSender sender = URLConnectionSender.create((String)url);
        SpanBytesEncoder jsonVersion = url.contains("/api/v1") ? SpanBytesEncoder.JSON_V1 : SpanBytesEncoder.JSON_V2;
        return AsyncReporter.builder((Sender)sender).build((BytesEncoder)jsonVersion);
    }

    private BraveTracer$() {
        MODULE$ = this;
        this.reporterCache = new ConcurrentHashMap();
    }
}

