/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.DependencyResolution;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import coursierapi.Dependency;
import coursierapi.Fetch;
import coursierapi.Module;
import coursierapi.Repository;
import coursierapi.error.CoursierError;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public final class DependencyResolution$ {
    public static DependencyResolution$ MODULE$;

    static {
        new DependencyResolution$();
    }

    public Path[] resolve(List<DependencyResolution.Artifact> artifacts, Logger logger, boolean resolveSources, Seq<Repository> additionalRepos) {
        Either<CoursierError, Path[]> either = this.resolveWithErrors(artifacts, logger, resolveSources, additionalRepos);
        if (either instanceof Right) {
            Right right = (Right)either;
            AbsolutePath[] paths = (AbsolutePath[])right.value();
            return paths;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            CoursierError error = (CoursierError)left.value();
            throw error;
        }
        throw new MatchError(either);
    }

    public boolean resolve$default$3() {
        return false;
    }

    public Seq<Repository> resolve$default$4() {
        return Nil$.MODULE$;
    }

    public Either<CoursierError, Path[]> resolveWithErrors(List<DependencyResolution.Artifact> artifacts, Logger logger, boolean resolveSources, Seq<Repository> additionalRepositories) {
        List dependencies = (List)artifacts.map((Function1 & Serializable & scala.Serializable)artifact -> {
            logger.debug(new java.lang.StringBuilder(12).append("Resolving ").append(artifact.organization()).append(":").append(artifact.module()).append(":").append(artifact.version()).toString(), (DebugFilter)DebugFilter.All$.MODULE$);
            Dependency baseDep = Dependency.of((String)artifact.organization(), (String)artifact.module(), (String)artifact.version());
            if (resolveSources) {
                return baseDep.withClassifier("sources");
            }
            return baseDep;
        }, List$.MODULE$.canBuildFrom());
        return this.resolveDependenciesWithErrors((Seq<Dependency>)dependencies, resolveSources, additionalRepositories, logger);
    }

    public boolean resolveWithErrors$default$3() {
        return false;
    }

    public Seq<Repository> resolveWithErrors$default$4() {
        return Nil$.MODULE$;
    }

    public Either<CoursierError, Path[]> resolveDependenciesWithErrors(Seq<Dependency> dependencies, boolean resolveSources, Seq<Repository> additionalRepositories, Logger logger) {
        Left left;
        block3: {
            Fetch fetch = Fetch.create().withDependencies((Dependency[])dependencies.toArray(ClassTag$.MODULE$.apply(Dependency.class)));
            Object object = resolveSources ? fetch.addArtifactTypes(new String[]{"src", "jar"}) : BoxedUnit.UNIT;
            fetch.addRepositories((Repository[])additionalRepositories.toArray(ClassTag$.MODULE$.apply(Repository.class)));
            try {
                left = package$.MODULE$.Right().apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(fetch.fetch()).asScala()).toArray(ClassTag$.MODULE$.apply(File.class)))).map((Function1 & Serializable & scala.Serializable)f -> new AbsolutePath(AbsolutePath$.MODULE$.apply(f.toPath(), AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class))));
            }
            catch (CoursierError error) {
                Seq fallbackJars = (Seq)dependencies.flatMap((Function1 & Serializable & scala.Serializable)dep -> MODULE$.fallbackDownload((Dependency)dep, logger), Seq$.MODULE$.canBuildFrom());
                if (fallbackJars.nonEmpty()) {
                    left = package$.MODULE$.Right().apply(((TraversableOnce)fallbackJars.map((Function1 & Serializable & scala.Serializable)x$1 -> new AbsolutePath(AbsolutePath$.MODULE$.apply(x$1, AbsolutePath$.MODULE$.workingDirectory())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)));
                    break block3;
                }
                left = package$.MODULE$.Left().apply((Object)error);
            }
        }
        return left;
    }

    public boolean resolveDependenciesWithErrors$default$2() {
        return false;
    }

    public Seq<Repository> resolveDependenciesWithErrors$default$3() {
        return Nil$.MODULE$;
    }

    public String majorMinorVersion(String version) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(version)).reverse())).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DependencyResolution$.$anonfun$majorMinorVersion$1(BoxesRunTime.unboxToChar((Object)x$2)))))).tail())).reverse();
    }

    public List<Path> fallbackDownload(Dependency dependency, Logger logger) {
        Path userHome = Paths.get(Properties$.MODULE$.userHome(), new String[0]);
        Option option = this.findInPath("cs").orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.findInPath("coursier")).orElse((Function0 & Serializable & scala.Serializable)() -> DependencyResolution$.inVsCodeMetals$1(userHome));
        if (None$.MODULE$.equals(option)) {
            return Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Path path = (Path)some.value();
            logger.debug(new java.lang.StringBuilder(59).append("Found coursier in path under ").append(path).append(", using it to fetch dependency").toString(), (DebugFilter)DebugFilter.All$.MODULE$);
            Module module = dependency.getModule();
            String depString = new java.lang.StringBuilder(2).append(module.getOrganization()).append(":").append(module.getName()).append(":").append(dependency.getVersion()).toString();
            Option<String> option2 = this.runSync((List<String>)new .colon.colon((Object)((Object)path).toString(), (List)new .colon.colon((Object)"fetch", (List)new .colon.colon((Object)depString, (List)Nil$.MODULE$))), AbsolutePath$.MODULE$.apply(userHome, AbsolutePath$.MODULE$.workingDirectory()));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String out = (String)some2.value();
                List lines = new StringOps(Predef$.MODULE$.augmentString(out)).linesIterator().toList();
                List jars = (List)lines.map((Function1 & Serializable & scala.Serializable)x$3 -> Paths.get(x$3, new String[0]), List$.MODULE$.canBuildFrom());
                return jars;
            }
            if (None$.MODULE$.equals(option2)) {
                return Nil$.MODULE$;
            }
            throw new MatchError(option2);
        }
        throw new MatchError((Object)option);
    }

    private Option<Path> findInPath(String app) {
        Path asIs = Paths.get(app, new String[0]);
        if (Paths.get(app, new String[0]).getNameCount() >= 2) {
            return new Some((Object)asIs);
        }
        return DependencyResolution$.matches$1(app).toStream().headOption();
    }

    private Option<String> runSync(List<String> command, Path workingDirectory) {
        None$ none$;
        block4: {
            try {
                ProcessBuilder pb = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class)));
                pb.directory(workingDirectory.toFile());
                Process process = pb.start();
                InputStream is = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder output = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append(System.lineSeparator());
                }
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    none$ = new Some((Object)output.toString());
                    break block4;
                }
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$majorMinorVersion$1(char x$2) {
        return x$2 != '.';
    }

    private static final Option inVsCodeMetals$1(Path userHome$1) {
        Path cs = userHome$1.resolve(".metals/cs");
        Path csExe = userHome$1.resolve(".metals/cs.exe");
        if (Files.exists(cs, new LinkOption[0])) {
            return new Some((Object)cs);
        }
        if (Files.exists(csExe, new LinkOption[0])) {
            return new Some((Object)csExe);
        }
        return None$.MODULE$;
    }

    private static final boolean endsWithCaseInsensitive$1(String s, String suffix) {
        return s.length() >= suffix.length() && s.regionMatches(true, s.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static final Iterator pathEntries$1() {
        return Option$.MODULE$.apply((Object)System.getenv("PATH")).iterator().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4.split(File.pathSeparator))).iterator());
    }

    private static final Iterator pathExts$1() {
        if (Properties$.MODULE$.isWin()) {
            return Option$.MODULE$.apply((Object)System.getenv("PATHEXT")).iterator().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5.split(File.pathSeparator))).iterator());
        }
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
    }

    public static final /* synthetic */ boolean $anonfun$findInPath$5(Tuple3 x$6) {
        Tuple3 tuple3 = x$6;
        if (tuple3 != null) {
            Path path = (Path)tuple3._3();
            return Files.isExecutable(path) && !Files.isDirectory(path, new LinkOption[0]);
        }
        throw new MatchError((Object)tuple3);
    }

    private static final Iterator matches$1(String app$1) {
        return DependencyResolution$.pathEntries$1().flatMap((Function1 & Serializable & scala.Serializable)dir -> DependencyResolution$.pathExts$1().map((Function1 & Serializable & scala.Serializable)ext -> {
            String app0 = DependencyResolution$.endsWithCaseInsensitive$1(app$1, ext) ? app$1 : new java.lang.StringBuilder(0).append(app$1).append((String)ext).toString();
            Path path = Paths.get(dir, new String[0]).resolve(app0);
            return new Tuple3(ext, (Object)app0, (Object)path);
        }).withFilter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DependencyResolution$.$anonfun$findInPath$5(x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple3 tuple3 = x$7;
            if (tuple3 != null) {
                Path path = (Path)tuple3._3();
                return path;
            }
            throw new MatchError((Object)tuple3);
        }));
    }

    private DependencyResolution$() {
        MODULE$ = this;
    }
}

