/*
 * Decompiled with CFR 0.152.
 */
package bloop.util;

import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.util.JavaRuntime;
import bloop.util.JavaRuntime$JDK$;
import bloop.util.JavaRuntime$JRE$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Try;
import scala.util.Try$;

public final class JavaRuntime$ {
    public static JavaRuntime$ MODULE$;
    private Try<BoxedUnit> loadJavaDebugInterface;
    private final Path home;
    private final String version;
    private final Option<AbsolutePath> javac;
    private final TrieMap<AbsolutePath, Option<String>> versions;
    private volatile boolean bitmap$0;

    static {
        new JavaRuntime$();
    }

    public Path home() {
        return this.home;
    }

    public String version() {
        return this.version;
    }

    public Option<AbsolutePath> javac() {
        return this.javac;
    }

    private TrieMap<AbsolutePath, Option<String>> versions() {
        return this.versions;
    }

    public Option<JavaCompiler> javaCompiler() {
        return Option$.MODULE$.apply((Object)ToolProvider.getSystemJavaCompiler());
    }

    public Option<String> getJavaVersionFromJavaHome(Path javaHome) {
        return (Option)this.versions().getOrElseUpdate((Object)new AbsolutePath(javaHome), (Function0 & Serializable & scala.Serializable)() -> {
            Path releaseFile = AbsolutePath$.MODULE$.resolve$extension1(javaHome, "release");
            if (AbsolutePath$.MODULE$.exists$extension(releaseFile)) {
                Some some;
                Config properties = ConfigFactory.parseFile((File)AbsolutePath$.MODULE$.toFile$extension(releaseFile), (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.PROPERTIES));
                try {
                    some = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(properties.getString("JAVA_VERSION"))).stripPrefix("\""))).stripSuffix("\""));
                }
                catch (ConfigException configException) {
                    some = None$.MODULE$;
                }
                return some;
            }
            if (AbsolutePath$.MODULE$.exists$extension(JavaRuntime$.rtJar$1(javaHome))) {
                return new Some((Object)"1.8");
            }
            return None$.MODULE$;
        });
    }

    public JavaRuntime current() {
        Option<JavaCompiler> option = this.javaCompiler();
        if (option instanceof Some) {
            return JavaRuntime$JDK$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return JavaRuntime$JRE$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<AbsolutePath> javacBinaryFromJavaHome(Path home) {
        String binaryName;
        String string = binaryName = Properties$.MODULE$.isWin() ? "javac.exe" : "javac";
        if (!AbsolutePath$.MODULE$.exists$extension(home)) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)new AbsolutePath(JavaRuntime$.toJavaBinary$1(home, binaryName))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbsolutePath$.MODULE$.exists$extension(((AbsolutePath)x$1).underlying()))).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)new AbsolutePath(JavaRuntime$.toJavaBinary$1(AbsolutePath$.MODULE$.getParent$extension(home), binaryName)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbsolutePath$.MODULE$.exists$extension(((AbsolutePath)x$2).underlying())));
    }

    private Try<BoxedUnit> loadJavaDebugInterface$lzycompute() {
        JavaRuntime$ javaRuntime$ = this;
        synchronized (javaRuntime$) {
            if (!this.bitmap$0) {
                this.loadJavaDebugInterface = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JavaRuntime$.initializeJDI$1()).orElse((Function0 & Serializable & scala.Serializable)() -> JavaRuntime$.loadTools$1()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                    JavaRuntime$.$anonfun$loadJavaDebugInterface$5(x$4);
                    return BoxedUnit.UNIT;
                });
                this.bitmap$0 = true;
            }
        }
        return this.loadJavaDebugInterface;
    }

    public Try<BoxedUnit> loadJavaDebugInterface() {
        if (!this.bitmap$0) {
            return this.loadJavaDebugInterface$lzycompute();
        }
        return this.loadJavaDebugInterface;
    }

    private static final Path rtJar$1(Path javaHome$1) {
        return AbsolutePath$.MODULE$.resolve$extension1(AbsolutePath$.MODULE$.resolve$extension1(javaHome$1, "lib"), "rt.jar");
    }

    private static final Path toJavaBinary$1(Path home, String binaryName$1) {
        return AbsolutePath$.MODULE$.resolve$extension1(AbsolutePath$.MODULE$.resolve$extension1(home, "bin"), binaryName$1);
    }

    private static final void initializeJDI$1() {
        Class.forName("com.sun.jdi.Value");
    }

    private static final Try loadTools$1() {
        Option urls = Option$.MODULE$.apply((Object)ToolProvider.getSystemToolClassLoader()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ClassLoader, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof URLClassLoader) {
                    URLClassLoader uRLClassLoader = (URLClassLoader)A1;
                    return (B1)uRLClassLoader.getURLs();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ClassLoader x1) {
                ClassLoader classLoader = x1;
                return classLoader instanceof URLClassLoader;
            }
        });
        Option option = urls;
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)new Exception("JDI implementation is not provided by the vendor"));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            URL[] urls2 = (URL[])some.value();
            Try hotLoadTools = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])urls2)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> method.invoke((Object)MODULE$.getClass().getClassLoader(), x$3));
                JavaRuntime$.initializeJDI$1();
            });
            return hotLoadTools.recoverWith((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof ClassNotFoundException) {
                        ClassNotFoundException classNotFoundException = (ClassNotFoundException)A1;
                        return (B1)new Failure((Throwable)new Exception("JDI implementation is not on the classpath", classNotFoundException));
                    }
                    if (A1 instanceof ReflectiveOperationException) {
                        ReflectiveOperationException reflectiveOperationException = (ReflectiveOperationException)A1;
                        return (B1)new Failure((Throwable)new Exception(new StringBuilder(29).append("Could not load tools due to: ").append(reflectiveOperationException.getMessage()).toString(), reflectiveOperationException));
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    if (throwable instanceof ClassNotFoundException) {
                        return true;
                    }
                    return throwable instanceof ReflectiveOperationException;
                }
            });
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$loadJavaDebugInterface$5(BoxedUnit x$4) {
    }

    private JavaRuntime$() {
        MODULE$ = this;
        this.home = AbsolutePath$.MODULE$.apply((String)package$.MODULE$.props().apply((Object)"java.home"), AbsolutePath$.MODULE$.workingDirectory());
        this.version = (String)package$.MODULE$.props().apply((Object)"java.version");
        this.javac = this.javacBinaryFromJavaHome(this.home());
        this.versions = TrieMap$.MODULE$.empty();
    }
}

