/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.bloop.internal;

import bloop.logging.ObservedLogger;
import bloop.logging.TeeOutputStream;
import bloop.reporter.ZincReporter;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.tracing.BraveTracer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.CompileFailed;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.PlainVirtualFileConverter$;
import sbt.internal.inc.bloop.internal.BloopHighLevelCompiler$;
import sbt.internal.inc.javac.AnalyzingJavaCompiler;
import sbt.io.IO$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.control.NonFatal$;
import xsbt.InterfaceCompileCancelled;
import xsbti.AnalysisCallback;
import xsbti.FileConverter;
import xsbti.Problem;
import xsbti.VirtualFile;
import xsbti.compile.ClassFileManager;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.CompileOrder;
import xsbti.compile.DependencyChanges;
import xsbti.compile.IncToolOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.MultipleOutput;
import xsbti.compile.Output;
import xsbti.compile.SingleOutput;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\t\u0012\u0005mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!A\u0004A!A!\u0002\u0013I\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000bI\u0003A\u0011A*\t\r\u0001\u0004\u0001\u0015!\u0004b\u0011\u0019I\u0007\u0001)A\u0007U\"1!\u0010\u0001Q\u0001\nmDa\u0001\u001a\u0001\u0005\u0002\u0005%qaBA'#!\u0005\u0011q\n\u0004\u0007!EA\t!!\u0015\t\rIkA\u0011AA*\u0011\u001d\t)&\u0004C\u0001\u0003/\u0012aC\u00117p_BD\u0015n\u001a5MKZ,GnQ8na&dWM\u001d\u0006\u0003%M\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003)U\tQA\u00197p_BT!AF\f\u0002\u0007%t7M\u0003\u0002\u00131)\t\u0011$A\u0002tER\u001c\u0001a\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\faa]2bY\u0006\u001c\u0007C\u0001\u0013&\u001b\u0005)\u0012B\u0001\u0014\u0016\u0005E\te.\u00197zu&twmQ8na&dWM]\u0001\u0006U\u00064\u0018m\u0019\t\u0003S-j\u0011A\u000b\u0006\u0003OUI!\u0001\f\u0016\u0003+\u0005s\u0017\r\\={S:<'*\u0019<b\u0007>l\u0007/\u001b7fe\u000611m\u001c8gS\u001e\u0004\"\u0001J\u0018\n\u0005A*\"\u0001F\"p[BLG.Z\"p]\u001aLw-\u001e:bi&|g.\u0001\u0005sKB|'\u000f^3s!\t\u0019d'D\u00015\u0015\t\tTGC\u0001\u0015\u0013\t9DG\u0001\u0007[S:\u001c'+\u001a9peR,'/\u0001\u0004m_\u001e<WM\u001d\u0019\u0003u\t\u00032a\u000f A\u001b\u0005a$BA\u001f6\u0003\u001dawnZ4j]\u001eL!a\u0010\u001f\u0003\u001d=\u00137/\u001a:wK\u0012dunZ4feB\u0011\u0011I\u0011\u0007\u0001\t%\u0019U!!A\u0001\u0002\u000b\u0005AIA\u0002`IE\n\"!\u0012%\u0011\u0005u1\u0015BA$\u001f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!H%\n\u0005)s\"aA!os\u00061AO]1dKJ\u0004\"!\u0014)\u000e\u00039S!aT\u001b\u0002\u000fQ\u0014\u0018mY5oO&\u0011\u0011K\u0014\u0002\f\u0005J\fg/\u001a+sC\u000e,'/\u0001\u0004=S:LGO\u0010\u000b\b)Z;\u0006,\u0017.`!\t)\u0006!D\u0001\u0012\u0011\u0015\u0011s\u00011\u0001$\u0011\u00159s\u00011\u0001)\u0011\u0015is\u00011\u0001/\u0011\u0015\tt\u00011\u00013\u0011\u0015At\u00011\u0001\\a\taf\fE\u0002<}u\u0003\"!\u00110\u0005\u0013\rS\u0016\u0011!A\u0001\u0006\u0003!\u0005\"B&\b\u0001\u0004a\u0015!B:fiV\u0004\bC\u00012h\u001b\u0005\u0019'B\u00013f\u0003\u001d\u0019w.\u001c9jY\u0016T\u0011AZ\u0001\u0006qN\u0014G/[\u0005\u0003Q\u000e\u0014\u0011\"T5oSN+G/\u001e9\u0002\u0013\rd\u0017m]:qCRD\u0007cA6tm:\u0011A.\u001d\b\u0003[Bl\u0011A\u001c\u0006\u0003_j\ta\u0001\u0010:p_Rt\u0014\"A\u0010\n\u0005It\u0012a\u00029bG.\fw-Z\u0005\u0003iV\u00141aU3r\u0015\t\u0011h\u0004\u0005\u0002xq6\tQ-\u0003\u0002zK\nYa+\u001b:uk\u0006dg)\u001b7f\u00035Q\u0015M^1D_6\u0004H.\u001a;fIB!Ap`A\u0002\u001b\u0005i(B\u0001@\u001f\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0004\u0003\u0003i(a\u0002)s_6L7/\u001a\t\u0004;\u0005\u0015\u0011bAA\u0004=\t!QK\\5u)1\tY!a\u0006\u0002,\u0005U\u0012qHA%!\u0019\ti!a\u0005\u0002\u00045\u0011\u0011q\u0002\u0006\u0004\u0003#)\u0014\u0001\u0002;bg.LA!!\u0006\u0002\u0010\t!A+Y:l\u0011\u001d\tIb\u0003a\u0001\u00037\t\u0001c]8ve\u000e,7\u000fV8D_6\u0004\u0018\u000e\\3\u0011\u000b\u0005u\u0011Q\u0005<\u000f\t\u0005}\u0011\u0011\u0005\t\u0003[zI1!a\t\u001f\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\r\u0019V\r\u001e\u0006\u0004\u0003Gq\u0002bBA\u0017\u0017\u0001\u0007\u0011qF\u0001\bG\"\fgnZ3t!\r\u0011\u0017\u0011G\u0005\u0004\u0003g\u0019'!\u0005#fa\u0016tG-\u001a8ds\u000eC\u0017M\\4fg\"9\u0011qG\u0006A\u0002\u0005e\u0012\u0001C2bY2\u0014\u0017mY6\u0011\u0007]\fY$C\u0002\u0002>\u0015\u0014\u0001#\u00118bYf\u001c\u0018n]\"bY2\u0014\u0017mY6\t\u000f\u0005\u00053\u00021\u0001\u0002D\u0005\u00012\r\\1tg\u001aLG.Z'b]\u0006<WM\u001d\t\u0004E\u0006\u0015\u0013bAA$G\n\u00012\t\\1tg\u001aKG.Z'b]\u0006<WM\u001d\u0005\u0007\u0003\u0017Z\u0001\u0019A>\u0002\u001b\r\fgnY3m!J|W.[:f\u0003Y\u0011En\\8q\u0011&<\u0007\u000eT3wK2\u001cu.\u001c9jY\u0016\u0014\bCA+\u000e'\tiA\u0004\u0006\u0002\u0002P\u0005)\u0011\r\u001d9msRYA+!\u0017\u0002\\\u0005u\u0013\u0011NA6\u0011\u0015is\u00021\u0001/\u0011\u0015\tt\u00021\u00013\u0011\u0019At\u00021\u0001\u0002`A\"\u0011\u0011MA3!\u0011Yd(a\u0019\u0011\u0007\u0005\u000b)\u0007B\u0006\u0002h\u0005u\u0013\u0011!A\u0001\u0006\u0003!%aA0%e!)1j\u0004a\u0001\u0019\"9\u0011QN\bA\u0002\u0005=\u0014\u0001E2mCN\u001c\b/\u0019;i\u001fB$\u0018n\u001c8t!\r\u0011\u0017\u0011O\u0005\u0004\u0003g\u001a'\u0001E\"mCN\u001c\b/\u0019;i\u001fB$\u0018n\u001c8t\u0001")
public final class BloopHighLevelCompiler {
    private final AnalyzingCompiler scalac;
    private final AnalyzingJavaCompiler javac;
    private final CompileConfiguration config;
    private final ZincReporter reporter;
    private final ObservedLogger<?> logger;
    private final BraveTracer tracer;
    private final MiniSetup setup;
    private final Seq<VirtualFile> classpath;
    private final Promise<BoxedUnit> JavaCompleted;

    public static BloopHighLevelCompiler apply(CompileConfiguration compileConfiguration, ZincReporter zincReporter, ObservedLogger<?> observedLogger, BraveTracer braveTracer, ClasspathOptions classpathOptions) {
        return BloopHighLevelCompiler$.MODULE$.apply(compileConfiguration, zincReporter, observedLogger, braveTracer, classpathOptions);
    }

    public Task<BoxedUnit> compile(Set<VirtualFile> sourcesToCompile, DependencyChanges changes, AnalysisCallback callback, ClassFileManager classfileManager, Promise<BoxedUnit> cancelPromise) {
        Task task;
        boolean existsCompilation;
        .colon.colon colon2;
        Output output = this.setup.output();
        if (output instanceof SingleOutput) {
            SingleOutput singleOutput = (SingleOutput)output;
            colon2 = new .colon.colon((Object)singleOutput.getOutputDirectoryAsPath(), (List)Nil$.MODULE$);
        } else if (output instanceof MultipleOutput) {
            MultipleOutput multipleOutput = (MultipleOutput)output;
            colon2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])multipleOutput.getOutputGroups())).iterator().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getOutputDirectoryAsPath()).toList();
        } else {
            throw new MatchError((Object)output);
        }
        .colon.colon outputDirs = colon2;
        outputDirs.foreach((Function1 & Serializable & scala.Serializable)d -> {
            BloopHighLevelCompiler.$anonfun$compile$3(d);
            return BoxedUnit.UNIT;
        });
        Seq includedSources = (Seq)this.config.sources().filter(sourcesToCompile);
        Tuple2 tuple2 = includedSources.partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BloopHighLevelCompiler.$anonfun$compile$4(x$3)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq javaSources = (Seq)tuple2._1();
        Seq scalaSources = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)javaSources, (Object)scalaSources);
        Seq javaSources2 = (Seq)tuple22._1();
        Seq scalaSources2 = (Seq)tuple22._2();
        boolean bl = existsCompilation = javaSources2.size() + scalaSources2.size() > 0;
        if (existsCompilation) {
            this.reporter.reportStartIncrementalCycle((Seq<VirtualFile>)includedSources, (Seq<File>)((Seq)outputDirs.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toFile(), List$.MODULE$.canBuildFrom())));
        }
        Object object = javaSources2.isEmpty() && !this.JavaCompleted.isCompleted() ? BoxesRunTime.boxToBoolean((boolean)this.JavaCompleted.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
        if (scalaSources2.isEmpty()) {
            task = Task$.MODULE$.now(BoxedUnit.UNIT);
        } else {
            CompileOrder compileOrder = this.setup.order();
            CompileOrder compileOrder2 = CompileOrder.Mixed;
            Seq sources = !(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null) ? includedSources : scalaSources2;
            task = this.compileSequentially$1(sources, callback, changes, cancelPromise);
        }
        Task compileScala = task;
        Task compileJava = Task$.MODULE$.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timed$1("javac", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IncToolOptions incToolOptions = IncToolOptions.of(Optional.of(classfileManager), (boolean)$this.config.incOptions().useCustomizedFileManager());
            String[] javaOptions = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.setup.options().javacOptions())).toArray(ClassTag$.MODULE$.apply(String.class));
            try {
                $this.javac.compile(javaSources2, (Seq)Nil$.MODULE$, (FileConverter)PlainVirtualFileConverter$.MODULE$.converter(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])javaOptions), $this.setup.output(), (Option)None$.MODULE$, callback, incToolOptions, $this.config.reporter(), $this.logger, $this.config.progress());
                $this.JavaCompleted.trySuccess((Object)BoxedUnit.UNIT);
            }
            catch (xsbti.CompileFailed f) {
                $this.config.reporter().printSummary();
                $this.JavaCompleted.tryFailure((Throwable)f);
                throw f;
            }
        }));
        CompileOrder compileOrder = this.setup.order();
        CompileOrder compileOrder3 = CompileOrder.JavaThenScala;
        Task combinedTasks = !(compileOrder != null ? !compileOrder.equals(compileOrder3) : compileOrder3 != null) ? compileJava.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> compileScala) : compileScala.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> compileJava);
        return Task$.MODULE$.apply((JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.nanoTime()).flatMap((Function1 & Serializable & scala.Serializable)nanoStart -> BloopHighLevelCompiler.$anonfun$compile$15(this, combinedTasks, existsCompilation, BoxesRunTime.unboxToLong((Object)nanoStart))).dematerialize(Predef$.MODULE$.$conforms());
    }

    private final Object timed$1(String label, Function0 t) {
        return this.tracer.trace(label, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$1 -> t.apply());
    }

    public static final /* synthetic */ void $anonfun$compile$3(Path d) {
        if (!d.endsWith(".jar") && !Files.exists(d, new LinkOption[0])) {
            IO$.MODULE$.createDirectory(d.toFile());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$compile$4(VirtualFile x$3) {
        return x$3.name().endsWith(".java");
    }

    private static final void withTee$1(Function1 block) {
        PrintStream printStream = System.out;
        if (printStream instanceof TeeOutputStream) {
            TeeOutputStream teeOutputStream = (TeeOutputStream)printStream;
            BoxedUnit cfr_ignored_0 = (BoxedUnit)block.apply((Object)teeOutputStream);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$compile$7(BloopHighLevelCompiler $this, ByteArrayOutputStream baos$1, TeeOutputStream tee) {
        String result = baos$1.toString();
        if (new StringOps(Predef$.MODULE$.augmentString(result)).nonEmpty()) {
            $this.logger.info(baos$1.toString());
        }
        tee.removeListener(baos$1);
    }

    private final void compileSources$1(Seq sources, String[] scalacOptions, AnalysisCallback callback, DependencyChanges changes$1, Promise cancelPromise$1) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scalac.scalaInstance().compilerJars())).isEmpty()) {
            throw new CompileFailed(new String[0], new StringBuilder(57).append("Expected Scala compiler jar in Scala instance containing ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scalac.scalaInstance().allJars())).mkString(", ")).toString(), new Problem[0]);
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scalac.scalaInstance().libraryJars())).isEmpty()) {
            throw new CompileFailed(new String[0], new StringBuilder(56).append("Expected Scala library jar in Scala instance containing ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scalac.scalaInstance().allJars())).mkString(", ")).toString(), new Problem[0]);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BloopHighLevelCompiler.withTee$1((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.addListener(baos);
            return BoxedUnit.UNIT;
        });
        try {
            try {
                this.scalac.compile((VirtualFile[])sources.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), (VirtualFile[])this.classpath.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), (FileConverter)PlainVirtualFileConverter$.MODULE$.converter(), changes$1, scalacOptions, this.setup.output(), callback, this.config.reporter(), JavaInterfaceUtil$.MODULE$.EnrichOption(this.config.progress()).toOptional(), this.logger);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof StackOverflowError) {
                    StackOverflowError stackOverflowError = (StackOverflowError)throwable2;
                    String msg = "Encountered a StackOverflowError coming from the compiler. You might need to restart your Bloop build server";
                    this.logger.error(new StringBuilder(2).append(msg).append(":\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackOverflowError.getStackTrace())).mkString("\n")).toString());
                    throw new CompileFailed(new String[0], msg, new Problem[0], (Option)None$.MODULE$, (Throwable)stackOverflowError);
                }
                if (throwable2 instanceof NoClassDefFoundError) {
                    NoClassDefFoundError noClassDefFoundError = (NoClassDefFoundError)throwable2;
                    String msg = "Encountered a NoClassDefFoundError coming from the compiler. You might need to clean compile your workspace";
                    this.logger.error(new StringBuilder(2).append(msg).append(":\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])noClassDefFoundError.getStackTrace())).mkString("\n")).toString());
                    throw new CompileFailed(new String[0], msg, new Problem[0], (Option)None$.MODULE$, (Throwable)noClassDefFoundError);
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    this.JavaCompleted.tryFailure(t);
                    Throwable throwable3 = t;
                    if (throwable3 instanceof NullPointerException && cancelPromise$1.isCompleted()) {
                        throw new InterfaceCompileCancelled((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Caught NPE when compilation was cancelled!");
                    }
                    throw throwable3;
                }
                throw throwable;
            }
        }
        finally {
            BloopHighLevelCompiler.withTee$1((Function1 & Serializable & scala.Serializable)tee -> {
                BloopHighLevelCompiler.$anonfun$compile$7(this, baos, tee);
                return BoxedUnit.UNIT;
            });
        }
    }

    private final Task compileSequentially$1(Seq sources$1, AnalysisCallback callback$1, DependencyChanges changes$1, Promise cancelPromise$1) {
        return Task$.MODULE$.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String[] scalacOptions = $this.setup.options().scalacOptions();
            this.timed$1("scalac", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.compileSources$1(sources$1, scalacOptions, callback$1, changes$1, cancelPromise$1));
        });
    }

    public static final /* synthetic */ Task $anonfun$compile$15(BloopHighLevelCompiler $this, Task combinedTasks$1, boolean existsCompilation$1, long nanoStart) {
        return combinedTasks$1.materialize().map((Function1 & Serializable & scala.Serializable)r -> {
            block0: {
                if (!existsCompilation$1) break block0;
                long elapsedMs = (System.nanoTime() - nanoStart) / 1000000L;
                $this.reporter.reportEndIncrementalCycle(elapsedMs, (Try<BoxedUnit>)r);
            }
            return r;
        });
    }

    public BloopHighLevelCompiler(AnalyzingCompiler scalac, AnalyzingJavaCompiler javac, CompileConfiguration config, ZincReporter reporter, ObservedLogger<?> logger, BraveTracer tracer) {
        this.scalac = scalac;
        this.javac = javac;
        this.config = config;
        this.reporter = reporter;
        this.logger = logger;
        this.tracer = tracer;
        this.setup = config.currentSetup();
        this.classpath = config.classpath();
        this.JavaCompleted = Promise$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }
}

