/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.bloop.internal;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import monix.eval.Task;
import monix.eval.Task$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.AnalysisCallback;
import sbt.internal.inc.ClassFileManager$;
import sbt.internal.inc.ExternalLookup;
import sbt.internal.inc.InitialChanges;
import sbt.internal.inc.InvalidationProfiler;
import sbt.internal.inc.InvalidationProfiler$;
import sbt.internal.inc.Lookup;
import sbt.internal.inc.Relations;
import sbt.internal.inc.Stamper$;
import sbt.internal.inc.Stamps$;
import sbt.internal.inc.bloop.internal.BloopNameHashing;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Equiv;
import scala.math.Equiv$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xsbti.AnalysisCallback;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.DependencyChanges;
import xsbti.compile.IR;
import xsbti.compile.IncOptions;
import xsbti.compile.Output;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.Stamp;

public final class BloopIncremental$ {
    public static BloopIncremental$ MODULE$;

    static {
        new BloopIncremental$();
    }

    public Task<Tuple2<Object, Analysis>> compile(Iterable<File> sources, Lookup lookup, Function4<Set<File>, DependencyChanges, AnalysisCallback, ClassFileManager, Task<BoxedUnit>> compile, CompileAnalysis previous0, Output output, Logger log, IncOptions options, CompletableFuture<IR[]> irPromise) {
        Analysis analysis;
        Function2 externalAPI = BloopIncremental$.getExternalAPI$1(lookup);
        ReadStamps current = Stamps$.MODULE$.initial(Stamper$.MODULE$.forLastModified(), Stamper$.MODULE$.forHash(), Stamper$.MODULE$.forLastModified());
        CompileAnalysis compileAnalysis = previous0;
        if (!(compileAnalysis instanceof Analysis)) {
            throw new MatchError((Object)compileAnalysis);
        }
        Analysis analysis2 = analysis = (Analysis)compileAnalysis;
        Analysis previous = analysis2;
        Relations previousRelations = previous.relations();
        Function1 & Serializable & scala.Serializable internalBinaryToSourceClassName = (Function1 & Serializable & scala.Serializable)binaryClassName -> previousRelations.productClassName().reverse(binaryClassName).headOption();
        Function1 & Serializable & scala.Serializable internalSourceToClassNamesMap = (Function1 & Serializable & scala.Serializable)f -> previousRelations.classNames(f);
        AnalysisCallback.Builder builder = new AnalysisCallback.Builder((Function1)internalBinaryToSourceClassName, (Function1)internalSourceToClassNamesMap, externalAPI, current, output, options, irPromise);
        return this.compileIncremental(sources, lookup, previous, current, compile, builder, log, options, this.compileIncremental$default$9(), (Equiv<Stamp>)Equiv$.MODULE$.universalEquiv());
    }

    public Task<Tuple2<Object, Analysis>> compileIncremental(Iterable<File> sources, Lookup lookup, Analysis previous, ReadStamps current, Function4<Set<File>, DependencyChanges, AnalysisCallback, ClassFileManager, Task<BoxedUnit>> compile, AnalysisCallback.Builder callbackBuilder, Logger log, IncOptions options, InvalidationProfiler profiler, Equiv<Stamp> equivS) {
        Task<Analysis> task;
        Set setOfSources = sources.toSet();
        BloopNameHashing incremental = new BloopNameHashing(log, options, profiler.profileRun());
        InitialChanges initialChanges = incremental.detectInitialChanges(setOfSources, previous, current, lookup, equivS);
        DependencyChanges binaryChanges = new DependencyChanges(initialChanges){
            private final File[] modifiedBinaries;
            private final String[] modifiedClasses;

            public File[] modifiedBinaries() {
                return this.modifiedBinaries;
            }

            public String[] modifiedClasses() {
                return this.modifiedClasses;
            }

            public boolean isEmpty() {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedBinaries())).isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedClasses())).isEmpty();
            }
            {
                this.modifiedBinaries = (File[])initialChanges$1.binaryDeps().toArray(ClassTag$.MODULE$.apply(File.class));
                this.modifiedClasses = (String[])initialChanges$1.external().allModified().toArray(ClassTag$.MODULE$.apply(String.class));
            }
        };
        Tuple2 tuple2 = incremental.invalidateInitial(previous.relations(), initialChanges);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set initialInvClasses = (Set)tuple2._1();
        Set initialInvSources = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)initialInvClasses, (Object)initialInvSources);
        Tuple2 tuple23 = tuple22;
        Set initialInvClasses2 = (Set)tuple23._1();
        Set initialInvSources2 = (Set)tuple23._2();
        if (initialInvClasses2.nonEmpty() || initialInvSources2.nonEmpty()) {
            Set set = initialInvSources2;
            Iterable<File> iterable = sources;
            if (!(set != null ? !set.equals(iterable) : iterable != null)) {
                incremental.log().debug((Function0 & Serializable & scala.Serializable)() -> "All sources are invalidated.");
            } else {
                incremental.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("All initially invalidated classes: ").append(initialInvClasses2).append("\n").append("All initially invalidated sources:").append(initialInvSources2).append("\n").toString());
            }
        }
        ClassFileManager classfileManager = ClassFileManager$.MODULE$.getClassFileManager(options);
        Function2 & Serializable & scala.Serializable doCompile = (Function2 & Serializable & scala.Serializable)(srcs, changes) -> Task$.MODULE$.now((Object)callbackBuilder.build()).flatMap((Function1 & Serializable & scala.Serializable)callback -> ((Task)compile.apply(srcs, changes, callback, (Object)classfileManager)).map((Function1 & Serializable & scala.Serializable)_ -> callback.get()));
        try {
            task = incremental.entrypoint((Set<String>)initialInvClasses2, (Set<File>)initialInvSources2, (Set<File>)setOfSources, binaryChanges, (ExternalLookup)lookup, previous, (Function2<Set<File>, DependencyChanges, Task<Analysis>>)doCompile, classfileManager, 1);
        }
        catch (Throwable e) {
            classfileManager.complete(false);
            throw e;
        }
        Task<Analysis> analysisTask = task;
        return analysisTask.map((Function1 & Serializable & scala.Serializable)analysis -> {
            classfileManager.complete(true);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((initialInvClasses2.nonEmpty() || initialInvSources2.nonEmpty() ? 1 : 0) != 0), analysis);
        });
    }

    public InvalidationProfiler compileIncremental$default$9() {
        return InvalidationProfiler$.MODULE$.empty();
    }

    private static final Function2 getExternalAPI$1(Lookup lookup) {
        return (Function2 & Serializable & scala.Serializable)(x$1, binaryClassName) -> lookup.lookupAnalysis(binaryClassName).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CompileAnalysis compileAnalysis = x0$1;
            if (!(compileAnalysis instanceof Analysis)) {
                throw new MatchError((Object)compileAnalysis);
            }
            Analysis analysis = (Analysis)compileAnalysis;
            Option sourceClassName = analysis.relations().productClassName().reverse(binaryClassName).headOption();
            Map map = analysis.apis().internal();
            Option option = sourceClassName.flatMap((Function1 & Serializable & scala.Serializable)key -> map.get(key));
            return option;
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final Object manageClassfiles$1(IncOptions options, Function1 run) {
        void var3_4;
        Object object;
        ClassFileManager classfileManager = ClassFileManager$.MODULE$.getClassFileManager(options);
        try {
            object = run.apply((Object)classfileManager);
        }
        catch (Throwable e) {
            classfileManager.complete(false);
            throw e;
        }
        Object result = object;
        classfileManager.complete(true);
        return var3_4;
    }

    private BloopIncremental$() {
        MODULE$ = this;
    }
}

