/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.Project;
import bloop.ScalaInstance;
import bloop.ScalaInstance$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.Paths$;
import bloop.io.Timer$;
import bloop.logging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple12;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.mutable.ParArray$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Project$
implements scala.Serializable {
    public static Project$ MODULE$;

    static {
        new Project$();
    }

    public List<Project> fromDir(Path config, Logger logger) {
        return (List)Timer$.MODULE$.timed(logger, (Function0 & Serializable & scala.Serializable)() -> {
            AbsolutePath[] configFiles = Paths$.MODULE$.getAll(config, "glob:**.config");
            logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", " projects from '", "'..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)configFiles.length), AbsolutePath$.MODULE$.syntax$extension(config)})));
            return ((ParIterableLike)Predef$.MODULE$.genericArrayOps((Object)configFiles).par().map((Function1 & Serializable & scala.Serializable)configFile -> Project$.MODULE$.fromFile(((AbsolutePath)configFile).underlying(), logger), (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toList();
        });
    }

    private Project fromFile(Path config, Logger logger) {
        logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading project from '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new AbsolutePath(config)})));
        Path configFilepath = config;
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(configFilepath, new OpenOption[0]);){
            properties.load(inputStream);
        }
        return this.fromProperties(properties, config);
    }

    public Project fromProperties(Properties properties, Path config) {
        String name = properties.getProperty("name");
        Path baseDirectory = AbsolutePath$.MODULE$.apply(Paths.get(properties.getProperty("baseDirectory"), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        String[] dependencies = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("dependencies").split(","))).filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEmpty()));
        String scalaOrganization = properties.getProperty("scalaOrganization");
        AbsolutePath[] allScalaJars = Project$.toPaths$1(properties.getProperty("allScalaJars"));
        String scalaName = properties.getProperty("scalaName");
        String scalaVersion = properties.getProperty("scalaVersion");
        ScalaInstance scalaInstance = ScalaInstance$.MODULE$.apply(scalaOrganization, scalaName, scalaVersion, allScalaJars);
        AbsolutePath[] classpath = Project$.toPaths$1(properties.getProperty("classpath"));
        Path classesDir = AbsolutePath$.MODULE$.apply(Paths.get(properties.getProperty("classesDir"), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        String[] scalacOptions = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("scalacOptions").split(";"))).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isEmpty()));
        String[] javacOptions = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("javacOptions").split(";"))).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isEmpty()));
        AbsolutePath[] sourceDirectories = (AbsolutePath[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("sourceDirectories").split(","))).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isEmpty())))).map((Function1 & Serializable & scala.Serializable)d -> new AbsolutePath(AbsolutePath$.MODULE$.apply(Paths.get(d, new String[0]), AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)));
        String[][] testFrameworks = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("testFrameworks").split(";"))).map((Function1 & Serializable & scala.Serializable)x$10 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$10.split(","))).filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isEmpty())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        Path tmp = AbsolutePath$.MODULE$.apply(Paths.get(properties.getProperty("tmp"), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        return new Project(name, baseDirectory, dependencies, scalaInstance, classpath, classesDir, scalacOptions, javacOptions, sourceDirectories, testFrameworks, tmp, config);
    }

    public Project apply(String name, Path baseDirectory, String[] dependencies, ScalaInstance scalaInstance, AbsolutePath[] classpath, Path classesDir, String[] scalacOptions, String[] javacOptions, AbsolutePath[] sourceDirectories, String[][] testFrameworks, Path tmp, Path bloopConfigDir) {
        return new Project(name, baseDirectory, dependencies, scalaInstance, classpath, classesDir, scalacOptions, javacOptions, sourceDirectories, testFrameworks, tmp, bloopConfigDir);
    }

    public Option<Tuple12<String, Path, String[], ScalaInstance, Path[], Path, String[], String[], Path[], String[][], Path, Path>> unapply(Project x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.name(), (Object)new AbsolutePath(x$0.baseDirectory()), (Object)x$0.dependencies(), (Object)x$0.scalaInstance(), (Object)x$0.classpath(), (Object)new AbsolutePath(x$0.classesDir()), (Object)x$0.scalacOptions(), (Object)x$0.javacOptions(), (Object)x$0.sourceDirectories(), (Object)x$0.testFrameworks(), (Object)new AbsolutePath(x$0.tmp()), (Object)new AbsolutePath(x$0.bloopConfigDir())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final AbsolutePath[] toPaths$1(String line) {
        return (AbsolutePath[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split(","))).map((Function1 & Serializable & scala.Serializable)x$5 -> Paths.get(x$5, new String[0]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)));
    }

    private Project$() {
        MODULE$ = this;
    }
}

