/*
 * Decompiled with CFR 0.152.
 */
package bloop.reporter;

import bloop.logging.Logger;
import bloop.reporter.ConfigurableReporter;
import bloop.reporter.Problem;
import bloop.reporter.Problem$;
import bloop.reporter.ReporterConfig;
import bloop.reporter.ReporterFormat;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xsbti.Position;
import xsbti.Severity;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u0005\u001d\u0011\u0001BU3q_J$XM\u001d\u0006\u0003\u0007\u0011\t\u0001B]3q_J$XM\u001d\u0006\u0002\u000b\u0005)!\r\\8pa\u000e\u00011\u0003\u0002\u0001\t!U\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)\u0001p\u001d2uS&\u0011\u0011A\u0005\t\u0003-]i\u0011AA\u0005\u00031\t\u0011AcQ8oM&<WO]1cY\u0016\u0014V\r]8si\u0016\u0014\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011A\u000e\u0002\r1|wmZ3s+\u0005a\u0002CA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u001dawnZ4j]\u001eL!!\t\u0010\u0003\r1{wmZ3s\u0011!\u0019\u0003A!A!\u0002\u0013a\u0012a\u00027pO\u001e,'\u000f\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005!!-Y:f+\u00059\u0003C\u0001\u00152\u001d\tIs\u0006\u0005\u0002+[5\t1F\u0003\u0002-\r\u00051AH]8pizR\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001'\f\u0005\tk\u0001\u0011\t\u0011)A\u0005O\u0005)!-Y:fA!Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\u000bt_V\u00148-\u001a)pg&$\u0018n\u001c8NCB\u0004XM\u001d\t\u0005sibD(D\u0001.\u0013\tYTFA\u0005Gk:\u001cG/[8ocA\u0011\u0011#P\u0005\u0003}I\u0011\u0001\u0002U8tSRLwN\u001c\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\u000611m\u001c8gS\u001e,\u0012A\u0011\t\u0003-\rK!\u0001\u0012\u0002\u0003\u001dI+\u0007o\u001c:uKJ\u001cuN\u001c4jO\"Aa\t\u0001B\u0001B\u0003%!)A\u0004d_:4\u0017n\u001a\u0011\t\u000b!\u0003A\u0011A%\u0002\rqJg.\u001b;?)\u0015Q5\nT'O!\t1\u0002\u0001C\u0003\u001b\u000f\u0002\u0007A\u0004C\u0003&\u000f\u0002\u0007q\u0005C\u00038\u000f\u0002\u0007\u0001\bC\u0003A\u000f\u0002\u0007!\tC\u0004Q\u0001\t\u0007I\u0011B)\u0002\r\u0019|'/\\1u+\u0005\u0011\u0006C\u0001\fT\u0013\t!&A\u0001\bSKB|'\u000f^3s\r>\u0014X.\u0019;\t\rY\u0003\u0001\u0015!\u0003S\u0003\u001d1wN]7bi\u0002Bq\u0001\u0017\u0001C\u0002\u0013%\u0011,A\u0005`aJ|'\r\\3ngV\t!\fE\u0002\\A\nl\u0011\u0001\u0018\u0006\u0003;z\u000bq!\\;uC\ndWM\u0003\u0002`[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0005d&aC!se\u0006L()\u001e4gKJ\u0004\"AF2\n\u0005\u0011\u0014!a\u0002)s_\ndW-\u001c\u0005\u0007M\u0002\u0001\u000b\u0011\u0002.\u0002\u0015}\u0003(o\u001c2mK6\u001c\b\u0005C\u0004i\u0001\u0001\u0007I\u0011B5\u0002\u000f}sW\r\u001f;J\tV\t!\u000e\u0005\u0002:W&\u0011A.\f\u0002\u0004\u0013:$\bb\u00028\u0001\u0001\u0004%Ia\\\u0001\f?:,\u0007\u0010^%E?\u0012*\u0017\u000f\u0006\u0002qgB\u0011\u0011(]\u0005\u0003e6\u0012A!\u00168ji\"9A/\\A\u0001\u0002\u0004Q\u0017a\u0001=%c!1a\u000f\u0001Q!\n)\f\u0001b\u00188fqRLE\t\t\u0005\u0006q\u0002!\t%_\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0002a\")1\u0010\u0001C!y\u0006I\u0001.Y:FeJ|'o\u001d\u000b\u0002{B\u0011\u0011H`\u0005\u0003\u007f6\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u0004\u0001!\t\u0005`\u0001\fQ\u0006\u001cx+\u0019:oS:<7\u000f\u0003\u0004\u0002\b\u0001!\t%_\u0001\raJLg\u000e^*v[6\f'/\u001f\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0003-\tG\u000e\u001c)s_\ndW-\\:\u0016\u0005\u0005=\u0001#BA\t\u00037\u0011g\u0002BA\n\u0003/q1AKA\u000b\u0013\u0005q\u0013bAA\r[\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000f\u0003?\u00111aU3r\u0015\r\tI\"\f\u0005\b\u0003G\u0001A\u0011IA\u0013\u0003!\u0001(o\u001c2mK6\u001cHCAA\u0014!\u0015I\u0014\u0011FA\u0017\u0013\r\tY#\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004#\u0005=\u0012B\u00013\u0013\u0011\u001d\t\u0019\u0004\u0001C!\u0003k\t1\u0001\\8h)\r\u0001\u0018q\u0007\u0005\t\u0003s\t\t\u00041\u0001\u0002.\u0005!\u0001O]8c\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\tqaY8n[\u0016tG\u000fF\u0003q\u0003\u0003\n)\u0005C\u0004\u0002D\u0005m\u0002\u0019\u0001\u001f\u0002\u0007A|7\u000fC\u0004\u0002H\u0005m\u0002\u0019A\u0014\u0002\u00075\u001cx\rC\u0004\u0002L\u0001!I!!\u0014\u0002\u000f1|wMR;mYR\u0019\u0001/a\u0014\t\u000f\u0005E\u0013\u0011\na\u0001E\u00069\u0001O]8cY\u0016l\u0007BB>\u0001\t\u0013\t)\u0006F\u0002~\u0003/B\u0001\"a\t\u0002T\u0001\u0007\u0011q\u0002\u0005\b\u0003\u0007\u0001A\u0011BA.)\ri\u0018Q\f\u0005\t\u0003G\tI\u00061\u0001\u0002\u0010!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0014A\u00028fqRLE\tF\u0001k\u0001")
public final class Reporter
implements xsbti.Reporter,
ConfigurableReporter {
    private final Logger logger;
    private final String base;
    private final Function1<Position, Position> sourcePositionMapper;
    private final ReporterConfig config;
    private final ReporterFormat format;
    private final ArrayBuffer<Problem> _problems;
    private int _nextID;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public String base() {
        return this.base;
    }

    @Override
    public ReporterConfig config() {
        return this.config;
    }

    private ReporterFormat format() {
        return this.format;
    }

    private ArrayBuffer<Problem> _problems() {
        return this._problems;
    }

    private int _nextID() {
        return this._nextID;
    }

    private void _nextID_$eq(int x$1) {
        this._nextID = x$1;
    }

    public void reset() {
        this._problems().clear();
        this._nextID_$eq(1);
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors((Seq<Problem>)this._problems());
    }

    @Override
    public boolean hasWarnings() {
        return this.hasWarnings((Seq<Problem>)this._problems());
    }

    public void printSummary() {
        if (this.config().reverseOrder()) {
            ((ResizableArray)this._problems().reverse()).foreach((Function1 & Serializable & scala.Serializable)problem -> {
                this.logFull(problem);
                return BoxedUnit.UNIT;
            });
        }
        this.format().printSummary();
    }

    @Override
    public Seq<Problem> allProblems() {
        return this._problems();
    }

    public xsbti.Problem[] problems() {
        return (xsbti.Problem[])this._problems().toArray(ClassTag$.MODULE$.apply(xsbti.Problem.class));
    }

    public void log(xsbti.Problem prob) {
        block0: {
            Position mappedPos = (Position)this.sourcePositionMapper.apply((Object)prob.position());
            int problemID = prob.position().sourceFile().isPresent() ? this.nextID() : -1;
            Problem problem = Problem$.MODULE$.apply(problemID, prob.severity(), prob.message(), mappedPos, prob.category());
            this._problems().$plus$eq((Object)problem);
            if (this.config().reverseOrder()) break block0;
            this.logFull(problem);
        }
    }

    public void comment(Position pos, String msg) {
    }

    private void logFull(Problem problem) {
        String text = this.format().formatProblem(problem);
        Severity severity = problem.severity();
        if (Severity.Error.equals(severity)) {
            this.logger().error(text);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Severity.Warn.equals(severity)) {
            this.logger().warn(text);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Severity.Info.equals(severity)) {
            this.logger().info(text);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)severity);
        }
    }

    private boolean hasErrors(Seq<Problem> problems) {
        return problems.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Reporter.$anonfun$hasErrors$1(x$1)));
    }

    private boolean hasWarnings(Seq<Problem> problems) {
        return problems.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Reporter.$anonfun$hasWarnings$1(x$2)));
    }

    /*
     * WARNING - void declaration
     */
    private int nextID() {
        void var1_1;
        int id = this._nextID();
        this._nextID_$eq(this._nextID() + 1);
        return (int)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$hasErrors$1(Problem x$1) {
        Severity severity = x$1.severity();
        Severity severity2 = Severity.Error;
        return !(severity != null ? !severity.equals(severity2) : severity2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasWarnings$1(Problem x$2) {
        Severity severity = x$2.severity();
        Severity severity2 = Severity.Warn;
        return !(severity != null ? !severity.equals(severity2) : severity2 != null);
    }

    public Reporter(Logger logger, String base, Function1<Position, Position> sourcePositionMapper, ReporterConfig config) {
        this.logger = logger;
        this.base = base;
        this.sourcePositionMapper = sourcePositionMapper;
        this.config = config;
        this.format = (ReporterFormat)config.format().apply((Object)this);
        this._problems = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this._nextID = 1;
    }
}

