/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.caches;

import bloop.Compiler;
import bloop.Project;
import bloop.engine.Build;
import bloop.engine.ExecutionContext$;
import bloop.engine.caches.ResultsCache;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.Logger;
import bloop.reporter.Reporter;
import bloop.reporter.Reporter$;
import bloop.util.JavaCompat$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.CancelableFuture;
import sbt.internal.inc.FileAnalysisStore$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import xsbti.compile.AnalysisContents;
import xsbti.compile.PreviousResult;

public final class ResultsCache$ {
    public static ResultsCache$ MODULE$;
    private final ConcurrentHashMap.KeySetView<PreviousResult, Boolean> persisted;
    private final PreviousResult EmptyResult;

    static {
        new ResultsCache$();
    }

    public ConcurrentHashMap.KeySetView<PreviousResult, Boolean> persisted() {
        return this.persisted;
    }

    public final PreviousResult EmptyResult() {
        return this.EmptyResult;
    }

    public ResultsCache load(Build build, Path cwd, Logger logger) {
        CancelableFuture handle = this.loadAsync(build, cwd, logger).runAsync(ExecutionContext$.MODULE$.ioScheduler());
        return (ResultsCache)Await$.MODULE$.result((Awaitable)handle, (Duration)Duration$.MODULE$.Inf());
    }

    public Task<ResultsCache> loadAsync(Build build, Path cwd, Logger logger) {
        List all = (List)build.projects().map((Function1 & Serializable & scala.Serializable)p -> ResultsCache$.fetchPreviousResult$1(p, cwd, logger).map((Function1 & Serializable & scala.Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), r)), List$.MODULE$.canBuildFrom());
        return Task$.MODULE$.gatherUnordered((TraversableOnce)all).executeOn(ExecutionContext$.MODULE$.ioScheduler()).map((Function1 & Serializable & scala.Serializable)projectResults -> {
            ResultsCache cache = new ResultsCache((Map<Project, Compiler.Result>)Predef$.MODULE$.Map().empty(), (Map<Project, PreviousResult>)Predef$.MODULE$.Map().empty(), logger);
            return cache.addResults((List<Tuple2<Project, Compiler.Result>>)projectResults);
        });
    }

    public Path pathToAnalysis(Project project) {
        return AbsolutePath$.MODULE$.resolve$extension1(project.out(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-analysis.bin"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project.name()})));
    }

    private static final Task fetchPreviousResult$1(Project p, Path cwd$1, Logger logger$1) {
        Task task;
        Path analysisFile = MODULE$.pathToAnalysis(p);
        if (Files.exists(analysisFile, new LinkOption[0])) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Compiler.Result$.Empty$ empty$;
                Option contents = JavaCompat$.MODULE$.EnrichOptional(FileAnalysisStore$.MODULE$.binary(AbsolutePath$.MODULE$.toFile$extension(analysisFile)).get()).toOption();
                Option option = contents;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AnalysisContents res = (AnalysisContents)some.value();
                    logger$1.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading previous analysis for '", "' from '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p.name(), new AbsolutePath(analysisFile)})));
                    PreviousResult r = PreviousResult.of(Optional.of(res.getAnalysis()), Optional.of(res.getMiniSetup()));
                    Reporter reporter = Reporter$.MODULE$.fromAnalysis(res.getAnalysis(), cwd$1, logger$1);
                    empty$ = new Compiler.Result$.Success(reporter, r, 0L);
                } else if (None$.MODULE$.equals(option)) {
                    logger$1.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Analysis '", "' for '", "' is empty."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new AbsolutePath(analysisFile), p.name()})));
                    empty$ = Compiler.Result$.Empty$.MODULE$;
                } else {
                    throw new MatchError(option);
                }
                return empty$;
            });
        } else {
            logger$1.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing analysis file for project '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p.name()})));
            task = Task$.MODULE$.now((Object)Compiler.Result$.Empty$.MODULE$);
        }
        return task;
    }

    private ResultsCache$() {
        MODULE$ = this;
        this.persisted = ConcurrentHashMap.newKeySet();
        this.EmptyResult = PreviousResult.of(Optional.empty(), Optional.empty());
    }
}

