/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.Project;
import bloop.bsp.BspServer$;
import bloop.engine.ExecutionContext$;
import bloop.engine.State;
import bloop.io.SourceWatcher$;
import bloop.logging.Slf4jAdapter;
import bloop.monix.FoldLeftAsyncConsumer$;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.DirectoryWatcher;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.reactive.Consumer;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0003\u000f\ti1k\\;sG\u0016<\u0016\r^2iKJT!a\u0001\u0003\u0002\u0005%|'\"A\u0003\u0002\u000b\tdwn\u001c9\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011=\u0001!\u0011!Q\u0001\nA\tq\u0001\u001d:pU\u0016\u001cG\u000f\u0005\u0002\u0012%5\tA!\u0003\u0002\u0014\t\t9\u0001K]8kK\u000e$\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t\u0011L'o\u001d\t\u0004/}\u0011cB\u0001\r\u001e\u001d\tIB$D\u0001\u001b\u0015\tYb!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011aDC\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0013EA\u0002TKFT!A\b\u0006\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001\u00024jY\u0016T!a\n\u0015\u0002\u00079LwNC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-\"#\u0001\u0002)bi\"D\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0006M&dWm\u001d\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u00051An\\4hKJ\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0003\u0002\u000f1|wmZ5oO&\u0011QG\r\u0002\u0007\u0019><w-\u001a:\t\u000b]\u0002A\u0011\u0002\u001d\u0002\rqJg.\u001b;?)\u0015I4\bP\u001f?!\tQ\u0004!D\u0001\u0003\u0011\u0015ya\u00071\u0001\u0011\u0011\u0015)b\u00071\u0001\u0017\u0011\u0015ic\u00071\u0001\u0017\u0011\u0015yc\u00071\u00011\u0011\u001d\u0001\u0005A1A\u0005\n\u0005\u000b1b\u001d7gi)dunZ4feV\t!\tE\u00022\u0007BJ!\u0001\u0012\u001a\u0003\u0019Mcg\r\u000e6BI\u0006\u0004H/\u001a:\t\r\u0019\u0003\u0001\u0015!\u0003C\u00031\u0019HN\u001a\u001bk\u0019><w-\u001a:!\u0011\u0015A\u0005\u0001\"\u0001J\u0003\u00159\u0018\r^2i)\rQ\u0005L\u0017\t\u0004\u0017B\u0013V\"\u0001'\u000b\u00055s\u0015\u0001B3wC2T\u0011aT\u0001\u0006[>t\u0017\u000e_\u0005\u0003#2\u0013A\u0001V1tWB\u00111KV\u0007\u0002)*\u0011Q\u000bB\u0001\u0007K:<\u0017N\\3\n\u0005]#&!B*uCR,\u0007\"B-H\u0001\u0004\u0011\u0016AB:uCR,\u0007\u0007C\u0003\\\u000f\u0002\u0007A,\u0001\u0004bGRLwN\u001c\t\u0005\u0013u\u0013&*\u0003\u0002_\u0015\tIa)\u001e8di&|g.\r\u0005\u0006A\u0002!\t!Y\u0001\f]>$\u0018NZ=XCR\u001c\u0007\u000eF\u0001c!\tI1-\u0003\u0002e\u0015\t!QK\\5u\u000f\u00151'\u0001#\u0001h\u00035\u0019v.\u001e:dK^\u000bGo\u00195feB\u0011!\b\u001b\u0004\u0006\u0003\tA\t![\n\u0003Q\"AQa\u000e5\u0005\u0002-$\u0012a\u001a\u0005\u0006[\"$\tA\\\u0001\u0006CB\u0004H.\u001f\u000b\u0005s=\u0004(\u000fC\u0003\u0010Y\u0002\u0007\u0001\u0003C\u0003rY\u0002\u0007a#\u0001\u0004qCRD7\u000f\r\u0005\u0006_1\u0004\r\u0001\r")
public final class SourceWatcher {
    private final Project project;
    private final Seq<Path> dirs;
    private final Seq<Path> files;
    private final bloop.logging.Logger logger;
    private final Slf4jAdapter<bloop.logging.Logger> slf4jLogger;

    public static SourceWatcher apply(Project project, Seq<Path> seq, bloop.logging.Logger logger) {
        return SourceWatcher$.MODULE$.apply(project, seq, logger);
    }

    private Slf4jAdapter<bloop.logging.Logger> slf4jLogger() {
        return this.slf4jLogger;
    }

    public Task<State> watch(State state0, Function1<State, Task<State>> action) {
        PrintStream ngout = state0.commonOptions().ngout();
        Tuple2 tuple2 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.publish(), ExecutionContext$.MODULE$.ioScheduler());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Observer.Sync observer = (Observer.Sync)tuple2._1();
        Observable observable = (Observable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)observer, (Object)observable);
        Tuple2 tuple23 = tuple22;
        Observer.Sync observer2 = (Observer.Sync)tuple23._1();
        Observable observable2 = (Observable)tuple23._2();
        List allPaths = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.files.$plus$plus(this.dirs, Seq$.MODULE$.canBuildFrom())).asJava();
        BooleanRef watchingEnabled = BooleanRef.create((boolean)true);
        DirectoryWatcher watcher = DirectoryWatcher.create((List)allPaths, (DirectoryChangeListener)new DirectoryChangeListener(null, observer2, watchingEnabled){
            private final Observer.Sync observer$1;
            private final BooleanRef watchingEnabled$1;

            public boolean isWatching() {
                return this.watchingEnabled$1.elem;
            }

            public void onException(Exception e, Logger logger) {
                logger.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File watching threw an exception: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})));
            }

            public void onEvent(DirectoryChangeEvent event) {
                block0: {
                    Path targetFile = event.path();
                    String targetPath = targetFile.toFile().getAbsolutePath();
                    if (!Files.isRegularFile(targetFile, new LinkOption[0]) || !targetPath.endsWith(".scala") && !targetPath.endsWith(".java")) break block0;
                    this.observer$1.onNext((Object)event);
                }
            }
            {
                this.observer$1 = observer$1;
                this.watchingEnabled$1 = watchingEnabled$1;
            }
        }, this.slf4jLogger());
        CompletableFuture watcherHandle = watcher.watchAsync((Executor)ExecutionContext$.MODULE$.ioExecutor());
        Task watchController = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                watcherHandle.get();
            }
            finally {
                watcher.close();
            }
            $this.logger.debug("The file watcher was successfully closed.");
        });
        Cancelable watchCancellation = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            watchingEnabled$1.elem = false;
            watcherHandle.complete(null);
            observer2.onComplete();
            ngout.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File watching on '", "' and dependent projects has been successfully cancelled."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.project.name()})));
        });
        Consumer fileEventConsumer = FoldLeftAsyncConsumer$.MODULE$.consume((Function0 & Serializable & scala.Serializable)() -> state0, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Task task;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            State state = (State)tuple2._1();
            DirectoryChangeEvent event = (DirectoryChangeEvent)tuple2._2();
            DirectoryChangeEvent.EventType eventType = event.eventType();
            if (DirectoryChangeEvent.EventType.CREATE.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else if (DirectoryChangeEvent.EventType.MODIFY.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else if (DirectoryChangeEvent.EventType.OVERFLOW.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else {
                if (!DirectoryChangeEvent.EventType.DELETE.equals(eventType)) throw new MatchError((Object)eventType);
                task = Task$.MODULE$.now((Object)state);
            }
            return task;
        });
        CancelableFuture watchHandle = watchController.runAsync(ExecutionContext$.MODULE$.ioScheduler());
        return observable2.consumeWith(fileEventConsumer).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> watchCancellation.cancel()));
    }

    public void notifyWatch() {
        int filesCount = this.files.size();
        int dirsCount = this.dirs.size();
        String andFiles = filesCount == 0 ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" and ", " files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)filesCount)}));
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Watching ", " directories", "... (press C-c to interrupt)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirsCount), andFiles})));
    }

    private final Task runAction$1(State state, DirectoryChangeEvent event, Function1 action$1) {
        if (!BspServer$.MODULE$.isWindows()) {
            this.logger.info("\u001b[H\u001b[2J");
        }
        this.logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A ", " in ", " has triggered an event."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{event.eventType(), event.path()})));
        return (Task)action$1.apply((Object)state);
    }

    public SourceWatcher(Project project, Seq<Path> dirs, Seq<Path> files, bloop.logging.Logger logger) {
        this.project = project;
        this.dirs = dirs;
        this.files = files;
        this.logger = logger;
        this.slf4jLogger = new Slf4jAdapter(logger);
    }
}

