/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.Project;
import bloop.ScalaInstance;
import bloop.ScalaInstance$;
import bloop.config.Config;
import bloop.config.ConfigEncoderDecoders$;
import bloop.engine.ExecutionContext$;
import bloop.engine.tasks.ScalaJsToolchain;
import bloop.engine.tasks.ScalaJsToolchain$;
import bloop.engine.tasks.ScalaNativeToolchain;
import bloop.engine.tasks.ScalaNativeToolchain$;
import bloop.exec.JavaEnv;
import bloop.exec.JavaEnv$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.Paths$;
import bloop.logging.Logger;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple20;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scalaz.Cord;
import scalaz.Show;
import scalaz.syntax.ShowSyntax;
import xsbti.compile.ClasspathOptions;

public final class Project$
implements scala.Serializable {
    public static Project$ MODULE$;
    private final Show<Project> ps;
    private final String loadPattern;
    private final int loadDepth;

    static {
        new Project$();
    }

    public final Show<Project> ps() {
        return this.ps;
    }

    public final String loadPattern() {
        return this.loadPattern;
    }

    public final int loadDepth() {
        return this.loadDepth;
    }

    private AbsolutePath[] loadAllFiles(Path configRoot) {
        return Paths$.MODULE$.getAllFiles(configRoot, this.loadPattern(), this.loadDepth());
    }

    public Task<List<Project>> lazyLoadFromDir(Path configRoot, Logger logger) {
        AbsolutePath[] configFiles = this.loadAllFiles(configRoot);
        logger.debug(new StringBuilder(28).append("Loading ").append(configFiles.length).append(" projects from '").append(AbsolutePath$.MODULE$.syntax$extension(configRoot)).append("'...").toString());
        List all = Predef$.MODULE$.genericArrayOps((Object)configFiles).iterator().map((Function1 & Serializable & scala.Serializable)configFile -> Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Project$.MODULE$.fromFile(configFile, logger$2))).toList();
        return Task$.MODULE$.gatherUnordered((TraversableOnce)all).executeOn(ExecutionContext$.MODULE$.scheduler());
    }

    public List<Project> eagerLoadFromDir(Path configRoot, Logger logger) {
        AbsolutePath[] configFiles = this.loadAllFiles(configRoot);
        logger.debug(new StringBuilder(28).append("Loading ").append(configFiles.length).append(" projects from '").append(AbsolutePath$.MODULE$.syntax$extension(configRoot)).append("'...").toString());
        return Predef$.MODULE$.genericArrayOps((Object)configFiles).iterator().map((Function1 & Serializable & scala.Serializable)configFile -> Project$.MODULE$.fromFile(((AbsolutePath)configFile).underlying(), logger)).toList();
    }

    public Project fromConfig(Config.File file, Logger logger) {
        JavaEnv javaEnv;
        Config.Platform$.Jvm jvm;
        Config.JvmConfig jvmConfig;
        None$ none$;
        None$ none$2;
        ScalaInstance scalaInstance;
        boolean isEmpty;
        Config.Project project = file.project();
        Config.Scala scala = project.scala();
        boolean bl = isEmpty = scala.organization().isEmpty() && scala.name().isEmpty() && scala.version().isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scala.jars())).isEmpty();
        if (isEmpty) {
            scalaInstance = ScalaInstance$.MODULE$.bloopScalaInstance(logger);
        } else {
            AbsolutePath[] scalaJars = (AbsolutePath[])Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scala.jars())).map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)))).toArray(ClassTag$.MODULE$.apply(AbsolutePath.class));
            scalaInstance = ScalaInstance$.MODULE$.apply(scala.organization(), scala.name(), scala.version(), scalaJars, logger);
        }
        ScalaInstance instance = scalaInstance;
        Config.CompileSetup setup = project.compileSetup();
        ClasspathOptions classpathOptions = ClasspathOptions.of((boolean)setup.addLibraryToBootClasspath(), (boolean)setup.addCompilerToClasspath(), (boolean)setup.addExtraJarsToClasspath(), (boolean)setup.manageBootClasspath(), (boolean)setup.filterLibraryFromClasspath());
        Config.Platform platform = project.platform();
        if (platform instanceof Config.Platform.Js) {
            Config.Platform.Js js = (Config.Platform.Js)platform;
            none$2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ScalaJsToolchain)ScalaJsToolchain$.MODULE$.resolveToolchain((Config.Platform)js, logger)).toOption();
        } else {
            none$2 = None$.MODULE$;
        }
        None$ jsToolchain = none$2;
        Config.Platform platform2 = project.platform();
        if (platform2 instanceof Config.Platform.Native) {
            Config.Platform.Native native_ = (Config.Platform.Native)platform2;
            none$ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ScalaNativeToolchain)ScalaNativeToolchain$.MODULE$.resolveToolchain((Config.Platform)native_, logger)).toOption();
        } else {
            none$ = None$.MODULE$;
        }
        None$ nativeToolchain = none$;
        Config.Platform platform3 = project.platform();
        if (platform3 instanceof Config.Platform$.Jvm && (jvmConfig = (jvm = (Config.Platform$.Jvm)platform3).config()) != null) {
            Option home = jvmConfig.home();
            List jvmOptions = jvmConfig.options();
            Path jvmHome = ((AbsolutePath)home.map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new AbsolutePath(JavaEnv$.MODULE$.DefaultJavaHome()))).underlying();
            javaEnv = new JavaEnv(jvmHome, (String[])jvmOptions.toArray(ClassTag$.MODULE$.apply(String.class)));
        } else {
            javaEnv = JavaEnv$.MODULE$.default();
        }
        JavaEnv javaEnv2 = javaEnv;
        Config.Sbt sbt = project.sbt();
        Config.Sbt sbt2 = Config.Sbt$.MODULE$.empty();
        Config.Sbt sbt3 = sbt;
        Object object = !(sbt2 != null ? !sbt2.equals(sbt3) : sbt3 != null) ? None$.MODULE$ : new Some((Object)sbt);
        None$ sbt4 = object;
        Config.Resolution resolution = project.resolution();
        Config.Resolution resolution2 = Config.Resolution$.MODULE$.empty();
        Config.Resolution resolution3 = resolution;
        Object object2 = !(resolution2 != null ? !resolution2.equals(resolution3) : resolution3 != null) ? None$.MODULE$ : new Some((Object)resolution);
        None$ resolution4 = object2;
        return new Project(project.name(), AbsolutePath$.MODULE$.apply(project.directory(), AbsolutePath$.MODULE$.workingDirectory()), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.dependencies())).toArray(ClassTag$.MODULE$.apply(String.class)), instance, (AbsolutePath[])Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.classpath())).map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)))).toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), classpathOptions, AbsolutePath$.MODULE$.apply(project.classesDir(), AbsolutePath$.MODULE$.workingDirectory()), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scala.options())).toArray(ClassTag$.MODULE$.apply(String.class)), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.java().options())).toArray(ClassTag$.MODULE$.apply(String.class)), (AbsolutePath[])Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.sources())).map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)))).toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), project.test().frameworks(), project.test().options(), javaEnv2, AbsolutePath$.MODULE$.apply(project.out(), AbsolutePath$.MODULE$.workingDirectory()), AbsolutePath$.MODULE$.apply(project.analysisOut(), AbsolutePath$.MODULE$.workingDirectory()), project.platform(), (Option)jsToolchain, (Option)nativeToolchain, (Option)sbt4, (Option)resolution4);
    }

    public Project fromFile(Path config, Logger logger) {
        Project project;
        logger.debug(new StringBuilder(23).append("Loading project from '").append(new AbsolutePath(config)).append("'").toString());
        String contents = new String(Files.readAllBytes(config), StandardCharsets.UTF_8);
        Either either = package$.MODULE$.parse(contents);
        if (either instanceof Left) {
            Left left = (Left)either;
            ParsingFailure failure = (ParsingFailure)left.value();
            throw failure;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Json json = (Json)right.value();
            Either either2 = ConfigEncoderDecoders$.MODULE$.allDecoder().decodeJson(json);
            if (!(either2 instanceof Right)) {
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    DecodingFailure failure = (DecodingFailure)left.value();
                    throw failure;
                }
                throw new MatchError((Object)either2);
            }
            Right right2 = (Right)either2;
            Config.File file = (Config.File)right2.value();
            project = this.fromConfig(file, logger);
        } else {
            throw new MatchError((Object)either);
        }
        Project project2 = project;
        return project2;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public Project apply(String name, Path baseDirectory, String[] dependencies, ScalaInstance scalaInstance, AbsolutePath[] rawClasspath, ClasspathOptions classpathOptions, Path classesDir, String[] scalacOptions, String[] javacOptions, AbsolutePath[] sources, Config.TestFramework[] testFrameworks, Config.TestOptions testOptions, JavaEnv javaEnv, Path out, Path analysisOut, Config.Platform platform, Option jsToolchain, Option nativeToolchain, Option sbt, Option resolution) {
        return new Project(name, baseDirectory, dependencies, scalaInstance, rawClasspath, classpathOptions, classesDir, scalacOptions, javacOptions, sources, testFrameworks, testOptions, javaEnv, out, analysisOut, platform, jsToolchain, nativeToolchain, sbt, resolution);
    }

    public Option<Tuple20<String, Path, String[], ScalaInstance, Path[], ClasspathOptions, Path, String[], String[], Path[], Config.TestFramework[], Config.TestOptions, JavaEnv, Path, Path, Config.Platform, Option<ScalaJsToolchain>, Option<ScalaNativeToolchain>, Option<Config.Sbt>, Option<Config.Resolution>>> unapply(Project x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple20((Object)x$0.name(), (Object)new AbsolutePath(x$0.baseDirectory()), (Object)x$0.dependencies(), (Object)x$0.scalaInstance(), (Object)x$0.rawClasspath(), (Object)x$0.classpathOptions(), (Object)new AbsolutePath(x$0.classesDir()), (Object)x$0.scalacOptions(), (Object)x$0.javacOptions(), (Object)x$0.sources(), (Object)x$0.testFrameworks(), (Object)x$0.testOptions(), (Object)x$0.javaEnv(), (Object)new AbsolutePath(x$0.out()), (Object)new AbsolutePath(x$0.analysisOut()), (Object)x$0.platform(), x$0.jsToolchain(), x$0.nativeToolchain(), x$0.sbt(), x$0.resolution()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Project$() {
        MODULE$ = this;
        this.ps = new Show<Project>(){
            private final ShowSyntax<Project> showSyntax;

            public Cord show(Object f) {
                return Show.show$((Show)this, (Object)f);
            }

            public ShowSyntax<Project> showSyntax() {
                return this.showSyntax;
            }

            public void scalaz$Show$_setter_$showSyntax_$eq(ShowSyntax<Project> x$1) {
                this.showSyntax = x$1;
            }

            public String shows(Project f) {
                return f.name();
            }
            {
                Show.$init$((Show)this);
            }
        };
        this.loadPattern = "glob:**.json";
        this.loadDepth = 1;
    }
}

