/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.Project;
import bloop.bsp.BspServer$;
import bloop.cli.BspProtocol;
import bloop.cli.BspProtocol$;
import bloop.cli.CliParsers$;
import bloop.cli.Commands;
import bloop.cli.Commands$;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.cli.OptimizerConfig;
import bloop.cli.OptimizerConfig$Debug$;
import bloop.cli.OptimizerConfig$Release$;
import bloop.cli.ReporterKind;
import bloop.cli.ReporterKind$;
import bloop.cli.completion.Case$;
import bloop.cli.completion.Mode;
import bloop.cli.completion.Mode$Commands$;
import bloop.cli.completion.Mode$Flags$;
import bloop.cli.completion.Mode$MainsFQCN$;
import bloop.cli.completion.Mode$ProjectBoundCommands$;
import bloop.cli.completion.Mode$Projects$;
import bloop.cli.completion.Mode$Protocols$;
import bloop.cli.completion.Mode$Reporters$;
import bloop.cli.completion.Mode$TestsFQCN$;
import bloop.config.Config;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.State$XState$;
import bloop.engine.tasks.ScalaJsToolchain;
import bloop.engine.tasks.ScalaNativeToolchain;
import bloop.engine.tasks.Tasks$;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.RelativePath$;
import bloop.io.SourceWatcher;
import bloop.io.SourceWatcher$;
import bloop.reporter.ReporterConfig;
import bloop.testing.LoggingEventHandler;
import bloop.testing.TestInternals$;
import caseapp.core.Arg;
import caseapp.core.CommandMessages;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;
    private final String line;

    static {
        new Interpreter$();
    }

    public Task<State> execute(Action action, Task<State> stateTask) {
        return Interpreter$.execute$1(action, stateTask, false);
    }

    private final String t() {
        return "    ";
    }

    private final String line() {
        return this.line;
    }

    private Task<State> printAbout(State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String bloopName = BuildInfo$.MODULE$.name();
            String bloopVersion = BuildInfo$.MODULE$.version();
            String scalaVersion = BuildInfo$.MODULE$.scalaVersion();
            String zincVersion = BuildInfo$.MODULE$.zincVersion();
            String developers = BuildInfo$.MODULE$.developers().mkString(", ");
            String header = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(366).append("|").append("    ").append("   _____            __         ______           __\n          |").append("    ").append("  / ___/_________ _/ /___ _   / ____/__  ____  / /____  _____\n          |").append("    ").append("  \\__ \\/ ___/ __ `/ / __ `/  / /   / _ \\/ __ \\/ __/ _ \\/ ___/\n          |").append("    ").append(" ___/ / /__/ /_/ / / /_/ /  / /___/ /__/ / / / /_/ /__/ /\n          |").append("    ").append("/____/\\___/\\__,_/_/\\__,_/   \\____/\\___/_/ /_/\\__/\\___/_/\n          |").toString())).stripMargin();
            String versions = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n                      |").append("    ").append(new StringOps(Predef$.MODULE$.augmentString(bloopName)).capitalize()).append(" version    `").append(bloopVersion).append("`\n                      |").append("    ").append("Zinc version     `").append(zincVersion).append("`\n                      |").append("    ").append("Scala version    `").append(scalaVersion).append("`").toString())).stripMargin();
            state.logger().info(new StringBuilder(0).append(header).append(MODULE$.line()).toString());
            state.logger().info(new StringBuilder(45).append("    ").append(bloopName).append(" is made with love at the Scala Center <3").append(MODULE$.line()).toString());
            state.logger().info(new StringBuilder(0).append(versions).append(MODULE$.line()).append(MODULE$.line()).toString());
            state.logger().info(new StringBuilder(25).append("    ").append("It is maintained by ").append(developers).append(".").toString());
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private Task<State> runBsp(Commands.ValidatedBsp cmd, State state) {
        Scheduler scheduler = ExecutionContext$.MODULE$.bspScheduler();
        return BspServer$.MODULE$.run(cmd, state, RelativePath$.MODULE$.apply(".bloop"), scheduler);
    }

    public Task<State> watch(Project project, State state, Function1<State, Task<State>> f) {
        List<Project> reachable = Dag$.MODULE$.dfs(state.build().getDagFor(project));
        Iterator allSources = reachable.iterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.genericArrayOps((Object)x$1.sources()).toList()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((AbsolutePath)x$2).underlying());
        SourceWatcher watcher = SourceWatcher$.MODULE$.apply(project, (Seq<Path>)allSources.toList(), state.logger());
        Function1 & Serializable & scala.Serializable fg = (Function1 & Serializable & scala.Serializable)state2 -> ((Task)f.apply(state2)).map((Function1 & Serializable & scala.Serializable)state -> {
            watcher.notifyWatch();
            return State$.MODULE$.stateCache().updateBuild((State)state);
        });
        return ((Task)fg.apply((Object)state)).flatMap((Function1 & Serializable & scala.Serializable)newState -> watcher.watch((State)newState, (Function1<State, Task<State>>)fg));
    }

    private Task<State> compile(Commands.Compile cmd, State state, boolean sequential) {
        Task task;
        ReporterConfig config = ReporterKind$.MODULE$.toReporterConfig(cmd.reporter());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            Task<State> initialState = cmd.incremental() ? Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state) : Tasks$.MODULE$.clean(state, state.build().projects(), true);
            task = initialState.flatMap((Function1 & Serializable & scala.Serializable)state2 -> !cmd.watch() ? Interpreter$.doCompile$1(state2, sequential, config, project) : MODULE$.watch(project, (State)state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doCompile$1(state, sequential, config, project)));
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> showProjects(Commands.Projects cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (cmd.dotGraph()) {
                String contents = Dag$.MODULE$.toDotGraph(state.build().dags());
                state.logger().info(contents);
            } else {
                String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
                state.logger().debug(new StringBuilder(24).append("Projects loaded from '").append(configDirectory).append("':").toString());
                ((List)((SeqLike)state.build().projects().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    Interpreter$.$anonfun$showProjects$3(state, x$1);
                    return BoxedUnit.UNIT;
                });
            }
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private Task<State> compileAnd(State state, Project project, ReporterConfig reporterConfig, boolean excludeRoot, boolean checkPrevious, String nextAction, Function1<State, Task<State>> next) {
        return Tasks$.MODULE$.compile(state, project, reporterConfig, checkPrevious, excludeRoot).flatMap((Function1 & Serializable & scala.Serializable)compiled -> {
            Task task;
            ExitStatus exitStatus = compiled.status();
            ExitStatus exitStatus2 = ExitStatus$.MODULE$.CompilationError();
            if (exitStatus == null ? exitStatus2 != null : !((Object)exitStatus).equals(exitStatus2)) {
                task = (Task)next.apply(compiled);
            } else {
                compiled.logger().debug(new StringBuilder(35).append("Failed compilation for ").append(project).append(". Skipping ").append(nextAction).append(".").toString());
                task = Task$.MODULE$.now(compiled);
            }
            return task;
        });
    }

    private Task<State> console(Commands.Console cmd, State state2, boolean sequential) {
        Task<State> task;
        ReporterConfig config = ReporterKind$.MODULE$.toReporterConfig(cmd.reporter());
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = this.compileAnd(state2, project, config, cmd.excludeRoot(), sequential, "`console`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Tasks$.MODULE$.console((State)state, project, config, cmd.excludeRoot()));
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> test(Commands.Test cmd, State state2, boolean sequential) {
        Task task;
        ReporterConfig reporterConfig = ReporterKind$.MODULE$.toReporterConfig(cmd.reporter());
        Option<Project> option = Tasks$.MODULE$.pickTestProject(cmd.project(), state2);
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.doTest$1((State)state, cmd, sequential, reporterConfig, project)) : this.doTest$1(state2, cmd, sequential, reporterConfig, project);
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Tuple2<List<Project>, List<String>> lookupProjects(List<String> names, State state) {
        Build build = state.build();
        Tuple2 result = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), (Object)Nil$.MODULE$);
        return (Tuple2)names.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String name = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            List projects = (List)tuple23._1();
            List missing = (List)tuple23._2();
            Option<Project> option = build.getProjectFor(name);
            if (option instanceof Some) {
                Project project;
                Some some = (Some)option;
                Project project2 = project = (Project)some.value();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects.$colon$colon((Object)project2)), (Object)missing);
                return tuple2;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                String string = name;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects), (Object)missing.$colon$colon((Object)string));
            }
            return tuple2;
        });
    }

    private Task<State> autocomplete(Commands.Autocomplete cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Mode mode = cmd.mode();
            if (Mode$ProjectBoundCommands$.MODULE$.equals(mode)) {
                state.logger().info(Commands$.MODULE$.projectBound());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Commands$.MODULE$.equals(mode)) {
                CliParsers$.MODULE$.CommandsMessages().messages().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Interpreter$.$anonfun$autocomplete$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                    Interpreter$.$anonfun$autocomplete$3(cmd, state, x$10);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Projects$.MODULE$.equals(mode)) {
                List<Project> projects = state.build().projects();
                state.build().projects().foreach((Function1 & Serializable & scala.Serializable)project -> {
                    Interpreter$.$anonfun$autocomplete$5(cmd, state, project);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Flags$.MODULE$.equals(mode)) {
                cmd.command().foreach((Function1 & Serializable & scala.Serializable)command -> {
                    Interpreter$.$anonfun$autocomplete$7(cmd, state, command);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Reporters$.MODULE$.equals(mode)) {
                ReporterKind$.MODULE$.reporters().foreach((Function1 & Serializable & scala.Serializable)reporter -> {
                    Interpreter$.$anonfun$autocomplete$11(cmd, state, reporter);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Protocols$.MODULE$.equals(mode)) {
                BspProtocol$.MODULE$.protocols().foreach((Function1 & Serializable & scala.Serializable)protocol -> {
                    Interpreter$.$anonfun$autocomplete$13(cmd, state, protocol);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$MainsFQCN$.MODULE$.equals(mode)) {
                cmd.project().foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$autocomplete$15(cmd, state, projectName);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$TestsFQCN$.MODULE$.equals(mode)) {
                cmd.project().foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$autocomplete$19(cmd, state, projectName);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)mode);
            }
            return state;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Config.LinkerMode getOptimizerMode(Option<OptimizerConfig> config, Config.LinkerMode fallbackMode) {
        OptimizerConfig optimizerConfig;
        boolean bl = false;
        Some some = null;
        Option<OptimizerConfig> option = config;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            OptimizerConfig optimizerConfig2 = (OptimizerConfig)some.value();
            if (OptimizerConfig$Debug$.MODULE$.equals(optimizerConfig2)) {
                return Config.LinkerMode$.Debug$.MODULE$;
            }
        }
        if (bl && OptimizerConfig$Release$.MODULE$.equals(optimizerConfig = (OptimizerConfig)some.value())) {
            return Config.LinkerMode$.Release$.MODULE$;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return fallbackMode;
    }

    private Task<State> link(Commands.Link cmd, State state2, boolean sequential) {
        Task<State> task;
        ReporterConfig reporter = ReporterKind$.MODULE$.toReporterConfig(cmd.reporter());
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else if (option instanceof Some) {
            Task<State> task2;
            Some some = (Some)option;
            Project project = (Project)some.value();
            Config.Platform platform = project.platform();
            if (platform instanceof Config.Platform.Native) {
                Config.Platform.Native native_ = (Config.Platform.Native)platform;
                Config.NativeConfig config = native_.config();
                task2 = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.doNativeRun$1(project, config, (State)state, cmd, sequential, reporter)) : this.doNativeRun$1(project, config, state2, cmd, sequential, reporter);
            } else if (platform instanceof Config.Platform.Js) {
                Config.Platform.Js js = (Config.Platform.Js)platform;
                Config.JsConfig config = js.config();
                task2 = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.doJsRun$1(project, config, (State)state, cmd, sequential, reporter)) : this.doJsRun$1(project, config, state2, cmd, sequential, reporter);
            } else if (platform instanceof Config.Platform$.Jvm) {
                String msg = "Expected Scala Native or Scala.js project to run `link`.";
                task2 = State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state2), msg, ExitStatus$.MODULE$.InvalidCommandLineOption());
            } else {
                throw new MatchError((Object)platform);
            }
            task = task2;
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> configure(Commands.Configure cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> cmd.threads() != ExecutionContext$.MODULE$.executor().getCorePoolSize() ? State$.MODULE$.setCores(state, cmd.threads()) : state);
    }

    private Task<State> clean(Commands.Clean cmd, State state) {
        Tuple2<List<Project>, List<String>> tuple2 = this.lookupProjects(cmd.project(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List projects = (List)tuple2._1();
        List missing = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)projects, (Object)missing);
        Tuple2 tuple23 = tuple22;
        List projects2 = (List)tuple23._1();
        List missing2 = (List)tuple23._2();
        return missing2.isEmpty() ? Tasks$.MODULE$.clean(state, (List<Project>)projects2, cmd.isolated()).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.mergeStatus(ExitStatus$.MODULE$.Ok())) : Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.reportMissing((List<String>)missing2, state));
    }

    private Task<State> run(Commands.Run cmd, State state2, boolean sequential) {
        Task task;
        ReporterConfig reporter = ReporterKind$.MODULE$.toReporterConfig(cmd.reporter());
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.doRun$1((State)state, cmd, sequential, reporter, project)) : this.doRun$1(state2, cmd, sequential, reporter, project);
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private State reportMissing(List<String> projectNames, State state) {
        String projects = projectNames.mkString("'", "', '", "'");
        String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
        state.logger().error(new StringBuilder(31).append("No projects named ").append(projects).append(" found in '").append(configDirectory).append("'.").toString());
        state.logger().error("Use the `projects` command to list existing projects.");
        return state.mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption());
    }

    private Option<String> getMainClass(State state, Project project) {
        None$ none$;
        String[] stringArray = Tasks$.MODULE$.findMainClasses(state, project);
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            state.logger().error(new StringBuilder(35).append("No main classes found in project '").append(project.name()).append("'").toString());
            none$ = None$.MODULE$;
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
                String main = (String)((SeqLike)option2.get()).apply(0);
                none$ = new Some((Object)main);
            } else {
                String eol = System.lineSeparator();
                String message = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(78).append("Several main classes were found, specify which one:\n                         |").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).mkString(" * ", new StringBuilder(3).append(eol).append(" * ").toString(), "")).toString())).stripMargin();
                state.logger().error(message);
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private static final Task execute$1(Action action, Task stateTask, boolean inRecursion) {
        return stateTask.flatMap((Function1 & Serializable & scala.Serializable)state -> {
            Commands.Command cmd;
            ExitStatus exitStatus;
            boolean bl = false;
            Exit exit = null;
            boolean bl2 = false;
            Run run2 = null;
            Action action = action;
            if (action instanceof Exit) {
                ExitStatus exitStatus2;
                bl = true;
                exit = (Exit)action;
                ExitStatus exitStatus3 = exit.exitStatus();
                if (exitStatus3 != null && (exitStatus2 = exitStatus3).isOk()) {
                    return Task$.MODULE$.now((Object)state.mergeStatus(exitStatus2));
                }
            }
            if (bl && (exitStatus = exit.exitStatus()) != null) {
                ExitStatus exitStatus4 = exitStatus;
                return Task$.MODULE$.now((Object)state.mergeStatus(exitStatus4));
            }
            if (action instanceof Print) {
                Print print = (Print)action;
                String msg = print.msg();
                Action next = print.next();
                state.logger().info(msg);
                return Interpreter$.execute$1(next, Task$.MODULE$.now(state), true);
            }
            if (action instanceof Run) {
                bl2 = true;
                run2 = (Run)action;
                Commands.Command command = run2.command();
                Action next = run2.next();
                if (command instanceof Commands.About) {
                    return Interpreter$.execute$1(next, MODULE$.printAbout((State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd2 = run2.command();
                Action next = run2.next();
                if (cmd2 instanceof Commands.ValidatedBsp) {
                    Commands.ValidatedBsp validatedBsp = (Commands.ValidatedBsp)cmd2;
                    return Interpreter$.execute$1(next, MODULE$.runBsp(validatedBsp, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd3 = run2.command();
                Action next = run2.next();
                if (cmd3 instanceof Commands.Clean) {
                    Commands.Clean clean = (Commands.Clean)cmd3;
                    return Interpreter$.execute$1(next, MODULE$.clean(clean, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd4 = run2.command();
                Action next = run2.next();
                if (cmd4 instanceof Commands.Compile) {
                    Commands.Compile compile = (Commands.Compile)cmd4;
                    return Interpreter$.execute$1(next, MODULE$.compile(compile, (State)state, inRecursion), true);
                }
            }
            if (bl2) {
                Commands.Command cmd5 = run2.command();
                Action next = run2.next();
                if (cmd5 instanceof Commands.Console) {
                    Commands.Console console = (Commands.Console)cmd5;
                    return Interpreter$.execute$1(next, MODULE$.console(console, (State)state, inRecursion), true);
                }
            }
            if (bl2) {
                Commands.Command cmd6 = run2.command();
                Action next = run2.next();
                if (cmd6 instanceof Commands.Projects) {
                    Commands.Projects projects = (Commands.Projects)cmd6;
                    return Interpreter$.execute$1(next, MODULE$.showProjects(projects, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd7 = run2.command();
                Action next = run2.next();
                if (cmd7 instanceof Commands.Test) {
                    Commands.Test test = (Commands.Test)cmd7;
                    return Interpreter$.execute$1(next, MODULE$.test(test, (State)state, inRecursion), true);
                }
            }
            if (bl2) {
                Commands.Command cmd8 = run2.command();
                Action next = run2.next();
                if (cmd8 instanceof Commands.Run) {
                    Commands.Run run3 = (Commands.Run)cmd8;
                    return Interpreter$.execute$1(next, MODULE$.run(run3, (State)state, inRecursion), true);
                }
            }
            if (bl2) {
                Commands.Command cmd9 = run2.command();
                Action next = run2.next();
                if (cmd9 instanceof Commands.Configure) {
                    Commands.Configure configure = (Commands.Configure)cmd9;
                    return Interpreter$.execute$1(next, MODULE$.configure(configure, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd10 = run2.command();
                Action next = run2.next();
                if (cmd10 instanceof Commands.Autocomplete) {
                    Commands.Autocomplete autocomplete = (Commands.Autocomplete)cmd10;
                    return Interpreter$.execute$1(next, MODULE$.autocomplete(autocomplete, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd11 = run2.command();
                Action next = run2.next();
                if (cmd11 instanceof Commands.Link) {
                    Commands.Link link2 = (Commands.Link)cmd11;
                    return Interpreter$.execute$1(next, MODULE$.link(link2, (State)state, inRecursion), true);
                }
            }
            if (bl2 && (cmd = run2.command()) instanceof Commands.Help) {
                Commands.Help help = (Commands.Help)cmd;
                String msg = "The handling of help doesn't happen in the `Interpreter`.";
                Print printAction = new Print(msg, help.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
                return Interpreter$.execute$1(printAction, Task$.MODULE$.now(state), true);
            }
            if (!bl2) throw new MatchError((Object)action);
            Commands.Command cmd12 = run2.command();
            if (!(cmd12 instanceof Commands.Bsp)) throw new MatchError((Object)action);
            Commands.Bsp bsp = (Commands.Bsp)cmd12;
            String msg = "Internal error: command bsp must be validated before use.";
            Print printAction = new Print(msg, bsp.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
            return Interpreter$.execute$1(printAction, Task$.MODULE$.now(state), true);
        });
    }

    private static final Task doCompile$1(State state, boolean sequential$1, ReporterConfig config$1, Project project$1) {
        return Tasks$.MODULE$.compile(state, project$1, config$1, sequential$1, Tasks$.MODULE$.compile$default$5()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.mergeStatus(ExitStatus$.MODULE$.Ok()));
    }

    public static final /* synthetic */ void $anonfun$showProjects$3(State state$5, String x$1) {
        state$5.logger().info(x$1);
    }

    private final Task doTest$1(State state2, Commands.Test cmd$4, boolean sequential$2, ReporterConfig reporterConfig$1, Project project$4) {
        Function1<String, Object> testFilter = TestInternals$.MODULE$.parseFilters(cmd$4.only());
        Path cwd = cmd$4.cliOptions().common().workingPath();
        return this.compileAnd(state2, project$4, reporterConfig$1, false, sequential$2, "`test`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            LoggingEventHandler testEventHandler = new LoggingEventHandler(state.logger());
            return Tasks$.MODULE$.test((State)state, project$4, cwd, cmd$4.isolated(), cmd$4.args(), testFilter, testEventHandler);
        });
    }

    public static final /* synthetic */ boolean $anonfun$autocomplete$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$4(State state$9, String completion) {
        state$9.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$3(Commands.Autocomplete cmd$7, State state$9, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        CommandMessages args = (CommandMessages)tuple2._2();
        cmd$7.format().showCommand(name, args).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$4(state$9, completion);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$6(State state$9, String completion) {
        state$9.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$5(Commands.Autocomplete cmd$7, State state$9, Project project) {
        cmd$7.format().showProject(project).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$6(state$9, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$10(State state$9, String completion) {
        state$9.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$9(Commands.Autocomplete cmd$7, State state$9, String command$1, Arg arg) {
        cmd$7.format().showArg(command$1, Case$.MODULE$.kebabizeArg(arg)).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$10(state$9, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$8(Commands.Autocomplete cmd$7, State state$9, String command$1, CommandMessages message) {
        message.args().foreach((Function1 & Serializable & scala.Serializable)arg -> {
            Interpreter$.$anonfun$autocomplete$9(cmd$7, state$9, command$1, arg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$7(Commands.Autocomplete cmd$7, State state$9, String command) {
        CliParsers$.MODULE$.CommandsMessages().messages().toMap(Predef$.MODULE$.$conforms()).get((Object)command).foreach((Function1 & Serializable & scala.Serializable)message -> {
            Interpreter$.$anonfun$autocomplete$8(cmd$7, state$9, command, message);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$12(State state$9, String completion) {
        state$9.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$11(Commands.Autocomplete cmd$7, State state$9, ReporterKind reporter) {
        cmd$7.format().showReporter(reporter).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$12(state$9, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$14(State state$9, String completion) {
        state$9.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$13(Commands.Autocomplete cmd$7, State state$9, BspProtocol protocol) {
        cmd$7.format().showProtocol(protocol).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$14(state$9, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$18(State state$9, String completion) {
        state$9.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$17(Commands.Autocomplete cmd$7, State state$9, String main) {
        cmd$7.format().showMainName(main).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$18(state$9, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$16(Commands.Autocomplete cmd$7, State state$9, Project project) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Tasks$.MODULE$.findMainClasses(state$9, project))).foreach((Function1 & Serializable & scala.Serializable)main -> {
            Interpreter$.$anonfun$autocomplete$17(cmd$7, state$9, main);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$15(Commands.Autocomplete cmd$7, State state$9, String projectName) {
        state$9.build().getProjectFor(projectName).foreach((Function1 & Serializable & scala.Serializable)project -> {
            Interpreter$.$anonfun$autocomplete$16(cmd$7, state$9, project);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$22(State state$9, String completion) {
        state$9.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$21(Commands.Autocomplete cmd$7, State state$9, String placeholder) {
        cmd$7.format().showTestName(placeholder).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$22(state$9, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$20(Commands.Autocomplete cmd$7, State state$9, Project project) {
        List$.MODULE$.empty().foreach((Function1 & Serializable & scala.Serializable)placeholder -> {
            Interpreter$.$anonfun$autocomplete$21(cmd$7, state$9, placeholder);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$19(Commands.Autocomplete cmd$7, State state$9, String projectName) {
        state$9.build().getProjectFor(projectName).foreach((Function1 & Serializable & scala.Serializable)project -> {
            Interpreter$.$anonfun$autocomplete$20(cmd$7, state$9, project);
            return BoxedUnit.UNIT;
        });
    }

    private final Task doJsRun$1(Project project, Config.JsConfig config0, State state2, Commands.Link cmd$8, boolean sequential$4, ReporterConfig reporter$1) {
        return this.compileAnd(state2, project, reporter$1, false, sequential$4, "`link`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            Option option = cmd$8.main().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getMainClass((State)state, project));
            if (None$.MODULE$.equals(option)) {
                task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state);
            } else if (option instanceof Some) {
                Task task2;
                Some some = (Some)option;
                String main = (String)some.value();
                Option<ScalaJsToolchain> option2 = project.jsToolchain();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    ScalaJsToolchain toolchain = (ScalaJsToolchain)some2.value();
                    Config.LinkerMode x$15 = MODULE$.getOptimizerMode(cmd$8.optimize(), config0.mode());
                    String x$16 = config0.copy$default$1();
                    Config.ModuleKindJS x$17 = config0.copy$default$3();
                    boolean x$18 = config0.copy$default$4();
                    List x$19 = config0.copy$default$5();
                    Config.JsConfig config = config0.copy(x$16, x$15, x$17, x$18, x$19);
                    task2 = toolchain.link(config, project, main, state.logger()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Task<State> task;
                        Try try_ = x0$2;
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Path jsOut = ((AbsolutePath)success.value()).underlying();
                            task = State$XState$.MODULE$.withInfo$extension(State$.MODULE$.XState((State)state), new StringBuilder(22).append("Generated js binary '").append(AbsolutePath$.MODULE$.syntax$extension(jsOut)).append("'").toString());
                        } else if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable ex = failure.exception();
                            state.logger().trace(ex);
                            String msg = new StringBuilder(33).append("Javascript linking failed with '").append(ex.getMessage()).append("'").toString();
                            task = State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.LinkingError());
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        return task;
                    });
                } else if (None$.MODULE$.equals(option2)) {
                    String msg = new StringBuilder(57).append("Missing Scala.js toolchain for project ").append(project).append(". Report upstream.").toString();
                    task2 = State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.LinkingError());
                } else {
                    throw new MatchError(option2);
                }
                task = task2;
            } else {
                throw new MatchError((Object)option);
            }
            return task;
        });
    }

    private final Task doNativeRun$1(Project project, Config.NativeConfig config0, State state2, Commands.Link cmd$8, boolean sequential$4, ReporterConfig reporter$1) {
        return this.compileAnd(state2, project, reporter$1, false, sequential$4, "`link`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            Option option = cmd$8.main().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getMainClass((State)state, project));
            if (None$.MODULE$.equals(option)) {
                task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state);
            } else if (option instanceof Some) {
                Task task2;
                Some some = (Some)option;
                String main = (String)some.value();
                Option<ScalaNativeToolchain> option2 = project.nativeToolchain();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    ScalaNativeToolchain toolchain = (ScalaNativeToolchain)some2.value();
                    Config.LinkerMode x$20 = MODULE$.getOptimizerMode(cmd$8.optimize(), config0.mode());
                    String x$21 = config0.copy$default$1();
                    String x$22 = config0.copy$default$3();
                    String x$23 = config0.copy$default$4();
                    Path x$24 = config0.copy$default$5();
                    Path x$25 = config0.copy$default$6();
                    Path x$26 = config0.copy$default$7();
                    List x$27 = config0.copy$default$8();
                    Config.NativeOptions x$28 = config0.copy$default$9();
                    boolean x$29 = config0.copy$default$10();
                    Config.NativeConfig config = config0.copy(x$21, x$20, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29);
                    task2 = toolchain.link(config, project, main, state.logger()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Task<State> task;
                        Try try_ = x0$3;
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Path bin = ((AbsolutePath)success.value()).underlying();
                            task = State$XState$.MODULE$.withInfo$extension(State$.MODULE$.XState((State)state), new StringBuilder(26).append("Generated native binary '").append(AbsolutePath$.MODULE$.syntax$extension(bin)).append("'").toString());
                        } else if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable ex = failure.exception();
                            state.logger().trace(ex);
                            String msg = new StringBuilder(29).append("Native linking failed with '").append(ex.getMessage()).append("'").toString();
                            task = State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.LinkingError());
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        return task;
                    });
                } else if (None$.MODULE$.equals(option2)) {
                    String msg = new StringBuilder(61).append("Missing Scala Native toolchain for project ").append(project).append(". Report upstream.").toString();
                    task2 = State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.LinkingError());
                } else {
                    throw new MatchError(option2);
                }
                task = task2;
            } else {
                throw new MatchError((Object)option);
            }
            return task;
        });
    }

    private final Task doRun$1(State state2, Commands.Run cmd$5, boolean sequential$3, ReporterConfig reporter$2, Project project$8) {
        return this.compileAnd(state2, project$8, reporter$2, false, sequential$3, "`run`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            Task<State> task;
            Option option = cmd$5.main().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getMainClass((State)state, project$8));
            if (None$.MODULE$.equals(option)) {
                task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state.mergeStatus(ExitStatus$.MODULE$.RunError()));
            } else if (option instanceof Some) {
                Task<State> task2;
                Some some = (Some)option;
                String mainClass = (String)some.value();
                String[] args = (String[])cmd$5.args().toArray(ClassTag$.MODULE$.apply(String.class));
                Path cwd = cmd$5.cliOptions().common().workingPath();
                Config.Platform platform = project$8.platform();
                if (platform instanceof Config.Platform.Native) {
                    Task<State> task3;
                    Config.Platform.Native native_ = (Config.Platform.Native)platform;
                    Config.NativeConfig config0 = native_.config();
                    Option<ScalaNativeToolchain> option2 = project$8.nativeToolchain();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        ScalaNativeToolchain toolchain = (ScalaNativeToolchain)some2.value();
                        Config.LinkerMode x$30 = MODULE$.getOptimizerMode(cmd$5.optimize(), config0.mode());
                        String x$31 = config0.copy$default$1();
                        String x$32 = config0.copy$default$3();
                        String x$33 = config0.copy$default$4();
                        Path x$34 = config0.copy$default$5();
                        Path x$35 = config0.copy$default$6();
                        Path x$36 = config0.copy$default$7();
                        List x$37 = config0.copy$default$8();
                        Config.NativeOptions x$38 = config0.copy$default$9();
                        boolean x$39 = config0.copy$default$10();
                        Config.NativeConfig config = config0.copy(x$31, x$30, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39);
                        task3 = toolchain.run((State)state, config, project$8, cwd, mainClass, args);
                    } else if (None$.MODULE$.equals(option2)) {
                        String msg = new StringBuilder(54).append("Missing Scala Native toolchain in '").append(project$8).append("'. Report upstream.").toString();
                        task3 = State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.LinkingError());
                    } else {
                        throw new MatchError(option2);
                    }
                    task2 = task3;
                } else if (platform instanceof Config.Platform.Js) {
                    Task<State> task4;
                    Config.Platform.Js js = (Config.Platform.Js)platform;
                    Config.JsConfig config0 = js.config();
                    Option<ScalaJsToolchain> option3 = project$8.jsToolchain();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        ScalaJsToolchain toolchain = (ScalaJsToolchain)some3.value();
                        Config.LinkerMode x$40 = MODULE$.getOptimizerMode(cmd$5.optimize(), config0.mode());
                        String x$41 = config0.copy$default$1();
                        Config.ModuleKindJS x$42 = config0.copy$default$3();
                        boolean x$43 = config0.copy$default$4();
                        List x$44 = config0.copy$default$5();
                        Config.JsConfig config = config0.copy(x$41, x$40, x$42, x$43, x$44);
                        task4 = toolchain.run((State)state, config, project$8, cwd, mainClass, args);
                    } else if (None$.MODULE$.equals(option3)) {
                        String msg = new StringBuilder(50).append("Missing Scala.js toolchain in '").append(project$8).append("'. Report upstream.").toString();
                        task4 = State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.LinkingError());
                    } else {
                        throw new MatchError(option3);
                    }
                    task2 = task4;
                } else {
                    task2 = Tasks$.MODULE$.run((State)state, project$8, cwd, mainClass, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toArray(ClassTag$.MODULE$.apply(String.class)));
                }
                task = task2;
            } else {
                throw new MatchError((Object)option);
            }
            return task;
        });
    }

    private Interpreter$() {
        MODULE$ = this;
        this.line = System.lineSeparator();
    }
}

