/*
 * Decompiled with CFR 0.152.
 */
package bloop.exec;

import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.engine.ExecutionContext$;
import bloop.exec.Forker;
import bloop.exec.JavaEnv;
import bloop.io.AbsolutePath;
import bloop.logging.Logger;
import com.zaxxer.nuprocess.NuAbstractProcessHandler;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import com.zaxxer.nuprocess.NuProcessHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;

public final class Forker$
implements scala.Serializable {
    public static Forker$ MODULE$;

    static {
        new Forker$();
    }

    private final int EXIT_OK() {
        return 0;
    }

    private final int EXIT_ERROR() {
        return 1;
    }

    public ExitStatus exitStatus(int exitCode) {
        return exitCode == 0 ? ExitStatus$.MODULE$.Ok() : ExitStatus$.MODULE$.RunError();
    }

    public Task<Object> run(Path cwd, Seq<String> cmd, Logger logger, CommonOptions opts) {
        Task task;
        if (!Files.exists(cwd, new LinkOption[0])) {
            task = Task$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                logger.error(new java.lang.StringBuilder(52).append("Couldn't start the process because '").append(new AbsolutePath(cwd)).append("' doesn't exist.").toString());
                return 1;
            });
        } else {
            ObjectRef gobbleInput = ObjectRef.create(null);
            VolatileBooleanRef shutdownInput = VolatileBooleanRef.create((boolean)false);
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                public final class Bloop_exec_Forker$ProcessHandler$1
                extends NuAbstractProcessHandler {
                    private final StringBuilder outBuilder;
                    private final StringBuilder errBuilder;
                    private final Path cwd$1;
                    private final Seq cmd$1;
                    private final Logger logger$1;
                    private final ObjectRef gobbleInput$1;

                    public void onStart(NuProcess nuProcess) {
                        this.logger$1.debug(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(138).append("Starting forked process:\n                          |  cwd = '").append(new AbsolutePath(this.cwd$1)).append("'\n                          |  pid = '").append(nuProcess.getPID()).append("'\n                          |  cmd = '").append(this.cmd$1.mkString(" ")).append("'").toString())).stripMargin());
                    }

                    public void onExit(int statusCode) {
                        this.logger$1.debug(new java.lang.StringBuilder(33).append("Forked process exited with code: ").append(statusCode).toString());
                    }

                    public StringBuilder outBuilder() {
                        return this.outBuilder;
                    }

                    public void onStdout(ByteBuffer buffer, boolean closed) {
                        if (closed) {
                            if ((Cancelable)this.gobbleInput$1.elem != null) {
                                ((Cancelable)this.gobbleInput$1.elem).cancel();
                            }
                            this.logger$1.debug("The process is closed; emptying out buffer.");
                            String remaining = this.outBuilder().mkString();
                            if (!remaining.isEmpty()) {
                                this.logger$1.info(remaining);
                            }
                        } else {
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Forker$.MODULE$.linesFrom(buffer, this.outBuilder()))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                                Bloop_exec_Forker$ProcessHandler$1.$anonfun$onStdout$1(this, x$10);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }

                    public StringBuilder errBuilder() {
                        return this.errBuilder;
                    }

                    public void onStderr(ByteBuffer buffer, boolean closed) {
                        if (closed) {
                            String remaining = this.errBuilder().mkString();
                            if (!remaining.isEmpty()) {
                                this.logger$1.error(remaining);
                            }
                        } else {
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Forker$.MODULE$.linesFrom(buffer, this.errBuilder()))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                                Bloop_exec_Forker$ProcessHandler$1.$anonfun$onStderr$1(this, x$11);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }

                    public static final /* synthetic */ void $anonfun$onStdout$1(Bloop_exec_Forker$ProcessHandler$1 $this, String x$10) {
                        $this.logger$1.info(x$10);
                    }

                    public static final /* synthetic */ void $anonfun$onStderr$1(Bloop_exec_Forker$ProcessHandler$1 $this, String x$11) {
                        $this.logger$1.error(x$11);
                    }

                    public Bloop_exec_Forker$ProcessHandler$1(Path cwd$1, Seq cmd$1, Logger logger$1, ObjectRef gobbleInput$1) {
                        this.cwd$1 = cwd$1;
                        this.cmd$1 = cmd$1;
                        this.logger$1 = logger$1;
                        this.gobbleInput$1 = gobbleInput$1;
                        this.outBuilder = package$.MODULE$.StringBuilder().newBuilder();
                        this.errBuilder = package$.MODULE$.StringBuilder().newBuilder();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onStdout$1$adapted(bloop.exec.Forker$ProcessHandler$1 java.lang.String ), $anonfun$onStderr$1$adapted(bloop.exec.Forker$ProcessHandler$1 java.lang.String )}, serializedLambda);
                    }
                }
                Bloop_exec_Forker$ProcessHandler$1 handler = new Bloop_exec_Forker$ProcessHandler$1(cwd, cmd, logger, gobbleInput);
                NuProcessBuilder builder = new NuProcessBuilder((NuProcessHandler)handler, (String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class)));
                builder.setCwd(cwd);
                java.util.Map npEnv = builder.environment();
                npEnv.clear();
                npEnv.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)JavaConverters$.MODULE$.propertiesAsScalaMap((Properties)opts.env())).asJava());
                return builder.start();
            }).flatMap((Function1 & Serializable & scala.Serializable)process -> {
                FiniteDuration duration = FiniteDuration$.MODULE$.apply(50L, TimeUnit.MILLISECONDS);
                gobbleInput$1.elem = Scheduler.Extensions$.MODULE$.scheduleWithFixedDelay$extension(Scheduler$.MODULE$.Extensions(ExecutionContext$.MODULE$.ioScheduler()), duration, duration, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    byte[] buffer = new byte[4096];
                    int read = opts.in().read(buffer, 0, buffer.length);
                    if (read != -1 && !shutdownInput$1.elem && process.isRunning()) {
                        process.writeStdin(ByteBuffer.wrap(buffer));
                    }
                });
                return Task$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                    int n;
                    try {
                        int exitCode = process.waitFor(0L, TimeUnit.SECONDS);
                        logger.debug(new java.lang.StringBuilder(27).append("Process ").append(process.getPID()).append(" exited with code: ").append(exitCode).toString());
                        n = exitCode;
                    }
                    finally {
                        shutdownInput$1.elem = true;
                        ((Cancelable)gobbleInput$1.elem).cancel();
                    }
                    return n;
                }).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    shutdownInput$1.elem = true;
                    ((Cancelable)gobbleInput$1.elem).cancel();
                    try {
                        process.closeStdin(true);
                    }
                    finally {
                        process.destroy(true);
                        process.waitFor(200L, TimeUnit.MILLISECONDS);
                        if (process.isRunning()) {
                            String msg = new java.lang.StringBuilder(43).append("The cancellation couldn't destroy process ").append(process.getPID()).append(".").toString();
                            opts.ngout().println(msg);
                            logger.debug(msg);
                        } else {
                            String msg = new java.lang.StringBuilder(33).append("The run process ").append(process.getPID()).append(" has been closed.").toString();
                            opts.ngout().println(msg);
                            logger.debug(msg);
                        }
                    }
                }));
            });
        }
        return task;
    }

    public String[] linesFrom(ByteBuffer buffer, StringBuilder remaining) {
        String[] stringArray;
        String[] newLines;
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        String msg = new String(bytes, StandardCharsets.UTF_8);
        String[] stringArray2 = newLines = msg.split(System.lineSeparator(), Integer.MAX_VALUE);
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray2);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            remaining.$plus$plus$eq(msg);
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        } else {
            String[] stringArray3;
            String msgAtTheEnd = newLines[newLines.length - 1];
            boolean shouldBuffer = !msgAtTheEnd.isEmpty();
            Object object = shouldBuffer ? remaining.$plus$plus$eq(msgAtTheEnd) : BoxedUnit.UNIT;
            if (stringArray2.length > 1) {
                if (shouldBuffer) {
                    stringArray3 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newLines)).init();
                } else {
                    String firstLine = newLines[0];
                    newLines[0] = (String)new StringOps(Predef$.MODULE$.augmentString(remaining.mkString())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(firstLine)), Predef$.MODULE$.StringCanBuildFrom());
                    remaining.clear();
                    stringArray3 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newLines)).init();
                }
            } else {
                stringArray3 = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
            stringArray = stringArray3;
        }
        return stringArray;
    }

    public Forker apply(JavaEnv javaEnv, AbsolutePath[] classpath) {
        return new Forker(javaEnv, classpath);
    }

    public Option<Tuple2<JavaEnv, Path[]>> unapply(Forker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.javaEnv(), (Object)x$0.classpath()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Forker$() {
        MODULE$ = this;
    }
}

