/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.Project;
import bloop.bsp.BspServer$;
import bloop.cli.CliOptions;
import bloop.cli.Commands;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.tasks.Tasks$;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.SourceWatcher;
import bloop.io.Timer$;
import bloop.reporter.ReporterConfig;
import bloop.reporter.ReporterConfig$;
import bloop.testing.TestInternals$;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.misc.NonFatal$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;
    private final String line;

    static {
        new Interpreter$();
    }

    public State execute(Action action, State state) {
        State state2;
        block23: {
            Action action2;
            while (true) {
                Commands.Command cmd;
                boolean bl = false;
                Exit exit = null;
                boolean bl2 = false;
                Run run2 = null;
                action2 = action;
                if (action2 instanceof Exit) {
                    bl = true;
                    exit = (Exit)action2;
                    ExitStatus exitStatus = exit.exitStatus();
                    if (state.status().isOk()) {
                        state2 = state.mergeStatus(exitStatus);
                        break block23;
                    }
                }
                if (bl) {
                    state2 = state;
                    break block23;
                }
                if (action2 instanceof Print) {
                    Print print = (Print)action2;
                    String msg = print.msg();
                    Action next = print.next();
                    state.logger().info(msg);
                    action = next;
                    continue;
                }
                if (action2 instanceof Run) {
                    bl2 = true;
                    run2 = (Run)action2;
                    Commands.Command command = run2.command();
                    Action next = run2.next();
                    if (command instanceof Commands.About) {
                        Commands.About about = (Commands.About)command;
                        CliOptions cliOptions = about.cliOptions();
                        state = Interpreter$.logAndTime$1(cliOptions, this.printAbout(state), state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd2 = run2.command();
                    Action next = run2.next();
                    if (cmd2 instanceof Commands.ValidatedBsp) {
                        Commands.ValidatedBsp validatedBsp = (Commands.ValidatedBsp)cmd2;
                        state = Interpreter$.logAndTime$1(validatedBsp.cliOptions(), this.runBsp(validatedBsp, state), state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd3 = run2.command();
                    Action next = run2.next();
                    if (cmd3 instanceof Commands.Clean) {
                        Commands.Clean clean = (Commands.Clean)cmd3;
                        state = Interpreter$.logAndTime$1(clean.cliOptions(), this.clean(clean, state), state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd4 = run2.command();
                    Action next = run2.next();
                    if (cmd4 instanceof Commands.Compile) {
                        Commands.Compile compile = (Commands.Compile)cmd4;
                        state = Interpreter$.logAndTime$1(compile.cliOptions(), this.compile(compile, state), state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd5 = run2.command();
                    Action next = run2.next();
                    if (cmd5 instanceof Commands.Console) {
                        Commands.Console console = (Commands.Console)cmd5;
                        state = Interpreter$.logAndTime$1(console.cliOptions(), this.console(console, state), state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd6 = run2.command();
                    Action next = run2.next();
                    if (cmd6 instanceof Commands.Projects) {
                        Commands.Projects projects = (Commands.Projects)cmd6;
                        state = Interpreter$.logAndTime$1(projects.cliOptions(), this.showProjects(projects, state), state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd7 = run2.command();
                    Action next = run2.next();
                    if (cmd7 instanceof Commands.Test) {
                        Commands.Test test = (Commands.Test)cmd7;
                        state = Interpreter$.logAndTime$1(test.cliOptions(), this.test(test, state), state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd8 = run2.command();
                    Action next = run2.next();
                    if (cmd8 instanceof Commands.Run) {
                        Commands.Run run3 = (Commands.Run)cmd8;
                        state = Interpreter$.logAndTime$1(run3.cliOptions(), this.run(run3, state), state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd9 = run2.command();
                    Action next = run2.next();
                    if (cmd9 instanceof Commands.Configure) {
                        Commands.Configure configure = (Commands.Configure)cmd9;
                        state = Interpreter$.logAndTime$1(configure.cliOptions(), this.configure(configure, state), state);
                        action = next;
                        continue;
                    }
                }
                if (!bl2 || !((cmd = run2.command()) instanceof Commands.Bsp)) break;
                Commands.Bsp bsp = (Commands.Bsp)cmd;
                String msg = "Internal error: command bsp must be validated before use.";
                action = new Print(msg, bsp.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
            }
            throw new MatchError((Object)action2);
        }
        return state2;
    }

    private final String t() {
        return "    ";
    }

    private final String line() {
        return this.line;
    }

    private Task<State> printAbout(State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String bloopName = BuildInfo$.MODULE$.name();
            String bloopVersion = BuildInfo$.MODULE$.version();
            String scalaVersion = BuildInfo$.MODULE$.scalaVersion();
            String zincVersion = BuildInfo$.MODULE$.zincVersion();
            String developers = BuildInfo$.MODULE$.developers().mkString(", ");
            String header = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "   _____            __         ______           __\n          |", "  / ___/_________ _/ /___ _   / ____/__  ____  / /____  _____\n          |", "  \\\\__ \\\\/ ___/ __ `/ / __ `/  / /   / _ \\\\/ __ \\\\/ __/ _ \\\\/ ___/\n          |", " ___/ / /__/ /_/ / / /_/ /  / /___/ /__/ / / / /_/ /__/ /\n          |", "/____/\\\\___/\\\\__,_/_/\\\\__,_/   \\\\____/\\\\___/_/ /_/\\\\__/\\\\___/_/\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", "    ", "    ", "    ", "    "})))).stripMargin();
            String versions = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                      |", "", " version    `", "`\n                      |", "Zinc version     `", "`\n                      |", "Scala version    `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", new StringOps(Predef$.MODULE$.augmentString(bloopName)).capitalize(), bloopVersion, "    ", zincVersion, "    ", scalaVersion})))).stripMargin();
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header, MODULE$.line()})));
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", " is made with love at the Scala Center <3", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", bloopName, MODULE$.line()})));
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versions, MODULE$.line(), MODULE$.line()})));
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "It is maintained by ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", developers})));
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private Task<State> runBsp(Commands.ValidatedBsp cmd, State state) {
        Scheduler scheduler = ExecutionContext$.MODULE$.bspScheduler();
        return BspServer$.MODULE$.run(cmd, state, scheduler);
    }

    private Task<State> watch(Project project, State state, Function1<State, Task<State>> f) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            List<Project> reachable = Dag$.MODULE$.dfs(state.build().getDagFor(project));
            Iterator allSourceDirs = reachable.iterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.genericArrayOps((Object)x$1.sourceDirectories()).toList()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((AbsolutePath)x$2).underlying());
            SourceWatcher watcher = new SourceWatcher((Seq<Path>)allSourceDirs.toList(), state.logger());
            Function1 & Serializable & scala.Serializable watchFn = (Function1 & Serializable & scala.Serializable)state -> MODULE$.waitAndLog((State)state, (Task<State>)((Task)f.apply(state)));
            State firstOp = (State)watchFn.apply((Object)state);
            return watcher.watch(firstOp, (Function1<State, State>)watchFn);
        });
    }

    private Task<State> compile(Commands.Compile cmd, State state) {
        Task task;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            Task<State> initialState = cmd.incremental() ? Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state) : Tasks$.MODULE$.clean(state, state.build().projects(), true);
            task = initialState.flatMap((Function1 & Serializable & scala.Serializable)state2 -> !cmd.watch() ? Interpreter$.doCompile$1(state2, reporterConfig, project) : MODULE$.watch(project, (State)state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doCompile$1(state, reporterConfig, project)));
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> showProjects(Commands.Projects cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (cmd.dotGraph()) {
                String contents = Dag$.MODULE$.toDotGraph(state.build().dags());
                state.logger().info(contents);
            } else {
                String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
                state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Projects loaded from '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configDirectory})));
                ((List)((SeqLike)state.build().projects().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$showProjects$3(state, projectName);
                    return BoxedUnit.UNIT;
                });
            }
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private Task<State> console(Commands.Console cmd, State state) {
        Task task;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = Tasks$.MODULE$.compile(state, project, reporterConfig, cmd.excludeRoot()).flatMap((Function1 & Serializable & scala.Serializable)compiled -> Tasks$.MODULE$.console((State)compiled, project, reporterConfig, cmd.excludeRoot()).map((Function1 & Serializable & scala.Serializable)result -> result.mergeStatus(ExitStatus$.MODULE$.Ok())));
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> test(Commands.Test cmd, State state2) {
        Task task;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = Tasks$.MODULE$.pickTestProject(cmd.project(), state2);
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doTest$1(state, cmd, reporterConfig, project)) : Interpreter$.doTest$1(state2, cmd, reporterConfig, project);
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Tuple2<List<Project>, List<String>> lookupProjects(List<String> names, State state) {
        Build build = state.build();
        Tuple2 result = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)List$.MODULE$.apply((Seq)Nil$.MODULE$)), (Object)List$.MODULE$.apply((Seq)Nil$.MODULE$));
        return (Tuple2)names.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String name = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            List projects = (List)tuple23._1();
            List missing = (List)tuple23._2();
            Option<Project> option = build.getProjectFor(name);
            if (option instanceof Some) {
                Project project;
                Some some = (Some)option;
                Project project2 = project = (Project)some.value();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects.$colon$colon((Object)project2)), (Object)missing);
                return tuple2;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                String string = name;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects), (Object)missing.$colon$colon((Object)string));
            }
            return tuple2;
        });
    }

    private Task<State> configure(Commands.Configure cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> cmd.threads() != ExecutionContext$.MODULE$.executor().getCorePoolSize() ? State$.MODULE$.setCores(state, cmd.threads()) : state);
    }

    private Task<State> clean(Commands.Clean cmd, State state) {
        Tuple2<List<Project>, List<String>> tuple2 = this.lookupProjects(cmd.projects(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List projects = (List)tuple2._1();
        List missing = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)projects, (Object)missing);
        Tuple2 tuple23 = tuple22;
        List projects2 = (List)tuple23._1();
        List missing2 = (List)tuple23._2();
        return missing2.isEmpty() ? Tasks$.MODULE$.clean(state, (List<Project>)projects2, cmd.isolated()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.mergeStatus(ExitStatus$.MODULE$.Ok())) : Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.reportMissing((List<String>)missing2, state));
    }

    private Task<State> run(Commands.Run cmd, State state2) {
        Task task;
        ReporterConfig reporter = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doRun$1(state, cmd, reporter, project)) : Interpreter$.doRun$1(state2, cmd, reporter, project);
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private State reportMissing(List<String> projectNames, State state) {
        String projects = projectNames.mkString("'", "', '", "'");
        String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
        state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No projects named ", " found in '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projects, configDirectory})));
        state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use the `projects` command to list existing projects."})).s((Seq)Nil$.MODULE$));
        return state.mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption());
    }

    private State waitAndLog(State previousState, Task<State> newState) {
        State state;
        try {
            state = (State)Await$.MODULE$.result((Awaitable)newState.runAsync(previousState.scheduler()), (Duration)Duration$.MODULE$.Inf());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            previousState.logger().error(t.getMessage());
            previousState.logger().trace(t);
            State state2 = previousState;
            state = state2;
        }
        return state;
    }

    private static final State logAndTime$1(CliOptions cliOptions, Task action, State state$1) {
        return (State)state$1.logger().verboseIf(cliOptions.verbose(), (Function0 & Serializable & scala.Serializable)() -> (State)Timer$.MODULE$.timed(state$1.logger(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.waitAndLog(state$1, (Task<State>)action)));
    }

    private static final Task doCompile$1(State state, ReporterConfig reporterConfig$1, Project project$2) {
        return Tasks$.MODULE$.compile(state, project$2, reporterConfig$1, Tasks$.MODULE$.compile$default$4()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.mergeStatus(ExitStatus$.MODULE$.Ok()));
    }

    public static final /* synthetic */ void $anonfun$showProjects$3(State state$6, String projectName) {
        state$6.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" * ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projectName})));
    }

    private static final Task doTest$1(State state, Commands.Test cmd$4, ReporterConfig reporterConfig$3, Project project$4) {
        Function1<String, Object> testFilter = TestInternals$.MODULE$.parseFilters(cmd$4.filter());
        Path cwd = cmd$4.cliOptions().common().workingPath();
        return Tasks$.MODULE$.compile(state, project$4, reporterConfig$3, false).flatMap((Function1 & Serializable & scala.Serializable)compiled -> Tasks$.MODULE$.test((State)compiled, project$4, cwd, cmd$4.isolated(), testFilter).map((Function1 & Serializable & scala.Serializable)result -> result));
    }

    private static final Option getMainClass$1(State state, Commands.Run cmd$5, Project project$5) {
        return cmd$5.main().orElse((Function0 & Serializable & scala.Serializable)() -> {
            Some some;
            String[] stringArray = Tasks$.MODULE$.findMainClasses(state, project$5);
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
                state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No main classes found in project '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project$5.name()})));
                some = None$.MODULE$;
            } else {
                Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
                    String main = (String)((SeqLike)option2.get()).apply(0);
                    some = new Some((Object)main);
                } else {
                    String eol = System.lineSeparator();
                    String message = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Several main classes were found, specify which one:\n                                 |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).mkString(" * ", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " * "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eol})), "")})))).stripMargin();
                    state.logger().error(message);
                    some = None$.MODULE$;
                }
            }
            return some;
        });
    }

    private static final Task doRun$1(State state, Commands.Run cmd$5, ReporterConfig reporter$1, Project project$5) {
        return Tasks$.MODULE$.compile(state, project$5, reporter$1, false).flatMap((Function1 & Serializable & scala.Serializable)compiled -> {
            Task<State> task;
            Option option = Interpreter$.getMainClass$1(compiled, cmd$5, project$5);
            if (None$.MODULE$.equals(option)) {
                task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> compiled.mergeStatus(ExitStatus$.MODULE$.UnexpectedError()));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String main = (String)some.value();
                String[] args = (String[])cmd$5.args().toArray(ClassTag$.MODULE$.apply(String.class));
                Path cwd = cmd$5.cliOptions().common().workingPath();
                task = Tasks$.MODULE$.run((State)compiled, project$5, cwd, main, args);
            } else {
                throw new MatchError((Object)option);
            }
            return task;
        });
    }

    private Interpreter$() {
        MODULE$ = this;
        this.line = System.lineSeparator();
    }
}

