/*
 * Decompiled with CFR 0.152.
 */
package bloop.reporter;

import bloop.logging.Logger;
import bloop.reporter.ConfigurableReporter;
import bloop.reporter.Problem;
import bloop.reporter.Problem$;
import bloop.reporter.ReporterConfig;
import bloop.reporter.ReporterFormat;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xsbti.Position;
import xsbti.Severity;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0005\u001d\u0011\u0001BU3q_J$XM\u001d\u0006\u0003\u0007\u0011\t\u0001B]3q_J$XM\u001d\u0006\u0002\u000b\u0005)!\r\\8pa\u000e\u00011\u0003\u0002\u0001\t!U\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)\u0001p\u001d2uS&\u0011\u0011A\u0005\t\u0003-]i\u0011AA\u0005\u00031\t\u0011AcQ8oM&<WO]1cY\u0016\u0014V\r]8si\u0016\u0014\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011A\u000e\u0002\r1|wmZ3s+\u0005a\u0002CA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u001dawnZ4j]\u001eL!!\t\u0010\u0003\r1{wmZ3s\u0011!\u0019\u0003A!A!\u0002\u0013a\u0012a\u00027pO\u001e,'\u000f\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005\u00191m\u001e3\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0003\u0002\u0005%|\u0017B\u0001\u0017*\u00051\t%m]8mkR,\u0007+\u0019;i\u0011!q\u0003A!A!\u0002\u00139\u0013\u0001B2xI\u0002B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0015g>,(oY3Q_NLG/[8o\u001b\u0006\u0004\b/\u001a:\u0011\tI*tgN\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\tIa)\u001e8di&|g.\r\t\u0003#aJ!!\u000f\n\u0003\u0011A{7/\u001b;j_:D\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001P\u0001\u0007G>tg-[4\u0016\u0003u\u0002\"A\u0006 \n\u0005}\u0012!A\u0004*fa>\u0014H/\u001a:D_:4\u0017n\u001a\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{\u000591m\u001c8gS\u001e\u0004\u0003\"B\"\u0001\t\u0003!\u0015A\u0002\u001fj]&$h\bF\u0003F\r\u001eC\u0015\n\u0005\u0002\u0017\u0001!)!D\u0011a\u00019!)QE\u0011a\u0001O!)\u0001G\u0011a\u0001c!)1H\u0011a\u0001{!91\n\u0001b\u0001\n\u0013a\u0015A\u00024pe6\fG/F\u0001N!\t1b*\u0003\u0002P\u0005\tq!+\u001a9peR,'OR8s[\u0006$\bBB)\u0001A\u0003%Q*A\u0004g_Jl\u0017\r\u001e\u0011\t\u000fM\u0003!\u0019!C\u0005)\u0006Iq\f\u001d:pE2,Wn]\u000b\u0002+B\u0019akW/\u000e\u0003]S!\u0001W-\u0002\u000f5,H/\u00192mK*\u0011!lM\u0001\u000bG>dG.Z2uS>t\u0017B\u0001/X\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005Yq\u0016BA0\u0003\u0005\u001d\u0001&o\u001c2mK6Da!\u0019\u0001!\u0002\u0013)\u0016AC0qe>\u0014G.Z7tA!91\r\u0001a\u0001\n\u0013!\u0017aB0oKb$\u0018\nR\u000b\u0002KB\u0011!GZ\u0005\u0003ON\u00121!\u00138u\u0011\u001dI\u0007\u00011A\u0005\n)\f1b\u00188fqRLEi\u0018\u0013fcR\u00111N\u001c\t\u0003e1L!!\\\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b_\"\f\t\u00111\u0001f\u0003\rAH%\r\u0005\u0007c\u0002\u0001\u000b\u0015B3\u0002\u0011}sW\r\u001f;J\t\u0002BQa\u001d\u0001\u0005BQ\fQA]3tKR$\u0012a\u001b\u0005\u0006m\u0002!\te^\u0001\nQ\u0006\u001cXI\u001d:peN$\u0012\u0001\u001f\t\u0003eeL!A_\u001a\u0003\u000f\t{w\u000e\\3b]\")A\u0010\u0001C!o\u0006Y\u0001.Y:XCJt\u0017N\\4t\u0011\u0015q\b\u0001\"\u0011u\u00031\u0001(/\u001b8u'VlW.\u0019:z\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007\t1\"\u00197m!J|'\r\\3ngV\u0011\u0011Q\u0001\t\u0006\u0003\u000f\t9\"\u0018\b\u0005\u0003\u0013\t\u0019B\u0004\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tyAB\u0001\u0007yI|w\u000e\u001e \n\u0003QJ1!!\u00064\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0007\u0002\u001c\t\u00191+Z9\u000b\u0007\u0005U1\u0007C\u0004\u0002 \u0001!\t%!\t\u0002\u0011A\u0014xN\u00197f[N$\"!a\t\u0011\u000bI\n)#!\u000b\n\u0007\u0005\u001d2GA\u0003BeJ\f\u0017\u0010E\u0002\u0012\u0003WI!a\u0018\n\t\u000f\u0005=\u0002\u0001\"\u0011\u00022\u0005\u0019An\\4\u0015\u0007-\f\u0019\u0004\u0003\u0005\u00026\u00055\u0002\u0019AA\u0015\u0003\u0011\u0001(o\u001c2\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<\u000591m\\7nK:$H#B6\u0002>\u0005\u0005\u0003bBA \u0003o\u0001\raN\u0001\u0004a>\u001c\b\u0002CA\"\u0003o\u0001\r!!\u0012\u0002\u00075\u001cx\r\u0005\u0003\u0002H\u0005=c\u0002BA%\u0003\u0017\u00022!a\u00034\u0013\r\tieM\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00131\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u000553\u0007C\u0004\u0002X\u0001!I!!\u0017\u0002\u000f1|wMR;mYR\u00191.a\u0017\t\u000f\u0005u\u0013Q\u000ba\u0001;\u00069\u0001O]8cY\u0016l\u0007B\u0002<\u0001\t\u0013\t\t\u0007F\u0002y\u0003GB\u0001\"a\b\u0002`\u0001\u0007\u0011Q\u0001\u0005\u0007y\u0002!I!a\u001a\u0015\u0007a\fI\u0007\u0003\u0005\u0002 \u0005\u0015\u0004\u0019AA\u0003\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\naA\\3yi&#E#A3")
public final class Reporter
implements xsbti.Reporter,
ConfigurableReporter {
    private final Logger logger;
    private final Path cwd;
    private final Function1<Position, Position> sourcePositionMapper;
    private final ReporterConfig config;
    private final ReporterFormat format;
    private final ArrayBuffer<Problem> _problems;
    private int _nextID;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public Path cwd() {
        return this.cwd;
    }

    @Override
    public ReporterConfig config() {
        return this.config;
    }

    private ReporterFormat format() {
        return this.format;
    }

    private ArrayBuffer<Problem> _problems() {
        return this._problems;
    }

    private int _nextID() {
        return this._nextID;
    }

    private void _nextID_$eq(int x$1) {
        this._nextID = x$1;
    }

    public void reset() {
        this._problems().clear();
        this._nextID_$eq(1);
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors((Seq<Problem>)this._problems());
    }

    @Override
    public boolean hasWarnings() {
        return this.hasWarnings((Seq<Problem>)this._problems());
    }

    public void printSummary() {
        if (this.config().reverseOrder()) {
            ((ResizableArray)this._problems().reverse()).foreach((Function1 & Serializable & scala.Serializable)problem -> {
                this.logFull(problem);
                return BoxedUnit.UNIT;
            });
        }
        this.format().printSummary();
    }

    @Override
    public Seq<Problem> allProblems() {
        return this._problems();
    }

    public xsbti.Problem[] problems() {
        return (xsbti.Problem[])this._problems().toArray(ClassTag$.MODULE$.apply(xsbti.Problem.class));
    }

    public void log(xsbti.Problem prob) {
        block0: {
            Position mappedPos = (Position)this.sourcePositionMapper.apply((Object)prob.position());
            int problemID = prob.position().sourceFile().isPresent() ? this.nextID() : -1;
            Problem problem = Problem$.MODULE$.apply(problemID, prob.severity(), prob.message(), mappedPos, prob.category());
            this._problems().$plus$eq((Object)problem);
            if (this.config().reverseOrder()) break block0;
            this.logFull(problem);
        }
    }

    public void comment(Position pos, String msg) {
    }

    private void logFull(Problem problem) {
        String text = this.format().formatProblem(problem);
        Severity severity = problem.severity();
        if (Severity.Error.equals(severity)) {
            this.logger().error(text);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Severity.Warn.equals(severity)) {
            this.logger().warn(text);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Severity.Info.equals(severity)) {
            this.logger().info(text);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)severity);
        }
    }

    private boolean hasErrors(Seq<Problem> problems) {
        return problems.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Reporter.$anonfun$hasErrors$1(x$1)));
    }

    private boolean hasWarnings(Seq<Problem> problems) {
        return problems.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Reporter.$anonfun$hasWarnings$1(x$2)));
    }

    /*
     * WARNING - void declaration
     */
    private int nextID() {
        void var1_1;
        int id = this._nextID();
        this._nextID_$eq(this._nextID() + 1);
        return (int)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$hasErrors$1(Problem x$1) {
        Severity severity = x$1.severity();
        Severity severity2 = Severity.Error;
        return !(severity != null ? !severity.equals(severity2) : severity2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasWarnings$1(Problem x$2) {
        Severity severity = x$2.severity();
        Severity severity2 = Severity.Warn;
        return !(severity != null ? !severity.equals(severity2) : severity2 != null);
    }

    public Reporter(Logger logger, Path cwd, Function1<Position, Position> sourcePositionMapper, ReporterConfig config) {
        this.logger = logger;
        this.cwd = cwd;
        this.sourcePositionMapper = sourcePositionMapper;
        this.config = config;
        this.format = (ReporterFormat)config.format().apply((Object)this);
        this._problems = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this._nextID = 1;
    }
}

