/*
 * Decompiled with CFR 0.152.
 */
package bloop.bsp;

import bloop.bsp.BloopBspServices;
import bloop.bsp.BspServer;
import bloop.cli.Commands;
import bloop.engine.State;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import com.martiansoftware.nailgun.NGUnixDomainServerSocket;
import com.martiansoftware.nailgun.NGWin32NamedPipeServerSocket;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Path;
import java.util.Locale;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import org.langmeta.jsonrpc.BaseProtocolMessage$;
import org.langmeta.jsonrpc.JsonRpcClient;
import org.langmeta.jsonrpc.Services;
import org.langmeta.lsp.LanguageClient;
import org.langmeta.lsp.LanguageServer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class BspServer$ {
    public static BspServer$ MODULE$;
    private final boolean isWindows;
    private final boolean isMac;
    private final Logger bspLogger;

    static {
        new BspServer$();
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    private Task<BspServer.ConnectionHandle> initServer(Commands.ValidatedBsp cmd, State state) {
        Task task;
        Commands.ValidatedBsp validatedBsp = cmd;
        if (validatedBsp instanceof Commands.WindowsLocalBsp) {
            Commands.WindowsLocalBsp windowsLocalBsp = (Commands.WindowsLocalBsp)validatedBsp;
            String pipeName = windowsLocalBsp.pipeName();
            NGWin32NamedPipeServerSocket server = new NGWin32NamedPipeServerSocket(pipeName);
            state.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for a connection at pipe ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pipeName})));
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BspServer.WindowsLocal(pipeName, (ServerSocket)server)).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.close()));
        } else if (validatedBsp instanceof Commands.UnixLocalBsp) {
            Commands.UnixLocalBsp unixLocalBsp = (Commands.UnixLocalBsp)validatedBsp;
            Path socketFile = unixLocalBsp.socket();
            NGUnixDomainServerSocket server = new NGUnixDomainServerSocket(AbsolutePath$.MODULE$.toString$extension(socketFile));
            state.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for a connection at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new AbsolutePath(socketFile)})));
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BspServer.UnixLocal(socketFile, (ServerSocket)server)).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.close()));
        } else if (validatedBsp instanceof Commands.TcpBsp) {
            Commands.TcpBsp tcpBsp = (Commands.TcpBsp)validatedBsp;
            InetAddress address = tcpBsp.host();
            int portNumber = tcpBsp.port();
            InetSocketAddress socketAddress = new InetSocketAddress(address, portNumber);
            ServerSocket server = new ServerSocket(portNumber, 10, address);
            state.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for a connection at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketAddress})));
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BspServer.Tcp(socketAddress, server)).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.close()));
        } else {
            throw new MatchError((Object)validatedBsp);
        }
        return task;
    }

    public void closeSocket(Commands.ValidatedBsp cmd, Socket socket) {
        Commands.ValidatedBsp validatedBsp = cmd;
        if (validatedBsp instanceof Commands.TcpBsp && !socket.isClosed()) {
            socket.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (validatedBsp instanceof Commands.WindowsLocalBsp && !socket.isClosed()) {
            socket.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (validatedBsp instanceof Commands.UnixLocalBsp && !socket.isClosed()) {
            if (!socket.isInputShutdown()) {
                socket.shutdownInput();
            }
            if (!socket.isOutputShutdown()) {
                socket.shutdownOutput();
            }
            socket.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final Logger bspLogger() {
        return this.bspLogger;
    }

    public Task<State> run(Commands.ValidatedBsp cmd, State state, Scheduler scheduler) {
        Task runTask = this.initServer(cmd, state).materialize().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Failure failure;
            Throwable t;
            Task task;
            Success success;
            BspServer.ConnectionHandle handle;
            Try try_ = x0$1;
            if (try_ instanceof Success && (handle = (BspServer.ConnectionHandle)(success = (Success)try_).value()) != null) {
                BspServer.ConnectionHandle connectionHandle = handle;
                task = this.startServer$1(connectionHandle, state, scheduler).onErrorRecover((PartialFunction)new scala.Serializable(state){
                    public static final long serialVersionUID = 0L;
                    private final State state$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            A1 A12 = A1;
                            this.state$1.logger().error(A12.getMessage());
                            this.state$1.logger().trace(A12);
                            object = this.state$1;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable != null;
                        return bl;
                    }
                    {
                        this.state$1 = state$1;
                    }
                });
            } else if (try_ instanceof Failure && (t = (failure = (Failure)try_).exception()) != null) {
                Throwable throwable = t;
                task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BSP server failed to open a socket: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable.getMessage()})));
                    state.logger().trace(throwable);
                    return state;
                });
            } else {
                throw new MatchError((Object)try_);
            }
            return task;
        });
        return runTask.executeWithOptions((Function1 & Serializable & scala.Serializable)x$3 -> x$3.enableAutoCancelableRunLoops());
    }

    private static final String uri$1(BspServer.ConnectionHandle handle) {
        String string;
        BspServer.ConnectionHandle connectionHandle = handle;
        if (connectionHandle instanceof BspServer.WindowsLocal) {
            BspServer.WindowsLocal windowsLocal = (BspServer.WindowsLocal)connectionHandle;
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"local:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{windowsLocal.pipeName()}));
        } else if (connectionHandle instanceof BspServer.UnixLocal) {
            BspServer.UnixLocal unixLocal = (BspServer.UnixLocal)connectionHandle;
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"local://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AbsolutePath$.MODULE$.syntax$extension(unixLocal.path())}));
        } else if (connectionHandle instanceof BspServer.Tcp) {
            BspServer.Tcp tcp = (BspServer.Tcp)connectionHandle;
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tcp://", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tcp.address().getHostString(), BoxesRunTime.boxToInteger((int)tcp.address().getPort())}));
        } else {
            throw new MatchError((Object)connectionHandle);
        }
        return string;
    }

    private final Task startServer$1(BspServer.ConnectionHandle handle, State state$1, Scheduler scheduler$1) {
        String connectionURI = BspServer$.uri$1(handle);
        state$1.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The server is starting to listen at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionURI})));
        Socket socket = handle.serverSocket().accept();
        state$1.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accepted incoming BSP client connection at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionURI})));
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        LanguageClient client = new LanguageClient(out, this.bspLogger());
        BloopBspServices servicesProvider = new BloopBspServices(state$1, (JsonRpcClient)client, this.bspLogger());
        Services bloopServices = servicesProvider.services();
        Observable messages = BaseProtocolMessage$.MODULE$.fromInputStream(in);
        LanguageServer server = new LanguageServer(messages, client, bloopServices, scheduler$1, this.bspLogger());
        return server.startTask().map((Function1 & Serializable & scala.Serializable)x$1 -> servicesProvider.latestState()).doOnFinish((Function1 & Serializable & scala.Serializable)x$2 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> handle.serverSocket().close()));
    }

    private BspServer$() {
        MODULE$ = this;
        this.isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        this.isMac = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
        this.bspLogger = Logger$.MODULE$.apply(this.getClass());
    }
}

