/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.Project;
import bloop.ScalaInstance;
import bloop.ScalaInstance$;
import bloop.exec.JavaEnv;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.Paths$;
import bloop.io.Timer$;
import bloop.logging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple14;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.mutable.ParArray$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import xsbti.compile.ClasspathOptions;

public final class Project$
implements scala.Serializable {
    public static Project$ MODULE$;
    private final String loadPattern;
    private final int loadDepth;

    static {
        new Project$();
    }

    public final String loadPattern() {
        return this.loadPattern;
    }

    public final int loadDepth() {
        return this.loadDepth;
    }

    public List<Project> fromDir(Path config, Logger logger) {
        return (List)Timer$.MODULE$.timed(logger, (Function0 & Serializable & scala.Serializable)() -> {
            AbsolutePath[] configFiles = Paths$.MODULE$.getAll(config, MODULE$.loadPattern(), MODULE$.loadDepth());
            logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", " projects from '", "'..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)configFiles.length), AbsolutePath$.MODULE$.syntax$extension(config)})));
            return ((ParIterableLike)Predef$.MODULE$.genericArrayOps((Object)configFiles).par().map((Function1 & Serializable & scala.Serializable)configFile -> Project$.MODULE$.fromFile(((AbsolutePath)configFile).underlying(), logger), (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toList();
        });
    }

    public Project fromFile(Path config, Logger logger) {
        logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading project from '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new AbsolutePath(config)})));
        Path configFilepath = config;
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(configFilepath, new OpenOption[0]);){
            properties.load(inputStream);
        }
        return this.fromProperties(properties, config, logger);
    }

    public Project fromProperties(Properties properties, Path config, Logger logger) {
        String name = properties.getProperty("name");
        Path baseDirectory = Project$.toPath$1(properties.getProperty("baseDirectory"));
        String[] dependencies = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("dependencies").split(","))).filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEmpty()));
        String scalaOrganization = properties.getProperty("scalaOrganization");
        AbsolutePath[] allScalaJars = Project$.toPaths$1(properties.getProperty("allScalaJars"));
        String scalaName = properties.getProperty("scalaName");
        String scalaVersion = properties.getProperty("scalaVersion");
        ScalaInstance scalaInstance = ScalaInstance$.MODULE$.apply(scalaOrganization, scalaName, scalaVersion, allScalaJars, logger);
        AbsolutePath[] classpath = Project$.toPaths$1(properties.getProperty("classpath"));
        Path classesDir = Project$.toPath$1(properties.getProperty("classesDir"));
        String opts = properties.getProperty("classpathOptions");
        if (opts == null) {
            throw new Project.MissingFieldError("classpathOptions", config);
        }
        String[] values = opts.split(",");
        boolean[] blArray = (boolean[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Project$.$anonfun$fromProperties$3(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
        Option option = Array$.MODULE$.unapplySeq((Object)blArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(5) != 0) {
            throw new MatchError((Object)blArray);
        }
        boolean bootLibrary = BoxesRunTime.unboxToBoolean((Object)((SeqLike)option.get()).apply(0));
        boolean compiler = BoxesRunTime.unboxToBoolean((Object)((SeqLike)option.get()).apply(1));
        boolean extra = BoxesRunTime.unboxToBoolean((Object)((SeqLike)option.get()).apply(2));
        boolean autoBoot = BoxesRunTime.unboxToBoolean((Object)((SeqLike)option.get()).apply(3));
        boolean filterLibrary = BoxesRunTime.unboxToBoolean((Object)((SeqLike)option.get()).apply(4));
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)bootLibrary), (Object)BoxesRunTime.boxToBoolean((boolean)compiler), (Object)BoxesRunTime.boxToBoolean((boolean)extra), (Object)BoxesRunTime.boxToBoolean((boolean)autoBoot), (Object)BoxesRunTime.boxToBoolean((boolean)filterLibrary));
        Tuple5 tuple52 = tuple5;
        boolean bootLibrary2 = BoxesRunTime.unboxToBoolean((Object)tuple52._1());
        boolean compiler2 = BoxesRunTime.unboxToBoolean((Object)tuple52._2());
        boolean extra2 = BoxesRunTime.unboxToBoolean((Object)tuple52._3());
        boolean autoBoot2 = BoxesRunTime.unboxToBoolean((Object)tuple52._4());
        boolean filterLibrary2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
        ClasspathOptions classpathOptions = ClasspathOptions.of((boolean)bootLibrary2, (boolean)compiler2, (boolean)extra2, (boolean)autoBoot2, (boolean)filterLibrary2);
        String[] scalacOptions = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("scalacOptions").split(";"))).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isEmpty()));
        String[] javacOptions = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("javacOptions").split(";"))).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isEmpty()));
        AbsolutePath[] sourceDirectories = (AbsolutePath[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("sourceDirectories").split(","))).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isEmpty())))).map((Function1 & Serializable & scala.Serializable)line -> new AbsolutePath(Project$.toPath$1(line)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)));
        String[][] testFrameworks = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("testFrameworks").split(";"))).map((Function1 & Serializable & scala.Serializable)x$11 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$11.split(","))).filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isEmpty())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        Path javaHome = Project$.toPath$1(properties.getProperty("javaHome"));
        String[] javaOptions = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])properties.getProperty("javaOptions").split(";"))).filterNot((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isEmpty()));
        JavaEnv javaEnv = new JavaEnv(javaHome, javaOptions);
        Path tmp = AbsolutePath$.MODULE$.apply(Paths.get(properties.getProperty("tmp"), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        return new Project(name, baseDirectory, dependencies, scalaInstance, classpath, classpathOptions, classesDir, scalacOptions, javacOptions, sourceDirectories, testFrameworks, javaEnv, tmp, config);
    }

    public Project apply(String name, Path baseDirectory, String[] dependencies, ScalaInstance scalaInstance, AbsolutePath[] rawClasspath, ClasspathOptions classpathOptions, Path classesDir, String[] scalacOptions, String[] javacOptions, AbsolutePath[] sourceDirectories, String[][] testFrameworks, JavaEnv javaEnv, Path tmp, Path bloopConfigDir) {
        return new Project(name, baseDirectory, dependencies, scalaInstance, rawClasspath, classpathOptions, classesDir, scalacOptions, javacOptions, sourceDirectories, testFrameworks, javaEnv, tmp, bloopConfigDir);
    }

    public Option<Tuple14<String, Path, String[], ScalaInstance, Path[], ClasspathOptions, Path, String[], String[], Path[], String[][], JavaEnv, Path, Path>> unapply(Project x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.name(), (Object)new AbsolutePath(x$0.baseDirectory()), (Object)x$0.dependencies(), (Object)x$0.scalaInstance(), (Object)x$0.rawClasspath(), (Object)x$0.classpathOptions(), (Object)new AbsolutePath(x$0.classesDir()), (Object)x$0.scalacOptions(), (Object)x$0.javacOptions(), (Object)x$0.sourceDirectories(), (Object)x$0.testFrameworks(), (Object)x$0.javaEnv(), (Object)new AbsolutePath(x$0.tmp()), (Object)new AbsolutePath(x$0.bloopConfigDir())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final AbsolutePath[] toPaths$1(String line2) {
        return (AbsolutePath[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line2.split(","))).map((Function1 & Serializable & scala.Serializable)line -> new AbsolutePath(Project$.toPath$1(line)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)));
    }

    private static final Path toPath$1(String line) {
        return AbsolutePath$.MODULE$.apply(Paths.get(line, new String[0]), AbsolutePath$.MODULE$.workingDirectory());
    }

    public static final /* synthetic */ boolean $anonfun$fromProperties$3(String x$1) {
        return Boolean.parseBoolean(x$1);
    }

    private Project$() {
        MODULE$ = this;
        this.loadPattern = "glob:**.config";
        this.loadDepth = 1;
    }
}

