/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.Project;
import bloop.bsp.BspServer$;
import bloop.cli.BspProtocol;
import bloop.cli.BspProtocol$;
import bloop.cli.CliOptions;
import bloop.cli.CliParsers$;
import bloop.cli.Commands;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.cli.ReporterKind;
import bloop.cli.ReporterKind$;
import bloop.cli.completion.Mode;
import bloop.cli.completion.Mode$Commands$;
import bloop.cli.completion.Mode$Flags$;
import bloop.cli.completion.Mode$MainsFQCN$;
import bloop.cli.completion.Mode$Projects$;
import bloop.cli.completion.Mode$Protocols$;
import bloop.cli.completion.Mode$Reporters$;
import bloop.cli.completion.Mode$TestsFQCN$;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.CloseEvent;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.tasks.Tasks$;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.SourceWatcher;
import bloop.io.Timer$;
import bloop.reporter.ReporterConfig;
import bloop.reporter.ReporterConfig$;
import bloop.testing.TestInternals$;
import caseapp.core.Arg;
import caseapp.core.CommandMessages;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.execution.misc.NonFatal$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;
    private final String line;

    static {
        new Interpreter$();
    }

    public State execute(Action action, State state) {
        State state2;
        block25: {
            Action action2;
            while (true) {
                Commands.Command cmd;
                boolean bl = false;
                Exit exit = null;
                boolean bl2 = false;
                Run run2 = null;
                action2 = action;
                if (action2 instanceof Exit) {
                    bl = true;
                    exit = (Exit)action2;
                    ExitStatus exitStatus = exit.exitStatus();
                    if (state.status().isOk()) {
                        state2 = state.mergeStatus(exitStatus);
                        break block25;
                    }
                }
                if (bl) {
                    state2 = state;
                    break block25;
                }
                if (action2 instanceof Print) {
                    Print print = (Print)action2;
                    String msg = print.msg();
                    Action next = print.next();
                    state.logger().info(msg);
                    action = next;
                    continue;
                }
                if (action2 instanceof Run) {
                    bl2 = true;
                    run2 = (Run)action2;
                    Commands.Command command = run2.command();
                    Action next = run2.next();
                    if (command instanceof Commands.About) {
                        Commands.About about = (Commands.About)command;
                        CliOptions cliOptions = about.cliOptions();
                        state = Interpreter$.logAndTime$1(cliOptions, this.printAbout(state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd2 = run2.command();
                    Action next = run2.next();
                    if (cmd2 instanceof Commands.ValidatedBsp) {
                        Commands.ValidatedBsp validatedBsp = (Commands.ValidatedBsp)cmd2;
                        state = Interpreter$.logAndTime$1(validatedBsp.cliOptions(), this.runBsp(validatedBsp, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd3 = run2.command();
                    Action next = run2.next();
                    if (cmd3 instanceof Commands.Clean) {
                        Commands.Clean clean = (Commands.Clean)cmd3;
                        state = Interpreter$.logAndTime$1(clean.cliOptions(), this.clean(clean, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd4 = run2.command();
                    Action next = run2.next();
                    if (cmd4 instanceof Commands.Compile) {
                        Commands.Compile compile = (Commands.Compile)cmd4;
                        state = Interpreter$.logAndTime$1(compile.cliOptions(), this.compile(compile, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd5 = run2.command();
                    Action next = run2.next();
                    if (cmd5 instanceof Commands.Console) {
                        Commands.Console console = (Commands.Console)cmd5;
                        state = Interpreter$.logAndTime$1(console.cliOptions(), this.console(console, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd6 = run2.command();
                    Action next = run2.next();
                    if (cmd6 instanceof Commands.Projects) {
                        Commands.Projects projects = (Commands.Projects)cmd6;
                        state = Interpreter$.logAndTime$1(projects.cliOptions(), this.showProjects(projects, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd7 = run2.command();
                    Action next = run2.next();
                    if (cmd7 instanceof Commands.Test) {
                        Commands.Test test = (Commands.Test)cmd7;
                        state = Interpreter$.logAndTime$1(test.cliOptions(), this.test(test, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd8 = run2.command();
                    Action next = run2.next();
                    if (cmd8 instanceof Commands.Run) {
                        Commands.Run run3 = (Commands.Run)cmd8;
                        state = Interpreter$.logAndTime$1(run3.cliOptions(), this.run(run3, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd9 = run2.command();
                    Action next = run2.next();
                    if (cmd9 instanceof Commands.Configure) {
                        Commands.Configure configure = (Commands.Configure)cmd9;
                        state = Interpreter$.logAndTime$1(configure.cliOptions(), this.configure(configure, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd10 = run2.command();
                    Action next = run2.next();
                    if (cmd10 instanceof Commands.Autocomplete) {
                        Commands.Autocomplete autocomplete = (Commands.Autocomplete)cmd10;
                        state = Interpreter$.logAndTime$1(autocomplete.cliOptions(), this.autocomplete(autocomplete, state), action, state);
                        action = next;
                        continue;
                    }
                }
                if (!bl2 || !((cmd = run2.command()) instanceof Commands.Bsp)) break;
                Commands.Bsp bsp = (Commands.Bsp)cmd;
                String msg = "Internal error: command bsp must be validated before use.";
                action = new Print(msg, bsp.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
            }
            throw new MatchError((Object)action2);
        }
        return state2;
    }

    private final String t() {
        return "    ";
    }

    private final String line() {
        return this.line;
    }

    private Task<State> printAbout(State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String bloopName = BuildInfo$.MODULE$.name();
            String bloopVersion = BuildInfo$.MODULE$.version();
            String scalaVersion = BuildInfo$.MODULE$.scalaVersion();
            String zincVersion = BuildInfo$.MODULE$.zincVersion();
            String developers = BuildInfo$.MODULE$.developers().mkString(", ");
            String header = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "   _____            __         ______           __\n          |", "  / ___/_________ _/ /___ _   / ____/__  ____  / /____  _____\n          |", "  \\\\__ \\\\/ ___/ __ `/ / __ `/  / /   / _ \\\\/ __ \\\\/ __/ _ \\\\/ ___/\n          |", " ___/ / /__/ /_/ / / /_/ /  / /___/ /__/ / / / /_/ /__/ /\n          |", "/____/\\\\___/\\\\__,_/_/\\\\__,_/   \\\\____/\\\\___/_/ /_/\\\\__/\\\\___/_/\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", "    ", "    ", "    ", "    "})))).stripMargin();
            String versions = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                      |", "", " version    `", "`\n                      |", "Zinc version     `", "`\n                      |", "Scala version    `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", new StringOps(Predef$.MODULE$.augmentString(bloopName)).capitalize(), bloopVersion, "    ", zincVersion, "    ", scalaVersion})))).stripMargin();
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header, MODULE$.line()})));
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", " is made with love at the Scala Center <3", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", bloopName, MODULE$.line()})));
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versions, MODULE$.line(), MODULE$.line()})));
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "It is maintained by ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", developers})));
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private Task<State> runBsp(Commands.ValidatedBsp cmd, State state) {
        Scheduler scheduler = ExecutionContext$.MODULE$.bspScheduler();
        return BspServer$.MODULE$.run(cmd, state, scheduler);
    }

    public Task<State> watch(Project project, State state, Function1<State, Task<State>> f) {
        List<Project> reachable = Dag$.MODULE$.dfs(state.build().getDagFor(project));
        Iterator allSourceDirs = reachable.iterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.genericArrayOps((Object)x$1.sourceDirectories()).toList()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((AbsolutePath)x$2).underlying());
        SourceWatcher watcher = new SourceWatcher(project, (Seq<Path>)allSourceDirs.toList(), state.logger());
        Function1 & Serializable & scala.Serializable fg = (Function1 & Serializable & scala.Serializable)state2 -> ((Task)f.apply(state2)).map((Function1 & Serializable & scala.Serializable)state -> State$.MODULE$.stateCache().updateBuild((State)state));
        return ((Task)fg.apply((Object)state)).flatMap((Function1 & Serializable & scala.Serializable)newState -> watcher.watch((State)newState, (Function1<State, Task<State>>)fg));
    }

    private Task<State> compile(Commands.Compile cmd, State state) {
        Task task;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            Task<State> initialState = cmd.incremental() ? Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state) : Tasks$.MODULE$.clean(state, state.build().projects(), true);
            task = initialState.flatMap((Function1 & Serializable & scala.Serializable)state2 -> !cmd.watch() ? Interpreter$.doCompile$1(state2, reporterConfig, project) : MODULE$.watch(project, (State)state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doCompile$1(state, reporterConfig, project)));
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> showProjects(Commands.Projects cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (cmd.dotGraph()) {
                String contents = Dag$.MODULE$.toDotGraph(state.build().dags());
                state.logger().info(contents);
            } else {
                String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
                state.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Projects loaded from '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configDirectory})));
                ((List)((SeqLike)state.build().projects().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    Interpreter$.$anonfun$showProjects$3(state, x$1);
                    return BoxedUnit.UNIT;
                });
            }
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private Task<State> compileAnd(State state, Project project, ReporterConfig reporterConfig, boolean excludeRoot, String nextAction, Function1<State, Task<State>> next) {
        return Tasks$.MODULE$.compile(state, project, reporterConfig, excludeRoot).flatMap((Function1 & Serializable & scala.Serializable)compiled -> {
            Task task;
            ExitStatus exitStatus = compiled.status();
            ExitStatus exitStatus2 = ExitStatus$.MODULE$.CompilationError();
            if (exitStatus == null ? exitStatus2 != null : !((Object)exitStatus).equals(exitStatus2)) {
                task = (Task)next.apply(compiled);
            } else {
                compiled.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed compilation for ", ". Skipping ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project, nextAction})));
                task = Task$.MODULE$.now(compiled);
            }
            return task;
        });
    }

    private Task<State> console(Commands.Console cmd, State state2) {
        Task<State> task;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = this.compileAnd(state2, project, reporterConfig, cmd.excludeRoot(), "`console`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Tasks$.MODULE$.console((State)state, project, reporterConfig, cmd.excludeRoot()));
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> test(Commands.Test cmd, State state2) {
        Task task;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = Tasks$.MODULE$.pickTestProject(cmd.project(), state2);
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.doTest$1((State)state, cmd, reporterConfig, project)) : this.doTest$1(state2, cmd, reporterConfig, project);
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Tuple2<List<Project>, List<String>> lookupProjects(List<String> names, State state) {
        Build build = state.build();
        Tuple2 result = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)List$.MODULE$.apply((Seq)Nil$.MODULE$)), (Object)List$.MODULE$.apply((Seq)Nil$.MODULE$));
        return (Tuple2)names.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String name = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            List projects = (List)tuple23._1();
            List missing = (List)tuple23._2();
            Option<Project> option = build.getProjectFor(name);
            if (option instanceof Some) {
                Project project;
                Some some = (Some)option;
                Project project2 = project = (Project)some.value();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects.$colon$colon((Object)project2)), (Object)missing);
                return tuple2;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                String string = name;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects), (Object)missing.$colon$colon((Object)string));
            }
            return tuple2;
        });
    }

    private Task<State> autocomplete(Commands.Autocomplete cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Mode mode = cmd.mode();
            if (Mode$Commands$.MODULE$.equals(mode)) {
                CliParsers$.MODULE$.CommandsMessages().messages().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Interpreter$.$anonfun$autocomplete$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                    Interpreter$.$anonfun$autocomplete$3(cmd, state, x$10);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Projects$.MODULE$.equals(mode)) {
                List<Project> projects = state.build().projects();
                state.build().projects().foreach((Function1 & Serializable & scala.Serializable)project -> {
                    Interpreter$.$anonfun$autocomplete$5(cmd, state, project);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Flags$.MODULE$.equals(mode)) {
                cmd.command().foreach((Function1 & Serializable & scala.Serializable)command -> {
                    Interpreter$.$anonfun$autocomplete$7(cmd, state, command);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Reporters$.MODULE$.equals(mode)) {
                ReporterKind$.MODULE$.reporters().foreach((Function1 & Serializable & scala.Serializable)reporter -> {
                    Interpreter$.$anonfun$autocomplete$11(cmd, state, reporter);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Protocols$.MODULE$.equals(mode)) {
                BspProtocol$.MODULE$.protocols().foreach((Function1 & Serializable & scala.Serializable)protocol -> {
                    Interpreter$.$anonfun$autocomplete$13(cmd, state, protocol);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$MainsFQCN$.MODULE$.equals(mode)) {
                cmd.project().foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$autocomplete$15(cmd, state, projectName);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$TestsFQCN$.MODULE$.equals(mode)) {
                cmd.project().foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$autocomplete$19(cmd, state, projectName);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)mode);
            }
            return state;
        });
    }

    private Task<State> configure(Commands.Configure cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> cmd.threads() != ExecutionContext$.MODULE$.executor().getCorePoolSize() ? State$.MODULE$.setCores(state, cmd.threads()) : state);
    }

    private Task<State> clean(Commands.Clean cmd, State state) {
        Tuple2<List<Project>, List<String>> tuple2 = this.lookupProjects(cmd.project(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List projects = (List)tuple2._1();
        List missing = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)projects, (Object)missing);
        Tuple2 tuple23 = tuple22;
        List projects2 = (List)tuple23._1();
        List missing2 = (List)tuple23._2();
        return missing2.isEmpty() ? Tasks$.MODULE$.clean(state, (List<Project>)projects2, cmd.isolated()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.mergeStatus(ExitStatus$.MODULE$.Ok())) : Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.reportMissing((List<String>)missing2, state));
    }

    private Task<State> run(Commands.Run cmd, State state2) {
        Task task;
        ReporterConfig reporter = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.doRun$1((State)state, cmd, reporter, project)) : this.doRun$1(state2, cmd, reporter, project);
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string = cmd.project();
                return MODULE$.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2);
            });
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private State reportMissing(List<String> projectNames, State state) {
        String projects = projectNames.mkString("'", "', '", "'");
        String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
        state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No projects named ", " found in '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projects, configDirectory})));
        state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use the `projects` command to list existing projects."})).s((Seq)Nil$.MODULE$));
        return state.mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption());
    }

    private State waitAndLog(Action action, CliOptions cliOptions, State previousState, Task<State> newState) {
        State state;
        ClientPool pool = previousState.pool();
        PrintStream ngout = cliOptions.common().ngout();
        try {
            CancelableFuture handle = newState.executeWithOptions((Function1 & Serializable & scala.Serializable)x$14 -> x$14.enableAutoCancelableRunLoops()).runAsync(previousState.scheduler());
            pool.addListener((Function1<CloseEvent, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
                Interpreter$.$anonfun$waitAndLog$2(previousState, ngout, handle, x0$2);
                return BoxedUnit.UNIT;
            });
            State result = (State)Await$.MODULE$.result((Awaitable)handle, (Duration)Duration$.MODULE$.Inf());
            ngout.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The task for ", " finished."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action})));
            state = result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            previousState.logger().error(t.getMessage());
            previousState.logger().trace(t);
            State state2 = previousState;
            state = state2;
        }
        return state;
    }

    private static final State logAndTime$1(CliOptions cliOptions, Task task, Action action$1, State state$1) {
        return (State)state$1.logger().verboseIf(cliOptions.verbose(), (Function0 & Serializable & scala.Serializable)() -> (State)Timer$.MODULE$.timed(state$1.logger(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.waitAndLog(action$1, cliOptions, state$1, (Task<State>)task)));
    }

    private static final Task doCompile$1(State state, ReporterConfig reporterConfig$1, Project project$1) {
        return Tasks$.MODULE$.compile(state, project$1, reporterConfig$1, Tasks$.MODULE$.compile$default$4()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.mergeStatus(ExitStatus$.MODULE$.Ok()));
    }

    public static final /* synthetic */ void $anonfun$showProjects$3(State state$6, String x$1) {
        state$6.logger().info(x$1);
    }

    private final Task doTest$1(State state2, Commands.Test cmd$4, ReporterConfig reporterConfig$3, Project project$4) {
        Function1<String, Object> testFilter = TestInternals$.MODULE$.parseFilters(cmd$4.only());
        Path cwd = cmd$4.cliOptions().common().workingPath();
        return this.compileAnd(state2, project$4, reporterConfig$3, false, "`test`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Tasks$.MODULE$.test((State)state, project$4, cwd, cmd$4.isolated(), testFilter));
    }

    public static final /* synthetic */ boolean $anonfun$autocomplete$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$4(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$3(Commands.Autocomplete cmd$7, State state$10, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        CommandMessages args = (CommandMessages)tuple2._2();
        cmd$7.format().showCommand(name, args).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$4(state$10, completion);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$6(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$5(Commands.Autocomplete cmd$7, State state$10, Project project) {
        cmd$7.format().showProject(project).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$6(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$10(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$9(Commands.Autocomplete cmd$7, State state$10, String command$1, Arg arg) {
        cmd$7.format().showArg(command$1, arg).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$10(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$8(Commands.Autocomplete cmd$7, State state$10, String command$1, CommandMessages message) {
        message.args().foreach((Function1 & Serializable & scala.Serializable)arg -> {
            Interpreter$.$anonfun$autocomplete$9(cmd$7, state$10, command$1, arg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$7(Commands.Autocomplete cmd$7, State state$10, String command) {
        CliParsers$.MODULE$.CommandsMessages().messages().toMap(Predef$.MODULE$.$conforms()).get((Object)command).foreach((Function1 & Serializable & scala.Serializable)message -> {
            Interpreter$.$anonfun$autocomplete$8(cmd$7, state$10, command, message);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$12(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$11(Commands.Autocomplete cmd$7, State state$10, ReporterKind reporter) {
        cmd$7.format().showReporter(reporter).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$12(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$14(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$13(Commands.Autocomplete cmd$7, State state$10, BspProtocol protocol) {
        cmd$7.format().showProtocol(protocol).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$14(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$18(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$17(Commands.Autocomplete cmd$7, State state$10, String main) {
        cmd$7.format().showMainName(main).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$18(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$16(Commands.Autocomplete cmd$7, State state$10, Project project) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Tasks$.MODULE$.findMainClasses(state$10, project))).foreach((Function1 & Serializable & scala.Serializable)main -> {
            Interpreter$.$anonfun$autocomplete$17(cmd$7, state$10, main);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$15(Commands.Autocomplete cmd$7, State state$10, String projectName) {
        state$10.build().getProjectFor(projectName).foreach((Function1 & Serializable & scala.Serializable)project -> {
            Interpreter$.$anonfun$autocomplete$16(cmd$7, state$10, project);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$22(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$21(Commands.Autocomplete cmd$7, State state$10, String placeholder) {
        cmd$7.format().showTestName(placeholder).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$22(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$20(Commands.Autocomplete cmd$7, State state$10, Project project) {
        List$.MODULE$.empty().foreach((Function1 & Serializable & scala.Serializable)placeholder -> {
            Interpreter$.$anonfun$autocomplete$21(cmd$7, state$10, placeholder);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$19(Commands.Autocomplete cmd$7, State state$10, String projectName) {
        state$10.build().getProjectFor(projectName).foreach((Function1 & Serializable & scala.Serializable)project -> {
            Interpreter$.$anonfun$autocomplete$20(cmd$7, state$10, project);
            return BoxedUnit.UNIT;
        });
    }

    private static final Option getMainClass$1(State state, Commands.Run cmd$5, Project project$5) {
        return cmd$5.main().orElse((Function0 & Serializable & scala.Serializable)() -> {
            Some some;
            String[] stringArray = Tasks$.MODULE$.findMainClasses(state, project$5);
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
                state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No main classes found in project '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project$5.name()})));
                some = None$.MODULE$;
            } else {
                Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
                    String main = (String)((SeqLike)option2.get()).apply(0);
                    some = new Some((Object)main);
                } else {
                    String eol = System.lineSeparator();
                    String message = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Several main classes were found, specify which one:\n                                 |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).mkString(" * ", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " * "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eol})), "")})))).stripMargin();
                    state.logger().error(message);
                    some = None$.MODULE$;
                }
            }
            return some;
        });
    }

    private final Task doRun$1(State state2, Commands.Run cmd$5, ReporterConfig reporter$1, Project project$5) {
        return this.compileAnd(state2, project$5, reporter$1, false, "`run`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            Task<State> task;
            Option option = Interpreter$.getMainClass$1(state, cmd$5, project$5);
            if (None$.MODULE$.equals(option)) {
                task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state.mergeStatus(ExitStatus$.MODULE$.RunError()));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String main = (String)some.value();
                String[] args = (String[])cmd$5.args().toArray(ClassTag$.MODULE$.apply(String.class));
                Path cwd = cmd$5.cliOptions().common().workingPath();
                task = Tasks$.MODULE$.run((State)state, project$5, cwd, main, args);
            } else {
                throw new MatchError((Object)option);
            }
            return task;
        });
    }

    public static final /* synthetic */ void $anonfun$waitAndLog$2(State previousState$1, PrintStream ngout$1, CancelableFuture handle$1, CloseEvent x0$2) {
        BoxedUnit boxedUnit;
        CloseEvent closeEvent = x0$2;
        if (closeEvent != null) {
            CloseEvent closeEvent2 = closeEvent;
            if (!handle$1.isCompleted()) {
                ngout$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client in ", " has disconnected with a '", "' event. Cancelling tasks..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AbsolutePath$.MODULE$.syntax$extension(previousState$1.build().origin()), closeEvent2})));
                handle$1.cancel();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)closeEvent);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private Interpreter$() {
        MODULE$ = this;
        this.line = System.lineSeparator();
    }
}

