/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.Project;
import bloop.ScalaInstance;
import bloop.ScalaInstance$;
import bloop.config.Config;
import bloop.config.ConfigDecoders$;
import bloop.exec.JavaEnv;
import bloop.exec.JavaEnv$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.Paths$;
import bloop.io.Timer$;
import bloop.logging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import metaconfig.Conf$;
import metaconfig.ConfError;
import metaconfig.Configured;
import metaconfig.typesafeconfig.package$;
import monix.eval.Task;
import monix.eval.Task$;
import org.langmeta.inputs.Input;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple14;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import xsbti.compile.ClasspathOptions;

public final class Project$
implements scala.Serializable {
    public static Project$ MODULE$;
    private final String loadPattern;
    private final int loadDepth;

    static {
        new Project$();
    }

    public final String loadPattern() {
        return this.loadPattern;
    }

    public final int loadDepth() {
        return this.loadDepth;
    }

    private AbsolutePath[] loadAllFiles(Path configRoot) {
        return Paths$.MODULE$.getAll(configRoot, this.loadPattern(), this.loadDepth());
    }

    public Task<List<Project>> lazyLoadFromDir(Path configRoot, Logger logger) {
        return (Task)Timer$.MODULE$.timed(logger, (Function0 & Serializable & scala.Serializable)() -> {
            AbsolutePath[] configFiles = MODULE$.loadAllFiles(configRoot);
            logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", " projects from '", "'..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)configFiles.length), AbsolutePath$.MODULE$.syntax$extension(configRoot)})));
            List all = Predef$.MODULE$.genericArrayOps((Object)configFiles).iterator().map((Function1 & Serializable & scala.Serializable)configFile -> Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Project$.MODULE$.fromFile(configFile, logger$2))).toList();
            return Task$.MODULE$.gatherUnordered((TraversableOnce)all);
        });
    }

    public List<Project> eagerLoadFromDir(Path configRoot, Logger logger) {
        AbsolutePath[] configFiles = this.loadAllFiles(configRoot);
        logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", " projects from '", "'..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)configFiles.length), AbsolutePath$.MODULE$.syntax$extension(configRoot)})));
        return Predef$.MODULE$.genericArrayOps((Object)configFiles).iterator().map((Function1 & Serializable & scala.Serializable)configFile -> Project$.MODULE$.fromFile(((AbsolutePath)configFile).underlying(), logger)).toList();
    }

    public Project fromConfig(Config.File file, Logger logger) {
        Config.Project project = file.project();
        Config.Scala scala = project.scala();
        AbsolutePath[] scalaJars = (AbsolutePath[])Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scala.jars())).map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)))).toArray(ClassTag$.MODULE$.apply(AbsolutePath.class));
        ScalaInstance instance = ScalaInstance$.MODULE$.apply(scala.organization(), scala.name(), scala.version(), scalaJars, logger);
        Config.ClasspathOptions opts = project.classpathOptions();
        ClasspathOptions classpathOptions = ClasspathOptions.of((boolean)opts.bootLibrary(), (boolean)opts.compiler(), (boolean)opts.extra(), (boolean)opts.autoBoot(), (boolean)opts.filterLibrary());
        Config.Jvm jvm = project.jvm();
        Path jvmHome = ((AbsolutePath)jvm.home().map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new AbsolutePath(JavaEnv$.MODULE$.DefaultJavaHome()))).underlying();
        JavaEnv javaEnv = new JavaEnv(jvmHome, jvm.options());
        return new Project(project.name(), AbsolutePath$.MODULE$.apply(project.directory(), AbsolutePath$.MODULE$.workingDirectory()), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.dependencies())).toArray(ClassTag$.MODULE$.apply(String.class)), instance, (AbsolutePath[])Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.classpath())).map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)))).toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), classpathOptions, AbsolutePath$.MODULE$.apply(project.classesDir(), AbsolutePath$.MODULE$.workingDirectory()), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scala.options())).toArray(ClassTag$.MODULE$.apply(String.class)), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.java().options())).toArray(ClassTag$.MODULE$.apply(String.class)), (AbsolutePath[])Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.sources())).map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)))).toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), project.test().frameworks(), project.test().options(), javaEnv, AbsolutePath$.MODULE$.apply(project.out(), AbsolutePath$.MODULE$.workingDirectory()));
    }

    public Project fromFile(Path config, Logger logger) {
        logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading project from '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new AbsolutePath(config)})));
        Path configFilepath = config;
        Input.File input = Input.File$.MODULE$.apply(configFilepath);
        Configured configured = Conf$.MODULE$.parseInput((Input)input, package$.MODULE$.typesafeConfigMetaconfigParser());
        Configured configured2 = ConfigDecoders$.MODULE$.allConfigDecoder().read(configured);
        if (!(configured2 instanceof Configured.Ok)) {
            if (configured2 instanceof Configured.NotOk) {
                Configured.NotOk notOk = (Configured.NotOk)configured2;
                ConfError error = notOk.error();
                throw scala.sys.package$.MODULE$.error(error.toString());
            }
            throw new MatchError((Object)configured2);
        }
        Configured.Ok ok = (Configured.Ok)configured2;
        Config.File file = (Config.File)ok.value();
        Project project = this.fromConfig(file, logger);
        return project;
    }

    public Project apply(String name, Path baseDirectory, String[] dependencies, ScalaInstance scalaInstance, AbsolutePath[] rawClasspath, ClasspathOptions classpathOptions, Path classesDir, String[] scalacOptions, String[] javacOptions, AbsolutePath[] sourceDirectories, Config.TestFramework[] testFrameworks, Config.TestOptions testOptions, JavaEnv javaEnv, Path out) {
        return new Project(name, baseDirectory, dependencies, scalaInstance, rawClasspath, classpathOptions, classesDir, scalacOptions, javacOptions, sourceDirectories, testFrameworks, testOptions, javaEnv, out);
    }

    public Option<Tuple14<String, Path, String[], ScalaInstance, Path[], ClasspathOptions, Path, String[], String[], Path[], Config.TestFramework[], Config.TestOptions, JavaEnv, Path>> unapply(Project x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.name(), (Object)new AbsolutePath(x$0.baseDirectory()), (Object)x$0.dependencies(), (Object)x$0.scalaInstance(), (Object)x$0.rawClasspath(), (Object)x$0.classpathOptions(), (Object)new AbsolutePath(x$0.classesDir()), (Object)x$0.scalacOptions(), (Object)x$0.javacOptions(), (Object)x$0.sourceDirectories(), (Object)x$0.testFrameworks(), (Object)x$0.testOptions(), (Object)x$0.javaEnv(), (Object)new AbsolutePath(x$0.out())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Project$() {
        MODULE$ = this;
        this.loadPattern = "glob:**.json";
        this.loadDepth = 1;
    }
}

