/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.CompilerCache;
import bloop.Project;
import bloop.Project$;
import bloop.cli.CommonOptions;
import bloop.cli.CommonOptions$;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.engine.Build;
import bloop.engine.Build$;
import bloop.engine.ClientPool;
import bloop.engine.ExecutionContext$;
import bloop.engine.NoPool$;
import bloop.engine.State;
import bloop.engine.caches.ResultsCache;
import bloop.engine.caches.ResultsCache$;
import bloop.engine.caches.StateCache;
import bloop.engine.caches.StateCache$;
import bloop.engine.tasks.Tasks$;
import bloop.io.AbsolutePath;
import bloop.io.Paths$;
import bloop.logging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import monix.eval.Task;
import sbt.internal.inc.bloop.ZincInternals$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import xsbti.ComponentProvider;

public final class State$
implements scala.Serializable {
    public static State$ MODULE$;
    private final StateCache stateCache;
    private CompilerCache singleCompilerCache;

    static {
        new State$();
    }

    public StateCache stateCache() {
        return this.stateCache;
    }

    private CompilerCache singleCompilerCache() {
        return this.singleCompilerCache;
    }

    private void singleCompilerCache_$eq(CompilerCache x$1) {
        this.singleCompilerCache = x$1;
    }

    private synchronized CompilerCache getCompilerCache(Logger logger) {
        CompilerCache compilerCache;
        if (this.singleCompilerCache() != null) {
            compilerCache = this.singleCompilerCache();
        } else {
            ComponentProvider provider = ZincInternals$.MODULE$.getComponentProvider(Paths$.MODULE$.getCacheDirectory("components"));
            Path jars = Paths$.MODULE$.getCacheDirectory("scala-jars");
            this.singleCompilerCache_$eq(new CompilerCache(provider, jars, logger, (List)Nil$.MODULE$));
            compilerCache = this.singleCompilerCache();
        }
        return compilerCache;
    }

    public State forTests(Build build, CompilerCache compilerCache, Logger logger) {
        ResultsCache results0 = (ResultsCache)build.projects().foldLeft((Object)ResultsCache$.MODULE$.getEmpty(logger), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResultsCache results = (ResultsCache)tuple2._1();
            Project project = (Project)tuple2._2();
            ResultsCache resultsCache = results.initializeResult(project);
            return resultsCache;
        });
        return this.apply(build, results0, compilerCache, NoPool$.MODULE$, CommonOptions$.MODULE$.default(), ExitStatus$.MODULE$.Ok(), logger);
    }

    public State apply(Build build, ClientPool pool, CommonOptions opts, Logger logger) {
        ResultsCache results = (ResultsCache)build.projects().foldLeft((Object)ResultsCache$.MODULE$.getEmpty(logger), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResultsCache results = (ResultsCache)tuple2._1();
            Project project = (Project)tuple2._2();
            ResultsCache resultsCache = results.initializeResult(project);
            return resultsCache;
        });
        CompilerCache compilerCache = this.getCompilerCache(logger);
        return this.apply(build, results, compilerCache, pool, opts, ExitStatus$.MODULE$.Ok(), logger);
    }

    public void setUpShutdownHoook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                State$.MODULE$.stateCache().allStates().foreach((Function1 & Serializable & scala.Serializable)s -> Tasks$.MODULE$.persist((State)s));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(bloop.engine.State )}, serializedLambda);
            }
        });
    }

    public State setCores(State state, int threads) {
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reconfiguring the number of bloop threads to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threads)})));
        ExecutionContext$.MODULE$.executor().setCorePoolSize(threads);
        return state;
    }

    public Task<State> loadActiveStateFor(Path configDir, ClientPool pool, CommonOptions opts, Logger logger) {
        Task<State> cached = this.stateCache().addIfMissing(configDir, (Function1<Path, Task<State>>)(Function1 & Serializable & scala.Serializable)path -> State$.$anonfun$loadActiveStateFor$1(configDir, pool, opts, logger, ((AbsolutePath)path).underlying()));
        return cached.map((Function1 & Serializable & scala.Serializable)x$1 -> {
            ClientPool x$9 = pool;
            CommonOptions x$10 = opts;
            Logger x$11 = logger;
            Build x$12 = x$1.copy$default$1();
            ResultsCache x$13 = x$1.copy$default$2();
            CompilerCache x$14 = x$1.copy$default$3();
            ExitStatus x$15 = x$1.copy$default$6();
            return x$1.copy(x$12, x$13, x$14, x$9, x$10, x$15, x$11);
        });
    }

    public State apply(Build build, ResultsCache results, CompilerCache compilerCache, ClientPool pool, CommonOptions commonOptions, ExitStatus status, Logger logger) {
        return new State(build, results, compilerCache, pool, commonOptions, status, logger);
    }

    public Option<Tuple7<Build, ResultsCache, CompilerCache, ClientPool, CommonOptions, ExitStatus, Logger>> unapply(State x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.build(), (Object)x$0.results(), (Object)x$0.compilerCache(), (Object)x$0.pool(), (Object)x$0.commonOptions(), (Object)x$0.status(), (Object)x$0.logger()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Task $anonfun$loadActiveStateFor$1(Path configDir$1, ClientPool pool$1, CommonOptions opts$1, Logger logger$1, Path path) {
        return Project$.MODULE$.lazyLoadFromDir(configDir$1, logger$1).map((Function1 & Serializable & scala.Serializable)projects -> {
            Build build = Build$.MODULE$.apply(configDir$1, (List<Project>)projects);
            return MODULE$.apply(build, pool$1, opts$1, logger$1);
        });
    }

    private State$() {
        MODULE$ = this;
        this.stateCache = StateCache$.MODULE$.empty();
        this.singleCompilerCache = null;
    }
}

