/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.caches;

import bloop.Project;
import bloop.engine.caches.ResultsCache$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.Logger;
import bloop.util.JavaCompat$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import sbt.internal.inc.FileAnalysisStore$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import xsbti.compile.AnalysisContents;
import xsbti.compile.PreviousResult;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0003\u0013\ta!+Z:vYR\u001c8)Y2iK*\u00111\u0001B\u0001\u0007G\u0006\u001c\u0007.Z:\u000b\u0005\u00151\u0011AB3oO&tWMC\u0001\b\u0003\u0015\u0011Gn\\8q\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011!\t\u0002A!A!\u0002\u0013\u0011\u0012!B2bG\",\u0007\u0003B\n\u001b;\u0005r!\u0001\u0006\r\u0011\u0005UaQ\"\u0001\f\u000b\u0005]A\u0011A\u0002\u001fs_>$h(\u0003\u0002\u001a\u0019\u00051\u0001K]3eK\u001aL!a\u0007\u000f\u0003\u00075\u000b\u0007O\u0003\u0002\u001a\u0019A\u0011adH\u0007\u0002\r%\u0011\u0001E\u0002\u0002\b!J|'.Z2u!\t\u0011s%D\u0001$\u0015\t!S%A\u0004d_6\u0004\u0018\u000e\\3\u000b\u0003\u0019\nQ\u0001_:ci&L!\u0001K\u0012\u0003\u001dA\u0013XM^5pkN\u0014Vm];mi\"A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0004m_\u001e<WM\u001d\t\u0003Y=j\u0011!\f\u0006\u0003]\u0019\tq\u0001\\8hO&tw-\u0003\u00021[\t1Aj\\4hKJDQA\r\u0001\u0005\u0002M\na\u0001P5oSRtDc\u0001\u001b7oA\u0011Q\u0007A\u0007\u0002\u0005!)\u0011#\ra\u0001%!)!&\ra\u0001W!9\u0011\b\u0001b\u0001\n\u0013Q\u0014aC#naRL(+Z:vYR,\u0012!\t\u0005\u0007y\u0001\u0001\u000b\u0011B\u0011\u0002\u0019\u0015k\u0007\u000f^=SKN,H\u000e\u001e\u0011\t\u000by\u0002A\u0011A \u0002\u0013\u001d,GOU3tk2$HCA\u0011A\u0011\u0015\tU\b1\u0001\u001e\u0003\u001d\u0001(o\u001c6fGRDQa\u0011\u0001\u0005\u0002\u0011\u000b\u0011\"\u00193e%\u0016\u001cX\u000f\u001c;\u0015\u0007Q*e\tC\u0003B\u0005\u0002\u0007Q\u0004C\u0003H\u0005\u0002\u0007\u0011%\u0001\bqe\u00164\u0018n\\;t%\u0016\u001cX\u000f\u001c;\t\u000b%\u0003A\u0011\u0001&\u0002\u0015\u0005$GMU3tk2$8\u000f\u0006\u00025\u0017\")A\n\u0013a\u0001\u001b\u0006\u0011\u0001o\u001d\t\u0004\u001dN3fBA(R\u001d\t)\u0002+C\u0001\u000e\u0013\t\u0011F\"A\u0004qC\u000e\\\u0017mZ3\n\u0005Q+&\u0001\u0002'jgRT!A\u0015\u0007\u0011\t-9V$I\u0005\u000312\u0011a\u0001V;qY\u0016\u0014\u0004\"\u0002.\u0001\t\u0003Y\u0016\u0001C5uKJ\fGo\u001c:\u0016\u0003q\u00032AT/W\u0013\tqVK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003\u0015\u0011Xm]3u)\t!$\rC\u0003d?\u0002\u0007A-\u0001\u0005qe>TWm\u0019;t!\rq5+\b\u0005\u0006M\u0002!\taZ\u0001\u0011S:LG/[1mSj,'+Z:vYR$\"\u0001\u000e5\t\u000b\u0005+\u0007\u0019A\u000f\t\u000b)\u0004A\u0011I6\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u001c\t\u0003'5L!A\u001c\u000f\u0003\rM#(/\u001b8h\u000f\u0015\u0001(\u0001#\u0001r\u00031\u0011Vm];miN\u001c\u0015m\u00195f!\t)$OB\u0003\u0002\u0005!\u00051o\u0005\u0002s\u0015!)!G\u001dC\u0001kR\t\u0011\u000fC\u0003xe\u0012\u0005\u00010\u0001\u0005hKR,U\u000e\u001d;z)\t!\u0014\u0010C\u0003+m\u0002\u00071\u0006")
public final class ResultsCache {
    private final Map<Project, PreviousResult> cache;
    private final Logger logger;
    private final PreviousResult EmptyResult;

    public static ResultsCache getEmpty(Logger logger) {
        return ResultsCache$.MODULE$.getEmpty(logger);
    }

    private PreviousResult EmptyResult() {
        return this.EmptyResult;
    }

    public PreviousResult getResult(Project project) {
        return (PreviousResult)this.cache.getOrElse((Object)project, (Function0 & Serializable & scala.Serializable)() -> this.EmptyResult());
    }

    public ResultsCache addResult(Project project, PreviousResult previousResult) {
        return new ResultsCache((Map<Project, PreviousResult>)this.cache.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)project), (Object)previousResult)), this.logger);
    }

    public ResultsCache addResults(List<Tuple2<Project, PreviousResult>> ps) {
        return new ResultsCache((Map<Project, PreviousResult>)this.cache.$plus$plus(ps), this.logger);
    }

    public Iterator<Tuple2<Project, PreviousResult>> iterator() {
        return this.cache.iterator();
    }

    public ResultsCache reset(List<Project> projects) {
        return new ResultsCache((Map<Project, PreviousResult>)this.cache.$plus$plus((GenTraversableOnce)((TraversableOnce)projects.map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)this.EmptyResult()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())), this.logger);
    }

    public ResultsCache initializeResult(Project project) {
        return this.cache.contains((Object)project) ? this : this.addResult(project, this.fetchPreviousResult$1(project, project));
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ResultsCache(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cache.mkString(", ")}));
    }

    private final PreviousResult fetchPreviousResult$1(Project p, Project project$1) {
        PreviousResult previousResult;
        Path analysisFile = AbsolutePath$.MODULE$.resolve$extension1(AbsolutePath$.MODULE$.getParent$extension(project$1.out()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-analysis.bin"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project$1.name()})));
        if (Files.exists(analysisFile, new LinkOption[0])) {
            PreviousResult previousResult2;
            Option contents;
            this.logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading previous analysis for '", "' from '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project$1.name(), new AbsolutePath(analysisFile)})));
            Option option = contents = JavaCompat$.MODULE$.EnrichOptional(FileAnalysisStore$.MODULE$.binary(AbsolutePath$.MODULE$.toFile$extension(analysisFile)).get()).toOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                AnalysisContents res = (AnalysisContents)some.value();
                previousResult2 = PreviousResult.of(Optional.of(res.getAnalysis()), Optional.of(res.getMiniSetup()));
            } else if (None$.MODULE$.equals(option)) {
                previousResult2 = this.EmptyResult();
            } else {
                throw new MatchError(option);
            }
            previousResult = previousResult2;
        } else {
            this.logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No previous analysis for project '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project$1.name()})));
            previousResult = this.EmptyResult();
        }
        return previousResult;
    }

    public ResultsCache(Map<Project, PreviousResult> cache, Logger logger) {
        this.cache = cache;
        this.logger = logger;
        this.EmptyResult = PreviousResult.of(Optional.empty(), Optional.empty());
    }
}

