/*
 * Decompiled with CFR 0.152.
 */
package bloop.bsp;

import bloop.Compiler;
import bloop.CompilerCache;
import bloop.Project;
import bloop.ScalaInstance;
import bloop.bsp.BloopBspServices$;
import bloop.bsp.ProjectUris$;
import bloop.cli.Commands;
import bloop.cli.Commands$Compile$;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.config.Config;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.Dag$;
import bloop.engine.Exit;
import bloop.engine.Interpreter$;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.caches.ResultsCache;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.BspLogger;
import bloop.logging.BspLogger$;
import bloop.logging.Logger;
import bloop.reporter.Problem;
import bloop.reporter.Problem$;
import ch.epfl.scala.bsp.BuildServerCapabilities;
import ch.epfl.scala.bsp.BuildTarget;
import ch.epfl.scala.bsp.BuildTargetCapabilities;
import ch.epfl.scala.bsp.BuildTargetIdentifier;
import ch.epfl.scala.bsp.BuildTargetKind;
import ch.epfl.scala.bsp.CompileParams;
import ch.epfl.scala.bsp.CompileResult;
import ch.epfl.scala.bsp.DependencySourcesItem;
import ch.epfl.scala.bsp.DependencySourcesParams;
import ch.epfl.scala.bsp.DependencySourcesResult;
import ch.epfl.scala.bsp.InitializeBuildParams;
import ch.epfl.scala.bsp.InitializeBuildResult;
import ch.epfl.scala.bsp.InitializedBuildParams;
import ch.epfl.scala.bsp.ScalaBuildTarget;
import ch.epfl.scala.bsp.ScalaBuildTarget$;
import ch.epfl.scala.bsp.ScalaPlatform;
import ch.epfl.scala.bsp.ScalacOptionsItem;
import ch.epfl.scala.bsp.ScalacOptionsParams;
import ch.epfl.scala.bsp.ScalacOptionsResult;
import ch.epfl.scala.bsp.Shutdown;
import ch.epfl.scala.bsp.Uri;
import ch.epfl.scala.bsp.Uri$;
import ch.epfl.scala.bsp.WorkspaceBuildTargets;
import ch.epfl.scala.bsp.WorkspaceBuildTargetsRequest;
import ch.epfl.scala.bsp.endpoints.Build$;
import ch.epfl.scala.bsp.endpoints.BuildTarget$;
import ch.epfl.scala.bsp.endpoints.Workspace$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.atomic.AtomicInt;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration$;
import scala.meta.jsonrpc.Endpoint;
import scala.meta.jsonrpc.JsonRpcClient;
import scala.meta.jsonrpc.Response;
import scala.meta.jsonrpc.Response$;
import scala.meta.jsonrpc.Services;
import scala.meta.jsonrpc.Services$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import xsbti.Problem;

@ScalaSignature(bytes="\u0006\u0001\r\u001db\u0001B\u0001\u0003\u0005\u001d\u0011\u0001C\u00117p_B\u00145\u000f]*feZL7-Z:\u000b\u0005\r!\u0011a\u00012ta*\tQ!A\u0003cY>|\u0007o\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0003\u0005\u0010\u0001\t\u0005\t\u0015!\u0003\u0011\u00035\u0019\u0017\r\u001c7TSR,7\u000b^1uKB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0007K:<\u0017N\\3\n\u0005U\u0011\"!B*uCR,\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\r\rd\u0017.\u001a8u!\tIb$D\u0001\u001b\u0015\tYB$A\u0004kg>t'\u000f]2\u000b\u0005uQ\u0011\u0001B7fi\u0006L!a\b\u000e\u0003\u001b)\u001bxN\u001c*qG\u000ec\u0017.\u001a8u\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013A\u0005:fY\u0006$\u0018N^3D_:4\u0017n\u001a)bi\"\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0003\u0002\u0005%|\u0017BA\u0014%\u00051\u0011V\r\\1uSZ,\u0007+\u0019;i\u0011!I\u0003A!A!\u0002\u0013Q\u0013aC:pG.,G/\u00138qkR\u0004\"aK\u0018\u000e\u00031R!!J\u0017\u000b\u00039\nAA[1wC&\u0011\u0001\u0007\f\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003))\u00070\u001b;Ti\u0006$Xo\u001d\t\u0003imj\u0011!\u000e\u0006\u0003m]\na!\u0019;p[&\u001c'B\u0001\u001d:\u0003%)\u00070Z2vi&|gNC\u0001;\u0003\u0015iwN\\5y\u0013\taTGA\u0005Bi>l\u0017nY%oi\")a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"b\u0001\u0011\"D\t\u00163\u0005CA!\u0001\u001b\u0005\u0011\u0001\"B\b>\u0001\u0004\u0001\u0002\"B\f>\u0001\u0004A\u0002\"B\u0011>\u0001\u0004\u0011\u0003\"B\u0015>\u0001\u0004Q\u0003\"\u0002\u001a>\u0001\u0004\u0019T\u0001\u0002%\u0001\t%\u0013Q\u0002\u0015:pi>\u001cw\u000e\\#se>\u0014\bC\u0001&N\u001d\tI2*\u0003\u0002M5\u0005A!+Z:q_:\u001cX-\u0003\u0002O\u001f\n)QI\u001d:pe*\u0011AJG\u0003\u0005#\u0002!!KA\u0006CgB\u0014Vm\u001d9p]N,WCA*j!\r!v+W\u0007\u0002+*\u0011a+O\u0001\u0005KZ\fG.\u0003\u0002Y+\n!A+Y:l!\u0011Q&-Z4\u000f\u0005m\u0003gB\u0001/`\u001b\u0005i&B\u00010\u0007\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002b\u0015\u00059\u0001/Y2lC\u001e,\u0017BA2e\u0005\u0019)\u0015\u000e\u001e5fe*\u0011\u0011M\u0003\t\u0003M\u001ek\u0011\u0001\u0001\t\u0003Q&d\u0001\u0001B\u0003k!\n\u00071NA\u0001U#\taw\u000e\u0005\u0002\n[&\u0011aN\u0003\u0002\b\u001d>$\b.\u001b8h!\tI\u0001/\u0003\u0002r\u0015\t\u0019\u0011I\\=\t\u000fM\u0004!\u0019!C\u0005i\u0006\u0011\"m\u001d9G_J<\u0018M\u001d3fe2{wmZ3s+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=\u0005\u0003\u001dawnZ4j]\u001eL!A_<\u0003\u0013\t\u001b\b\u000fT8hO\u0016\u0014\bB\u0002?\u0001A\u0003%Q/A\ncgB4uN]<be\u0012,'\u000fT8hO\u0016\u0014\b\u0005C\u0004\u007f\u0001\t\u0007IQA@\u0002\u0011M,'O^5dKN,\"!!\u0001\u0011\u0007e\t\u0019!C\u0002\u0002\u0006i\u0011\u0001bU3sm&\u001cWm\u001d\u0005\t\u0003\u0013\u0001\u0001\u0015!\u0004\u0002\u0002\u0005I1/\u001a:wS\u000e,7\u000f\t\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001f\tAbY;se\u0016tGo\u0015;bi\u0016,\u0012\u0001\u0005\u0005\n\u0003'\u0001\u0001\u0019!C\u0005\u0003+\t\u0001cY;se\u0016tGo\u0015;bi\u0016|F%Z9\u0015\t\u0005]\u0011Q\u0004\t\u0004\u0013\u0005e\u0011bAA\u000e\u0015\t!QK\\5u\u0011%\ty\"!\u0005\u0002\u0002\u0003\u0007\u0001#A\u0002yIEBq!a\t\u0001A\u0003&\u0001#A\u0007dkJ\u0014XM\u001c;Ti\u0006$X\r\t\u0015\u0005\u0003C\t9\u0003E\u0002\n\u0003SI1!a\u000b\u000b\u0005!1x\u000e\\1uS2,\u0007bBA\u0018\u0001\u0011\u0005\u0011qB\u0001\fY\u0006$Xm\u001d;Ti\u0006$X\rC\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u00026\u0005!\u0001o\\8m+\t\t9\u0004E\u0002\u0012\u0003sI1!a\u000f\u0013\u0005)\u0019E.[3oiB{w\u000e\u001c\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u00028\u0005)\u0001o\\8mA!I\u00111\t\u0001C\u0002\u0013%\u0011QI\u0001\fI\u00164\u0017-\u001e7u\u001fB$8/\u0006\u0002\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\u0011\t1a\u00197j\u0013\u0011\t\t&a\u0013\u0003\u001b\r{W.\\8o\u001fB$\u0018n\u001c8t\u0011!\t)\u0006\u0001Q\u0001\n\u0005\u001d\u0013\u0001\u00043fM\u0006,H\u000e^(qiN\u0004\u0003bBA-\u0001\u0011\u0005\u00111L\u0001\fe\u0016dw.\u00193Ti\u0006$X\r\u0006\u0003\u0002^\u0005}\u0003c\u0001+X!!A\u0011\u0011MA,\u0001\u0004\t\u0019'\u0001\u0004d_:4\u0017n\u001a\t\u0004G\u0005\u0015\u0014bAA4I\ta\u0011IY:pYV$X\rU1uQ\"9\u00111\u000e\u0001\u0005\u0002\u00055\u0014AC5oSRL\u0017\r\\5{KR!\u0011qNAC!\u00111\u0007+!\u001d\u0011\t\u0005M\u0014\u0011Q\u0007\u0003\u0003kR1aAA<\u0015\rY\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0003fa\u001ad'BAA@\u0003\t\u0019\u0007.\u0003\u0003\u0002\u0004\u0006U$!F%oSRL\u0017\r\\5{K\n+\u0018\u000e\u001c3SKN,H\u000e\u001e\u0005\t\u0003\u000f\u000bI\u00071\u0001\u0002\n\u00061\u0001/\u0019:b[N\u0004B!a\u001d\u0002\f&!\u0011QRA;\u0005UIe.\u001b;jC2L'0\u001a\"vS2$\u0007+\u0019:b[ND\u0011\"!%\u0001\u0005\u0004%\t!a%\u0002\u001b%\u001c\u0018J\\5uS\u0006d\u0017N_3e+\t\t)\n\u0005\u0004\u0002\u0018\u0006u\u0015\u0011U\u0007\u0003\u00033S1!a'\u000b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003?\u000bIJA\u0004Qe>l\u0017n]3\u0011\u000bi\u0013W-a\u0006\t\u0011\u0005\u0015\u0006\u0001)A\u0005\u0003+\u000ba\"[:J]&$\u0018.\u00197ju\u0016$\u0007\u0005C\u0005\u0002*\u0002\u0011\r\u0011\"\u0001\u0002,\u0006\t\u0012n]%oSRL\u0017\r\\5{K\u0012$\u0016m]6\u0016\u0005\u00055\u0006\u0003\u0002+X\u0003CC\u0001\"!-\u0001A\u0003%\u0011QV\u0001\u0013SNLe.\u001b;jC2L'0\u001a3UCN\\\u0007\u0005C\u0004\u00026\u0002!\t!a.\u0002\u0017%t\u0017\u000e^5bY&TX\r\u001a\u000b\u0005\u0003/\tI\f\u0003\u0005\u0002<\u0006M\u0006\u0019AA_\u0003YIg.\u001b;jC2L'0\u001a3Ck&dG\rU1sC6\u001c\b\u0003BA:\u0003\u007fKA!!1\u0002v\t1\u0012J\\5uS\u0006d\u0017N_3e\u0005VLG\u000e\u001a)be\u0006l7\u000fC\u0004\u0002F\u0002!\t!a2\u0002\u001b%4\u0017J\\5uS\u0006d\u0017N_3e+\u0011\tI-a4\u0015\t\u0005-\u0017\u0011\u001b\t\u0005MB\u000bi\rE\u0002i\u0003\u001f$aA[Ab\u0005\u0004Y\u0007\"CAj\u0003\u0007$\t\u0019AAk\u0003\u0005!\b#B\u0005\u0002X\u0006-\u0017bAAm\u0015\tAAHY=oC6,g(\u0002\u0004\u0002^\u0002\u0001\u0011q\u001c\u0002\u000f!J|'.Z2u\u001b\u0006\u0004\b/\u001b8h!\u001dI\u0011\u0011]As\u0003WL1!a9\u000b\u0005\u0019!V\u000f\u001d7feA!\u00111OAt\u0013\u0011\tI/!\u001e\u0003+\t+\u0018\u000e\u001c3UCJ<W\r^%eK:$\u0018NZ5feB!\u0011Q^Ax\u001b\u0005!\u0011bAAy\t\t9\u0001K]8kK\u000e$\bbBA{\u0001\u0011%\u0011q_\u0001\u000e[\u0006\u0004Hk\u001c)s_*,7\r^:\u0015\t\u0005e(1\u0001\t\u00065\n,\u00171 \t\u00065\u0006u(\u0011A\u0005\u0004\u0003\u007f$'aA*fcB\u0019a-a7\t\u0011\t\u0015\u00111\u001fa\u0001\u0005\u000f\tq\u0001^1sO\u0016$8\u000fE\u0003[\u0003{\f)\u000fC\u0004\u0003\f\u0001!\tA!\u0004\u0002\u000f\r|W\u000e]5mKR!!q\u0002B\f!\u00111\u0007K!\u0005\u0011\t\u0005M$1C\u0005\u0005\u0005+\t)HA\u0007D_6\u0004\u0018\u000e\\3SKN,H\u000e\u001e\u0005\t\u0003\u000f\u0013I\u00011\u0001\u0003\u001aA!\u00111\u000fB\u000e\u0013\u0011\u0011i\"!\u001e\u0003\u001b\r{W\u000e]5mKB\u000b'/Y7t\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005G\tq\u0002^8Ck&dG\rV1sO\u0016$\u0018\n\u001a\u000b\u0005\u0003K\u0014)\u0003\u0003\u0005\u0003(\t}\u0001\u0019AAv\u0003\u001d\u0001(o\u001c6fGRDqAa\u000b\u0001\t\u0003\u0011i#\u0001\nu_N\u001b\u0017\r\\1Ck&dG\rV1sO\u0016$H\u0003\u0002B\u0018\u0005k\u0001B!a\u001d\u00032%!!1GA;\u0005A\u00196-\u00197b\u0005VLG\u000e\u001a+be\u001e,G\u000f\u0003\u0005\u0003(\t%\u0002\u0019AAv\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005w\tABY;jY\u0012$\u0016M]4fiN$BA!\u0010\u0003FA!a\r\u0015B !\u0011\t\u0019H!\u0011\n\t\t\r\u0013Q\u000f\u0002\u0016/>\u00148n\u001d9bG\u0016\u0014U/\u001b7e)\u0006\u0014x-\u001a;t\u0011!\u00119Ea\u000eA\u0002\t%\u0013a\u0002:fcV,7\u000f\u001e\t\u0005\u0003g\u0012Y%\u0003\u0003\u0003N\u0005U$\u0001H,pe.\u001c\b/Y2f\u0005VLG\u000e\u001a+be\u001e,Go\u001d*fcV,7\u000f\u001e\u0005\b\u0005#\u0002A\u0011\u0001B*\u0003E!W\r]3oI\u0016t7-_*pkJ\u001cWm\u001d\u000b\u0005\u0005+\u0012i\u0006\u0005\u0003g!\n]\u0003\u0003BA:\u00053JAAa\u0017\u0002v\t9B)\u001a9f]\u0012,gnY=T_V\u00148-Z:SKN,H\u000e\u001e\u0005\t\u0005\u000f\u0012y\u00051\u0001\u0003`A!\u00111\u000fB1\u0013\u0011\u0011\u0019'!\u001e\u0003/\u0011+\u0007/\u001a8eK:\u001c\u0017pU8ve\u000e,7\u000fU1sC6\u001c\bb\u0002B4\u0001\u0011\u0005!\u0011N\u0001\u000eg\u000e\fG.Y2PaRLwN\\:\u0015\t\t-$1\u000f\t\u0005MB\u0013i\u0007\u0005\u0003\u0002t\t=\u0014\u0002\u0002B9\u0003k\u00121cU2bY\u0006\u001cw\n\u001d;j_:\u001c(+Z:vYRD\u0001Ba\u0012\u0003f\u0001\u0007!Q\u000f\t\u0005\u0003g\u00129(\u0003\u0003\u0003z\u0005U$aE*dC2\f7m\u00149uS>t7\u000fU1sC6\u001c\b\"\u0003B?\u0001\t\u0007I\u0011AAJ\u0003)I7o\u00155vi\u0012|wO\u001c\u0005\t\u0005\u0003\u0003\u0001\u0015!\u0003\u0002\u0016\u0006Y\u0011n]*ikR$wn\u001e8!\u0011%\u0011)\t\u0001b\u0001\n\u0003\tY+\u0001\bjgNCW\u000f\u001e3po:$\u0016m]6\t\u0011\t%\u0005\u0001)A\u0005\u0003[\u000bq\"[:TQV$Hm\\<o)\u0006\u001c8\u000e\t\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u0003!\u0019\b.\u001e;e_^tG\u0003BA\f\u0005#C\u0001B!$\u0003\f\u0002\u0007!1\u0013\t\u0005\u0003g\u0012)*\u0003\u0003\u0003\u0018\u0006U$\u0001C*ikR$wn\u001e8\t\u000f\tm\u0005\u0001\"\u0001\u0003\u001e\u0006!Q\r_5u)\u0011\u0011yJ!)\u0011\tQ;\u0016q\u0003\u0005\t\u0005\u001b\u0013I\n1\u0001\u0003$B!\u00111\u000fBS\u0013\u0011\u00119+!\u001e\u0003\t\u0015C\u0018\u000e^\u0004\b\u0005W\u0013\u0001\u0012\u0001BW\u0003A\u0011En\\8q\u0005N\u00048+\u001a:wS\u000e,7\u000fE\u0002B\u0005_3a!\u0001\u0002\t\u0002\tE6c\u0001BX\u0011!9aHa,\u0005\u0002\tUFC\u0001BW\u0011-\u0011ILa,C\u0002\u0013\u0005AAa/\u0002\u000f\r|WO\u001c;feV\u0011!Q\u0018\t\u0005\u0005\u007f\u0013I-\u0004\u0002\u0003B*\u0019aGa1\u000b\t\u0005m%Q\u0019\u0006\u0004\u0005\u000fl\u0013\u0001B;uS2LAAa3\u0003B\ni\u0011\t^8nS\u000eLe\u000e^3hKJD\u0011Ba4\u00030\u0002\u0006IA!0\u0002\u0011\r|WO\u001c;fe\u0002B1Ba5\u00030\n\u0007I\u0011\u0001\u0003\u0003V\u0006\u0001B)\u001a4bk2$H*\u00198hk\u0006<Wm]\u000b\u0003\u0005/\u0004bA!7\u0003d\n\u001dXB\u0001Bn\u0015\u0011\u0011iNa8\u0002\u0013%lW.\u001e;bE2,'b\u0001Bq\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0015(1\u001c\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0003j\n=XB\u0001Bv\u0015\r\u0011i/L\u0001\u0005Y\u0006tw-\u0003\u0003\u0003r\n-(AB*ue&tw\rC\u0005\u0003v\n=\u0006\u0015!\u0003\u0003X\u0006\tB)\u001a4bk2$H*\u00198hk\u0006<Wm\u001d\u0011\t\u0017\te(q\u0016b\u0001\n\u0003!!1`\u0001\u0017\t\u00164\u0017-\u001e7u\u0007>l\u0007/\u001b7f!J|g/\u001b3feV\u0011!Q \t\u0005\u0003g\u0012y0\u0003\u0003\u0004\u0002\u0005U$aD\"p[BLG.\u001a)s_ZLG-\u001a:\t\u0013\r\u0015!q\u0016Q\u0001\n\tu\u0018a\u0006#fM\u0006,H\u000e^\"p[BLG.\u001a)s_ZLG-\u001a:!\u0011-\u0019IAa,C\u0002\u0013\u0005Aaa\u0003\u0002'\u0011+g-Y;miR+7\u000f\u001e)s_ZLG-\u001a:\u0016\u0005\r5\u0001\u0003BA:\u0007\u001fIAa!\u0005\u0002v\taA+Z:u!J|g/\u001b3fe\"I1Q\u0003BXA\u0003%1QB\u0001\u0015\t\u00164\u0017-\u001e7u)\u0016\u001cH\u000f\u0015:pm&$WM\u001d\u0011\t\u0017\re!q\u0016b\u0001\n\u0003!11D\u0001\u0013\t\u00164\u0017-\u001e7u%Vt\u0007K]8wS\u0012,'/\u0006\u0002\u0004\u001eA!\u00111OB\u0010\u0013\u0011\u0019\t#!\u001e\u0003\u0017I+h\u000e\u0015:pm&$WM\u001d\u0005\n\u0007K\u0011y\u000b)A\u0005\u0007;\t1\u0003R3gCVdGOU;o!J|g/\u001b3fe\u0002\u0002")
public final class BloopBspServices {
    private final State callSiteState;
    private final Path relativeConfigPath;
    private final InputStream socketInput;
    private final AtomicInt exitStatus;
    private final BspLogger bspForwarderLogger;
    private final Services services;
    private volatile State currentState;
    private final ClientPool pool;
    private final CommonOptions defaultOpts;
    private final Promise<Either<Response.Error, BoxedUnit>> isInitialized;
    private final Task<Either<Response.Error, BoxedUnit>> isInitializedTask;
    private final Promise<Either<Response.Error, BoxedUnit>> isShutdown;
    private final Task<Either<Response.Error, BoxedUnit>> isShutdownTask;

    private BspLogger bspForwarderLogger() {
        return this.bspForwarderLogger;
    }

    public final Services services() {
        return this.services;
    }

    private State currentState() {
        return this.currentState;
    }

    private void currentState_$eq(State x$1) {
        this.currentState = x$1;
    }

    public State latestState() {
        State state0 = this.currentState() == null ? this.callSiteState : this.currentState();
        Logger x$13 = this.callSiteState.logger();
        Build x$14 = state0.copy$default$1();
        ResultsCache x$15 = state0.copy$default$2();
        CompilerCache x$16 = state0.copy$default$3();
        ClientPool x$17 = state0.copy$default$4();
        CommonOptions x$18 = state0.copy$default$5();
        ExitStatus x$19 = state0.copy$default$6();
        return state0.copy(x$14, x$15, x$16, x$17, x$18, x$19, x$13);
    }

    private ClientPool pool() {
        return this.pool;
    }

    private CommonOptions defaultOpts() {
        return this.defaultOpts;
    }

    public Task<State> reloadState(Path config) {
        this.bspForwarderLogger().debug(new StringBuilder(24).append("Reloading bsp state for ").append(AbsolutePath$.MODULE$.syntax$extension(config)).toString());
        return State$.MODULE$.loadActiveStateFor(config, this.pool(), this.defaultOpts(), this.bspForwarderLogger()).map((Function1 & Serializable & scala.Serializable)state0 -> {
            BspLogger x$20 = this.bspForwarderLogger();
            CommonOptions x$21 = this.latestState().commonOptions();
            Build x$22 = state0.copy$default$1();
            ResultsCache x$23 = state0.copy$default$2();
            CompilerCache x$24 = state0.copy$default$3();
            ClientPool x$25 = state0.copy$default$4();
            ExitStatus x$26 = state0.copy$default$6();
            return state0.copy(x$22, x$23, x$24, x$25, x$21, x$26, x$20);
        });
    }

    public Task<Either<Response.Error, InitializeBuildResult>> initialize(InitializeBuildParams params) {
        URI uri = new URI(params.rootUri().value());
        Path configDir = AbsolutePath$.MODULE$.resolve$extension0(AbsolutePath$.MODULE$.apply(uri), this.relativeConfigPath);
        return this.reloadState(configDir).map((Function1 & Serializable & scala.Serializable)state -> {
            $this.callSiteState.logger().info("request received: build/initialize");
            this.currentState_$eq((State)state);
            return package$.MODULE$.Right().apply((Object)new InitializeBuildResult(new BuildServerCapabilities(BloopBspServices$.MODULE$.DefaultCompileProvider(), BloopBspServices$.MODULE$.DefaultTestProvider(), BloopBspServices$.MODULE$.DefaultRunProvider(), true, true, false, false)));
        });
    }

    public Promise<Either<Response.Error, BoxedUnit>> isInitialized() {
        return this.isInitialized;
    }

    public Task<Either<Response.Error, BoxedUnit>> isInitializedTask() {
        return this.isInitializedTask;
    }

    public void initialized(InitializedBuildParams initializedBuildParams) {
        this.isInitialized().success((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        this.callSiteState.logger().info("BSP initialization handshake complete.");
    }

    public <T> Task<Either<Response.Error, T>> ifInitialized(Function0<Task<Either<Response.Error, T>>> t) {
        return this.isInitializedTask().timeoutTo(FiniteDuration$.MODULE$.apply(1L, TimeUnit.SECONDS), Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)Response$.MODULE$.invalidRequest("The session has not been initialized.")))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Task task;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Response.Error e = (Response.Error)left.value();
                task = Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)e));
            } else if (either instanceof Right) {
                task = (Task)t.apply();
            } else {
                throw new MatchError((Object)either);
            }
            return task;
        });
    }

    private Either<Response.Error, Seq<Tuple2<BuildTargetIdentifier, Project>>> mapToProjects(Seq<BuildTargetIdentifier> targets) {
        Left left;
        Option option = targets.headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            BuildTargetIdentifier head = (BuildTargetIdentifier)some.value();
            Either init = this.getProject$1(head).map((Function1 & Serializable & scala.Serializable)m -> {
                Tuple2 tuple2 = m;
                return Nil$.MODULE$.$colon$colon((Object)tuple2);
            });
            left = (Either)((TraversableOnce)targets.tail()).foldLeft((Object)init, (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Either acc = (Either)tuple2._1();
                BuildTargetIdentifier t = (BuildTargetIdentifier)tuple2._2();
                Either either = acc.flatMap((Function1 & Serializable & scala.Serializable)ms -> this.getProject$1(t).map((Function1 & Serializable & scala.Serializable)m -> {
                    Tuple2 tuple2 = m;
                    return ms.$colon$colon((Object)tuple2);
                }));
                return either;
            });
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)Response$.MODULE$.invalidRequest("Empty build targets. Expected at least one build target identifier."));
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Task<Either<Response.Error, CompileResult>> compile(CompileParams params) {
        return this.ifInitialized((Function0 & Serializable & scala.Serializable)() -> {
            Task task;
            Either<Response.Error, Seq<Tuple2<BuildTargetIdentifier, Project>>> either = this.mapToProjects((Seq<BuildTargetIdentifier>)params.targets());
            if (either instanceof Left) {
                Left left = (Left)either;
                Response.Error error = (Response.Error)left.value();
                task = Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)error));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq mappings = (Seq)right.value();
                task = this.compile$1(mappings);
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    private BuildTargetIdentifier toBuildTargetId(Project project) {
        return new BuildTargetIdentifier(project.bspUri());
    }

    public ScalaBuildTarget toScalaBuildTarget(Project project) {
        ScalaInstance instance = project.scalaInstance();
        List jars = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instance.allJars())).iterator().map((Function1 & Serializable & scala.Serializable)j -> Uri$.MODULE$.apply(j.toURI())).toList();
        return new ScalaBuildTarget(instance.organization(), instance.version(), instance.version(), (ScalaPlatform)ScalaPlatform.Jvm$.MODULE$, jars);
    }

    public Task<Either<Response.Error, WorkspaceBuildTargets>> buildTargets(WorkspaceBuildTargetsRequest request) {
        return this.ifInitialized((Function0 & Serializable & scala.Serializable)() -> {
            Build build = this.currentState().build();
            WorkspaceBuildTargets targets = new WorkspaceBuildTargets((List)build.projects().map((Function1 & Serializable & scala.Serializable)p -> {
                BuildTargetIdentifier id = this.toBuildTargetId((Project)p);
                BuildTargetKind.Library$ kind = p.name().endsWith("-test") && build.getProjectFor(new StringBuilder(5).append(p.name()).append("-test").toString()).isEmpty() ? BuildTargetKind.Test$.MODULE$ : BuildTargetKind.Library$.MODULE$;
                Iterator deps = p.dependencies().iterator().flatMap((Function1 & Serializable & scala.Serializable)x$12 -> build.getProjectFor((String)x$12).toList());
                Some extra = new Some((Object)ScalaBuildTarget$.MODULE$.encodeScalaBuildTarget().apply((Object)this.toScalaBuildTarget((Project)p)));
                BuildTargetCapabilities capabilities = new BuildTargetCapabilities(true, true, true);
                return new BuildTarget(id, p.name(), (BuildTargetKind)kind, BloopBspServices$.MODULE$.DefaultLanguages(), deps.map((Function1 & Serializable & scala.Serializable)project -> this.toBuildTargetId((Project)project)).toList(), capabilities, (Option)extra);
            }, List$.MODULE$.canBuildFrom()));
            return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)targets));
        });
    }

    public Task<Either<Response.Error, DependencySourcesResult>> dependencySources(DependencySourcesParams request) {
        return this.ifInitialized((Function0 & Serializable & scala.Serializable)() -> {
            Task task;
            Either<Response.Error, Seq<Tuple2<BuildTargetIdentifier, Project>>> either = this.mapToProjects((Seq<BuildTargetIdentifier>)request.targets());
            if (either instanceof Left) {
                Left left = (Left)either;
                Response.Error error = (Response.Error)left.value();
                task = Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)error));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq mappings = (Seq)right.value();
                task = BloopBspServices.sources$1(mappings);
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    public Task<Either<Response.Error, ScalacOptionsResult>> scalacOptions(ScalacOptionsParams request) {
        return this.ifInitialized((Function0 & Serializable & scala.Serializable)() -> {
            Task task;
            Either<Response.Error, Seq<Tuple2<BuildTargetIdentifier, Project>>> either = this.mapToProjects((Seq<BuildTargetIdentifier>)request.targets());
            if (either instanceof Left) {
                Left left = (Left)either;
                Response.Error error = (Response.Error)left.value();
                task = Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)error));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq mappings = (Seq)right.value();
                task = BloopBspServices.scalacOptions$1(mappings);
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    public Promise<Either<Response.Error, BoxedUnit>> isShutdown() {
        return this.isShutdown;
    }

    public Task<Either<Response.Error, BoxedUnit>> isShutdownTask() {
        return this.isShutdownTask;
    }

    public void shutdown(Shutdown shutdown) {
        this.isShutdown().success((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        this.callSiteState.logger().info("shutdown request received: build/shutdown");
    }

    public Task<BoxedUnit> exit(ch.epfl.scala.bsp.Exit shutdown) {
        return this.isShutdownTask().timeoutTo(FiniteDuration$.MODULE$.apply(1L, TimeUnit.SECONDS), Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT))).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            BloopBspServices.$anonfun$exit$1(this, x0$7);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Either getProject$1(BuildTargetIdentifier target) {
        Uri uri = target.uri();
        boolean bl = false;
        Right right = null;
        Either<String, Option<Project>> either = ProjectUris$.MODULE$.getProjectDagFromUri(uri.value(), this.currentState());
        if (either instanceof Left) {
            Left left = (Left)either;
            String errorMsg = (String)left.value();
            return package$.MODULE$.Left().apply((Object)Response$.MODULE$.parseError(errorMsg));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (option instanceof Some) {
                Some some = (Some)option;
                Project project = (Project)some.value();
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)target, (Object)project));
            }
        }
        if (!bl) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!None$.MODULE$.equals(option)) throw new MatchError(either);
        return package$.MODULE$.Left().apply((Object)Response$.MODULE$.invalidRequest(new StringBuilder(27).append("No project associated with ").append(uri).toString()));
    }

    private static final String reportError$1(Project p, Problem[] problems, long elapsedMs) {
        Problem.DiagnosticsCount count = Problem$.MODULE$.count(problems);
        return new StringBuilder(26).append(p.name()).append(" [").append(elapsedMs).append("ms] (errors ").append(count.errors()).append(", warnings ").append(count.warnings()).append(")").toString();
    }

    private final Task compile$1(Seq projects0) {
        State current = this.currentState();
        Set<Project> projects = Dag$.MODULE$.reduce(current.build().dags(), ((TraversableOnce)projects0.map((Function1 & Serializable & scala.Serializable)x$11 -> (Project)x$11._2(), Seq$.MODULE$.canBuildFrom())).toSet());
        Action action = (Action)projects.foldLeft((Object)new Exit(ExitStatus$.MODULE$.Ok()), (Function2 & Serializable & scala.Serializable)(x0$3, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Action action = (Action)tuple2._1();
            Project project = (Project)tuple2._2();
            Run run2 = new Run(new Commands.Compile(project.name(), Commands$Compile$.MODULE$.apply$default$2(), Commands$Compile$.MODULE$.apply$default$3(), Commands$Compile$.MODULE$.apply$default$4(), Commands$Compile$.MODULE$.apply$default$5()), action);
            return run2;
        });
        return Interpreter$.MODULE$.execute(action, (Task<State>)Task$.MODULE$.now((Object)current)).map((Function1 & Serializable & scala.Serializable)state -> {
            Right right;
            List errorMsgs;
            this.currentState_$eq((State)state);
            List<Tuple2<Project, Compiler.Result>> compiledProjects = current.results().diffLatest(state.results());
            List list = errorMsgs = (List)compiledProjects.flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Nil$ nil$;
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Project p = (Project)tuple2._1();
                Compiler.Result result = (Compiler.Result)tuple2._2();
                Compiler.Result result2 = result;
                if (Compiler.Result$.Empty$.MODULE$.equals(result2)) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                } else if (result2 instanceof Compiler.Result$.Cancelled) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                } else if (result2 instanceof Compiler.Result$.Blocked) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                } else if (result2 instanceof Compiler.Result$.Success) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                } else {
                    if (!(result2 instanceof Compiler.Result$.Failed)) throw new MatchError((Object)result2);
                    Compiler.Result$.Failed failed2 = (Compiler.Result$.Failed)result2;
                    Problem[] problems = failed2.problems();
                    long elapsed = failed2.elapsed();
                    nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{BloopBspServices.reportError$1(p, problems, elapsed)}));
                }
                return nil$;
            }, List$.MODULE$.canBuildFrom());
            if (Nil$.MODULE$.equals(list)) {
                right = package$.MODULE$.Right().apply((Object)new CompileResult((Option)None$.MODULE$, (Option)None$.MODULE$));
            } else {
                String allErrors = ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)str -> new StringBuilder(2).append("  ").append((String)str).toString(), List$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
                right = package$.MODULE$.Left().apply((Object)Response$.MODULE$.internalError(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(19).append("Compilation failed:").append(System.lineSeparator()).append(allErrors).toString())).stripMargin()));
            }
            return right;
        });
    }

    public static final /* synthetic */ boolean $anonfun$dependencySources$5(Config.Artifact a) {
        return a.classifier().toList().contains((Object)"sources");
    }

    private static final Task sources$1(Seq projects) {
        DependencySourcesResult response = new DependencySourcesResult(projects.iterator().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BuildTargetIdentifier target = (BuildTargetIdentifier)tuple2._1();
            Project project = (Project)tuple2._2();
            List sources = project.sources().iterator().map((Function1 & Serializable & scala.Serializable)s -> Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspUri$extension(((AbsolutePath)s).underlying()))).toList();
            List sourceJars = (List)project.resolution().toList().flatMap((Function1 & Serializable & scala.Serializable)res -> (List)res.modules().flatMap((Function1 & Serializable & scala.Serializable)m -> m.artifacts().iterator().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)BloopBspServices.$anonfun$dependencySources$5(a))).map((Function1 & Serializable & scala.Serializable)a -> Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspUri$extension(AbsolutePath$.MODULE$.apply(a.path(), AbsolutePath$.MODULE$.workingDirectory())))).toList(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
            DependencySourcesItem dependencySourcesItem = new DependencySourcesItem(target, (List)sources.$plus$plus((GenTraversableOnce)sourceJars, List$.MODULE$.canBuildFrom()));
            return dependencySourcesItem;
        }).toList());
        return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)response));
    }

    private static final Task scalacOptions$1(Seq projects) {
        ScalacOptionsResult response = new ScalacOptionsResult(projects.iterator().map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BuildTargetIdentifier target = (BuildTargetIdentifier)tuple2._1();
            Project project = (Project)tuple2._2();
            ScalacOptionsItem scalacOptionsItem = new ScalacOptionsItem(target, project.scalacOptions().toList(), Predef$.MODULE$.genericArrayOps((Object)project.classpath()).iterator().map((Function1 & Serializable & scala.Serializable)e -> Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspUri$extension(((AbsolutePath)e).underlying()))).toList(), Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspUri$extension(project.classesDir())));
            return scalacOptionsItem;
        }).toList());
        return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)response));
    }

    private final void closeServices$1(int code) {
        this.exitStatus.set(code);
        try {
            this.socketInput.close();
        }
        catch (Throwable throwable) {}
    }

    public static final /* synthetic */ void $anonfun$exit$1(BloopBspServices $this, Either x0$7) {
        Either either = x0$7;
        if (either instanceof Left) {
            $this.closeServices$1(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            $this.closeServices$1(0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    public BloopBspServices(State callSiteState, JsonRpcClient client, Path relativeConfigPath, InputStream socketInput, AtomicInt exitStatus) {
        this.callSiteState = callSiteState;
        this.relativeConfigPath = relativeConfigPath;
        this.socketInput = socketInput;
        this.exitStatus = exitStatus;
        this.bspForwarderLogger = BspLogger$.MODULE$.apply(callSiteState, client, false);
        this.services = Services$.MODULE$.empty().requestAsync((Endpoint)Build$.MODULE$.initialize(), x$1 -> this.initialize((InitializeBuildParams)x$1)).notification((Endpoint)Build$.MODULE$.initialized(), (Function1 & Serializable & scala.Serializable)x$2 -> {
            this.initialized(x$2);
            return BoxedUnit.UNIT;
        }).request((Endpoint)Build$.MODULE$.shutdown(), (Function1 & Serializable & scala.Serializable)x$3 -> {
            this.shutdown(x$3);
            return BoxedUnit.UNIT;
        }).notificationAsync((Endpoint)Build$.MODULE$.exit(), x$4 -> this.exit((ch.epfl.scala.bsp.Exit)x$4)).requestAsync((Endpoint)Workspace$.MODULE$.buildTargets(), x$5 -> this.buildTargets((WorkspaceBuildTargetsRequest)x$5)).requestAsync((Endpoint)BuildTarget$.MODULE$.dependencySources(), x$6 -> this.dependencySources((DependencySourcesParams)x$6)).requestAsync((Endpoint)BuildTarget$.MODULE$.scalacOptions(), x$7 -> this.scalacOptions((ScalacOptionsParams)x$7)).requestAsync((Endpoint)BuildTarget$.MODULE$.compile(), x$8 -> this.compile((CompileParams)x$8));
        this.currentState = null;
        this.pool = callSiteState.pool();
        this.defaultOpts = callSiteState.commonOptions();
        this.isInitialized = Promise$.MODULE$.apply();
        this.isInitializedTask = Task$.MODULE$.fromFuture(this.isInitialized().future()).memoize();
        this.isShutdown = Promise$.MODULE$.apply();
        this.isShutdownTask = Task$.MODULE$.fromFuture(this.isShutdown().future()).memoize();
    }
}

