/*
 * Decompiled with CFR 0.152.
 */
package bloop.bsp;

import bloop.bsp.BloopBspServices;
import bloop.bsp.BspServer;
import bloop.cli.Commands;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.State$XState$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.BspClientLogger;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import com.martiansoftware.nailgun.NGUnixDomainServerSocket;
import com.martiansoftware.nailgun.NGWin32NamedPipeServerSocket;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Path;
import java.util.Locale;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.Observable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.meta.jsonrpc.BaseProtocolMessage$;
import scala.meta.jsonrpc.JsonRpcClient;
import scala.meta.jsonrpc.LanguageClient;
import scala.meta.jsonrpc.LanguageServer;
import scala.meta.jsonrpc.Services;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class BspServer$ {
    public static BspServer$ MODULE$;
    private final DebugFilter logContext;
    private final boolean isWindows;
    private final boolean isMac;

    static {
        new BspServer$();
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    private Task<BspServer.ConnectionHandle> initServer(Commands.ValidatedBsp cmd, State state) {
        Task task;
        Commands.ValidatedBsp validatedBsp = cmd;
        if (validatedBsp instanceof Commands.WindowsLocalBsp) {
            Commands.WindowsLocalBsp windowsLocalBsp = (Commands.WindowsLocalBsp)validatedBsp;
            String pipeName = windowsLocalBsp.pipeName();
            NGWin32NamedPipeServerSocket server = new NGWin32NamedPipeServerSocket(pipeName);
            state.logger().debug(new StringBuilder(36).append("Waiting for a connection at pipe ").append(pipeName).append("...").toString(), this.logContext());
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BspServer.WindowsLocal(pipeName, (ServerSocket)server)).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.close()));
        } else if (validatedBsp instanceof Commands.UnixLocalBsp) {
            Commands.UnixLocalBsp unixLocalBsp = (Commands.UnixLocalBsp)validatedBsp;
            Path socketFile = unixLocalBsp.socket();
            NGUnixDomainServerSocket server = new NGUnixDomainServerSocket(AbsolutePath$.MODULE$.toString$extension(socketFile));
            state.logger().debug(new StringBuilder(31).append("Waiting for a connection at ").append(new AbsolutePath(socketFile)).append("...").toString(), this.logContext());
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BspServer.UnixLocal(socketFile, (ServerSocket)server)).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.close()));
        } else if (validatedBsp instanceof Commands.TcpBsp) {
            Commands.TcpBsp tcpBsp = (Commands.TcpBsp)validatedBsp;
            InetAddress address = tcpBsp.host();
            int portNumber = tcpBsp.port();
            InetSocketAddress socketAddress = new InetSocketAddress(address, portNumber);
            ServerSocket server = new ServerSocket(portNumber, 10, address);
            state.logger().debug(new StringBuilder(31).append("Waiting for a connection at ").append(socketAddress).append("...").toString(), this.logContext());
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BspServer.Tcp(socketAddress, server)).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.close()));
        } else {
            throw new MatchError((Object)validatedBsp);
        }
        return task;
    }

    public void closeSocket(Commands.ValidatedBsp cmd, Socket socket) {
        Commands.ValidatedBsp validatedBsp = cmd;
        if (validatedBsp instanceof Commands.TcpBsp && !socket.isClosed()) {
            socket.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (validatedBsp instanceof Commands.WindowsLocalBsp && !socket.isClosed()) {
            socket.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (validatedBsp instanceof Commands.UnixLocalBsp && !socket.isClosed()) {
            if (!socket.isInputShutdown()) {
                socket.shutdownInput();
            }
            if (!socket.isOutputShutdown()) {
                socket.shutdownOutput();
            }
            socket.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Task<State> run(Commands.ValidatedBsp cmd, State state, Path configPath, Scheduler scheduler) {
        return this.initServer(cmd, state).materialize().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Failure failure;
            Throwable t;
            Task task;
            Success success;
            BspServer.ConnectionHandle handle;
            Try try_ = x0$1;
            if (try_ instanceof Success && (handle = (BspServer.ConnectionHandle)(success = (Success)try_).value()) != null) {
                BspServer.ConnectionHandle connectionHandle = handle;
                task = this.startServer$1(connectionHandle, state, configPath, scheduler).onErrorRecoverWith((PartialFunction)new scala.Serializable(state){
                    public static final long serialVersionUID = 0L;
                    private final State state$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            A1 A12 = A1;
                            object = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension1(State$.MODULE$.XState(this.state$1), new StringBuilder(32).append("BSP server failed to start with ").append(A12.getMessage()).toString(), A12));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable != null;
                        return bl;
                    }
                    {
                        this.state$1 = state$1;
                    }
                });
            } else if (try_ instanceof Failure && (t = (failure = (Failure)try_).exception()) != null) {
                Throwable throwable = t;
                task = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension1(State$.MODULE$.XState(state), new StringBuilder(38).append("BSP server failed to open a socket: '").append(throwable.getMessage()).append("'").toString(), throwable));
            } else {
                throw new MatchError((Object)try_);
            }
            return task;
        });
    }

    private static final String uri$1(BspServer.ConnectionHandle handle) {
        String string;
        BspServer.ConnectionHandle connectionHandle = handle;
        if (connectionHandle instanceof BspServer.WindowsLocal) {
            BspServer.WindowsLocal windowsLocal = (BspServer.WindowsLocal)connectionHandle;
            string = new StringBuilder(6).append("local:").append(windowsLocal.pipeName()).toString();
        } else if (connectionHandle instanceof BspServer.UnixLocal) {
            BspServer.UnixLocal unixLocal = (BspServer.UnixLocal)connectionHandle;
            string = new StringBuilder(8).append("local://").append(AbsolutePath$.MODULE$.syntax$extension(unixLocal.path())).toString();
        } else if (connectionHandle instanceof BspServer.Tcp) {
            BspServer.Tcp tcp = (BspServer.Tcp)connectionHandle;
            string = new StringBuilder(7).append("tcp://").append(tcp.address().getHostString()).append(":").append(tcp.address().getPort()).toString();
        } else {
            throw new MatchError((Object)connectionHandle);
        }
        return string;
    }

    private final Task startServer$1(BspServer.ConnectionHandle handle, State state$1, Path configPath$1, Scheduler scheduler$1) {
        String connectionURI = BspServer$.uri$1(handle);
        state$1.logger().debug(new StringBuilder(55).append("The server is listening for incoming connections at ").append(connectionURI).append("...").toString(), this.logContext());
        Socket socket = handle.serverSocket().accept();
        state$1.logger().info(new StringBuilder(43).append("Accepted incoming BSP client connection at ").append(connectionURI).toString());
        AtomicInt exitStatus = AtomicBuilder.AtomicIntBuilder$.MODULE$.buildInstance(0, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        BspClientLogger<Logger> bspLogger = new BspClientLogger<Logger>(state$1.logger());
        LanguageClient client = new LanguageClient(out, bspLogger);
        BloopBspServices servicesProvider = new BloopBspServices(state$1, (JsonRpcClient)client, configPath$1, in, exitStatus);
        Services bloopServices = servicesProvider.services();
        Observable messages = BaseProtocolMessage$.MODULE$.fromInputStream(in, bspLogger);
        LanguageServer server = new LanguageServer(messages, client, bloopServices, scheduler$1, bspLogger);
        return server.startTask().map((Function1 & Serializable & scala.Serializable)x$1 -> servicesProvider.stateAfterExecution()).onErrorHandleWith((Function1 & Serializable & scala.Serializable)t -> Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(servicesProvider.stateAfterExecution()), new StringBuilder(22).append("BSP server stopped by ").append(t.getMessage()).toString()))).doOnFinish((Function1 & Serializable & scala.Serializable)x$2 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> handle.serverSocket().close()));
    }

    private BspServer$() {
        MODULE$ = this;
        this.logContext = DebugFilter.Bsp$.MODULE$;
        this.isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        this.isMac = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    }
}

