/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.data.Origin$;
import bloop.data.Project;
import bloop.data.Project$;
import bloop.engine.Build;
import bloop.engine.ExecutionContext$;
import bloop.io.AbsolutePath$;
import bloop.io.Paths;
import bloop.io.Paths$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.util.ByteHasher$;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public final class BuildLoader$ {
    public static BuildLoader$ MODULE$;
    private final String JsonFilePattern;

    static {
        new BuildLoader$();
    }

    public final String JsonFilePattern() {
        return this.JsonFilePattern;
    }

    public List<Paths.AttributedPath> readConfigurationFilesInBase(Path base, Logger logger) {
        return Paths$.MODULE$.attributedPathFilesUnder(base, this.JsonFilePattern(), logger, 1);
    }

    public Task<List<Project>> loadBuildFromConfigurationFiles(Path configDir, List<Build.ReadConfiguration> configFiles, Logger logger) {
        logger.debug(new StringBuilder(28).append("Loading ").append(configFiles.length()).append(" projects from '").append(AbsolutePath$.MODULE$.syntax$extension(configDir)).append("'...").toString(), (DebugFilter)DebugFilter.Compilation$.MODULE$);
        List all = (List)configFiles.map((Function1 & Serializable & scala.Serializable)f -> Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Project$.MODULE$.fromBytesAndOrigin(f.bytes(), f.origin(), logger)), List$.MODULE$.canBuildFrom());
        return Task$.MODULE$.gatherUnordered((TraversableOnce)all).executeOn(ExecutionContext$.MODULE$.scheduler());
    }

    public Task<List<Project>> load(Path configDir, Logger logger) {
        List configFiles = (List)this.readConfigurationFilesInBase(configDir, logger).map((Function1 & Serializable & scala.Serializable)ap -> Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            byte[] bytes = AbsolutePath$.MODULE$.readAllBytes$extension(ap.path());
            int hash = ByteHasher$.MODULE$.hashBytes(bytes);
            return new Build.ReadConfiguration(Origin$.MODULE$.apply((Paths.AttributedPath)ap, hash), bytes);
        }), List$.MODULE$.canBuildFrom());
        return Task$.MODULE$.gatherUnordered((TraversableOnce)configFiles).flatMap((Function1 & Serializable & scala.Serializable)fs -> MODULE$.loadBuildFromConfigurationFiles(configDir, (List<Build.ReadConfiguration>)fs, logger));
    }

    public List<Project> loadSynchronously(Path configDir, Logger logger) {
        List configFiles = (List)this.readConfigurationFilesInBase(configDir, logger).map((Function1 & Serializable & scala.Serializable)ap -> {
            byte[] bytes = AbsolutePath$.MODULE$.readAllBytes$extension(ap.path());
            int hash = ByteHasher$.MODULE$.hashBytes(bytes);
            return new Build.ReadConfiguration(Origin$.MODULE$.apply((Paths.AttributedPath)ap, hash), bytes);
        }, List$.MODULE$.canBuildFrom());
        logger.debug(new StringBuilder(28).append("Loading ").append(configFiles.length()).append(" projects from '").append(AbsolutePath$.MODULE$.syntax$extension(configDir)).append("'...").toString(), (DebugFilter)DebugFilter.Compilation$.MODULE$);
        return (List)configFiles.map((Function1 & Serializable & scala.Serializable)f -> Project$.MODULE$.fromBytesAndOrigin(f.bytes(), f.origin(), logger), List$.MODULE$.canBuildFrom());
    }

    private BuildLoader$() {
        MODULE$ = this;
        this.JsonFilePattern = "glob:**.json";
    }
}

