/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.data.Project;
import bloop.engine.Feedback;
import bloop.io.AbsolutePath;
import java.nio.file.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class Feedback$ {
    public static Feedback$ MODULE$;
    private final String eol;

    static {
        new Feedback$();
    }

    private final String eol() {
        return this.eol;
    }

    public String listMainClasses(List<String> mainClasses) {
        return new StringBuilder(32).append("Use the following main classes:\n").append(mainClasses.mkString(" * ", new StringBuilder(3).append(this.eol()).append(" * ").toString(), "")).toString();
    }

    public String missingMainClass(Project project) {
        return new StringBuilder(37).append("No main classes defined in project '").append(project.name()).append("'").toString();
    }

    public String expectedDefaultMainClass(Project project) {
        return new StringBuilder(113).append("Multiple main classes found. Expected a default main class via command-line or in the configuration of project '").append(project.name()).append("'").toString();
    }

    public String missingScalaInstance(Project project) {
        return new StringBuilder(93).append("Failed to compile project '").append(project.name()).append("': found Scala sources but project is missing Scala configuration.").toString();
    }

    public String missingInstanceForJavaCompilation(Project project) {
        return new StringBuilder(84).append("Failed to compile Java sources in ").append(project.name()).append(": default Zinc Scala instance couldn't be created!").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<String> detectMissingDependencies(Project project, List<String> missing) {
        List<String> list = missing;
        if (Nil$.MODULE$.equals(list)) {
            return None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String missing2 = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return new Some((Object)new StringBuilder(62).append("Missing project '").append(missing2).append("', may cause compilation issues in project '").append(project.name()).append("'").toString());
            }
        }
        String deps = ((TraversableOnce)missing.map((Function1 & java.io.Serializable & Serializable)m -> new StringBuilder(2).append("'").append((String)m).append("'").toString(), List$.MODULE$.canBuildFrom())).mkString(", ");
        return new Some((Object)new StringBuilder(61).append("Missing projects ").append(deps).append(", may cause compilation issues in project '").append(project.name()).append("'").toString());
    }

    public String failedToLink(Project project, String linker, Throwable t) {
        return new StringBuilder(30).append("Failed to link ").append(linker).append(" project '").append(project.name()).append("': '").append(t.getMessage()).append("'").toString();
    }

    public String missingLinkArtifactFor(Project project, String artifactName, String linker) {
        return new StringBuilder(55).append("Missing ").append(linker).append("'s artifact ").append(artifactName).append(" for project '").append(project).append("' (resolution failed)").toString();
    }

    public String noLinkFor(Project project) {
        return new StringBuilder(90).append("Cannot link JVM project '").append(project.name()).append("', `link` is only available in Scala Native or Scala.js projects.").toString();
    }

    public String printException(String error, Throwable t) {
        String msg = t.getMessage();
        Throwable cause = t.getCause();
        return msg == null ? new StringBuilder(4).append(error).append(": '").append(cause).append("'").toString() : (cause == null ? new StringBuilder(4).append(error).append(": '").append(t).append("'").toString() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(53).append("\n           |").append(error).append(": '").append(t).append("'\n           |  Caused by: '").append(cause).append("'\n       ").toString())).stripMargin());
    }

    public String missingConfigDirectory(Path configDirectory) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(433).append("Missing configuration directory in ").append(new AbsolutePath(configDirectory)).append(".\n       |\n       |  1. Did you run bloop outside of the working directory of your build?\n       |     If so, change your current directory or point directly to your `.bloop` directory via `--config-dir`.\n       |\n       |  2. Did you forget to generate configuration files for your build?\n       |     Check the installation instructions https://scalacenter.github.io/bloop/docs/installation/\n    ").toString())).stripMargin();
    }

    public Feedback.XMessageString XMessageString(String msg) {
        return new Feedback.XMessageString(msg);
    }

    private Feedback$() {
        MODULE$ = this;
        this.eol = System.lineSeparator();
    }
}

