/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.bsp.BspServer$;
import bloop.data.Project;
import bloop.engine.ExecutionContext$;
import bloop.engine.State;
import bloop.io.SourceWatcher$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.Slf4jAdapter;
import bloop.monix.FoldLeftAsyncConsumer$;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.DirectoryWatcher;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.reactive.Consumer;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0003\u000f\ti1k\\;sG\u0016<\u0016\r^2iKJT!a\u0001\u0003\u0002\u0005%|'\"A\u0003\u0002\u000b\tdwn\u001c9\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011=\u0001!\u0011!Q\u0001\nA\tq\u0001\u001d:pU\u0016\u001cG\u000f\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005!A-\u0019;b\u0013\t)\"CA\u0004Qe>TWm\u0019;\t\u0011]\u0001!\u0011!Q\u0001\na\tA\u0001Z5sgB\u0019\u0011$\t\u0013\u000f\u0005iybBA\u000e\u001f\u001b\u0005a\"BA\u000f\u0007\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002!\u0015\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0012$\u0005\r\u0019V-\u001d\u0006\u0003A)\u0001\"!\n\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\t\u0019LG.\u001a\u0006\u0003S)\n1A\\5p\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0014\u0003\tA\u000bG\u000f\u001b\u0005\t_\u0001\u0011\t\u0011)A\u00051\u0005)a-\u001b7fg\"A\u0011\u0007\u0001B\u0001B\u0003%!'\u0001\u0004m_\u001e<WM\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0011\tq\u0001\\8hO&tw-\u0003\u00028i\t1Aj\\4hKJDQ!\u000f\u0001\u0005\ni\na\u0001P5oSRtD#B\u001e>}}\u0002\u0005C\u0001\u001f\u0001\u001b\u0005\u0011\u0001\"B\b9\u0001\u0004\u0001\u0002\"B\f9\u0001\u0004A\u0002\"B\u00189\u0001\u0004A\u0002\"B\u00199\u0001\u0004\u0011\u0004b\u0002\"\u0001\u0005\u0004%IaQ\u0001\fg24GG\u001b'pO\u001e,'/F\u0001E!\r\u0019TIM\u0005\u0003\rR\u0012Ab\u00157gi)\fE-\u00199uKJDa\u0001\u0013\u0001!\u0002\u0013!\u0015\u0001D:mMRRGj\\4hKJ\u0004\u0003b\u0002&\u0001\u0005\u0004%YaS\u0001\u000bY><7i\u001c8uKb$X#\u0001'\u0011\u0005Mj\u0015B\u0001(5\u0005-!UMY;h\r&dG/\u001a:\t\rA\u0003\u0001\u0015!\u0003M\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\t\u000bI\u0003A\u0011A*\u0002\u000b]\fGo\u00195\u0015\u0007Q\u0013G\rE\u0002V5rk\u0011A\u0016\u0006\u0003/b\u000bA!\u001a<bY*\t\u0011,A\u0003n_:L\u00070\u0003\u0002\\-\n!A+Y:l!\ti\u0006-D\u0001_\u0015\tyF!\u0001\u0004f]\u001eLg.Z\u0005\u0003Cz\u0013Qa\u0015;bi\u0016DQaY)A\u0002q\u000baa\u001d;bi\u0016\u0004\u0004\"B3R\u0001\u00041\u0017AB1di&|g\u000e\u0005\u0003\nOr#\u0016B\u00015\u000b\u0005%1UO\\2uS>t\u0017\u0007C\u0003k\u0001\u0011\u00051.A\u0006o_RLg-_,bi\u000eDG#\u00017\u0011\u0005%i\u0017B\u00018\u000b\u0005\u0011)f.\u001b;\b\u000bA\u0014\u0001\u0012A9\u0002\u001bM{WO]2f/\u0006$8\r[3s!\ta$OB\u0003\u0002\u0005!\u00051o\u0005\u0002s\u0011!)\u0011H\u001dC\u0001kR\t\u0011\u000fC\u0003xe\u0012\u0005\u00010A\u0003baBd\u0017\u0010\u0006\u0003<sjd\b\"B\bw\u0001\u0004\u0001\u0002\"B>w\u0001\u0004A\u0012A\u00029bi\"\u001c\b\u0007C\u00032m\u0002\u0007!\u0007")
public final class SourceWatcher {
    private final Project project;
    private final Seq<Path> dirs;
    private final Seq<Path> files;
    private final Logger logger;
    private final Slf4jAdapter<Logger> bloop$io$SourceWatcher$$slf4jLogger;
    private final DebugFilter logContext;

    public static SourceWatcher apply(Project project, Seq<Path> seq, Logger logger) {
        return SourceWatcher$.MODULE$.apply(project, seq, logger);
    }

    public Slf4jAdapter<Logger> bloop$io$SourceWatcher$$slf4jLogger() {
        return this.bloop$io$SourceWatcher$$slf4jLogger;
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    public Task<State> watch(State state0, Function1<State, Task<State>> action) {
        PrintStream ngout = state0.commonOptions().ngout();
        Tuple2 tuple2 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.publish(), ExecutionContext$.MODULE$.ioScheduler());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Observer.Sync observer = (Observer.Sync)tuple2._1();
        Observable observable = (Observable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)observer, (Object)observable);
        Tuple2 tuple23 = tuple22;
        Observer.Sync observer2 = (Observer.Sync)tuple23._1();
        Observable observable2 = (Observable)tuple23._2();
        BooleanRef watchingEnabled = BooleanRef.create((boolean)true);
        DirectoryChangeListener listener = new DirectoryChangeListener(this, observer2, watchingEnabled){
            private final /* synthetic */ SourceWatcher $outer;
            private final Observer.Sync observer$1;
            private final BooleanRef watchingEnabled$1;

            public boolean isWatching() {
                return this.watchingEnabled$1.elem;
            }

            public void onException(Exception e) {
                this.$outer.bloop$io$SourceWatcher$$slf4jLogger().error(new StringBuilder(34).append("File watching threw an exception: ").append(e.getMessage()).toString());
            }

            public void onEvent(DirectoryChangeEvent event) {
                block0: {
                    Path targetFile = event.path();
                    String targetPath = targetFile.toFile().getAbsolutePath();
                    if (!Files.isRegularFile(targetFile, new LinkOption[0]) || !targetPath.endsWith(".scala") && !targetPath.endsWith(".java")) break block0;
                    this.observer$1.onNext((Object)event);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.observer$1 = observer$1;
                this.watchingEnabled$1 = watchingEnabled$1;
            }
        };
        DirectoryWatcher watcher = DirectoryWatcher.builder().paths((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.dirs).asJava()).files((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.files).asJava()).logger(this.bloop$io$SourceWatcher$$slf4jLogger()).listener(listener).fileHashing(true).build();
        CompletableFuture watcherHandle = watcher.watchAsync((Executor)ExecutionContext$.MODULE$.ioExecutor());
        Task watchController = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                watcherHandle.get();
            }
            finally {
                watcher.close();
            }
            $this.logger.debug("File watcher was successfully closed", this.logContext());
        });
        Cancelable watchCancellation = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            watchingEnabled$1.elem = false;
            watcherHandle.complete(null);
            observer2.onComplete();
            ngout.println(new StringBuilder(74).append("File watching on '").append($this.project.name()).append("' and dependent projects has been successfully cancelled").toString());
        });
        Consumer fileEventConsumer = FoldLeftAsyncConsumer$.MODULE$.consume((Function0 & Serializable & scala.Serializable)() -> state0, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Task task;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            State state = (State)tuple2._1();
            DirectoryChangeEvent event = (DirectoryChangeEvent)tuple2._2();
            DirectoryChangeEvent.EventType eventType = event.eventType();
            if (DirectoryChangeEvent.EventType.CREATE.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else if (DirectoryChangeEvent.EventType.MODIFY.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else if (DirectoryChangeEvent.EventType.OVERFLOW.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else {
                if (!DirectoryChangeEvent.EventType.DELETE.equals(eventType)) throw new MatchError((Object)eventType);
                task = Task$.MODULE$.now((Object)state);
            }
            return task;
        });
        return observable2.consumeWith(fileEventConsumer).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> watchCancellation.cancel()));
    }

    public void notifyWatch() {
        int filesCount = this.files.size();
        int dirsCount = this.dirs.size();
        String andFiles = filesCount == 0 ? "" : new StringBuilder(11).append(" and ").append(filesCount).append(" files").toString();
        this.logger.info(new StringBuilder(52).append("Watching ").append(dirsCount).append(" directories").append(andFiles).append("... (press Ctrl-C to interrupt)").toString());
    }

    private final Task runAction$1(State state, DirectoryChangeEvent event, Function1 action$1) {
        if (!BspServer$.MODULE$.isWindows()) {
            this.logger.info("\u001b[H\u001b[2J");
        }
        this.logger.debug(new StringBuilder(29).append("A ").append(event.eventType()).append(" in ").append(event.path()).append(" has triggered an event").toString(), this.logContext());
        return (Task)action$1.apply((Object)state);
    }

    public SourceWatcher(Project project, Seq<Path> dirs, Seq<Path> files, Logger logger) {
        this.project = project;
        this.dirs = dirs;
        this.files = files;
        this.logger = logger;
        this.bloop$io$SourceWatcher$$slf4jLogger = new Slf4jAdapter(logger);
        this.logContext = DebugFilter.FileWatching$.MODULE$;
    }
}

