/*
 * Decompiled with CFR 0.152.
 */
package bloop.cli.validation;

import bloop.bsp.BspServer$;
import bloop.cli.BspProtocol;
import bloop.cli.BspProtocol$Local$;
import bloop.cli.BspProtocol$Tcp$;
import bloop.cli.CliOptions;
import bloop.cli.Commands;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus$;
import bloop.engine.Action;
import bloop.engine.Dag;
import bloop.engine.Exit;
import bloop.engine.Feedback$;
import bloop.engine.Print;
import bloop.engine.Run$;
import bloop.engine.State;
import bloop.io.AbsolutePath$;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;
import scala.util.matching.Regex;

public final class Validate$ {
    public static Validate$ MODULE$;
    private final Charset DefaultCharset;
    private final Regex PipeName;

    static {
        new Validate$();
    }

    private Action cliError(String msg, CommonOptions commonOptions) {
        return new Print(msg, commonOptions, new Exit(ExitStatus$.MODULE$.InvalidCommandLineOption()));
    }

    private final Charset DefaultCharset() {
        return this.DefaultCharset;
    }

    public int bytesOf(String s) {
        return s.getBytes(this.DefaultCharset()).length;
    }

    private final Regex PipeName() {
        return this.PipeName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Action bsp(Commands.Bsp cmd, boolean isWindows) {
        CliOptions cliOptions = cmd.cliOptions();
        CommonOptions commonOptions = cliOptions.common();
        boolean bl = false;
        BspProtocol bspProtocol = null;
        BspProtocol bspProtocol2 = cmd.protocol();
        if (BspProtocol$Local$.MODULE$.equals(bspProtocol2)) {
            bl = true;
            bspProtocol = bspProtocol2;
            if (isWindows) {
                return this.validatePipeName$1(cmd, cliOptions, commonOptions);
            }
        }
        if (bl) {
            return this.validateSocket$1(cmd, cliOptions, commonOptions);
        }
        if (!BspProtocol$Tcp$.MODULE$.equals(bspProtocol2)) throw new MatchError((Object)bspProtocol2);
        return this.validateTcp$1(cmd, cliOptions, commonOptions);
    }

    public Task<State> validateBuildForCLICommands(State state, Function1<String, BoxedUnit> report) {
        Task task;
        Path configDirectory = state.build().origin();
        if (AbsolutePath$.MODULE$.isDirectory$extension(state.build().origin())) {
            Task task2;
            List<Dag.RecursiveTrace> list = state.build().traces();
            if (Nil$.MODULE$.equals(list)) {
                task2 = Task$.MODULE$.now((Object)state);
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                Dag.RecursiveTrace x = (Dag.RecursiveTrace)colon2.head();
                List xs = colon2.tl$access$1();
                xs.foldLeft(report.apply((Object)Feedback$.MODULE$.reportRecursiveTrace(x)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Validate$.$anonfun$validateBuildForCLICommands$1(report, x0$1, x1$1);
                    return BoxedUnit.UNIT;
                });
                task2 = Task$.MODULE$.now((Object)state.mergeStatus(ExitStatus$.MODULE$.BuildDefinitionError()));
            } else {
                throw new MatchError(list);
            }
            task = task2;
        } else {
            report.apply((Object)Feedback$.MODULE$.missingConfigDirectory(configDirectory));
            task = Task$.MODULE$.now((Object)state.mergeStatus(ExitStatus$.MODULE$.BuildDefinitionError()));
        }
        return task;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Action validateSocket$1(Commands.Bsp cmd$1, CliOptions cliOptions$1, CommonOptions commonOptions$1) {
        Path socket;
        Path socket2;
        boolean bl = false;
        Some some = null;
        Option option = cmd$1.socket().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toAbsolutePath());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Path socket3 = (Path)some.value();
            if (Files.exists(socket3, new LinkOption[0])) {
                return this.cliError(Feedback$.MODULE$.existingSocketFile(socket3), commonOptions$1);
            }
        }
        if (bl && !Files.exists((socket2 = (Path)some.value()).getParent(), new LinkOption[0])) {
            return this.cliError(Feedback$.MODULE$.missingParentOfSocket(socket2), commonOptions$1);
        }
        if (bl) {
            Path socket4 = (Path)some.value();
            if (BspServer$.MODULE$.isMac() && this.bytesOf(((Object)socket4).toString()) > 104) {
                return this.cliError(Feedback$.MODULE$.excessiveSocketLengthInMac(socket4), commonOptions$1);
            }
        }
        if (bl && this.bytesOf(((Object)(socket = (Path)some.value())).toString()) > 108) {
            return this.cliError(Feedback$.MODULE$.excessiveSocketLength(socket), commonOptions$1);
        }
        if (bl) {
            Path socket5 = (Path)some.value();
            return Run$.MODULE$.apply(new Commands.UnixLocalBsp(AbsolutePath$.MODULE$.apply(socket5, AbsolutePath$.MODULE$.workingDirectory()), cliOptions$1));
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        return this.cliError(Feedback$.MODULE$.MissingSocket(), commonOptions$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Action validatePipeName$1(Commands.Bsp cmd$1, CliOptions cliOptions$1, CommonOptions commonOptions$1) {
        boolean bl = false;
        Some some = null;
        Option<String> option = cmd$1.pipeName();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string = (String)some.value();
            Option option2 = this.PipeName().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String pipeName = (String)((LinearSeqOptimized)option2.get()).apply(0);
                return Run$.MODULE$.apply(new Commands.WindowsLocalBsp(pipeName, cliOptions$1));
            }
        }
        if (bl) {
            String wrong = (String)some.value();
            return this.cliError(Feedback$.MODULE$.unexpectedPipeFormat(wrong), commonOptions$1);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return this.cliError(Feedback$.MODULE$.MissingPipeName(), commonOptions$1);
    }

    private final Action continueValidation$1(InetAddress address, Commands.Bsp cmd$1, CliOptions cliOptions$1, CommonOptions commonOptions$1) {
        int n = cmd$1.port();
        switch (n) {
            default: 
        }
        return n > 0 && n <= 1023 ? this.cliError(Feedback$.MODULE$.reservedPortNumber(n), commonOptions$1) : (n > 1023 && n <= 65535 ? Run$.MODULE$.apply(new Commands.TcpBsp(address, n, cliOptions$1)) : this.cliError(Feedback$.MODULE$.outOfRangePort(n), commonOptions$1));
    }

    private final Action validateTcp$1(Commands.Bsp cmd$1, CliOptions cliOptions$1, CommonOptions commonOptions$1) {
        Action action;
        Either either = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{UnknownHostException.class})).either((Function0 & Serializable & scala.Serializable)() -> this.continueValidation$1(InetAddress.getByName(cmd$1.host()), cmd$1, cliOptions$1, commonOptions$1));
        if (either instanceof Right) {
            Action action2;
            Right right = (Right)either;
            action = action2 = (Action)right.value();
        } else if (either instanceof Left) {
            action = this.cliError(Feedback$.MODULE$.unknownHostName(cmd$1.host()), commonOptions$1);
        } else {
            throw new MatchError((Object)either);
        }
        return action;
    }

    public static final /* synthetic */ void $anonfun$validateBuildForCLICommands$1(Function1 report$1, BoxedUnit x0$1, Dag.RecursiveTrace x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dag.RecursiveTrace trace = (Dag.RecursiveTrace)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)report$1.apply((Object)Feedback$.MODULE$.reportRecursiveTrace(trace));
    }

    private Validate$() {
        MODULE$ = this;
        this.DefaultCharset = Charset.defaultCharset();
        this.PipeName = new StringOps(Predef$.MODULE$.augmentString("^\\Q\\\\.\\pipe\\\\E(.*)")).r();
    }
}

