/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.CompileMode;
import bloop.bsp.BspServer$;
import bloop.cli.BspProtocol;
import bloop.cli.BspProtocol$;
import bloop.cli.CliParsers$;
import bloop.cli.Commands;
import bloop.cli.Commands$;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.cli.ReporterKind;
import bloop.cli.ReporterKind$;
import bloop.cli.completion.Case$;
import bloop.cli.completion.Mode;
import bloop.cli.completion.Mode$Commands$;
import bloop.cli.completion.Mode$Flags$;
import bloop.cli.completion.Mode$MainsFQCN$;
import bloop.cli.completion.Mode$ProjectBoundCommands$;
import bloop.cli.completion.Mode$Projects$;
import bloop.cli.completion.Mode$Protocols$;
import bloop.cli.completion.Mode$Reporters$;
import bloop.cli.completion.Mode$TestsFQCN$;
import bloop.cli.validation.Validate$;
import bloop.config.Config;
import bloop.data.Platform;
import bloop.data.Project;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Feedback$;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.State$XState$;
import bloop.engine.tasks.CompilationTask$;
import bloop.engine.tasks.LinkTask$;
import bloop.engine.tasks.Tasks$;
import bloop.engine.tasks.toolchains.ScalaJsToolchain$;
import bloop.engine.tasks.toolchains.ScalaNativeToolchain$;
import bloop.exec.JavaEnv;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.RelativePath$;
import bloop.io.SourceWatcher;
import bloop.io.SourceWatcher$;
import bloop.logging.DebugFilter;
import bloop.reporter.Reporter;
import bloop.reporter.ReporterConfig;
import bloop.testing.LoggingEventHandler;
import bloop.testing.TestInternals$;
import caseapp.core.Arg;
import caseapp.core.CommandMessages;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;
    private final String line;

    static {
        new Interpreter$();
    }

    public Task<State> execute(Action action, Task<State> stateTask) {
        return Interpreter$.execute$1(action, stateTask, false);
    }

    private final String t() {
        return "    ";
    }

    private final String line() {
        return this.line;
    }

    private Task<State> printAbout(State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String bloopName = BuildInfo$.MODULE$.bloopName();
            String bloopVersion = BuildInfo$.MODULE$.version();
            String scalaVersion = BuildInfo$.MODULE$.scalaVersion();
            String zincVersion = BuildInfo$.MODULE$.zincVersion();
            String developers = BuildInfo$.MODULE$.developers().mkString(", ");
            state.logger().info(new StringBuilder(2).append(bloopName).append(" v").append(bloopVersion).toString());
            state.logger().info("");
            state.logger().info(new StringBuilder(29).append("Running on Scala v").append(scalaVersion).append(" and Zinc v").append(zincVersion).toString());
            state.logger().info(new StringBuilder(33).append("Maintained by the Scala Center (").append(developers).append(")").toString());
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private Task<State> runBsp(Commands.ValidatedBsp cmd, State state) {
        Scheduler scheduler = ExecutionContext$.MODULE$.bspScheduler();
        return BspServer$.MODULE$.run(cmd, state, RelativePath$.MODULE$.apply(".bloop"), scheduler);
    }

    public Task<State> watch(Project project, State state, Function1<State, Task<State>> f) {
        Function1 & Serializable & scala.Serializable fg;
        SourceWatcher watcher;
        block0: {
            List<Project> reachable = Dag$.MODULE$.dfs(state.build().getDagFor(project));
            Iterator allSources = reachable.iterator().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.sources().toList()).map((Function1 & Serializable & scala.Serializable)x$3 -> ((AbsolutePath)x$3).underlying());
            watcher = SourceWatcher$.MODULE$.apply(project, (Seq<Path>)allSources.toList(), state.logger());
            fg = (Function1 & Serializable & scala.Serializable)state2 -> ((Task)f.apply(state2)).map((Function1 & Serializable & scala.Serializable)state -> {
                watcher.notifyWatch();
                return State$.MODULE$.stateCache().updateBuild((State)state);
            });
            if (BspServer$.MODULE$.isWindows()) break block0;
            state.logger().info("\u001b[H\u001b[2J");
        }
        return ((Task)fg.apply((Object)state)).flatMap((Function1 & Serializable & scala.Serializable)newState -> watcher.watch((State)newState, (Function1<State, Task<State>>)fg));
    }

    private Task<State> runCompile(Commands.CompilingCommand cmd, State state0, Project project, boolean deduplicateFailures, boolean excludeRoot) {
        Task<State> state = cmd.incremental() ? Task$.MODULE$.now((Object)state0) : Tasks$.MODULE$.clean(state0, state0.build().projects(), true);
        CompileMode.Sequential$ compilerMode = CompileMode.Sequential$.MODULE$;
        Task compileTask = state.flatMap(arg_0 -> Interpreter$.$anonfun$runCompile$1(cmd, project, deduplicateFailures, excludeRoot, (CompileMode.ConfigurableMode)compilerMode, arg_0));
        return compileTask.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.mergeStatus(ExitStatus$.MODULE$.Ok()));
    }

    private Task<State> compile(Commands.Compile cmd, State state, boolean deduplicateFailures) {
        Task<State> task;
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = !cmd.watch() ? this.runCompile(cmd, state, project, deduplicateFailures, this.runCompile$default$5()) : this.watch(project, state, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.runCompile(cmd, (State)x$5, project, deduplicateFailures, MODULE$.runCompile$default$5()));
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> showProjects(Commands.Projects cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (cmd.dotGraph()) {
                String contents = Dag$.MODULE$.toDotGraph(state.build().dags());
                state.logger().info(contents);
            } else {
                String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
                state.logger().debug(new StringBuilder(24).append("Projects loaded from '").append(configDirectory).append("':").toString(), (DebugFilter)DebugFilter.All$.MODULE$);
                ((List)((SeqLike)state.build().projects().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    Interpreter$.$anonfun$showProjects$3(state, x$1);
                    return BoxedUnit.UNIT;
                });
            }
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private <C extends Commands.CompilingCommand> Task<State> compileAnd(C cmd, State state, Project project, boolean excludeRoot, boolean deduplicateFailures, String nextAction, Function1<State, Task<State>> next) {
        return this.runCompile(cmd, state, project, deduplicateFailures, excludeRoot).flatMap((Function1 & Serializable & scala.Serializable)compiled -> {
            ExitStatus exitStatus = compiled.status();
            ExitStatus exitStatus2 = ExitStatus$.MODULE$.CompilationError();
            return (exitStatus == null ? exitStatus2 != null : !((Object)exitStatus).equals(exitStatus2)) ? (Task)next.apply(compiled) : Task$.MODULE$.now((Object)State$XState$.MODULE$.withDebug$extension(State$.MODULE$.XState(state), new StringBuilder(37).append("Failed compilation for ").append(project).append(". Skipping ").append(nextAction).append("...").toString(), (DebugFilter)DebugFilter.Compilation$.MODULE$));
        });
    }

    private Task<State> console(Commands.Console cmd, State state2, boolean sequential) {
        Task<State> task;
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = this.compileAnd(cmd, state2, project, cmd.excludeRoot(), sequential, "`console`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Tasks$.MODULE$.console((State)state, project, cmd.excludeRoot()));
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> test(Commands.Test cmd, State state2, boolean sequential) {
        Task<State> task;
        Option<Project> option = Tasks$.MODULE$.pickTestProject(cmd.project(), state2);
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.doTest$1((State)state, cmd, sequential, project)) : this.doTest$1(state2, cmd, sequential, project);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Tuple2<List<Project>, List<String>> lookupProjects(List<String> names, State state) {
        Build build = state.build();
        Tuple2 result = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), (Object)Nil$.MODULE$);
        return (Tuple2)names.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String name = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            List projects = (List)tuple23._1();
            List missing = (List)tuple23._2();
            Option<Project> option = build.getProjectFor(name);
            if (option instanceof Some) {
                Project project;
                Some some = (Some)option;
                Project project2 = project = (Project)some.value();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects.$colon$colon((Object)project2)), (Object)missing);
                return tuple2;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                String string = name;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects), (Object)missing.$colon$colon((Object)string));
            }
            return tuple2;
        });
    }

    private Task<State> autocomplete(Commands.Autocomplete cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Mode mode = cmd.mode();
            if (Mode$ProjectBoundCommands$.MODULE$.equals(mode)) {
                state.logger().info(Commands$.MODULE$.projectBound());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Commands$.MODULE$.equals(mode)) {
                CliParsers$.MODULE$.CommandsMessages().messages().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Interpreter$.$anonfun$autocomplete$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                    Interpreter$.$anonfun$autocomplete$3(cmd, state, x$12);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Projects$.MODULE$.equals(mode)) {
                state.build().projects().foreach((Function1 & Serializable & scala.Serializable)project -> {
                    Interpreter$.$anonfun$autocomplete$5(cmd, state, project);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Flags$.MODULE$.equals(mode)) {
                cmd.command().foreach((Function1 & Serializable & scala.Serializable)command -> {
                    Interpreter$.$anonfun$autocomplete$7(cmd, state, command);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Reporters$.MODULE$.equals(mode)) {
                ReporterKind$.MODULE$.reporters().foreach((Function1 & Serializable & scala.Serializable)reporter -> {
                    Interpreter$.$anonfun$autocomplete$11(cmd, state, reporter);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Protocols$.MODULE$.equals(mode)) {
                BspProtocol$.MODULE$.protocols().foreach((Function1 & Serializable & scala.Serializable)protocol -> {
                    Interpreter$.$anonfun$autocomplete$13(cmd, state, protocol);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$MainsFQCN$.MODULE$.equals(mode)) {
                cmd.project().foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$autocomplete$15(cmd, state, projectName);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$TestsFQCN$.MODULE$.equals(mode)) {
                cmd.project().foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$autocomplete$19(cmd, state, projectName);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)mode);
            }
            return state;
        });
    }

    private Task<State> configure(Commands.Configure cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> cmd.threads() == 0 ? state : State$XState$.MODULE$.withWarn$extension(State$.MODULE$.XState(state), "Dynamic thread configuration has been deprecated and is a no-op."));
    }

    private Task<State> clean(Commands.Clean cmd, State state) {
        Task task;
        if (cmd.project().isEmpty()) {
            task = Tasks$.MODULE$.clean(state, state.build().projects(), cmd.includeDependencies()).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.mergeStatus(ExitStatus$.MODULE$.Ok()));
        } else {
            Tuple2<List<Project>, List<String>> tuple2 = this.lookupProjects(cmd.project(), state);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List projects = (List)tuple2._1();
            List missing = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)projects, (Object)missing);
            Tuple2 tuple23 = tuple22;
            List projects2 = (List)tuple23._1();
            List missing2 = (List)tuple23._2();
            task = missing2.isEmpty() ? Tasks$.MODULE$.clean(state, (List<Project>)projects2, cmd.includeDependencies()).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.mergeStatus(ExitStatus$.MODULE$.Ok())) : Task$.MODULE$.now((Object)this.reportMissing((List<String>)missing2, state));
        }
        return task;
    }

    public Task<State> link(Commands.Link cmd, State state2, boolean sequential) {
        Task<State> task;
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            Function1 & Serializable & scala.Serializable linkTask = (Function1 & Serializable & scala.Serializable)state -> this.doLink$1(project, (State)state, cmd, sequential);
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)linkTask) : (Task<State>)linkTask.apply((Object)state2);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> run(Commands.Run cmd, State state2, boolean sequential) {
        Task<State> task;
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            Function1 & Serializable & scala.Serializable runTask = (Function1 & Serializable & scala.Serializable)state -> this.doRun$1(project, (State)state, cmd, sequential);
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)runTask) : (Task<State>)runTask.apply((Object)state2);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private boolean runCompile$default$5() {
        return false;
    }

    private State reportMissing(List<String> projectNames, State state) {
        String projects = projectNames.mkString("'", "', '", "'");
        String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
        return State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state), new StringBuilder(35).append("No projects named ").append(projects).append(" were found in '").append(configDirectory).append("'").toString())), "Use the `projects` command to list all existing projects").mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption());
    }

    public Either<State, String> getMainClass(State state, Project project, Option<String> cliMainClass) {
        Right right;
        Option<String> option = cliMainClass;
        if (option instanceof Some) {
            Some some = (Some)option;
            String userMainClass = (String)some.value();
            right = package$.MODULE$.Right().apply((Object)userMainClass);
        } else if (None$.MODULE$.equals(option)) {
            Right right2;
            Option<String> option2 = project.platform().userMainClass();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String configMainClass = (String)some.value();
                right2 = package$.MODULE$.Right().apply((Object)configMainClass);
            } else if (None$.MODULE$.equals(option2)) {
                Left left;
                List<String> list = Tasks$.MODULE$.findMainClasses(state, project);
                if (Nil$.MODULE$.equals(list)) {
                    String msg = Feedback$.MODULE$.missingMainClass(project);
                    left = package$.MODULE$.Left().apply((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                } else {
                    Some some = List$.MODULE$.unapplySeq(list);
                    if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
                        String mainClass = (String)((LinearSeqOptimized)some.get()).apply(0);
                        left = package$.MODULE$.Right().apply((Object)mainClass);
                    } else {
                        String msg = Feedback$.MODULE$.XMessageString(Feedback$.MODULE$.expectedDefaultMainClass(project)).suggest(Feedback$.MODULE$.listMainClasses(list));
                        left = package$.MODULE$.Left().apply((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                    }
                }
                right2 = left;
            } else {
                throw new MatchError(option2);
            }
            right = right2;
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    public static final /* synthetic */ void $anonfun$execute$2(State state$6, String x$1) {
        state$6.logger().error(x$1);
    }

    private static final Task execute$1(Action action, Task stateTask, boolean inRecursion) {
        return stateTask.flatMap((Function1 & Serializable & scala.Serializable)state2 -> {
            Commands.Command cmd;
            ExitStatus exitStatus;
            boolean bl = false;
            Exit exit = null;
            boolean bl2 = false;
            Run run2 = null;
            Action action = action;
            if (action instanceof Exit) {
                ExitStatus exitStatus2;
                bl = true;
                exit = (Exit)action;
                ExitStatus exitStatus3 = exit.exitStatus();
                if (exitStatus3 != null && (exitStatus2 = exitStatus3).isOk()) {
                    return Task$.MODULE$.now((Object)state2.mergeStatus(exitStatus2));
                }
            }
            if (bl && (exitStatus = exit.exitStatus()) != null) {
                ExitStatus exitStatus4 = exitStatus;
                return Task$.MODULE$.now((Object)state2.mergeStatus(exitStatus4));
            }
            if (action instanceof Print) {
                Print print = (Print)action;
                String msg = print.msg();
                Action next = print.next();
                state2.logger().info(msg);
                return Interpreter$.execute$1(next, Task$.MODULE$.now(state2), true);
            }
            if (action instanceof Run) {
                bl2 = true;
                run2 = (Run)action;
                Commands.Command cmd2 = run2.command();
                if (cmd2 instanceof Commands.Bsp) {
                    Commands.Bsp bsp = (Commands.Bsp)cmd2;
                    String msg = "Internal error: The `bsp` command must be validated before use";
                    Print printAction = new Print(msg, bsp.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
                    return Interpreter$.execute$1(printAction, Task$.MODULE$.now(state2), true);
                }
            }
            if (bl2) {
                Commands.Command cmd3 = run2.command();
                Action next = run2.next();
                if (cmd3 instanceof Commands.ValidatedBsp) {
                    Commands.ValidatedBsp validatedBsp = (Commands.ValidatedBsp)cmd3;
                    return Interpreter$.execute$1(next, MODULE$.runBsp(validatedBsp, (State)state2), true);
                }
            }
            if (bl2) {
                Commands.Command command = run2.command();
                Action next = run2.next();
                if (command instanceof Commands.About) {
                    return Interpreter$.execute$1(next, MODULE$.printAbout((State)state2), true);
                }
            }
            if (bl2 && (cmd = run2.command()) instanceof Commands.Help) {
                Commands.Help help = (Commands.Help)cmd;
                String msg = "The handling of `help` does not happen in the `Interpreter`";
                Print printAction = new Print(msg, help.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
                return Interpreter$.execute$1(printAction, Task$.MODULE$.now(state2), true);
            }
            if (!bl2) throw new MatchError((Object)action);
            Commands.Command cmd4 = run2.command();
            Action next = run2.next();
            if (cmd4 == null) throw new MatchError((Object)action);
            Commands.Command command = cmd4;
            return Validate$.MODULE$.validateBuildForCLICommands((State)state2, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                Interpreter$.$anonfun$execute$2(state2, x$1);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                Task task;
                ExitStatus exitStatus = state.status();
                ExitStatus exitStatus2 = ExitStatus$.MODULE$.BuildDefinitionError();
                if (!(exitStatus != null ? !((Object)exitStatus).equals(exitStatus2) : exitStatus2 != null)) {
                    task = Task$.MODULE$.now(state);
                } else {
                    Task task2;
                    Commands.Command command = command;
                    if (command instanceof Commands.Clean) {
                        Commands.Clean clean = (Commands.Clean)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.clean(clean, (State)state), true);
                    } else if (command instanceof Commands.Compile) {
                        Commands.Compile compile = (Commands.Compile)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.compile(compile, (State)state, inRecursion), true);
                    } else if (command instanceof Commands.Console) {
                        Commands.Console console = (Commands.Console)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.console(console, (State)state, inRecursion), true);
                    } else if (command instanceof Commands.Projects) {
                        Commands.Projects projects = (Commands.Projects)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.showProjects(projects, (State)state), true);
                    } else if (command instanceof Commands.Test) {
                        Commands.Test test = (Commands.Test)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.test(test, (State)state, inRecursion), true);
                    } else if (command instanceof Commands.Run) {
                        Commands.Run run2 = (Commands.Run)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.run(run2, (State)state, inRecursion), true);
                    } else if (command instanceof Commands.Configure) {
                        Commands.Configure configure = (Commands.Configure)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.configure(configure, (State)state), true);
                    } else if (command instanceof Commands.Autocomplete) {
                        Commands.Autocomplete autocomplete = (Commands.Autocomplete)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.autocomplete(autocomplete, (State)state), true);
                    } else if (command instanceof Commands.Link) {
                        Commands.Link link = (Commands.Link)command;
                        task2 = Interpreter$.execute$1(next, MODULE$.link(link, (State)state, inRecursion), true);
                    } else {
                        throw new MatchError((Object)command);
                    }
                    task = task2;
                }
                return task;
            });
        });
    }

    public static final /* synthetic */ Task $anonfun$runCompile$1(Commands.CompilingCommand cmd$9, Project project$1, boolean deduplicateFailures$2, boolean excludeRoot$1, CompileMode.ConfigurableMode compilerMode$1, State state) {
        ReporterConfig config = ReporterKind$.MODULE$.toReporterConfig(cmd$9.reporter());
        Function2 & Serializable & scala.Serializable createReporter = (Function2 & Serializable & scala.Serializable)(project, cwd) -> CompilationTask$.MODULE$.toReporter(project, ((AbsolutePath)cwd).underlying(), config, state.logger());
        return CompilationTask$.MODULE$.compile(state, project$1, (Function2<Project, Path, Reporter>)createReporter, deduplicateFailures$2, compilerMode$1, cmd$9.pipeline(), excludeRoot$1);
    }

    public static final /* synthetic */ void $anonfun$showProjects$3(State state$2, String x$1) {
        state$2.logger().info(x$1);
    }

    private final Task doTest$1(State state2, Commands.Test cmd$4, boolean sequential$1, Project project$5) {
        Function1<String, Object> testFilter = TestInternals$.MODULE$.parseFilters(cmd$4.only());
        Path cwd = project$5.baseDirectory();
        return this.compileAnd(cmd$4, state2, project$5, false, sequential$1, "`test`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            LoggingEventHandler handler = new LoggingEventHandler(state.logger());
            return Tasks$.MODULE$.test((State)state, project$5, cwd, cmd$4.includeDependencies(), cmd$4.args(), testFilter, handler);
        });
    }

    public static final /* synthetic */ boolean $anonfun$autocomplete$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$4(State state$4, String completion) {
        state$4.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$3(Commands.Autocomplete cmd$7, State state$4, Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        CommandMessages args = (CommandMessages)tuple2._2();
        cmd$7.format().showCommand(name, args).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$4(state$4, completion);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$6(State state$4, String completion) {
        state$4.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$5(Commands.Autocomplete cmd$7, State state$4, Project project) {
        cmd$7.format().showProject(project).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$6(state$4, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$10(State state$4, String completion) {
        state$4.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$9(Commands.Autocomplete cmd$7, State state$4, String command$1, Arg arg) {
        cmd$7.format().showArg(command$1, Case$.MODULE$.kebabizeArg(arg)).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$10(state$4, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$8(Commands.Autocomplete cmd$7, State state$4, String command$1, CommandMessages message) {
        message.args().foreach((Function1 & Serializable & scala.Serializable)arg -> {
            Interpreter$.$anonfun$autocomplete$9(cmd$7, state$4, command$1, arg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$7(Commands.Autocomplete cmd$7, State state$4, String command) {
        CliParsers$.MODULE$.CommandsMessages().messages().toMap(Predef$.MODULE$.$conforms()).get((Object)command).foreach((Function1 & Serializable & scala.Serializable)message -> {
            Interpreter$.$anonfun$autocomplete$8(cmd$7, state$4, command, message);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$12(State state$4, String completion) {
        state$4.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$11(Commands.Autocomplete cmd$7, State state$4, ReporterKind reporter) {
        cmd$7.format().showReporter(reporter).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$12(state$4, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$14(State state$4, String completion) {
        state$4.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$13(Commands.Autocomplete cmd$7, State state$4, BspProtocol protocol) {
        cmd$7.format().showProtocol(protocol).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$14(state$4, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$18(State state$4, String completion) {
        state$4.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$17(Commands.Autocomplete cmd$7, State state$4, String main) {
        cmd$7.format().showMainName(main).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$18(state$4, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$16(Commands.Autocomplete cmd$7, State state$4, Project project) {
        Tasks$.MODULE$.findMainClasses(state$4, project).foreach((Function1 & Serializable & scala.Serializable)main -> {
            Interpreter$.$anonfun$autocomplete$17(cmd$7, state$4, main);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$15(Commands.Autocomplete cmd$7, State state$4, String projectName) {
        state$4.build().getProjectFor(projectName).foreach((Function1 & Serializable & scala.Serializable)project -> {
            Interpreter$.$anonfun$autocomplete$16(cmd$7, state$4, project);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$21(State state$4, String completion) {
        state$4.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$20(Commands.Autocomplete cmd$7, State state$4, String placeholder) {
        cmd$7.format().showTestName(placeholder).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$21(state$4, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$19(Commands.Autocomplete cmd$7, State state$4, String projectName) {
        List$.MODULE$.empty().foreach((Function1 & Serializable & scala.Serializable)placeholder -> {
            Interpreter$.$anonfun$autocomplete$20(cmd$7, state$4, placeholder);
            return BoxedUnit.UNIT;
        });
    }

    private final Task doLink$1(Project project, State state2, Commands.Link cmd$8, boolean sequential$3) {
        return this.compileAnd(cmd$8, state2, project, false, sequential$3, "`link`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            Task<State> task;
            Either<State, String> either = MODULE$.getMainClass((State)state, project, cmd$8.main());
            if (either instanceof Left) {
                Left left = (Left)either;
                State state2 = (State)left.value();
                task = Task$.MODULE$.now((Object)state2);
            } else if (either instanceof Right) {
                Task<State> task2;
                Right right = (Right)either;
                String mainClass = (String)right.value();
                Platform platform = project.platform();
                if (platform instanceof Platform.Native) {
                    Platform.Native native_ = (Platform.Native)platform;
                    Config.NativeConfig config = native_.config();
                    Path target = ScalaNativeToolchain$.MODULE$.linkTargetFrom(project, config);
                    task2 = LinkTask$.MODULE$.linkMainWithNative(cmd$8, project, (State)state, mainClass, target, native_);
                } else if (platform instanceof Platform.Js) {
                    Platform.Js js = (Platform.Js)platform;
                    Config.JsConfig config = js.config();
                    Path target = ScalaJsToolchain$.MODULE$.linkTargetFrom(project, config);
                    task2 = LinkTask$.MODULE$.linkMainWithJs(cmd$8, project, (State)state, mainClass, target, js);
                } else if (platform instanceof Platform.Jvm) {
                    String msg = Feedback$.MODULE$.noLinkFor(project);
                    task2 = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                } else {
                    throw new MatchError((Object)platform);
                }
                task = task2;
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    private final Task doRun$1(Project project, State state, Commands.Run cmd$5, boolean sequential$2) {
        Path cwd = project.baseDirectory();
        return this.compileAnd(cmd$5, state, project, false, sequential$2, "`run`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state2 -> {
            Task task;
            Either<State, String> either = MODULE$.getMainClass((State)state2, project, cmd$5.main());
            if (either instanceof Left) {
                Left left = (Left)either;
                State state3 = (State)left.value();
                task = Task$.MODULE$.now((Object)state3);
            } else if (either instanceof Right) {
                Task task2;
                Right right = (Right)either;
                String mainClass = (String)right.value();
                Platform platform = project.platform();
                if (platform instanceof Platform.Native) {
                    Platform.Native native_ = (Platform.Native)platform;
                    Config.NativeConfig config = native_.config();
                    Path target = ScalaNativeToolchain$.MODULE$.linkTargetFrom(project, config);
                    task2 = LinkTask$.MODULE$.linkMainWithNative(cmd$5, project, (State)state2, mainClass, target, native_).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                        String string = AbsolutePath$.MODULE$.syntax$extension(target);
                        String[] args = (String[])((TraversableOnce)cmd$5.args().$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        return !state.status().isOk() ? Task$.MODULE$.now(state) : Tasks$.MODULE$.runNativeOrJs((State)state, project, cwd, mainClass, args);
                    });
                } else if (platform instanceof Platform.Js) {
                    Platform.Js js = (Platform.Js)platform;
                    Config.JsConfig config = js.config();
                    Path target = ScalaJsToolchain$.MODULE$.linkTargetFrom(project, config);
                    task2 = LinkTask$.MODULE$.linkMainWithJs(cmd$5, project, (State)state2, mainClass, target, js).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                        String string = "node";
                        String string2 = AbsolutePath$.MODULE$.syntax$extension(target);
                        String[] args = (String[])((TraversableOnce)((List)cmd$5.args().$plus$colon((Object)string2, List$.MODULE$.canBuildFrom())).$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        return !state.status().isOk() ? Task$.MODULE$.now(state) : Tasks$.MODULE$.runNativeOrJs((State)state, project, cwd, mainClass, args);
                    });
                } else if (platform instanceof Platform.Jvm) {
                    Platform.Jvm jvm = (Platform.Jvm)platform;
                    JavaEnv javaEnv = jvm.env();
                    task2 = Tasks$.MODULE$.runJVM((State)state2, project, javaEnv, cwd, mainClass, (String[])cmd$5.args().toArray(ClassTag$.MODULE$.apply(String.class)));
                } else {
                    throw new MatchError((Object)platform);
                }
                task = task2;
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    private Interpreter$() {
        MODULE$ = this;
        this.line = System.lineSeparator();
    }
}

