/*
 * Decompiled with CFR 0.152.
 */
package bloop.logging;

import bloop.data.Project;
import bloop.engine.State;
import bloop.logging.BspServerLogger$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.ScribeAdapter;
import bloop.reporter.Problem;
import ch.epfl.scala.bsp.BuildTargetIdentifier;
import ch.epfl.scala.bsp.CompileReport;
import ch.epfl.scala.bsp.CompileReport$;
import ch.epfl.scala.bsp.CompileTask;
import ch.epfl.scala.bsp.CompileTask$;
import ch.epfl.scala.bsp.Diagnostic;
import ch.epfl.scala.bsp.DiagnosticSeverity;
import ch.epfl.scala.bsp.LogMessageParams;
import ch.epfl.scala.bsp.MessageType;
import ch.epfl.scala.bsp.Position;
import ch.epfl.scala.bsp.PublishDiagnosticsParams;
import ch.epfl.scala.bsp.Range;
import ch.epfl.scala.bsp.StatusCode;
import ch.epfl.scala.bsp.TaskDataKind$;
import ch.epfl.scala.bsp.TaskFinishParams;
import ch.epfl.scala.bsp.TaskId;
import ch.epfl.scala.bsp.TaskStartParams;
import ch.epfl.scala.bsp.TextDocumentIdentifier;
import ch.epfl.scala.bsp.Uri;
import ch.epfl.scala.bsp.Uri$;
import ch.epfl.scala.bsp.endpoints.Build$;
import io.circe.Json;
import java.io.File;
import java.io.Serializable;
import monix.execution.atomic.AtomicInt;
import sbt.internal.inc.bloop.ZincInternals;
import sbt.util.InterfaceUtil$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.meta.jsonrpc.JsonRpcClient;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scribe.LogRecord;
import scribe.LoggerSupport;
import xsbti.Severity;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001B\u0001\u0003\u0005\u001d\u0011qBQ:q'\u0016\u0014h/\u001a:M_\u001e<WM\u001d\u0006\u0003\u0007\u0011\tq\u0001\\8hO&twMC\u0001\u0006\u0003\u0015\u0011Gn\\8q\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\u0004M_\u001e<WM\u001d\t\u0003\u00135I!A\u0004\u0002\u0003\u001bM\u001b'/\u001b2f\u0003\u0012\f\u0007\u000f^3s\u0011!\u0001\u0002A!b\u0001\n\u0003\n\u0012\u0001\u00028b[\u0016,\u0012A\u0005\t\u0003'qq!\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011A\u0002\u001fs_>$hHC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002$\u0001\u0004Qe\u0016$WMZ\u0005\u0003;y\u0011aa\u0015;sS:<'BA\u000e\u0019\u0011!\u0001\u0003A!A!\u0002\u0013\u0011\u0012!\u00028b[\u0016\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0005\u0002\u0015UtG-\u001a:ms&tw\r\u0003\u0005%\u0001\t\u0015\r\u0011b\u0001&\u0003\u0019\u0019G.[3oiV\ta\u0005\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u00059!n]8oeB\u001c'BA\u0016\u0019\u0003\u0011iW\r^1\n\u00055B#!\u0004&t_:\u0014\u0006oY\"mS\u0016tG\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003'\u0003\u001d\u0019G.[3oi\u0002B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\u000ei\u0006\u001c8.\u00133D_VtG/\u001a:\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014AB1u_6L7M\u0003\u00028q\u0005IQ\r_3dkRLwN\u001c\u0006\u0002s\u0005)Qn\u001c8jq&\u00111\b\u000e\u0002\n\u0003R|W.[2J]RD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u000eC:\u001c\u0018nU;qa>\u0014H/\u001a3\u0011\u0005}\u0002U\"\u0001\r\n\u0005\u0005C\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0007\u0002!I\u0001R\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u00153u\tS%K!\tI\u0001\u0001C\u0003\u0011\u0005\u0002\u0007!\u0003C\u0003#\u0005\u0002\u0007\u0001\u0002C\u0003%\u0005\u0002\u000fa\u0005C\u00032\u0005\u0002\u0007!\u0007C\u0003>\u0005\u0002\u0007a\bC\u0003M\u0001\u0011\u0005S*A\u0006eK\n,xMR5mi\u0016\u0014X#\u0001(\u0011\u0005%y\u0015B\u0001)\u0003\u0005-!UMY;h\r&dG/\u001a:\t\u000bI\u0003A\u0011I*\u0002\u0013%\u001ch+\u001a:c_N,W#\u0001 \t\u000bU\u0003A\u0011\t,\u0002\u0015\u0005\u001cH)[:de\u0016$X-F\u0001\t\u0011\u0015A\u0006\u0001\"\u0011W\u0003%\t7OV3sE>\u001cX\rC\u0003[\u0001\u0011\u00053,\u0001\nb]NL7i\u001c3fgN+\b\u000f]8si\u0016$G#\u0001 \t\ru\u0003A\u0011\t\u0002_\u0003)\u0001(/\u001b8u\t\u0016\u0014Wo\u001a\u000b\u0003?\n\u0004\"a\u00101\n\u0005\u0005D\"\u0001B+oSRDQa\u0019/A\u0002I\t1!\\:h\u0011\u0015)\u0007\u0001\"\u0011g\u0003\u0015!WMY;h)\t9'\u000e\u0006\u0002`Q\")\u0011\u000e\u001aa\u0002\u001d\u0006\u00191\r\u001e=\t\u000b\r$\u0007\u0019\u0001\n\t\u000b1\u0004A\u0011I7\u0002\u000bQ\u0014\u0018mY3\u0015\u0005}s\u0007\"B8l\u0001\u0004\u0001\u0018!\u0001;\u0011\u0005E4hB\u0001:u\u001d\t)2/C\u0001\u001a\u0013\t)\b$A\u0004qC\u000e\\\u0017mZ3\n\u0005]D(!\u0003+ie><\u0018M\u00197f\u0015\t)\b\u0004C\u0003{\u0001\u0011\u000530A\u0003feJ|'\u000f\u0006\u0002`y\")1-\u001fa\u0001%!)a\u0010\u0001C!\u007f\u0006!q/\u0019:o)\ry\u0016\u0011\u0001\u0005\u0006Gv\u0004\rA\u0005\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0003\u0011IgNZ8\u0015\u0007}\u000bI\u0001\u0003\u0004d\u0003\u0007\u0001\rA\u0005\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003)!\u0017.Y4o_N$\u0018n\u0019\u000b\b?\u0006E\u0011\u0011EA\u0019\u0011!\t\u0019\"a\u0003A\u0002\u0005U\u0011a\u00029s_*,7\r\u001e\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\u0003\u0002\t\u0011\fG/Y\u0005\u0005\u0003?\tIBA\u0004Qe>TWm\u0019;\t\u0011\u0005\r\u00121\u0002a\u0001\u0003K\tq\u0001\u001d:pE2,W\u000e\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\t\tY#A\u0003yg\n$\u0018.\u0003\u0003\u00020\u0005%\"a\u0002)s_\ndW-\u001c\u0005\b\u0003g\tY\u00011\u0001?\u0003\u0015\u0019G.Z1s\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\tAB\\8ES\u0006<gn\\:uS\u000e$RaXA\u001e\u0003{A\u0001\"a\u0005\u00026\u0001\u0007\u0011Q\u0003\u0005\t\u0003\u007f\t)\u00041\u0001\u0002B\u0005!a-\u001b7f!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n!![8\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006LA!a\u0014\u0002F\t!a)\u001b7f\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\n!B\\3yiR\u000b7o[%e+\t\t9\u0006\u0005\u0003\u0002Z\u0005%TBAA.\u0015\u0011\ti&a\u0018\u0002\u0007\t\u001c\bOC\u0002\u001a\u0003CRA!a\u0019\u0002f\u0005!Q\r\u001d4m\u0015\t\t9'\u0001\u0002dQ&!\u00111NA.\u0005\u0019!\u0016m]6JI\"9\u0011q\u000e\u0001\u0005\n\u0005E\u0014a\u00018poV\u0011\u00111\u000f\t\u0004\u007f\u0005U\u0014bAA<1\t!Aj\u001c8h\u0011\u001d\tY\b\u0001C\u0001\u0003{\n1\u0003];cY&\u001c\bnQ8na&dWm\u0015;beR$RaXA@\u0003\u0003C\u0001\"a\u0005\u0002z\u0001\u0007\u0011Q\u0003\u0005\t\u0003\u0007\u000bI\b1\u0001\u0002X\u00051A/Y:l\u0013\u0012Dq!a\"\u0001\t\u0003\tI)A\tqk\nd\u0017n\u001d5D_6\u0004\u0018\u000e\\3F]\u0012$\u0012bXAF\u0003\u001b\u000by)a)\t\u0011\u0005M\u0011Q\u0011a\u0001\u0003+A\u0001\"a!\u0002\u0006\u0002\u0007\u0011q\u000b\u0005\t\u0003#\u000b)\t1\u0001\u0002\u0014\u0006A\u0001O]8cY\u0016l7\u000fE\u0003r\u0003+\u000bI*C\u0002\u0002\u0018b\u00141aU3r!\u0011\tY*!)\u000e\u0005\u0005u%bAAP\t\u0005A!/\u001a9peR,'/\u0003\u0003\u00020\u0005u\u0005\u0002CAS\u0003\u000b\u0003\r!a*\u0002\t\r|G-\u001a\t\u0005\u00033\nI+\u0003\u0003\u0002,\u0006m#AC*uCR,8oQ8eK\u001e9\u0011q\u0016\u0002\t\u0002\u0005E\u0016a\u0004\"taN+'O^3s\u0019><w-\u001a:\u0011\u0007%\t\u0019L\u0002\u0004\u0002\u0005!\u0005\u0011QW\n\u0005\u0003g\u000b9\fE\u0002@\u0003sK1!a/\u0019\u0005\u0019\te.\u001f*fM\"91)a-\u0005\u0002\u0005}FCAAY\u0011-\t\u0019-a-C\u0002\u0013\u0015A!!2\u0002\u000f\r|WO\u001c;feV\u0011\u0011q\u0019\t\u0005\u0003\u0013\f).\u0004\u0002\u0002L*\u0019Q'!4\u000b\t\u0005=\u0017\u0011[\u0001\u000bG>t7-\u001e:sK:$(\u0002BAj\u0003\u0013\nA!\u001e;jY&!\u0011q[Af\u00055\tEo\\7jG&sG/Z4fe\"I\u00111\\AZA\u00035\u0011qY\u0001\tG>,h\u000e^3sA!A\u0011q\\AZ\t\u0003\t\t/A\u0003baBd\u0017\u0010F\u0005F\u0003G\f\u00190!>\u0002x\"A\u0011Q]Ao\u0001\u0004\t9/A\u0003ti\u0006$X\r\u0005\u0003\u0002j\u0006=XBAAv\u0015\r\ti\u000fB\u0001\u0007K:<\u0017N\\3\n\t\u0005E\u00181\u001e\u0002\u0006'R\fG/\u001a\u0005\u0007I\u0005u\u0007\u0019\u0001\u0014\t\rE\ni\u000e1\u00013\u0011\u0019Q\u0016Q\u001ca\u0001}\u0001")
public final class BspServerLogger
extends Logger
implements ScribeAdapter {
    private final String name;
    private final Logger underlying;
    private final JsonRpcClient client;
    private final AtomicInt taskIdCounter;
    private final boolean ansiSupported;

    public static BspServerLogger apply(State state, JsonRpcClient jsonRpcClient, AtomicInt atomicInt, boolean bl) {
        return BspServerLogger$.MODULE$.apply(state, jsonRpcClient, atomicInt, bl);
    }

    @Override
    public <M> void log(LogRecord<M> record) {
        ScribeAdapter.log$(this, record);
    }

    public String name() {
        return this.name;
    }

    public JsonRpcClient client() {
        return this.client;
    }

    public DebugFilter debugFilter() {
        return this.underlying.debugFilter();
    }

    public boolean isVerbose() {
        return this.underlying.isVerbose();
    }

    public Logger asDiscrete() {
        return new BspServerLogger(this.name(), this.underlying.asDiscrete(), this.client(), this.taskIdCounter, this.ansiSupported);
    }

    public Logger asVerbose() {
        return new BspServerLogger(this.name(), this.underlying.asVerbose(), this.client(), this.taskIdCounter, this.ansiSupported);
    }

    public boolean ansiCodesSupported() {
        return this.ansiSupported || this.underlying.ansiCodesSupported();
    }

    public void printDebug(String msg) {
        this.underlying.printDebug(msg);
    }

    public void debug(String msg, DebugFilter ctx) {
        block0: {
            if (!this.debugFilter().isEnabledFor(ctx)) break block0;
            this.printDebug(msg);
        }
    }

    public void trace(Throwable t) {
        this.underlying.trace(t);
    }

    public void error(String msg) {
        Build$.MODULE$.logMessage().notify((Object)new LogMessageParams((MessageType)MessageType.Error$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, msg), this.client());
    }

    public void warn(String msg) {
        Build$.MODULE$.logMessage().notify((Object)new LogMessageParams((MessageType)MessageType.Warning$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, msg), this.client());
    }

    public void info(String msg) {
        Build$.MODULE$.logMessage().notify((Object)new LogMessageParams((MessageType)MessageType.Info$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, msg), this.client());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void diagnostic(Project project, xsbti.Problem problem, boolean clear) {
        Severity severity;
        BoxedUnit boxedUnit;
        Option sourceFile;
        String message = problem.message();
        xsbti.Position problemPos = problem.position();
        Tuple2 tuple2 = new Tuple2((Object)problemPos, (Object)(sourceFile = InterfaceUtil$.MODULE$.toOption(problemPos.sourceFile())));
        if (tuple2 != null) {
            xsbti.Position position = (xsbti.Position)tuple2._1();
            Option option = (Option)tuple2._2();
            Option option2 = ZincInternals.ZincExistsStartPos$.MODULE$.unapply(position);
            if (!option2.isEmpty()) {
                int startLine = ((Tuple2)option2.get())._1$mcI$sp();
                int startColumn = ((Tuple2)option2.get())._2$mcI$sp();
                if (option instanceof Some) {
                    DiagnosticSeverity.Error$ error$;
                    Range range;
                    Some some = (Some)option;
                    File file = (File)some.value();
                    xsbti.Position position2 = problem.position();
                    Option option3 = ZincInternals.ZincRangePos$.MODULE$.unapply(position2);
                    if (!option3.isEmpty()) {
                        int endLine = ((Tuple2)option3.get())._1$mcI$sp();
                        int endColumn = ((Tuple2)option3.get())._2$mcI$sp();
                        Position start = new Position(startLine - 1, startColumn);
                        Position end = new Position(endLine - 1, endColumn);
                        range = new Range(start, end);
                    } else {
                        Position pos = new Position(startLine - 1, startColumn);
                        range = new Range(pos, pos);
                    }
                    Range pos = range;
                    Severity severity2 = problem.severity();
                    if (Severity.Error.equals(severity2)) {
                        error$ = DiagnosticSeverity.Error$.MODULE$;
                    } else if (Severity.Warn.equals(severity2)) {
                        error$ = DiagnosticSeverity.Warning$.MODULE$;
                    } else {
                        if (!Severity.Info.equals(severity2)) throw new MatchError((Object)severity2);
                        error$ = DiagnosticSeverity.Information$.MODULE$;
                    }
                    DiagnosticSeverity.Error$ severity3 = error$;
                    Uri uri = Uri$.MODULE$.apply(file.toPath().toUri());
                    Diagnostic diagnostic = new Diagnostic(pos, (Option)new Some((Object)severity3), (Option)None$.MODULE$, (Option)None$.MODULE$, message, (Option)None$.MODULE$);
                    TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
                    BuildTargetIdentifier buildTargetId = new BuildTargetIdentifier(project.bspUri());
                    PublishDiagnosticsParams diagnostics = new PublishDiagnosticsParams(textDocument, buildTargetId, (Option)None$.MODULE$, (List)new .colon.colon((Object)diagnostic, (List)Nil$.MODULE$), clear);
                    boxedUnit = Build$.MODULE$.publishDiagnostics().notify((Object)diagnostics, this.client());
                    return;
                }
            }
        }
        if (Severity.Error.equals(severity = problem.severity())) {
            this.error(message);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (Severity.Warn.equals(severity)) {
            this.warn(message);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            if (!Severity.Info.equals(severity)) throw new MatchError((Object)severity);
            this.info(message);
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        }
        boxedUnit = BoxedUnit.UNIT;
    }

    public void noDiagnostic(Project project, File file) {
        Uri uri = Uri$.MODULE$.apply(file.toPath().toUri());
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        BuildTargetIdentifier buildTargetId = new BuildTargetIdentifier(project.bspUri());
        PublishDiagnosticsParams diagnostics = new PublishDiagnosticsParams(textDocument, buildTargetId, (Option)None$.MODULE$, (List)Nil$.MODULE$, true);
        Build$.MODULE$.publishDiagnostics().notify((Object)diagnostics, this.client());
    }

    public TaskId nextTaskId() {
        return new TaskId(((Object)BoxesRunTime.boxToInteger((int)this.taskIdCounter.addAndGet(1))).toString(), (Option)None$.MODULE$);
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public void publishCompileStart(Project project, TaskId taskId) {
        Json json = CompileTask$.MODULE$.encodeCompileTask().apply((Object)new CompileTask(new BuildTargetIdentifier(project.bspUri())));
        Future ack = Build$.MODULE$.taskStart().notify((Object)new TaskStartParams(taskId, (Option)new Some((Object)BoxesRunTime.boxToLong((long)this.now())), (Option)new Some((Object)new StringBuilder(12).append("Compiling '").append(project.name()).append("'").toString()), (Option)new Some((Object)TaskDataKind$.MODULE$.CompileTask()), (Option)new Some((Object)json)), this.client());
    }

    public void publishCompileEnd(Project project, TaskId taskId, Seq<Problem> problems, StatusCode code) {
        int errors = problems.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BspServerLogger.$anonfun$publishCompileEnd$1(x$1)));
        int warnings = problems.count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BspServerLogger.$anonfun$publishCompileEnd$2(x$2)));
        Json json = CompileReport$.MODULE$.encodeCompileReport().apply((Object)new CompileReport(new BuildTargetIdentifier(project.bspUri()), (Option)None$.MODULE$, errors, warnings, (Option)None$.MODULE$));
        Build$.MODULE$.taskFinish().notify((Object)new TaskFinishParams(taskId, (Option)new Some((Object)BoxesRunTime.boxToLong((long)this.now())), (Option)new Some((Object)new StringBuilder(11).append("Compiled '").append(project.name()).append("'").toString()), code, (Option)new Some((Object)TaskDataKind$.MODULE$.CompileReport()), (Option)new Some((Object)json)), this.client());
    }

    public static final /* synthetic */ boolean $anonfun$publishCompileEnd$1(Problem x$1) {
        Severity severity = x$1.severity();
        Severity severity2 = Severity.Error;
        return !(severity != null ? !severity.equals(severity2) : severity2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$publishCompileEnd$2(Problem x$2) {
        Severity severity = x$2.severity();
        Severity severity2 = Severity.Warn;
        return !(severity != null ? !severity.equals(severity2) : severity2 != null);
    }

    public BspServerLogger(String name, Logger underlying, JsonRpcClient client, AtomicInt taskIdCounter, boolean ansiSupported) {
        this.name = name;
        this.underlying = underlying;
        this.client = client;
        this.taskIdCounter = taskIdCounter;
        this.ansiSupported = ansiSupported;
        LoggerSupport.$init$((LoggerSupport)this);
        ScribeAdapter.$init$(this);
    }
}

