/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks;

import bloop.CompileInputs;
import bloop.CompileMode;
import bloop.Compiler;
import bloop.Compiler$;
import bloop.CompilerCache;
import bloop.ScalaInstance;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.data.Project;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.Dag;
import bloop.engine.Dag$;
import bloop.engine.Feedback$;
import bloop.engine.State;
import bloop.engine.caches.ResultsCache;
import bloop.engine.tasks.compilation.CompileBundle;
import bloop.engine.tasks.compilation.CompileBundle$;
import bloop.engine.tasks.compilation.CompileExceptions;
import bloop.engine.tasks.compilation.CompileExceptions$FailPromise$;
import bloop.engine.tasks.compilation.CompileGraph;
import bloop.engine.tasks.compilation.CompileGraph$;
import bloop.engine.tasks.compilation.CompileSourcesAndInstance;
import bloop.engine.tasks.compilation.FinalCompileResult;
import bloop.engine.tasks.compilation.FinalEmptyResult$;
import bloop.engine.tasks.compilation.FinalNormalCompileResult;
import bloop.engine.tasks.compilation.PartialCompileResult;
import bloop.engine.tasks.compilation.PartialCompileResult$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.BspServerLogger;
import bloop.logging.DebugFilter;
import bloop.reporter.BspProjectReporter;
import bloop.reporter.BspProjectReporter$;
import bloop.reporter.LogReporter;
import bloop.reporter.LogReporter$;
import bloop.reporter.ReporterConfig;
import bloop.reporter.ReporterConfig$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import monix.eval.Task;
import monix.eval.Task$;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.ConcreteSingleOutput;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.Promise;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import xsbti.Logger;
import xsbti.Position;
import xsbti.Reporter;
import xsbti.compile.CachedCompiler;
import xsbti.compile.EmptyIRStore;
import xsbti.compile.IR;
import xsbti.compile.IRStore;
import xsbti.compile.Output;
import xsbti.compile.PreviousResult;

public final class CompilationTask$ {
    public static CompilationTask$ MODULE$;
    private final DebugFilter logContext;
    private final SimpleDateFormat dateFormat;

    static {
        new CompilationTask$();
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    private SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    private String currentTime() {
        return this.dateFormat().format(new Date());
    }

    private final String GeneratePicklesFlag() {
        return "-Ygenerate-pickles";
    }

    public Task<State> compile(State state, Dag<Project> dag, Function2<Project, Path, bloop.reporter.Reporter> createReporter, CompileMode.ConfigurableMode userCompileMode, boolean pipeline, boolean excludeRoot, Promise<BoxedUnit> cancelCompilation) {
        Path cwd = AbsolutePath$.MODULE$.getParent$extension(state.build().origin());
        return CompileGraph$.MODULE$.traverse(dag, (Function1<Project, CompileBundle>)(Function1 & Serializable & scala.Serializable)x$3 -> CompilationTask$.setup$1(x$3), (Function1<CompileGraph.Inputs, Task<Compiler.Result>>)(Function1 & Serializable & scala.Serializable)x$4 -> CompilationTask$.compile$1(x$4, state, createReporter, userCompileMode, pipeline, cancelCompilation, cwd), pipeline, state.logger()).flatMap((Function1 & Serializable & scala.Serializable)partialDag -> {
            List partialResults = Dag$.MODULE$.dfs(partialDag);
            List finalResults = (List)partialResults.map((Function1 & Serializable & scala.Serializable)r -> PartialCompileResult$.MODULE$.toFinalResult((PartialCompileResult)r), List$.MODULE$.canBuildFrom());
            return Task$.MODULE$.gatherUnordered((TraversableOnce)finalResults).map((Function1 & Serializable & scala.Serializable)x$5 -> (List)x$5.flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)results -> {
                State state;
                MODULE$.cleanStatePerBuildRun(dag, (List<FinalCompileResult>)results, state);
                ResultsCache x$6 = state.results().addFinalResults((List<FinalCompileResult>)results);
                Build x$7 = state.copy$default$1();
                CompilerCache x$8 = state.copy$default$3();
                ClientPool x$9 = state.copy$default$4();
                CommonOptions x$10 = state.copy$default$5();
                ExitStatus x$11 = state.copy$default$6();
                bloop.logging.Logger x$12 = state.copy$default$7();
                State newState = state.copy(x$7, x$6, x$8, x$9, x$10, x$11, x$12);
                List failures = (List)results.collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends FinalCompileResult, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof FinalNormalCompileResult) {
                            FinalNormalCompileResult finalNormalCompileResult = (FinalNormalCompileResult)A1;
                            CompileBundle p = finalNormalCompileResult.bundle();
                            Compiler.Result result = finalNormalCompileResult.result();
                            Option option = Compiler.Result$.NotOk$.MODULE$.unapply(result);
                            if (!option.isEmpty()) {
                                object = p;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(FinalCompileResult x1) {
                        FinalNormalCompileResult finalNormalCompileResult;
                        Compiler.Result result;
                        Option option;
                        FinalCompileResult finalCompileResult = x1;
                        boolean bl = finalCompileResult instanceof FinalNormalCompileResult && !(option = Compiler.Result$.NotOk$.MODULE$.unapply(result = (finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult).result())).isEmpty();
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom());
                if (failures.isEmpty()) {
                    ExitStatus x$13 = ExitStatus$.MODULE$.Ok();
                    Build x$14 = newState.copy$default$1();
                    ResultsCache x$15 = newState.copy$default$2();
                    CompilerCache x$16 = newState.copy$default$3();
                    ClientPool x$17 = newState.copy$default$4();
                    CommonOptions x$18 = newState.copy$default$5();
                    bloop.logging.Logger x$19 = newState.copy$default$7();
                    state = newState.copy(x$14, x$15, x$16, x$17, x$18, x$13, x$19);
                } else {
                    results.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        CompilationTask$.$anonfun$compile$10(state, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    failures.foreach((Function1 & Serializable & scala.Serializable)b -> {
                        CompilationTask$.$anonfun$compile$11(state, b);
                        return BoxedUnit.UNIT;
                    });
                    ExitStatus x$20 = ExitStatus$.MODULE$.CompilationError();
                    Build x$21 = newState.copy$default$1();
                    ResultsCache x$22 = newState.copy$default$2();
                    CompilerCache x$23 = newState.copy$default$3();
                    ClientPool x$24 = newState.copy$default$4();
                    CommonOptions x$25 = newState.copy$default$5();
                    bloop.logging.Logger x$26 = newState.copy$default$7();
                    state = newState.copy(x$21, x$22, x$23, x$24, x$25, x$20, x$26);
                }
                return state;
            });
        });
    }

    private void cleanStatePerBuildRun(Dag<Project> dag, List<FinalCompileResult> results, State state) {
        Path tmpDir = Files.createTempDirectory("outputDir", new FileAttribute[0]);
        try {
            IRStore mergedStore = (IRStore)results.foldLeft((Object)EmptyIRStore.getStore(), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                IRStore acc = (IRStore)tuple2._1();
                FinalCompileResult result = (FinalCompileResult)tuple2._2();
                IRStore iRStore = acc.merge(result.store());
                return iRStore;
            });
            Set instances = results.iterator().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Nil$ nil$;
                FinalCompileResult finalCompileResult = x0$3;
                if (finalCompileResult instanceof FinalNormalCompileResult) {
                    FinalNormalCompileResult finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult;
                    CompileBundle bundle = finalNormalCompileResult.bundle();
                    nil$ = Option$.MODULE$.option2Iterable(bundle.project().scalaInstance());
                } else if (FinalEmptyResult$.MODULE$.equals(finalCompileResult)) {
                    nil$ = Nil$.MODULE$;
                } else {
                    throw new MatchError((Object)finalCompileResult);
                }
                return nil$;
            }).toSet();
            instances.foreach((Function1 & Serializable & scala.Serializable)i -> {
                CompilationTask$.$anonfun$cleanStatePerBuildRun$3(dag, state, tmpDir, mergedStore, i);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Files.delete(tmpDir);
        }
    }

    public bloop.reporter.Reporter toReporter(Project project, Path cwd, ReporterConfig config, bloop.logging.Logger logger) {
        bloop.reporter.Reporter reporter;
        bloop.logging.Logger logger2 = logger;
        if (logger2 instanceof BspServerLogger) {
            BspServerLogger bspServerLogger = (BspServerLogger)logger2;
            boolean x$27 = false;
            boolean x$28 = config.copy$default$1();
            boolean x$29 = config.copy$default$2();
            boolean x$30 = config.copy$default$3();
            boolean x$31 = config.copy$default$5();
            String x$32 = config.copy$default$6();
            String x$33 = config.copy$default$7();
            String x$34 = config.copy$default$8();
            String x$35 = config.copy$default$9();
            String x$36 = config.copy$default$10();
            String x$37 = config.copy$default$11();
            Function1 x$38 = config.copy$default$12();
            reporter = new BspProjectReporter(project, bspServerLogger, cwd, (Function1<Position, Position>)(Function1 & Serializable & scala.Serializable)x -> (Position)Predef$.MODULE$.identity(x), config.copy(x$28, x$29, x$30, x$27, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38), false, BspProjectReporter$.MODULE$.$lessinit$greater$default$7());
        } else {
            reporter = new LogReporter(project, logger, cwd, (Function1<Position, Position>)(Function1 & Serializable & scala.Serializable)x -> (Position)Predef$.MODULE$.identity(x), config, LogReporter$.MODULE$.$lessinit$greater$default$6());
        }
        return reporter;
    }

    public static final /* synthetic */ void $anonfun$compile$2(State state$1, String msg) {
        state$1.logger().warn(msg);
    }

    public static final /* synthetic */ void $anonfun$compile$1(State state$1, Project project$1, List missing) {
        Feedback$.MODULE$.detectMissingDependencies(project$1, (List<String>)missing).foreach((Function1 & Serializable & scala.Serializable)msg -> {
            CompilationTask$.$anonfun$compile$2(state$1, msg);
            return BoxedUnit.UNIT;
        });
    }

    private static final Task compile$1(CompileGraph.Inputs graphInputs, State state$1, Function2 createReporter$1, CompileMode.ConfigurableMode userCompileMode$1, boolean pipeline$1, Promise cancelCompilation$1, Path cwd$1) {
        Right right;
        CompileSourcesAndInstance compileSourcesAndInstance;
        Task task;
        Project project = graphInputs.bundle().project();
        Either<Compiler.Result, CompileSourcesAndInstance> either = graphInputs.bundle().toSourcesAndInstance();
        if (either instanceof Left) {
            Left left = (Left)either;
            Compiler.Result earlyResult = (Compiler.Result)left.value();
            CompileExceptions.CompletePromise complete = new CompileExceptions.CompletePromise(graphInputs.store());
            graphInputs.irPromise().completeExceptionally(complete);
            graphInputs.completeJava().complete(BoxedUnit.UNIT);
            task = Task$.MODULE$.now((Object)earlyResult);
        } else if (either instanceof Right && (compileSourcesAndInstance = (CompileSourcesAndInstance)(right = (Right)either).value()) != null) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            List<Path> sources = compileSourcesAndInstance.sources();
            ScalaInstance instance = compileSourcesAndInstance.instance();
            boolean javaOnly = compileSourcesAndInstance.javaOnly();
            Compiler.Result previousResult = state$1.results().latestResult(project);
            PreviousResult previousSuccesful = state$1.results().lastSuccessfulResultOrEmpty(project);
            bloop.reporter.Reporter reporter = (bloop.reporter.Reporter)createReporter$1.apply((Object)project, (Object)new AbsolutePath(cwd$1));
            state$1.build().hasMissingDependencies(project).foreach((Function1 & Serializable & scala.Serializable)missing -> {
                CompilationTask$.$anonfun$compile$1(state$1, project, missing);
                return BoxedUnit.UNIT;
            });
            if (!pipeline$1) {
                tuple22 = new Tuple2(project.scalacOptions().toArray(ClassTag$.MODULE$.apply(String.class)), (Object)userCompileMode$1);
            } else {
                CompileMode.Pipelined pipelined;
                String string = "-Ygenerate-pickles";
                String[] scalacOptions = (String[])project.scalacOptions().$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
                CompileMode.ConfigurableMode configurableMode = userCompileMode$1;
                if (CompileMode.Sequential$.MODULE$.equals(configurableMode)) {
                    pipelined = new CompileMode.Pipelined(graphInputs.irPromise(), graphInputs.completeJava(), graphInputs.transitiveJavaSignal(), graphInputs.oracle(), graphInputs.separateJavaAndScala());
                } else if (configurableMode instanceof CompileMode.Parallel) {
                    CompileMode.Parallel parallel = (CompileMode.Parallel)configurableMode;
                    int batches = parallel.batches();
                    pipelined = new CompileMode.ParallelAndPipelined(batches, graphInputs.irPromise(), graphInputs.completeJava(), graphInputs.transitiveJavaSignal(), graphInputs.oracle(), graphInputs.separateJavaAndScala());
                } else {
                    throw new MatchError((Object)configurableMode);
                }
                CompileMode.Pipelined mode = pipelined;
                tuple22 = tuple2 = new Tuple2((Object)scalacOptions, (Object)mode);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String[] scalacOptions = (String[])tuple2._1();
            CompileMode compileMode = (CompileMode)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)scalacOptions, (Object)compileMode);
            Tuple2 tuple24 = tuple23;
            String[] scalacOptions2 = (String[])tuple24._1();
            CompileMode compileMode2 = (CompileMode)tuple24._2();
            CompileInputs backendInputs = new CompileInputs(instance, state$1.compilerCache(), (AbsolutePath[])sources.toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), project.compilationClasspath(), graphInputs.store(), project.classesDir(), project.out(), scalacOptions2, (String[])project.javacOptions().toArray(ClassTag$.MODULE$.apply(String.class)), project.compileOrder(), project.classpathOptions(), previousSuccesful, previousResult, reporter, compileMode2, graphInputs.dependentResults(), cancelCompilation$1);
            task = Compiler$.MODULE$.compile(backendInputs).map((Function1 & Serializable & scala.Serializable)result -> {
                Boolean bl;
                if (!graphInputs.irPromise().isDone()) {
                    boolean bl2;
                    Compiler.Result result2 = result;
                    Option option = Compiler.Result$.NotOk$.MODULE$.unapply(result2);
                    if (!option.isEmpty()) {
                        bl2 = graphInputs.irPromise().completeExceptionally(CompileExceptions$FailPromise$.MODULE$);
                    } else {
                        if (pipeline$1 && !javaOnly) {
                            state$1.logger().warn(new StringBuilder(46).append("The project ").append(project.name()).append(" didn't use pipelined compilation.").toString());
                        }
                        CompileExceptions.CompletePromise complete = new CompileExceptions.CompletePromise(graphInputs.store());
                        bl2 = graphInputs.irPromise().completeExceptionally(complete);
                    }
                    bl = BoxesRunTime.boxToBoolean((boolean)bl2);
                } else {
                    IR[] iRArray = graphInputs.irPromise().get();
                    Option option = Array$.MODULE$.unapplySeq((Object)iRArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0 && pipeline$1) {
                        state$1.logger().warn(new StringBuilder(48).append("Project ").append(project.name()).append(" compiled without pipelined compilation.").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        state$1.logger().debug(new StringBuilder(41).append("The pickle promise of ").append(project.name()).append(" completed in Zinc.").toString(), MODULE$.logContext());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    bl = BoxedUnit.UNIT;
                }
                return result;
            });
        } else {
            throw new MatchError(either);
        }
        return task;
    }

    private static final CompileBundle setup$1(Project project) {
        return CompileBundle$.MODULE$.apply(project);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$compile$10(State state$1, FinalCompileResult x0$1) {
        FinalCompileResult finalCompileResult = x0$1;
        if (finalCompileResult instanceof FinalNormalCompileResult) {
            Compiler.Result$.Failed failed;
            Option option;
            FinalNormalCompileResult finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult;
            CompileBundle bundle = finalNormalCompileResult.bundle();
            Compiler.Result result = finalNormalCompileResult.result();
            if (result instanceof Compiler.Result$.Failed && (option = (failed = (Compiler.Result$.Failed)result).t()) instanceof Some) {
                Some some = (Some)option;
                Throwable t = (Throwable)some.value();
                Project project = bundle.project();
                state$1.logger().error(new StringBuilder(36).append("Unexpected error when compiling ").append(project.name()).append(": '").append(t.getMessage()).append("'").toString());
                t.printStackTrace();
                state$1.logger().trace(t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$compile$11(State state$1, CompileBundle b) {
        state$1.logger().error(new StringBuilder(21).append("'").append(b.project().name()).append("' failed to compile.").toString());
    }

    public static final /* synthetic */ void $anonfun$cleanStatePerBuildRun$3(Dag dag$2, State state$2, Path tmpDir$1, IRStore mergedStore$1, ScalaInstance i) {
        bloop.logging.Logger logger = state$2.logger();
        AnalyzingCompiler scalac = (AnalyzingCompiler)state$2.compilerCache().get(i).scalac();
        ReporterConfig config = ReporterConfig$.MODULE$.defaultFormat();
        Path cwd = state$2.commonOptions().workingPath();
        Project randomProjectFromDag = (Project)Dag$.MODULE$.dfs(dag$2).head();
        LogReporter reporter = new LogReporter(randomProjectFromDag, logger, cwd, (Function1<Position, Position>)(Function1 & Serializable & scala.Serializable)x -> (Position)Predef$.MODULE$.identity(x), config, LogReporter$.MODULE$.$lessinit$greater$default$6());
        ConcreteSingleOutput output = new ConcreteSingleOutput(tmpDir$1.toFile());
        CachedCompiler cached = scalac.newCachedCompiler((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Output)output, (Logger)logger, (Reporter)reporter);
        scalac.resetGlobalIRCaches(mergedStore$1, cached, (Logger)logger);
    }

    private CompilationTask$() {
        MODULE$ = this;
        this.logContext = DebugFilter.Compilation$.MODULE$;
        this.dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    }
}

