/*
 * Decompiled with CFR 0.152.
 */
package bloop.exec;

import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.engine.ExecutionContext$;
import bloop.exec.Forker;
import bloop.exec.JavaEnv;
import bloop.io.AbsolutePath;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import com.zaxxer.nuprocess.NuAbstractProcessHandler;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import com.zaxxer.nuprocess.NuProcessHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;

public final class Forker$
implements scala.Serializable {
    public static Forker$ MODULE$;
    private final DebugFilter bloop$exec$Forker$$logContext;

    static {
        new Forker$();
    }

    public DebugFilter bloop$exec$Forker$$logContext() {
        return this.bloop$exec$Forker$$logContext;
    }

    private final int EXIT_OK() {
        return 0;
    }

    private final int EXIT_ERROR() {
        return 1;
    }

    public ExitStatus exitStatus(int exitCode) {
        return exitCode == 0 ? ExitStatus$.MODULE$.Ok() : ExitStatus$.MODULE$.RunError();
    }

    public Task<Object> run(Path cwd, Seq<String> cmd, Logger logger, CommonOptions opts) {
        Task task;
        if (!Files.exists(cwd, new LinkOption[0])) {
            task = Task$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                logger.error(new java.lang.StringBuilder(53).append("Could not start the process because '").append(new AbsolutePath(cwd)).append("' does not exist").toString());
                return 1;
            });
        } else {
            ObjectRef gobbleInput = ObjectRef.create(null);
            VolatileBooleanRef shutdownInput = VolatileBooleanRef.create((boolean)false);
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                public final class Bloop_exec_Forker$ProcessHandler$1
                extends NuAbstractProcessHandler {
                    private final StringBuilder outBuilder;
                    private final StringBuilder errBuilder;
                    private final Path cwd$2;
                    private final Seq cmd$1;
                    private final Logger logger$2;
                    private final ObjectRef gobbleInput$1;

                    public void onStart(NuProcess nuProcess) {
                        this.logger$2.debug(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(138).append("Starting forked process:\n                          |  cwd = '").append(new AbsolutePath(this.cwd$2)).append("'\n                          |  pid = '").append(nuProcess.getPID()).append("'\n                          |  cmd = '").append(this.cmd$1.mkString(" ")).append("'").toString())).stripMargin(), Forker$.MODULE$.bloop$exec$Forker$$logContext());
                    }

                    public void onExit(int statusCode) {
                        this.logger$2.debug(new java.lang.StringBuilder(33).append("Forked process exited with code: ").append(statusCode).toString(), Forker$.MODULE$.bloop$exec$Forker$$logContext());
                    }

                    public StringBuilder outBuilder() {
                        return this.outBuilder;
                    }

                    public void onStdout(ByteBuffer buffer, boolean closed) {
                        if (closed) {
                            if ((Cancelable)this.gobbleInput$1.elem != null) {
                                ((Cancelable)this.gobbleInput$1.elem).cancel();
                            }
                            this.logger$2.debug("The process is closed. Emptying buffer...", Forker$.MODULE$.bloop$exec$Forker$$logContext());
                            String remaining = this.outBuilder().mkString();
                            if (!remaining.isEmpty()) {
                                this.logger$2.info(remaining);
                            }
                        } else {
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Forker$.MODULE$.linesFrom(buffer, this.outBuilder()))).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                                Bloop_exec_Forker$ProcessHandler$1.$anonfun$onStdout$1(this, x$13);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }

                    public StringBuilder errBuilder() {
                        return this.errBuilder;
                    }

                    public void onStderr(ByteBuffer buffer, boolean closed) {
                        if (closed) {
                            String remaining = this.errBuilder().mkString();
                            if (!remaining.isEmpty()) {
                                this.logger$2.error(remaining);
                            }
                        } else {
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Forker$.MODULE$.linesFrom(buffer, this.errBuilder()))).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                                Bloop_exec_Forker$ProcessHandler$1.$anonfun$onStderr$1(this, x$14);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }

                    public static final /* synthetic */ void $anonfun$onStdout$1(Bloop_exec_Forker$ProcessHandler$1 $this, String x$13) {
                        $this.logger$2.info(x$13);
                    }

                    public static final /* synthetic */ void $anonfun$onStderr$1(Bloop_exec_Forker$ProcessHandler$1 $this, String x$14) {
                        $this.logger$2.error(x$14);
                    }

                    public Bloop_exec_Forker$ProcessHandler$1(Path cwd$2, Seq cmd$1, Logger logger$2, ObjectRef gobbleInput$1) {
                        this.cwd$2 = cwd$2;
                        this.cmd$1 = cmd$1;
                        this.logger$2 = logger$2;
                        this.gobbleInput$1 = gobbleInput$1;
                        this.outBuilder = package$.MODULE$.StringBuilder().newBuilder();
                        this.errBuilder = package$.MODULE$.StringBuilder().newBuilder();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onStdout$1$adapted(bloop.exec.Forker$ProcessHandler$1 java.lang.String ), $anonfun$onStderr$1$adapted(bloop.exec.Forker$ProcessHandler$1 java.lang.String )}, serializedLambda);
                    }
                }
                Bloop_exec_Forker$ProcessHandler$1 handler = new Bloop_exec_Forker$ProcessHandler$1(cwd, cmd, logger, gobbleInput);
                NuProcessBuilder builder = new NuProcessBuilder((NuProcessHandler)handler, (String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class)));
                builder.setCwd(cwd);
                Map npEnv = builder.environment();
                npEnv.clear();
                npEnv.putAll((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(opts.env().toMap()).asJava());
                return builder.start();
            }).flatMap((Function1 & Serializable & scala.Serializable)process -> {
                FiniteDuration duration = FiniteDuration$.MODULE$.apply(50L, TimeUnit.MILLISECONDS);
                gobbleInput$1.elem = Scheduler.Extensions$.MODULE$.scheduleWithFixedDelay$extension(Scheduler$.MODULE$.Extensions(ExecutionContext$.MODULE$.ioScheduler()), duration, duration, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    byte[] buffer = new byte[4096];
                    int read = opts.in().read(buffer, 0, buffer.length);
                    if (read != -1 && !shutdownInput$1.elem && process.isRunning()) {
                        process.writeStdin(ByteBuffer.wrap(buffer));
                    }
                });
                return Task$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                    int n;
                    try {
                        int exitCode = process.waitFor(0L, TimeUnit.SECONDS);
                        logger.debug(new java.lang.StringBuilder(27).append("Process ").append(process.getPID()).append(" exited with code: ").append(exitCode).toString(), MODULE$.bloop$exec$Forker$$logContext());
                        n = exitCode;
                    }
                    finally {
                        shutdownInput$1.elem = true;
                        ((Cancelable)gobbleInput$1.elem).cancel();
                    }
                    return n;
                }).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    shutdownInput$1.elem = true;
                    ((Cancelable)gobbleInput$1.elem).cancel();
                    try {
                        process.closeStdin(true);
                    }
                    finally {
                        process.destroy(false);
                        process.waitFor(400L, TimeUnit.MILLISECONDS);
                        process.destroy(true);
                        if (process.isRunning()) {
                            String msg = new java.lang.StringBuilder(43).append("The cancellation could not destroy process ").append(process.getPID()).toString();
                            opts.ngout().println(msg);
                            logger.debug(msg, MODULE$.bloop$exec$Forker$$logContext());
                        } else {
                            String msg = new java.lang.StringBuilder(32).append("The run process ").append(process.getPID()).append(" has been closed").toString();
                            opts.ngout().println(msg);
                            logger.debug(msg, MODULE$.bloop$exec$Forker$$logContext());
                        }
                    }
                }));
            });
        }
        return task;
    }

    public String[] linesFrom(ByteBuffer buffer, StringBuilder remaining) {
        String[] stringArray;
        String[] newLines;
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        String msg = new String(bytes, StandardCharsets.UTF_8);
        String[] stringArray2 = newLines = msg.split(System.lineSeparator(), Integer.MAX_VALUE);
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray2);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            remaining.$plus$plus$eq(msg);
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        } else {
            String[] stringArray3;
            String msgAtTheEnd = newLines[newLines.length - 1];
            boolean shouldBuffer = !msgAtTheEnd.isEmpty();
            Object object = shouldBuffer ? remaining.$plus$plus$eq(msgAtTheEnd) : BoxedUnit.UNIT;
            if (stringArray2.length > 1) {
                if (shouldBuffer) {
                    stringArray3 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newLines)).init();
                } else {
                    String firstLine = newLines[0];
                    newLines[0] = (String)new StringOps(Predef$.MODULE$.augmentString(remaining.mkString())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(firstLine)), Predef$.MODULE$.StringCanBuildFrom());
                    remaining.clear();
                    stringArray3 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newLines)).init();
                }
            } else {
                stringArray3 = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
            stringArray = stringArray3;
        }
        return stringArray;
    }

    public Forker apply(JavaEnv javaEnv, AbsolutePath[] classpath) {
        return new Forker(javaEnv, classpath);
    }

    public Option<Tuple2<JavaEnv, Path[]>> unapply(Forker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.javaEnv(), (Object)x$0.classpath()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Forker$() {
        MODULE$ = this;
        this.bloop$exec$Forker$$logContext = DebugFilter.All$.MODULE$;
    }
}

