/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.bsp.BspServer$;
import bloop.engine.ExecutionContext$;
import bloop.engine.State;
import bloop.io.SourceWatcher$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.Slf4jAdapter;
import bloop.util.monix.FoldLeftAsyncConsumer$;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.DirectoryWatcher;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.reactive.Consumer;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0005\u001d\u0011QbU8ve\u000e,w+\u0019;dQ\u0016\u0014(BA\u0002\u0005\u0003\tIwNC\u0001\u0006\u0003\u0015\u0011Gn\\8q\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011!y\u0001A!A!\u0002\u0013\u0001\u0012\u0001\u00049s_*,7\r\u001e(b[\u0016\u001c\bcA\t\u001a99\u0011!c\u0006\b\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005aQ\u0011a\u00029bG.\fw-Z\u0005\u00035m\u0011A\u0001T5ti*\u0011\u0001D\u0003\t\u0003;\u0005r!AH\u0010\u0011\u0005MQ\u0011B\u0001\u0011\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011!e\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001R\u0001\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\t\u0011L'o\u001d\t\u0004#\u001dJ\u0013B\u0001\u0015\u001c\u0005\r\u0019V-\u001d\t\u0003UEj\u0011a\u000b\u0006\u0003Y5\nAAZ5mK*\u0011afL\u0001\u0004]&|'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e-\u0012A\u0001U1uQ\"AA\u0007\u0001B\u0001B\u0003%a%A\u0003gS2,7\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003\u0019awnZ4feB\u0011\u0001hO\u0007\u0002s)\u0011!\bB\u0001\bY><w-\u001b8h\u0013\ta\u0014H\u0001\u0004M_\u001e<WM\u001d\u0005\u0006}\u0001!IaP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0001\u00135\tR#\u0011\u0005\u0005\u0003Q\"\u0001\u0002\t\u000b=i\u0004\u0019\u0001\t\t\u000b\u0015j\u0004\u0019\u0001\u0014\t\u000bQj\u0004\u0019\u0001\u0014\t\u000bYj\u0004\u0019A\u001c\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\u0006Y1\u000f\u001c45U2{wmZ3s+\u0005I\u0005c\u0001\u001dKo%\u00111*\u000f\u0002\r'24GG[!eCB$XM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0019Mdg\r\u000e6M_\u001e<WM\u001d\u0011\t\u000f=\u0003!\u0019!C\u0006!\u0006QAn\\4D_:$X\r\u001f;\u0016\u0003E\u0003\"\u0001\u000f*\n\u0005MK$a\u0003#fEV<g)\u001b7uKJDa!\u0016\u0001!\u0002\u0013\t\u0016a\u00037pO\u000e{g\u000e^3yi\u0002BQa\u0016\u0001\u0005\u0002a\u000bQa^1uG\"$2!W4j!\rQv,Y\u0007\u00027*\u0011A,X\u0001\u0005KZ\fGNC\u0001_\u0003\u0015iwN\\5y\u0013\t\u00017L\u0001\u0003UCN\\\u0007C\u00012f\u001b\u0005\u0019'B\u00013\u0005\u0003\u0019)gnZ5oK&\u0011am\u0019\u0002\u0006'R\fG/\u001a\u0005\u0006QZ\u0003\r!Y\u0001\u0007gR\fG/\u001a\u0019\t\u000b)4\u0006\u0019A6\u0002\r\u0005\u001cG/[8o!\u0011IA.Y-\n\u00055T!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015y\u0007\u0001\"\u0001q\u0003-qw\u000e^5gs^\u000bGo\u00195\u0015\u0003E\u0004\"!\u0003:\n\u0005MT!\u0001B+oSR<Q!\u001e\u0002\t\u0002Y\fQbU8ve\u000e,w+\u0019;dQ\u0016\u0014\bCA!x\r\u0015\t!\u0001#\u0001y'\t9\b\u0002C\u0003?o\u0012\u0005!\u0010F\u0001w\u0011\u0015ax\u000f\"\u0001~\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0001ep`A\u0002\u0011\u0015y1\u00101\u0001\u0011\u0011\u0019\t\ta\u001fa\u0001M\u00051\u0001/\u0019;igBBQAN>A\u0002]\u0002")
public final class SourceWatcher {
    private final List<String> projectNames;
    private final Seq<Path> dirs;
    private final Seq<Path> files;
    private final Logger logger;
    private final Slf4jAdapter<Logger> bloop$io$SourceWatcher$$slf4jLogger;
    private final DebugFilter logContext;

    public static SourceWatcher apply(List<String> list, Seq<Path> seq, Logger logger) {
        return SourceWatcher$.MODULE$.apply(list, seq, logger);
    }

    public Slf4jAdapter<Logger> bloop$io$SourceWatcher$$slf4jLogger() {
        return this.bloop$io$SourceWatcher$$slf4jLogger;
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    public Task<State> watch(State state0, Function1<State, Task<State>> action) {
        PrintStream ngout = state0.commonOptions().ngout();
        Tuple2 tuple2 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.publish(), ExecutionContext$.MODULE$.ioScheduler());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Observer.Sync observer = (Observer.Sync)tuple2._1();
        Observable observable = (Observable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)observer, (Object)observable);
        Tuple2 tuple23 = tuple22;
        Observer.Sync observer2 = (Observer.Sync)tuple23._1();
        Observable observable2 = (Observable)tuple23._2();
        BooleanRef watchingEnabled = BooleanRef.create((boolean)true);
        DirectoryChangeListener listener = new DirectoryChangeListener(this, observer2, watchingEnabled){
            private final /* synthetic */ SourceWatcher $outer;
            private final Observer.Sync observer$1;
            private final BooleanRef watchingEnabled$1;

            public boolean isWatching() {
                return this.watchingEnabled$1.elem;
            }

            public void onException(Exception e) {
                this.$outer.bloop$io$SourceWatcher$$slf4jLogger().error(new StringBuilder(34).append("File watching threw an exception: ").append(e.getMessage()).toString());
            }

            public void onEvent(DirectoryChangeEvent event) {
                block0: {
                    Path targetFile = event.path();
                    String targetPath = targetFile.toFile().getAbsolutePath();
                    if (!Files.isRegularFile(targetFile, new LinkOption[0]) || !targetPath.endsWith(".scala") && !targetPath.endsWith(".java")) break block0;
                    this.observer$1.onNext((Object)event);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.observer$1 = observer$1;
                this.watchingEnabled$1 = watchingEnabled$1;
            }
        };
        DirectoryWatcher watcher = DirectoryWatcher.builder().paths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.dirs).asJava()).files((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.files).asJava()).logger(this.bloop$io$SourceWatcher$$slf4jLogger()).listener(listener).fileHashing(true).build();
        CompletableFuture watcherHandle = watcher.watchAsync((Executor)ExecutionContext$.MODULE$.ioExecutor());
        Task watchController = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                watcherHandle.get();
            }
            finally {
                watcher.close();
            }
            $this.logger.debug("File watcher was successfully closed", this.logContext());
        });
        Cancelable watchCancellation = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            watchingEnabled$1.elem = false;
            watcherHandle.complete(null);
            observer2.onComplete();
            ngout.println(new StringBuilder(74).append("File watching on '").append($this.projectNames.mkString("', '")).append("' and dependent projects has been successfully cancelled").toString());
        });
        Consumer fileEventConsumer = FoldLeftAsyncConsumer$.MODULE$.consume((Function0 & Serializable & scala.Serializable)() -> state0, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Task task;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            State state = (State)tuple2._1();
            DirectoryChangeEvent event = (DirectoryChangeEvent)tuple2._2();
            DirectoryChangeEvent.EventType eventType = event.eventType();
            if (DirectoryChangeEvent.EventType.CREATE.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else if (DirectoryChangeEvent.EventType.MODIFY.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else if (DirectoryChangeEvent.EventType.OVERFLOW.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else {
                if (!DirectoryChangeEvent.EventType.DELETE.equals(eventType)) throw new MatchError((Object)eventType);
                task = Task$.MODULE$.now((Object)state);
            }
            return task;
        });
        return observable2.consumeWith(fileEventConsumer).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> watchCancellation.cancel()));
    }

    public void notifyWatch() {
        int filesCount = this.files.size();
        int dirsCount = this.dirs.size();
        String andFiles = filesCount == 0 ? "" : new StringBuilder(11).append(" and ").append(filesCount).append(" files").toString();
        this.logger.info(new StringBuilder(52).append("Watching ").append(dirsCount).append(" directories").append(andFiles).append("... (press Ctrl-C to interrupt)").toString());
    }

    private final Task runAction$1(State state, DirectoryChangeEvent event, Function1 action$1) {
        if (!BspServer$.MODULE$.isWindows()) {
            this.logger.info("\u001b[H\u001b[2J");
        }
        this.logger.debug(new StringBuilder(29).append("A ").append(event.eventType()).append(" in ").append(event.path()).append(" has triggered an event").toString(), this.logContext());
        return (Task)action$1.apply((Object)state);
    }

    public SourceWatcher(List<String> projectNames, Seq<Path> dirs, Seq<Path> files, Logger logger) {
        this.projectNames = projectNames;
        this.dirs = dirs;
        this.files = files;
        this.logger = logger;
        this.bloop$io$SourceWatcher$$slf4jLogger = new Slf4jAdapter(logger);
        this.logContext = DebugFilter.FileWatching$.MODULE$;
    }
}

