/*
 * Decompiled with CFR 0.152.
 */
package bloop.bsp;

import bloop.CompileMode;
import bloop.Compiler;
import bloop.CompilerCache;
import bloop.ScalaInstance;
import bloop.bsp.BloopBspServices$;
import bloop.bsp.ProjectUris$;
import bloop.cli.Commands;
import bloop.cli.Commands$Run$;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.cli.Validate$;
import bloop.config.Config;
import bloop.data.Platform;
import bloop.data.Project;
import bloop.engine.Aggregate;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.Dag;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Interpreter$;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.caches.ResultsCache;
import bloop.engine.tasks.CompilationTask$;
import bloop.engine.tasks.LinkTask$;
import bloop.engine.tasks.Tasks$;
import bloop.engine.tasks.toolchains.ScalaJsToolchain$;
import bloop.engine.tasks.toolchains.ScalaNativeToolchain$;
import bloop.exec.JavaEnv;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.BspServerLogger;
import bloop.logging.BspServerLogger$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.reporter.BspProjectReporter;
import bloop.reporter.BspProjectReporter$;
import bloop.reporter.Problem;
import bloop.reporter.Problem$;
import bloop.reporter.Reporter;
import bloop.reporter.ReporterConfig;
import bloop.reporter.ReporterConfig$;
import bloop.testing.BspLoggingEventHandler;
import bloop.testing.TestInternals$;
import ch.epfl.scala.bsp.BuildServerCapabilities;
import ch.epfl.scala.bsp.BuildTarget;
import ch.epfl.scala.bsp.BuildTargetCapabilities;
import ch.epfl.scala.bsp.BuildTargetIdentifier;
import ch.epfl.scala.bsp.BuildTargetTag$;
import ch.epfl.scala.bsp.CompileParams;
import ch.epfl.scala.bsp.CompileResult;
import ch.epfl.scala.bsp.DependencySourcesItem;
import ch.epfl.scala.bsp.DependencySourcesParams;
import ch.epfl.scala.bsp.DependencySourcesResult;
import ch.epfl.scala.bsp.Exit;
import ch.epfl.scala.bsp.InitializeBuildParams;
import ch.epfl.scala.bsp.InitializeBuildResult;
import ch.epfl.scala.bsp.InitializedBuildParams;
import ch.epfl.scala.bsp.MessageType;
import ch.epfl.scala.bsp.RunParams;
import ch.epfl.scala.bsp.RunResult;
import ch.epfl.scala.bsp.ScalaBuildTarget;
import ch.epfl.scala.bsp.ScalaBuildTarget$;
import ch.epfl.scala.bsp.ScalaPlatform;
import ch.epfl.scala.bsp.ScalacOptionsItem;
import ch.epfl.scala.bsp.ScalacOptionsParams;
import ch.epfl.scala.bsp.ScalacOptionsResult;
import ch.epfl.scala.bsp.ShowMessageParams;
import ch.epfl.scala.bsp.Shutdown;
import ch.epfl.scala.bsp.SourceItem;
import ch.epfl.scala.bsp.SourcesItem;
import ch.epfl.scala.bsp.SourcesParams;
import ch.epfl.scala.bsp.SourcesResult;
import ch.epfl.scala.bsp.StatusCode;
import ch.epfl.scala.bsp.TestParams;
import ch.epfl.scala.bsp.TestResult;
import ch.epfl.scala.bsp.Uri;
import ch.epfl.scala.bsp.Uri$;
import ch.epfl.scala.bsp.WorkspaceBuildTargets;
import ch.epfl.scala.bsp.WorkspaceBuildTargetsRequest;
import ch.epfl.scala.bsp.endpoints.Build$;
import ch.epfl.scala.bsp.endpoints.BuildTarget$;
import ch.epfl.scala.bsp.endpoints.Workspace$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.AtomicInt$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration$;
import scala.meta.jsonrpc.Endpoint;
import scala.meta.jsonrpc.JsonRpcClient;
import scala.meta.jsonrpc.Response;
import scala.meta.jsonrpc.Response$;
import scala.meta.jsonrpc.Services;
import scala.meta.jsonrpc.Services$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scribe.LoggerSupport;
import xsbti.Position;

@ScalaSignature(bytes="\u0006\u0001\r=h\u0001B\"E\u0005%C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t/\u0002\u0011\t\u0011)A\u00051\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!y\u0007A!A!\u0002\u0013\u0001\b\"\u0002>\u0001\t\u0003Y\b\"CA\u0004\u0001\t\u0007I1BA\u0005\u0011!\t9\u0002\u0001Q\u0001\n\u0005-QABA\r\u0001\u0011\tY\"\u0002\u0004\u0002*\u0001!\u00111F\u0003\u0007\u0003?\u0002A!!\u0019\u0006\r\u0005U\u0004\u0001BA<\u000b\u0019\t9\t\u0001\u0003\u0002\n\"I\u0011q\u0013\u0001C\u0002\u0013%\u0011\u0011\u0014\u0005\b\u00037\u0003\u0001\u0015!\u0003q\u0011%\ti\n\u0001b\u0001\n\u0013\ty\n\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAQ\u0011%\tI\u000b\u0001b\u0001\n\u000b\tY\u000b\u0003\u0005\u00024\u0002\u0001\u000bQBAW\u0011%\t)\f\u0001a\u0001\n\u0013\t9\fC\u0005\u0002:\u0002\u0001\r\u0011\"\u0003\u0002<\"9\u0011q\u0019\u0001!B\u0013\t\u0006bBAi\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KDq!!<\u0001\t\u0003\ty\u000fC\u0005\u0003\u0012\u0001\u0011\r\u0011\"\u0001\u0003\u0014!A!1\u0005\u0001!\u0002\u0013\u0011)\u0002C\u0005\u0003&\u0001\u0011\r\u0011\"\u0001\u0003(!A!1\u0006\u0001!\u0002\u0013\u0011I\u0003C\u0004\u0003.\u0001!\tAa\f\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!Q\n\u0001\u0005\u0002\t=SA\u0002B3\u0001\u0001\u00119\u0007C\u0004\u0003\u0002\u0002!IAa!\t\u0013\tU\u0005A1A\u0005\n\t]\u0005\u0002\u0003BW\u0001\u0001\u0006IA!'\t\u000f\t=\u0006\u0001\"\u0001\u00032\"9!1\u001a\u0001\u0005\u0002\t5\u0007b\u0002Bm\u0001\u0011\u0005!1\u001c\u0005\b\u0005[\u0004A\u0011\u0001Bx\u0011\u001d\u0019\t\u0001\u0001C\u0005\u0007\u0007Aqa!\u0003\u0001\t\u0003\u0019Y\u0001C\u0004\u0004\"\u0001!\taa\t\t\u000f\r]\u0002\u0001\"\u0001\u0004:!911\n\u0001\u0005\u0002\r5\u0003bBB0\u0001\u0011\u00051\u0011\r\u0005\n\u0007g\u0002!\u0019!C\u0001\u0005'A\u0001b!\u001e\u0001A\u0003%!Q\u0003\u0005\n\u0007o\u0002!\u0019!C\u0001\u0005OA\u0001b!\u001f\u0001A\u0003%!\u0011\u0006\u0005\b\u0007w\u0002A\u0011AB?\u0011\u001d\u00199\t\u0001C\u0001\u0007\u0013;qaa%E\u0011\u0003\u0019)J\u0002\u0004D\t\"\u00051q\u0013\u0005\u0007u^\"\ta!'\t\u0015\rmuG1A\u0005\u0002\u0019\u001bi\n\u0003\u0005\u00040^\u0002\u000b\u0011BBP\u0011)\u0019\tl\u000eb\u0001\n\u0003151\u0017\u0005\t\u0007\u0013<\u0004\u0015!\u0003\u00046\"Q11Z\u001cC\u0002\u0013\u0005ai!4\t\u0011\rUw\u0007)A\u0005\u0007\u001fD!ba68\u0005\u0004%\tARBm\u0011!\u0019\to\u000eQ\u0001\n\rm\u0007BCBro\t\u0007I\u0011\u0001$\u0004f\"A1Q^\u001c!\u0002\u0013\u00199O\u0001\tCY>|\u0007OQ:q'\u0016\u0014h/[2fg*\u0011QIR\u0001\u0004EN\u0004(\"A$\u0002\u000b\tdwn\u001c9\u0004\u0001M\u0011\u0001A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\u001b\r\fG\u000e\\*ji\u0016\u001cF/\u0019;f!\t\u0011V+D\u0001T\u0015\t!f)\u0001\u0004f]\u001eLg.Z\u0005\u0003-N\u0013Qa\u0015;bi\u0016\faa\u00197jK:$\bCA-_\u001b\u0005Q&BA.]\u0003\u001dQ7o\u001c8sa\u000eT!!\u0018'\u0002\t5,G/Y\u0005\u0003?j\u0013QBS:p]J\u00038m\u00117jK:$\u0018A\u0005:fY\u0006$\u0018N^3D_:4\u0017n\u001a)bi\"\u0004\"AY3\u000e\u0003\rT!\u0001\u001a$\u0002\u0005%|\u0017B\u00014d\u00051\u0011V\r\\1uSZ,\u0007+\u0019;i\u0003-\u0019xnY6fi&s\u0007/\u001e;\u0011\u0005%lW\"\u00016\u000b\u0005\u0011\\'\"\u00017\u0002\t)\fg/Y\u0005\u0003]*\u00141\"\u00138qkR\u001cFO]3b[\u0006QQ\r_5u'R\fG/^:\u0011\u0005EDX\"\u0001:\u000b\u0005M$\u0018AB1u_6L7M\u0003\u0002vm\u0006IQ\r_3dkRLwN\u001c\u0006\u0002o\u0006)Qn\u001c8jq&\u0011\u0011P\u001d\u0002\n\u0003R|W.[2J]R\fa\u0001P5oSRtD#\u0003?\u007f\u007f\u0006\u0005\u00111AA\u0003!\ti\b!D\u0001E\u0011\u0015\u0001f\u00011\u0001R\u0011\u00159f\u00011\u0001Y\u0011\u0015\u0001g\u00011\u0001b\u0011\u00159g\u00011\u0001i\u0011\u0015yg\u00011\u0001q\u0003-!WMY;h\r&dG/\u001a:\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005Ea)A\u0004m_\u001e<\u0017N\\4\n\t\u0005U\u0011q\u0002\u0002\f\t\u0016\u0014Wo\u001a$jYR,'/\u0001\u0007eK\n,xMR5mi\u0016\u0014\bEA\u0007Qe>$xnY8m\u000bJ\u0014xN\u001d\t\u0005\u0003;\t\u0019CD\u0002Z\u0003?I1!!\t[\u0003!\u0011Vm\u001d9p]N,\u0017\u0002BA\u0013\u0003O\u0011Q!\u0012:s_JT1!!\t[\u0005-\u00115\u000f\u001d*fgB|gn]3\u0016\t\u00055\u0012Q\n\t\t\u0003_\ty$!\u0012\u0002J9!\u0011\u0011GA\u001e\u001d\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c\u0011\u00061AH]8pizJ\u0011!T\u0005\u0004\u0003{a\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003{a\u0005cAA$\u00135\t\u0001\u0001\u0005\u0003\u0002L\u00055C\u0002\u0001\u0003\b\u0003\u001fR!\u0019AA)\u0005\u0005!\u0016\u0003BA*\u00033\u00022aSA+\u0013\r\t9\u0006\u0014\u0002\b\u001d>$\b.\u001b8h!\rY\u00151L\u0005\u0004\u0003;b%aA!os\n\u0019\"i\u001d9F]\u0012\u0004x.\u001b8u%\u0016\u001c\bo\u001c8tKV!\u00111MA:!\u0019\t)'a\u001b\u0002p5\u0011\u0011q\r\u0006\u0004\u0003S2\u0018\u0001B3wC2LA!!\u001c\u0002h\t!A+Y:l!\u0015\t9ECA9!\u0011\tY%a\u001d\u0005\u000f\u0005=3B1\u0001\u0002R\tI!i\u001d9SKN,H\u000e^\u000b\u0005\u0003s\n)\t\u0005\u0004\u0002f\u0005-\u00141\u0010\t\u0007\u0017\u0006u\u0014+!!\n\u0007\u0005}DJ\u0001\u0004UkBdWM\r\t\u0006\u0003\u000fR\u00111\u0011\t\u0005\u0003\u0017\n)\tB\u0004\u0002P1\u0011\r!!\u0015\u0003\u001d\t\u001b\boQ8naV$\u0018\r^5p]V!\u00111RAK!\u0019Y\u0015QR)\u0002\u0012&\u0019\u0011q\u0012'\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#BA$\u0019\u0005M\u0005\u0003BA&\u0003+#q!a\u0014\u000e\u0005\u0004\t\t&A\u0007uCN\\\u0017\nZ\"pk:$XM]\u000b\u0002a\u0006qA/Y:l\u0013\u0012\u001cu.\u001e8uKJ\u0004\u0013!\u00032ta2{wmZ3s+\t\t\t\u000b\u0005\u0003\u0002\u000e\u0005\r\u0016\u0002BAS\u0003\u001f\u0011qBQ:q'\u0016\u0014h/\u001a:M_\u001e<WM]\u0001\u000bEN\u0004Hj\\4hKJ\u0004\u0013\u0001C:feZL7-Z:\u0016\u0005\u00055\u0006cA-\u00020&\u0019\u0011\u0011\u0017.\u0003\u0011M+'O^5dKN\f\u0011b]3sm&\u001cWm\u001d\u0011\u0002\u0019\r,(O]3oiN#\u0018\r^3\u0016\u0003E\u000b\u0001cY;se\u0016tGo\u0015;bi\u0016|F%Z9\u0015\t\u0005u\u00161\u0019\t\u0004\u0017\u0006}\u0016bAAa\u0019\n!QK\\5u\u0011!\t)-FA\u0001\u0002\u0004\t\u0016a\u0001=%c\u0005i1-\u001e:sK:$8\u000b^1uK\u0002B3AFAf!\rY\u0015QZ\u0005\u0004\u0003\u001fd%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002'M$\u0018\r^3BMR,'/\u0012=fGV$\u0018n\u001c8\u0002\u0017I,Gn\\1e'R\fG/\u001a\u000b\u0005\u0003/\fI\u000eE\u0003\u0002f\u0005-\u0014\u000bC\u0004\u0002\\b\u0001\r!!8\u0002\r\r|gNZ5h!\r\u0011\u0017q\\\u0005\u0004\u0003C\u001c'\u0001D!cg>dW\u000f^3QCRD\u0017!C:bm\u0016\u001cF/\u0019;f)\u0011\t9/!;\u0011\r\u0005\u0015\u00141NA_\u0011\u0019\tY/\u0007a\u0001#\u0006)1\u000f^1uK\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\t\u0005E(q\u0001\t\u0006\u0003\u000fZ\u00111\u001f\t\u0005\u0003k\u0014\u0019!\u0004\u0002\u0002x*\u0019Q)!?\u000b\u00075\u000bYP\u0003\u0003\u0002~\u0006}\u0018\u0001B3qM2T!A!\u0001\u0002\u0005\rD\u0017\u0002\u0002B\u0003\u0003o\u0014Q#\u00138ji&\fG.\u001b>f\u0005VLG\u000e\u001a*fgVdG\u000fC\u0004\u0003\ni\u0001\rAa\u0003\u0002\rA\f'/Y7t!\u0011\t)P!\u0004\n\t\t=\u0011q\u001f\u0002\u0016\u0013:LG/[1mSj,')^5mIB\u000b'/Y7t\u00035I7/\u00138ji&\fG.\u001b>fIV\u0011!Q\u0003\t\u0007\u0005/\u0011iB!\t\u000e\u0005\te!b\u0001B\u000e\u0019\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t}!\u0011\u0004\u0002\b!J|W.[:f!\u0015\t9ECA_\u00039I7/\u00138ji&\fG.\u001b>fI\u0002\n\u0011#[:J]&$\u0018.\u00197ju\u0016$G+Y:l+\t\u0011I\u0003\u0005\u0004\u0002f\u0005-$\u0011E\u0001\u0013SNLe.\u001b;jC2L'0\u001a3UCN\\\u0007%A\u0006j]&$\u0018.\u00197ju\u0016$G\u0003BA_\u0005cAqAa\r \u0001\u0004\u0011)$\u0001\fj]&$\u0018.\u00197ju\u0016$')^5mIB\u000b'/Y7t!\u0011\t)Pa\u000e\n\t\te\u0012q\u001f\u0002\u0017\u0013:LG/[1mSj,GMQ;jY\u0012\u0004\u0016M]1ng\u0006i\u0011NZ%oSRL\u0017\r\\5{K\u0012,BAa\u0010\u0003FQ!!\u0011\tB$!\u0015\t9e\u0003B\"!\u0011\tYE!\u0012\u0005\u000f\u0005=\u0003E1\u0001\u0002R!9!\u0011\n\u0011A\u0002\t-\u0013aB2p[B,H/\u001a\t\u0006\u0003\u000fj!1I\u0001\r[\u0006\u0004Hk\u001c)s_*,7\r\u001e\u000b\u0007\u0005#\u0012YHa \u0011\u0011\u0005=\u0012q\bB*\u0005G\u0002BA!\u0016\u0003^9!!q\u000bB-!\r\t\u0019\u0004T\u0005\u0004\u00057b\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003`\t\u0005$AB*ue&twMC\u0002\u0003\\1\u00032!a\u0012#\u00059\u0001&o\u001c6fGRl\u0015\r\u001d9j]\u001e\u0004raSA?\u0005S\u0012y\u0007\u0005\u0003\u0002v\n-\u0014\u0002\u0002B7\u0003o\u0014QCQ;jY\u0012$\u0016M]4fi&#WM\u001c;jM&,'\u000f\u0005\u0003\u0003r\t]TB\u0001B:\u0015\r\u0011)HR\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0003z\tM$a\u0002)s_*,7\r\u001e\u0005\b\u0005{\n\u0003\u0019\u0001B5\u0003\u0019!\u0018M]4fi\"1\u00111^\u0011A\u0002E\u000bQ\"\\1q)>\u0004&o\u001c6fGR\u001cHC\u0002BC\u0005\u001b\u0013\u0019\n\u0005\u0005\u00020\u0005}\"1\u000bBD!\u0019\tyC!#\u0003d%!!1RA\"\u0005\r\u0019V-\u001d\u0005\b\u0005\u001f\u001b\u0003\u0019\u0001BI\u0003\u001d!\u0018M]4fiN\u0004b!a\f\u0003\n\n%\u0004BBAvG\u0001\u0007\u0011+\u0001\u000ed_6\u0004\u0018\u000e\\3e)\u0006\u0014x-\u001a;t\u0003RdU-Y:u\u001f:\u001cW-\u0006\u0002\u0003\u001aBA!1\u0014BR\u0005S\u00129+\u0004\u0002\u0003\u001e*!!1\u0004BP\u0015\r\u0011\t\u000bT\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BS\u0005;\u0013q\u0001\u0016:jK6\u000b\u0007\u000fE\u0002L\u0005SK1Aa+M\u0005\u001d\u0011un\u001c7fC:\f1dY8na&dW\r\u001a+be\u001e,Go]!u\u0019\u0016\f7\u000f^(oG\u0016\u0004\u0013aD2p[BLG.\u001a)s_*,7\r^:\u0015\u0011\tM&1\u0018B`\u0005\u0003\u0004R!a\u0012\r\u0005k\u0003B!!>\u00038&!!\u0011XA|\u00055\u0019u.\u001c9jY\u0016\u0014Vm];mi\"9!Q\u0018\u0014A\u0002\t\u001d\u0015\u0001D;tKJ\u0004&o\u001c6fGR\u001c\bBBAvM\u0001\u0007\u0011\u000bC\u0004\u0003D\u001a\u0002\rA!2\u0002\u0017\r|W\u000e]5mK\u0006\u0013xm\u001d\t\u0007\u0003_\u00119Ma\u0015\n\t\t%\u00171\t\u0002\u0005\u0019&\u001cH/A\u0004d_6\u0004\u0018\u000e\\3\u0015\t\t='\u0011\u001b\t\u0006\u0003\u000fZ!Q\u0017\u0005\b\u0005\u00139\u0003\u0019\u0001Bj!\u0011\t)P!6\n\t\t]\u0017q\u001f\u0002\u000e\u0007>l\u0007/\u001b7f!\u0006\u0014\u0018-\\:\u0002\tQ,7\u000f\u001e\u000b\u0005\u0005;\u0014)\u000fE\u0003\u0002H-\u0011y\u000e\u0005\u0003\u0002v\n\u0005\u0018\u0002\u0002Br\u0003o\u0014!\u0002V3tiJ+7/\u001e7u\u0011\u001d\u0011I\u0001\u000ba\u0001\u0005O\u0004B!!>\u0003j&!!1^A|\u0005)!Vm\u001d;QCJ\fWn]\u0001\u0004eVtG\u0003\u0002By\u0005s\u0004R!a\u0012\f\u0005g\u0004B!!>\u0003v&!!q_A|\u0005%\u0011VO\u001c*fgVdG\u000fC\u0004\u0003\n%\u0002\rAa?\u0011\t\u0005U(Q`\u0005\u0005\u0005\u007f\f9PA\u0005Sk:\u0004\u0016M]1ng\u0006yAo\u001c\"vS2$G+\u0019:hKRLE\r\u0006\u0003\u0003j\r\u0015\u0001bBB\u0004U\u0001\u0007!qN\u0001\baJ|'.Z2u\u0003I!xnU2bY\u0006\u0014U/\u001b7e)\u0006\u0014x-\u001a;\u0015\r\r511CB\u000b!\u0011\t)pa\u0004\n\t\rE\u0011q\u001f\u0002\u0011'\u000e\fG.\u0019\"vS2$G+\u0019:hKRDqaa\u0002,\u0001\u0004\u0011y\u0007C\u0004\u0004\u0018-\u0002\ra!\u0007\u0002\u0011%t7\u000f^1oG\u0016\u0004Baa\u0007\u0004\u001e5\ta)C\u0002\u0004 \u0019\u0013QbU2bY\u0006Len\u001d;b]\u000e,\u0017\u0001\u00042vS2$G+\u0019:hKR\u001cH\u0003BB\u0013\u0007[\u0001R!a\u0012\f\u0007O\u0001B!!>\u0004*%!11FA|\u0005U9vN]6ta\u0006\u001cWMQ;jY\u0012$\u0016M]4fiNDqaa\f-\u0001\u0004\u0019\t$A\u0004sKF,Xm\u001d;\u0011\t\u0005U81G\u0005\u0005\u0007k\t9P\u0001\u000fX_J\\7\u000f]1dK\n+\u0018\u000e\u001c3UCJ<W\r^:SKF,Xm\u001d;\u0002\u000fM|WO]2fgR!11HB\"!\u0015\t9eCB\u001f!\u0011\t)pa\u0010\n\t\r\u0005\u0013q\u001f\u0002\u000e'>,(oY3t%\u0016\u001cX\u000f\u001c;\t\u000f\r=R\u00061\u0001\u0004FA!\u0011Q_B$\u0013\u0011\u0019I%a>\u0003\u001bM{WO]2fgB\u000b'/Y7t\u0003E!W\r]3oI\u0016t7-_*pkJ\u001cWm\u001d\u000b\u0005\u0007\u001f\u001a9\u0006E\u0003\u0002H-\u0019\t\u0006\u0005\u0003\u0002v\u000eM\u0013\u0002BB+\u0003o\u0014q\u0003R3qK:$WM\\2z'>,(oY3t%\u0016\u001cX\u000f\u001c;\t\u000f\r=b\u00061\u0001\u0004ZA!\u0011Q_B.\u0013\u0011\u0019i&a>\u0003/\u0011+\u0007/\u001a8eK:\u001c\u0017pU8ve\u000e,7\u000fU1sC6\u001c\u0018!D:dC2\f7m\u00149uS>t7\u000f\u0006\u0003\u0004d\r-\u0004#BA$\u0017\r\u0015\u0004\u0003BA{\u0007OJAa!\u001b\u0002x\n\u00192kY1mC\u000e|\u0005\u000f^5p]N\u0014Vm];mi\"91qF\u0018A\u0002\r5\u0004\u0003BA{\u0007_JAa!\u001d\u0002x\n\u00192kY1mC\u000e|\u0005\u000f^5p]N\u0004\u0016M]1ng\u0006Q\u0011n]*ikR$wn\u001e8\u0002\u0017%\u001c8\u000b[;uI><h\u000eI\u0001\u000fSN\u001c\u0006.\u001e;e_^tG+Y:l\u0003=I7o\u00155vi\u0012|wO\u001c+bg.\u0004\u0013\u0001C:ikR$wn\u001e8\u0015\t\u0005u6q\u0010\u0005\b\u0007w\"\u0004\u0019ABA!\u0011\t)pa!\n\t\r\u0015\u0015q\u001f\u0002\t'\",H\u000fZ8x]\u0006!Q\r_5u)\u0011\t9oa#\t\u000f\rmT\u00071\u0001\u0004\u000eB!\u0011Q_BH\u0013\u0011\u0019\t*a>\u0003\t\u0015C\u0018\u000e^\u0001\u0011\u00052|w\u000e\u001d\"taN+'O^5dKN\u0004\"!`\u001c\u0014\u0005]RECABK\u0003\u001d\u0019w.\u001e8uKJ,\"aa(\u0011\t\r\u000561V\u0007\u0003\u0007GS1a]BS\u0015\u0011\u0011Yba*\u000b\u0007\r%6.\u0001\u0003vi&d\u0017\u0002BBW\u0007G\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018\u0001C2pk:$XM\u001d\u0011\u0002!\u0011+g-Y;mi2\u000bgnZ;bO\u0016\u001cXCAB[!\u0019\u00199l!0\u0004@6\u00111\u0011\u0018\u0006\u0005\u0007w\u0013y*A\u0005j[6,H/\u00192mK&!!\u0011ZB]!\u0011\u0019\tma2\u000e\u0005\r\r'bABcW\u0006!A.\u00198h\u0013\u0011\u0011yfa1\u0002#\u0011+g-Y;mi2\u000bgnZ;bO\u0016\u001c\b%\u0001\fEK\u001a\fW\u000f\u001c;D_6\u0004\u0018\u000e\\3Qe>4\u0018\u000eZ3s+\t\u0019y\r\u0005\u0003\u0002v\u000eE\u0017\u0002BBj\u0003o\u0014qbQ8na&dW\r\u0015:pm&$WM]\u0001\u0018\t\u00164\u0017-\u001e7u\u0007>l\u0007/\u001b7f!J|g/\u001b3fe\u0002\n1\u0003R3gCVdG\u000fV3tiB\u0013xN^5eKJ,\"aa7\u0011\t\u0005U8Q\\\u0005\u0005\u0007?\f9P\u0001\u0007UKN$\bK]8wS\u0012,'/\u0001\u000bEK\u001a\fW\u000f\u001c;UKN$\bK]8wS\u0012,'\u000fI\u0001\u0013\t\u00164\u0017-\u001e7u%Vt\u0007K]8wS\u0012,'/\u0006\u0002\u0004hB!\u0011Q_Bu\u0013\u0011\u0019Y/a>\u0003\u0017I+h\u000e\u0015:pm&$WM]\u0001\u0014\t\u00164\u0017-\u001e7u%Vt\u0007K]8wS\u0012,'\u000f\t")
public final class BloopBspServices {
    private final State callSiteState;
    private final JsonRpcClient client;
    private final Path relativeConfigPath;
    private final InputStream socketInput;
    private final AtomicInt exitStatus;
    private final DebugFilter debugFilter;
    private final AtomicInt taskIdCounter;
    private final BspServerLogger bspLogger;
    private final Services services;
    private volatile State currentState;
    private final Promise<Either<Response.Error, BoxedUnit>> isInitialized;
    private final Task<Either<Response.Error, BoxedUnit>> isInitializedTask;
    private final TrieMap<BuildTargetIdentifier, Object> compiledTargetsAtLeastOnce;
    private final Promise<Either<Response.Error, BoxedUnit>> isShutdown;
    private final Task<Either<Response.Error, BoxedUnit>> isShutdownTask;

    private DebugFilter debugFilter() {
        return this.debugFilter;
    }

    private AtomicInt taskIdCounter() {
        return this.taskIdCounter;
    }

    private BspServerLogger bspLogger() {
        return this.bspLogger;
    }

    public final Services services() {
        return this.services;
    }

    private State currentState() {
        return this.currentState;
    }

    private void currentState_$eq(State x$1) {
        this.currentState = x$1;
    }

    public State stateAfterExecution() {
        State qual$1 = this.currentState();
        Logger x$1 = this.callSiteState.logger();
        Build x$2 = qual$1.copy$default$1();
        ResultsCache x$3 = qual$1.copy$default$2();
        CompilerCache x$4 = qual$1.copy$default$3();
        ClientPool x$5 = qual$1.copy$default$4();
        CommonOptions x$6 = qual$1.copy$default$5();
        ExitStatus x$7 = qual$1.copy$default$6();
        return qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1);
    }

    private Task<State> reloadState(Path config) {
        ClientPool pool = this.currentState().pool();
        CommonOptions defaultOpts = this.currentState().commonOptions();
        this.bspLogger().debug(new StringBuilder(24).append("Reloading bsp state for ").append(AbsolutePath$.MODULE$.syntax$extension(config)).toString(), this.debugFilter());
        return State$.MODULE$.loadActiveStateFor(config, pool, defaultOpts, this.bspLogger()).map((Function1 & Serializable & scala.Serializable)state0 -> {
            void var2_9;
            BspServerLogger x$1 = this.bspLogger();
            Build x$2 = state0.copy$default$1();
            ResultsCache x$3 = state0.copy$default$2();
            CompilerCache x$4 = state0.copy$default$3();
            ClientPool x$5 = state0.copy$default$4();
            CommonOptions x$6 = state0.copy$default$5();
            ExitStatus x$7 = state0.copy$default$6();
            State newState = state0.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1);
            this.currentState_$eq(newState);
            return var2_9;
        });
    }

    private Task<BoxedUnit> saveState(State state) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path configDir = state.build().origin();
            this.bspLogger().debug(new StringBuilder(21).append("Saving bsp state for ").append(AbsolutePath$.MODULE$.syntax$extension(configDir)).toString(), this.debugFilter());
            Function1 & Serializable & scala.Serializable persistOut = (Function1 & Serializable & scala.Serializable)msg -> {
                BloopBspServices.$anonfun$saveState$2(this, msg);
                return BoxedUnit.UNIT;
            };
            Tasks$.MODULE$.persist(state, (Function1<String, BoxedUnit>)persistOut).runAsync(ExecutionContext$.MODULE$.scheduler());
            State$.MODULE$.stateCache().updateBuild(state);
        });
    }

    public Task<Either<Response.Error, InitializeBuildResult>> initialize(InitializeBuildParams params) {
        URI uri = new URI(params.rootUri().value());
        Path configDir = AbsolutePath$.MODULE$.resolve$extension0(AbsolutePath$.MODULE$.apply(uri), this.relativeConfigPath);
        return this.reloadState(configDir).map((Function1 & Serializable & scala.Serializable)state -> {
            $this.callSiteState.logger().info("request received: build/initialize");
            return package$.MODULE$.Right().apply((Object)new InitializeBuildResult(BuildInfo$.MODULE$.bloopName(), BuildInfo$.MODULE$.version(), BuildInfo$.MODULE$.bspVersion(), new BuildServerCapabilities((Option)new Some((Object)BloopBspServices$.MODULE$.DefaultCompileProvider()), (Option)new Some((Object)BloopBspServices$.MODULE$.DefaultTestProvider()), (Option)new Some((Object)BloopBspServices$.MODULE$.DefaultRunProvider()), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false))), (Option)None$.MODULE$));
        });
    }

    public Promise<Either<Response.Error, BoxedUnit>> isInitialized() {
        return this.isInitialized;
    }

    public Task<Either<Response.Error, BoxedUnit>> isInitializedTask() {
        return this.isInitializedTask;
    }

    public void initialized(InitializedBuildParams initializedBuildParams) {
        this.isInitialized().success((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        this.callSiteState.logger().info("BSP initialization handshake complete.");
    }

    public <T> Task<Either<Response.Error, T>> ifInitialized(Function1<State, Task<Tuple2<State, Either<Response.Error, T>>>> compute) {
        return this.isInitializedTask().timeoutTo(FiniteDuration$.MODULE$.apply(1L, TimeUnit.SECONDS), Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)Response$.MODULE$.invalidRequest("The session has not been initialized.")))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Task task;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Response.Error e = (Response.Error)left.value();
                task = Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)e));
            } else if (either instanceof Right) {
                task = this.reloadState(this.currentState().build().origin()).flatMap((Function1 & Serializable & scala.Serializable)state -> ((Task)compute.apply(state)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    State state = (State)tuple2._1();
                    Either e = (Either)tuple2._2();
                    Task task = this.saveState(state).map((Function1 & Serializable & scala.Serializable)x$12 -> e);
                    return task;
                }));
            } else {
                throw new MatchError((Object)either);
            }
            return task;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, Tuple2<BuildTargetIdentifier, Project>> mapToProject(BuildTargetIdentifier target, State state) {
        Uri uri = target.uri();
        boolean bl = false;
        Right right = null;
        Either<String, Option<Project>> either = ProjectUris$.MODULE$.getProjectDagFromUri(uri.value(), state);
        if (either instanceof Left) {
            Left left = (Left)either;
            String errorMsg = (String)left.value();
            return package$.MODULE$.Left().apply((Object)errorMsg);
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (option instanceof Some) {
                Some some = (Some)option;
                Project project = (Project)some.value();
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)target, (Object)project));
            }
        }
        if (!bl) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!None$.MODULE$.equals(option)) throw new MatchError(either);
        return package$.MODULE$.Left().apply((Object)new StringBuilder(27).append("No project associated with ").append(uri).toString());
    }

    private Either<String, Seq<Tuple2<BuildTargetIdentifier, Project>>> mapToProjects(Seq<BuildTargetIdentifier> targets, State state) {
        Left left;
        Option option = targets.headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            BuildTargetIdentifier head = (BuildTargetIdentifier)some.value();
            Either init = this.mapToProject(head, state).map((Function1 & Serializable & scala.Serializable)m -> {
                Tuple2 tuple2 = m;
                return Nil$.MODULE$.$colon$colon((Object)tuple2);
            });
            left = (Either)((TraversableOnce)targets.tail()).foldLeft((Object)init, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Either acc = (Either)tuple2._1();
                BuildTargetIdentifier t = (BuildTargetIdentifier)tuple2._2();
                Either either = acc.flatMap((Function1 & Serializable & scala.Serializable)ms -> this.mapToProject(t, state).map((Function1 & Serializable & scala.Serializable)m -> {
                    Tuple2 tuple2 = m;
                    return ms.$colon$colon((Object)tuple2);
                }));
                return either;
            });
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)"Empty build targets. Expected at least one build target identifier.");
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    private TrieMap<BuildTargetIdentifier, Object> compiledTargetsAtLeastOnce() {
        return this.compiledTargetsAtLeastOnce;
    }

    public Task<Tuple2<State, Either<Response.Error, CompileResult>>> compileProjects(Seq<Tuple2<BuildTargetIdentifier, Project>> userProjects, State state, List<String> compileArgs) {
        Promise cancelCompilation = Promise$.MODULE$.apply();
        boolean pipeline = compileArgs.exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BloopBspServices.$anonfun$compileProjects$1(x$15)));
        List<Project> projects0 = Dag$.MODULE$.reduce(state.build().dags(), ((TraversableOnce)userProjects.map((Function1 & Serializable & scala.Serializable)x$16 -> (Project)x$16._2(), Seq$.MODULE$.canBuildFrom())).toSet()).toList();
        List<Project> projects = !compileArgs.exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)BloopBspServices.$anonfun$compileProjects$6(x$17))) ? projects0 : Dag$.MODULE$.inverseDependencies(state.build().dags(), projects0).reduced();
        return this.compile$1(projects, state, pipeline, cancelCompilation).map((Function1 & Serializable & scala.Serializable)newState -> {
            Right right;
            List<Tuple2<Project, Compiler.Result>> compiledResults = state.results().diffLatest(newState.results());
            List errorMsgs = (List)compiledResults.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Nil$ nil$;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Project p = (Project)tuple2._1();
                Compiler.Result result = (Compiler.Result)tuple2._2();
                Compiler.Result result2 = result;
                if (Compiler.Result$.Empty$.MODULE$.equals(result2)) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                } else if (result2 instanceof Compiler.Result$.Blocked) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                } else if (result2 instanceof Compiler.Result$.Success) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                } else if (result2 instanceof Compiler.Result$.GlobalError) {
                    Compiler.Result$.GlobalError globalError = (Compiler.Result$.GlobalError)result2;
                    String problem = globalError.problem();
                    nil$ = new .colon.colon((Object)problem, (List)Nil$.MODULE$);
                    return nil$;
                } else if (result2 instanceof Compiler.Result$.Cancelled) {
                    Compiler.Result$.Cancelled cancelled = (Compiler.Result$.Cancelled)result2;
                    List problems = cancelled.problems();
                    long elapsed = cancelled.elapsed();
                    nil$ = new .colon.colon((Object)BloopBspServices.reportError$1(p, problems, elapsed), (List)Nil$.MODULE$);
                    return nil$;
                } else {
                    .colon.colon colon2;
                    if (!(result2 instanceof Compiler.Result$.Failed)) throw new MatchError((Object)result2);
                    Compiler.Result$.Failed failed = (Compiler.Result$.Failed)result2;
                    List problems = failed.problems();
                    Option t = failed.t();
                    long elapsed = failed.elapsed();
                    .colon.colon acc = new .colon.colon((Object)BloopBspServices.reportError$1(p, problems, elapsed), (List)Nil$.MODULE$);
                    Option option = t;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Throwable t2 = (Throwable)some.value();
                        String string = new StringBuilder(31).append("Bloop error when compiling ").append(p.name()).append(": '").append(t2.getMessage()).append("'").toString();
                        colon2 = acc.$colon$colon((Object)string);
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        colon2 = acc;
                    }
                    nil$ = colon2;
                }
                return nil$;
            }, List$.MODULE$.canBuildFrom());
            if (cancelCompilation.isCompleted()) {
                right = package$.MODULE$.Right().apply((Object)new CompileResult((Option)None$.MODULE$, (StatusCode)StatusCode.Cancelled$.MODULE$, (Option)None$.MODULE$));
            } else {
                List list = errorMsgs;
                Right right2 = Nil$.MODULE$.equals(list) ? package$.MODULE$.Right().apply((Object)new CompileResult((Option)None$.MODULE$, (StatusCode)StatusCode.Ok$.MODULE$, (Option)None$.MODULE$)) : package$.MODULE$.Right().apply((Object)new CompileResult((Option)None$.MODULE$, (StatusCode)StatusCode.Error$.MODULE$, (Option)None$.MODULE$));
                right = right2;
            }
            Right response = right;
            return new Tuple2(newState, (Object)response);
        });
    }

    public Task<Either<Response.Error, CompileResult>> compile(CompileParams params) {
        return this.ifInitialized((Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            Either<String, Seq<Tuple2<BuildTargetIdentifier, Project>>> either = this.mapToProjects((Seq<BuildTargetIdentifier>)params.targets(), (State)state);
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                this.bspLogger().error(error);
                task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Right().apply((Object)new CompileResult((Option)None$.MODULE$, (StatusCode)StatusCode.Error$.MODULE$, (Option)None$.MODULE$))));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq mappings = (Seq)right.value();
                List compileArgs = (List)params.arguments().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                task = this.compileProjects((Seq<Tuple2<BuildTargetIdentifier, Project>>)mappings, (State)state, (List<String>)compileArgs);
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    public Task<Either<Response.Error, TestResult>> test(TestParams params) {
        return this.ifInitialized((Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            Either<String, Seq<Tuple2<BuildTargetIdentifier, Project>>> either = this.mapToProjects((Seq<BuildTargetIdentifier>)params.targets(), (State)state);
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                this.bspLogger().error(error);
                task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Right().apply((Object)new TestResult((Option)None$.MODULE$, (StatusCode)StatusCode.Error$.MODULE$, (Option)None$.MODULE$))));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq mappings = (Seq)right.value();
                List args = (List)params.arguments().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                task = this.compileProjects((Seq<Tuple2<BuildTargetIdentifier, Project>>)mappings, (State)state, (List<String>)args).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Task task;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    State newState = (State)tuple2._1();
                    Either compileResult = (Either)tuple2._2();
                    Either either = compileResult;
                    if (either instanceof Right) {
                        Task sequentialTestExecution = (Task)mappings.foldLeft((Object)Task$.MODULE$.now((Object)newState), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                            Tuple2 tuple2;
                            Task taskState;
                            block3: {
                                Tuple2 tuple22;
                                block2: {
                                    tuple22 = new Tuple2(x0$2, x1$1);
                                    if (tuple22 == null) break block2;
                                    taskState = (Task)tuple22._1();
                                    tuple2 = (Tuple2)tuple22._2();
                                    if (tuple2 != null) break block3;
                                }
                                throw new MatchError((Object)tuple22);
                            }
                            BuildTargetIdentifier tid = (BuildTargetIdentifier)tuple2._1();
                            Project p = (Project)tuple2._2();
                            Task task = taskState.flatMap((Function1 & Serializable & scala.Serializable)state -> this.test$1(tid, p, (State)state));
                            return task;
                        });
                        task = sequentialTestExecution.materialize().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.toEither()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            Tuple2 tuple2;
                            Either either = x0$3;
                            if (either instanceof Right) {
                                Right right = (Right)either;
                                State newState = (State)right.value();
                                tuple2 = new Tuple2((Object)newState, (Object)package$.MODULE$.Right().apply((Object)new TestResult((Option)None$.MODULE$, (StatusCode)StatusCode.Ok$.MODULE$, (Option)None$.MODULE$)));
                            } else if (either instanceof Left) {
                                Left left = (Left)either;
                                Throwable e = (Throwable)left.value();
                                Response.Error errorMessage = Response$.MODULE$.internalError(new StringBuilder(23).append("Failed test execution: ").append(e.getMessage()).toString());
                                tuple2 = new Tuple2((Object)newState, (Object)package$.MODULE$.Left().apply((Object)errorMessage));
                            } else {
                                throw new MatchError((Object)either);
                            }
                            return tuple2;
                        });
                        return task;
                    } else {
                        if (!(either instanceof Left)) throw new MatchError((Object)either);
                        Left left = (Left)either;
                        Response.Error error = (Response.Error)left.value();
                        task = Task$.MODULE$.now((Object)new Tuple2((Object)newState, (Object)package$.MODULE$.Left().apply((Object)error)));
                    }
                    return task;
                });
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    public Task<Either<Response.Error, RunResult>> run(RunParams params) {
        return this.ifInitialized((Function1 & Serializable & scala.Serializable)state -> {
            Right right;
            Tuple2 tuple2;
            Task task;
            Either<String, Tuple2<BuildTargetIdentifier, Project>> either = this.mapToProject(params.target(), (State)state);
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                this.bspLogger().error(error);
                task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Right().apply((Object)new RunResult((Option)None$.MODULE$, (StatusCode)StatusCode.Error$.MODULE$))));
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                BuildTargetIdentifier tid = (BuildTargetIdentifier)tuple2._1();
                Project project = (Project)tuple2._2();
                List args = (List)params.arguments().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                task = this.compileProjects((Seq<Tuple2<BuildTargetIdentifier, Project>>)new .colon.colon((Object)new Tuple2((Object)tid, (Object)project), (List)Nil$.MODULE$), (State)state, (List<String>)args).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Task task;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    State newState = (State)tuple2._1();
                    Either compileResult = (Either)tuple2._2();
                    Either either = compileResult;
                    if (either instanceof Right) {
                        BooleanRef isCancelled = BooleanRef.create((boolean)false);
                        task = BloopBspServices.run$1(tid, project, newState).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            isCancelled$1.elem = true;
                        })).materialize().map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.toEither()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2;
                            Either either = x0$2;
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                Throwable e = (Throwable)left.value();
                                Response.Error errorMsg = Response$.MODULE$.internalError(new StringBuilder(23).append("Failed test execution: ").append(e.getMessage()).toString());
                                tuple2 = new Tuple2(state, (Object)package$.MODULE$.Left().apply((Object)errorMsg));
                            } else if (either instanceof Right) {
                                Right right = (Right)either;
                                State state = (State)right.value();
                                ExitStatus exitStatus = state.status();
                                StatusCode.Cancelled$ status = isCancelled$1.elem ? StatusCode.Cancelled$.MODULE$ : (exitStatus.isOk() ? StatusCode.Ok$.MODULE$ : StatusCode.Error$.MODULE$);
                                tuple2 = new Tuple2((Object)state, (Object)package$.MODULE$.Right().apply((Object)new RunResult((Option)None$.MODULE$, (StatusCode)status)));
                            } else {
                                throw new MatchError((Object)either);
                            }
                            return tuple2;
                        });
                        return task;
                    } else {
                        if (!(either instanceof Left)) throw new MatchError((Object)either);
                        Left left = (Left)either;
                        Response.Error error = (Response.Error)left.value();
                        task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Left().apply((Object)error)));
                    }
                    return task;
                });
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    private BuildTargetIdentifier toBuildTargetId(Project project) {
        return new BuildTargetIdentifier(project.bspUri());
    }

    public ScalaBuildTarget toScalaBuildTarget(Project project, ScalaInstance instance) {
        ScalaPlatform.Jvm$ jvm$;
        List jars = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instance.allJars())).iterator().map((Function1 & Serializable & scala.Serializable)j -> Uri$.MODULE$.apply(j.toPath().toUri())).toList();
        Platform platform = project.platform();
        if (platform instanceof Platform.Jvm) {
            jvm$ = ScalaPlatform.Jvm$.MODULE$;
        } else if (platform instanceof Platform.Js) {
            jvm$ = ScalaPlatform.Js$.MODULE$;
        } else if (platform instanceof Platform.Native) {
            jvm$ = ScalaPlatform.Native$.MODULE$;
        } else {
            throw new MatchError((Object)platform);
        }
        ScalaPlatform.Jvm$ platform2 = jvm$;
        return new ScalaBuildTarget(instance.organization(), instance.version(), BloopBspServices.toBinaryScalaVersion$1(instance.version()), (ScalaPlatform)platform2, jars);
    }

    public Task<Either<Response.Error, WorkspaceBuildTargets>> buildTargets(WorkspaceBuildTargetsRequest request) {
        return this.ifInitialized((Function1 & Serializable & scala.Serializable)state2 -> Validate$.MODULE$.validateBuildForCLICommands((State)state2, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$24 -> {
            this.reportBuildError$1(x$24);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            ExitStatus exitStatus = state.status();
            ExitStatus exitStatus2 = ExitStatus$.MODULE$.BuildDefinitionError();
            if (!(exitStatus != null ? !((Object)exitStatus).equals(exitStatus2) : exitStatus2 != null)) {
                task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Right().apply((Object)new WorkspaceBuildTargets((List)Nil$.MODULE$))));
            } else {
                Build build = state.build();
                WorkspaceBuildTargets targets = new WorkspaceBuildTargets((List)build.projects().map((Function1 & Serializable & scala.Serializable)p -> {
                    BuildTargetIdentifier id = this.toBuildTargetId((Project)p);
                    String tag = p.name().endsWith("-test") && build.getProjectFor(new StringBuilder(5).append(p.name()).append("-test").toString()).isEmpty() ? BuildTargetTag$.MODULE$.Test() : BuildTargetTag$.MODULE$.Library();
                    Iterator deps = p.dependencies().iterator().flatMap((Function1 & Serializable & scala.Serializable)x$25 -> build.getProjectFor((String)x$25).toList());
                    Option extra = p.scalaInstance().map((Function1 & Serializable & scala.Serializable)i -> ScalaBuildTarget$.MODULE$.encodeScalaBuildTarget().apply((Object)this.toScalaBuildTarget((Project)p, (ScalaInstance)i)));
                    BuildTargetCapabilities capabilities = new BuildTargetCapabilities(true, true, true);
                    BuildTargetIdentifier x$1 = id;
                    Some x$2 = new Some((Object)p.name());
                    Some x$3 = new Some((Object)Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspUri$extension(p.baseDirectory())));
                    .colon.colon x$4 = new .colon.colon((Object)tag, (List)Nil$.MODULE$);
                    List<String> x$5 = BloopBspServices$.MODULE$.DefaultLanguages();
                    List x$6 = deps.map((Function1 & Serializable & scala.Serializable)project -> this.toBuildTargetId((Project)project)).toList();
                    BuildTargetCapabilities x$7 = capabilities;
                    Option x$8 = extra;
                    return new BuildTarget(x$1, (Option)x$2, (Option)x$3, (List)x$4, x$7, x$5, x$6, x$8);
                }, List$.MODULE$.canBuildFrom()));
                task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Right().apply((Object)targets)));
            }
            return task;
        }));
    }

    public Task<Either<Response.Error, SourcesResult>> sources(SourcesParams request) {
        return this.ifInitialized((Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            Either<String, Seq<Tuple2<BuildTargetIdentifier, Project>>> either = this.mapToProjects((Seq<BuildTargetIdentifier>)request.targets(), (State)state);
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                this.bspLogger().error(error);
                task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Right().apply((Object)new SourcesResult((List)Nil$.MODULE$))));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq mappings = (Seq)right.value();
                task = BloopBspServices.sources$1(mappings, state);
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    public Task<Either<Response.Error, DependencySourcesResult>> dependencySources(DependencySourcesParams request) {
        return this.ifInitialized((Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            Either<String, Seq<Tuple2<BuildTargetIdentifier, Project>>> either = this.mapToProjects((Seq<BuildTargetIdentifier>)request.targets(), (State)state);
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                this.bspLogger().error(error);
                task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Right().apply((Object)new DependencySourcesResult((List)Nil$.MODULE$))));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq mappings = (Seq)right.value();
                task = BloopBspServices.sources$2(mappings, state);
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    public Task<Either<Response.Error, ScalacOptionsResult>> scalacOptions(ScalacOptionsParams request) {
        return this.ifInitialized((Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            Either<String, Seq<Tuple2<BuildTargetIdentifier, Project>>> either = this.mapToProjects((Seq<BuildTargetIdentifier>)request.targets(), (State)state);
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                this.bspLogger().error(error);
                task = Task$.MODULE$.now((Object)new Tuple2(state, (Object)package$.MODULE$.Right().apply((Object)new ScalacOptionsResult((List)Nil$.MODULE$))));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq mappings = (Seq)right.value();
                task = BloopBspServices.scalacOptions$1(mappings, state);
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    public Promise<Either<Response.Error, BoxedUnit>> isShutdown() {
        return this.isShutdown;
    }

    public Task<Either<Response.Error, BoxedUnit>> isShutdownTask() {
        return this.isShutdownTask;
    }

    public void shutdown(Shutdown shutdown) {
        this.isShutdown().success((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        this.callSiteState.logger().info("shutdown request received: build/shutdown");
    }

    public Task<BoxedUnit> exit(Exit shutdown) {
        return this.isShutdownTask().timeoutTo(FiniteDuration$.MODULE$.apply(1L, TimeUnit.SECONDS), Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BloopBspServices.$anonfun$exit$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$saveState$2(BloopBspServices $this, String msg) {
        $this.bspLogger().debug(msg, $this.debugFilter());
    }

    private static final String reportError$1(Project p, List problems, long elapsedMs) {
        Problem.DiagnosticsCount count = Problem$.MODULE$.count(problems);
        return new StringBuilder(15).append(p.name()).append(" [").append(elapsedMs).append("ms] (errors ").append(count.errors()).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$compileProjects$1(String x$15) {
        String string = x$15;
        String string2 = "--pipeline";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ BspProjectReporter $anonfun$compileProjects$2(BloopBspServices $this, ReporterConfig config$1, Project project, Path cwd) {
        boolean bl;
        BuildTargetIdentifier btid = new BuildTargetIdentifier(project.bspUri());
        Option option = $this.compiledTargetsAtLeastOnce().putIfAbsent((Object)btid, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (option instanceof Some) {
            bl = false;
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError((Object)option);
        }
        boolean reportAllPreviousProblems = bl;
        return new BspProjectReporter(project, $this.bspLogger(), cwd, (Function1<Position, Position>)(Function1 & Serializable & scala.Serializable)x -> (Position)Predef$.MODULE$.identity(x), config$1, reportAllPreviousProblems, BspProjectReporter$.MODULE$.$lessinit$greater$default$7());
    }

    private final Task compile$1(List projects, State state$3, boolean pipeline$1, Promise cancelCompilation$1) {
        Path cwd2 = AbsolutePath$.MODULE$.getParent$extension(state$3.build().origin());
        boolean x$1 = false;
        boolean x$2 = ReporterConfig$.MODULE$.defaultFormat().copy$default$1();
        boolean x$3 = ReporterConfig$.MODULE$.defaultFormat().copy$default$2();
        boolean x$4 = ReporterConfig$.MODULE$.defaultFormat().copy$default$3();
        boolean x$5 = ReporterConfig$.MODULE$.defaultFormat().copy$default$5();
        String x$6 = ReporterConfig$.MODULE$.defaultFormat().copy$default$6();
        String x$7 = ReporterConfig$.MODULE$.defaultFormat().copy$default$7();
        String x$8 = ReporterConfig$.MODULE$.defaultFormat().copy$default$8();
        String x$9 = ReporterConfig$.MODULE$.defaultFormat().copy$default$9();
        String x$10 = ReporterConfig$.MODULE$.defaultFormat().copy$default$10();
        String x$11 = ReporterConfig$.MODULE$.defaultFormat().copy$default$11();
        Function1 x$12 = ReporterConfig$.MODULE$.defaultFormat().copy$default$12();
        ReporterConfig config = ReporterConfig$.MODULE$.defaultFormat().copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
        Function2 & Serializable & scala.Serializable createReporter = (Function2 & Serializable & scala.Serializable)(project, cwd) -> BloopBspServices.$anonfun$compileProjects$2(this, config, project, ((AbsolutePath)cwd).underlying());
        Aggregate<Project> dag = new Aggregate<Project>((List)projects.map((Function1 & Serializable & scala.Serializable)p -> state$3.build().getDagFor((Project)p), List$.MODULE$.canBuildFrom()));
        return CompilationTask$.MODULE$.compile(state$3, dag, (Function2<Project, Path, Reporter>)createReporter, (CompileMode.ConfigurableMode)CompileMode.Sequential$.MODULE$, pipeline$1, false, (Promise<BoxedUnit>)cancelCompilation$1);
    }

    public static final /* synthetic */ boolean $anonfun$compileProjects$6(String x$17) {
        String string = x$17;
        String string2 = "--cascade";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Task test$1(BuildTargetIdentifier id, Project project, State state) {
        Function1<String, Object> testFilter = TestInternals$.MODULE$.parseFilters((List<String>)Nil$.MODULE$);
        BspLoggingEventHandler handler = new BspLoggingEventHandler(id, state.logger(), this.client);
        return Tasks$.MODULE$.test(state, (List<Project>)new .colon.colon((Object)project, (List)Nil$.MODULE$), (List<String>)Nil$.MODULE$, testFilter, handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Task run$1(BuildTargetIdentifier id, Project project, State state2) {
        Task task;
        Path cwd = state2.commonOptions().workingPath();
        Commands.Run cmd = new Commands.Run((List<String>)new .colon.colon((Object)project.name(), (List)Nil$.MODULE$), Commands$Run$.MODULE$.apply$default$2(), Commands$Run$.MODULE$.apply$default$3(), Commands$Run$.MODULE$.apply$default$4(), Commands$Run$.MODULE$.apply$default$5(), Commands$Run$.MODULE$.apply$default$6(), Commands$Run$.MODULE$.apply$default$7(), Commands$Run$.MODULE$.apply$default$8(), Commands$Run$.MODULE$.apply$default$9(), Commands$Run$.MODULE$.apply$default$10());
        Either<State, String> either = Interpreter$.MODULE$.getMainClass(state2, project, cmd.main());
        if (either instanceof Left) {
            Task$ task$ = Task$.MODULE$;
            throw scala.sys.package$.MODULE$.error(new StringBuilder(28).append("Failed to run main class in ").append(project.name()).toString());
        }
        if (!(either instanceof Right)) throw new MatchError(either);
        Right right = (Right)either;
        String mainClass = (String)right.value();
        Platform platform = project.platform();
        if (platform instanceof Platform.Jvm) {
            Platform.Jvm jvm = (Platform.Jvm)platform;
            JavaEnv javaEnv = jvm.env();
            task = Tasks$.MODULE$.runJVM(state2, project, javaEnv, cwd, mainClass, (String[])cmd.args().toArray(ClassTag$.MODULE$.apply(String.class)), false);
            return task;
        } else if (platform instanceof Platform.Native) {
            Platform.Native native_ = (Platform.Native)platform;
            Config.NativeConfig config = native_.config();
            Path target = ScalaNativeToolchain$.MODULE$.linkTargetFrom(project, config);
            task = LinkTask$.MODULE$.linkMainWithNative(cmd, project, state2, mainClass, target, native_).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                String string = AbsolutePath$.MODULE$.syntax$extension(target);
                String[] args = (String[])((TraversableOnce)cmd.args().$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                return !state.status().isOk() ? Task$.MODULE$.now(state) : Tasks$.MODULE$.runNativeOrJs((State)state, project, cwd, mainClass, args);
            });
            return task;
        } else {
            if (!(platform instanceof Platform.Js)) throw new MatchError((Object)platform);
            Platform.Js js = (Platform.Js)platform;
            Config.JsConfig config = js.config();
            Path target = ScalaJsToolchain$.MODULE$.linkTargetFrom(project, config);
            task = LinkTask$.MODULE$.linkMainWithJs(cmd, project, state2, mainClass, target, js).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                String string = "node";
                String string2 = AbsolutePath$.MODULE$.syntax$extension(target);
                String[] args = (String[])((TraversableOnce)((List)cmd.args().$plus$colon((Object)string2, List$.MODULE$.canBuildFrom())).$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                return !state.status().isOk() ? Task$.MODULE$.now(state) : Tasks$.MODULE$.runNativeOrJs((State)state, project, cwd, mainClass, args);
            });
        }
        return task;
    }

    private static final String toBinaryScalaVersion$1(String version) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(version)).split('.'))).take(2))).mkString(".");
    }

    private final void reportBuildError$1(String msg) {
        Build$.MODULE$.showMessage().notify((Object)new ShowMessageParams((MessageType)MessageType.Error$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, msg), this.client);
    }

    public static final /* synthetic */ SourceItem $anonfun$sources$2(Path s) {
        return new SourceItem(Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspSourceUri$extension(s)), false);
    }

    private static final Task sources$1(Seq projects, State state) {
        SourcesResult response = new SourcesResult(projects.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BuildTargetIdentifier target = (BuildTargetIdentifier)tuple2._1();
            Project project = (Project)tuple2._2();
            List sources = (List)project.sources().map((Function1 & Serializable & scala.Serializable)s -> BloopBspServices.$anonfun$sources$2(((AbsolutePath)s).underlying()), List$.MODULE$.canBuildFrom());
            SourcesItem sourcesItem = new SourcesItem(target, sources);
            return sourcesItem;
        }).toList());
        return Task$.MODULE$.now((Object)new Tuple2((Object)state, (Object)package$.MODULE$.Right().apply((Object)response)));
    }

    public static final /* synthetic */ boolean $anonfun$dependencySources$4(Config.Artifact a) {
        return a.classifier().toList().contains((Object)"sources");
    }

    private static final Task sources$2(Seq projects, State state) {
        DependencySourcesResult response = new DependencySourcesResult(projects.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BuildTargetIdentifier target = (BuildTargetIdentifier)tuple2._1();
            Project project = (Project)tuple2._2();
            List sourceJars = (List)project.resolution().toList().flatMap((Function1 & Serializable & scala.Serializable)res -> (List)res.modules().flatMap((Function1 & Serializable & scala.Serializable)m -> m.artifacts().iterator().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)BloopBspServices.$anonfun$dependencySources$4(a))).map((Function1 & Serializable & scala.Serializable)a -> Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspUri$extension(AbsolutePath$.MODULE$.apply(a.path(), AbsolutePath$.MODULE$.workingDirectory())))).toList(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
            DependencySourcesItem dependencySourcesItem = new DependencySourcesItem(target, sourceJars);
            return dependencySourcesItem;
        }).toList());
        return Task$.MODULE$.now((Object)new Tuple2((Object)state, (Object)package$.MODULE$.Right().apply((Object)response)));
    }

    private static final Task scalacOptions$1(Seq projects, State state) {
        ScalacOptionsResult response = new ScalacOptionsResult(projects.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BuildTargetIdentifier target = (BuildTargetIdentifier)tuple2._1();
            Project project = (Project)tuple2._2();
            Dag<Project> dag = state.build().getDagFor(project);
            AbsolutePath[] fullClasspath = project.dependencyClasspath(dag);
            List classpath = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)fullClasspath).map((Function1 & Serializable & scala.Serializable)e -> Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspUri$extension(((AbsolutePath)e).underlying())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Uri.class))))).toList();
            ScalacOptionsItem scalacOptionsItem = new ScalacOptionsItem(target, project.scalacOptions().toList(), classpath, Uri$.MODULE$.apply(AbsolutePath$.MODULE$.toBspUri$extension(project.classesDir())));
            return scalacOptionsItem;
        }).toList());
        return Task$.MODULE$.now((Object)new Tuple2((Object)state, (Object)package$.MODULE$.Right().apply((Object)response)));
    }

    private final void closeServices$1(int code) {
        this.exitStatus.set(code);
        try {
            this.socketInput.close();
        }
        catch (Throwable throwable) {}
    }

    public static final /* synthetic */ void $anonfun$exit$1(BloopBspServices $this, Either x0$1) {
        Either either = x0$1;
        if (either instanceof Left) {
            $this.closeServices$1(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            $this.closeServices$1(0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    public BloopBspServices(State callSiteState, JsonRpcClient client, Path relativeConfigPath, InputStream socketInput, AtomicInt exitStatus) {
        this.callSiteState = callSiteState;
        this.client = client;
        this.relativeConfigPath = relativeConfigPath;
        this.socketInput = socketInput;
        this.exitStatus = exitStatus;
        this.debugFilter = DebugFilter.Bsp$.MODULE$;
        this.taskIdCounter = AtomicInt$.MODULE$.apply(0);
        this.bspLogger = BspServerLogger$.MODULE$.apply(callSiteState, client, this.taskIdCounter(), false);
        this.services = Services$.MODULE$.empty((LoggerSupport)this.bspLogger()).requestAsync((Endpoint)Build$.MODULE$.initialize(), x$1 -> this.initialize((InitializeBuildParams)x$1)).notification((Endpoint)Build$.MODULE$.initialized(), (Function1 & Serializable & scala.Serializable)x$2 -> {
            this.initialized(x$2);
            return BoxedUnit.UNIT;
        }).request((Endpoint)Build$.MODULE$.shutdown(), (Function1 & Serializable & scala.Serializable)x$3 -> {
            this.shutdown(x$3);
            return BoxedUnit.UNIT;
        }).notificationAsync((Endpoint)Build$.MODULE$.exit(), x$4 -> this.exit((Exit)x$4)).requestAsync((Endpoint)Workspace$.MODULE$.buildTargets(), x$5 -> this.buildTargets((WorkspaceBuildTargetsRequest)x$5)).requestAsync((Endpoint)BuildTarget$.MODULE$.dependencySources(), x$6 -> this.dependencySources((DependencySourcesParams)x$6)).requestAsync((Endpoint)BuildTarget$.MODULE$.sources(), x$7 -> this.sources((SourcesParams)x$7)).requestAsync((Endpoint)BuildTarget$.MODULE$.scalacOptions(), x$8 -> this.scalacOptions((ScalacOptionsParams)x$8)).requestAsync((Endpoint)BuildTarget$.MODULE$.compile(), x$9 -> this.compile((CompileParams)x$9)).requestAsync((Endpoint)BuildTarget$.MODULE$.test(), x$10 -> this.test((TestParams)x$10)).requestAsync((Endpoint)BuildTarget$.MODULE$.run(), x$11 -> this.run((RunParams)x$11));
        this.currentState = callSiteState;
        this.isInitialized = Promise$.MODULE$.apply();
        this.isInitializedTask = Task$.MODULE$.fromFuture(this.isInitialized().future()).memoize();
        this.compiledTargetsAtLeastOnce = new TrieMap();
        this.isShutdown = Promise$.MODULE$.apply();
        this.isShutdownTask = Task$.MODULE$.fromFuture(this.isShutdown().future()).memoize();
    }
}

