/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks.compilation;

import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.XML$;

public final class CompilerPluginWhitelist$ {
    public static CompilerPluginWhitelist$ MODULE$;
    private final List<String> whitelistedPluginNames;
    private final List<String> scalaVersionBlacklist;
    private final DebugFilter.Compilation$ debug;
    private final Map<String, String> emptyMap;
    private final ConcurrentHashMap<Path, Tuple2<FileTime, Object>> cachePluginJar;

    static {
        new CompilerPluginWhitelist$();
    }

    public List<String> whitelistedPluginNames() {
        return this.whitelistedPluginNames;
    }

    public List<String> scalaVersionBlacklist() {
        return this.scalaVersionBlacklist;
    }

    private DebugFilter.Compilation$ debug() {
        return this.debug;
    }

    private Map<String, String> emptyMap() {
        return this.emptyMap;
    }

    public Task<List<String>> enablePluginCaching(String scalaVersion, List<String> scalacOptions, Logger logger) {
        Task task;
        Option option = this.scalaVersionBlacklist().find((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)scalaVersion.startsWith(v)));
        if (option instanceof Some) {
            Some some = (Some)option;
            String blacklistedVersion = (String)some.value();
            logger.debug(new StringBuilder(61).append("Disabling compiler plugin classloading, unsupported in Scala ").append(blacklistedVersion).toString(), (DebugFilter)this.debug());
            task = Task$.MODULE$.now(scalacOptions);
        } else if (None$.MODULE$.equals(option)) {
            Task task2;
            if (scalacOptions.contains((Object)"-Ycache-plugin-class-loader:none")) {
                task2 = Task$.MODULE$.now(scalacOptions);
            } else {
                List pluginCompilerFlags = (List)scalacOptions.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-Xplugin:")));
                List shouldCachePlugins = (List)pluginCompilerFlags.map((Function1 & Serializable & scala.Serializable)flag -> Task$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> CompilerPluginWhitelist$.$anonfun$enablePluginCaching$4(this, flag, logger))), List$.MODULE$.canBuildFrom());
                task2 = Task$.MODULE$.gatherUnordered((TraversableOnce)shouldCachePlugins).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CompilerPluginWhitelist$.$anonfun$enablePluginCaching$6(BoxesRunTime.unboxToBoolean((Object)x$3)))))).map((Function1 & Serializable & scala.Serializable)enableCacheFlag -> CompilerPluginWhitelist$.$anonfun$enablePluginCaching$7(scalacOptions, BoxesRunTime.unboxToBoolean((Object)enableCacheFlag)));
            }
            task = task2;
        } else {
            throw new MatchError((Object)option);
        }
        return task;
    }

    private final boolean isPluginWhitelisted$1(Path pluginPath, Logger logger$1) {
        boolean bl;
        URI uriZipFile = URI.create(new StringBuilder(9).append("jar:file:").append(pluginPath.toUri().getRawPath()).toString());
        try (FileSystem fs = FileSystems.newFileSystem(uriZipFile, this.emptyMap());){
            Path pluginDeclarationFile = fs.getPath("/scalac-plugin.xml", new String[0]);
            Elem xml = (Elem)XML$.MODULE$.load(Files.newInputStream(pluginDeclarationFile, new OpenOption[0]));
            String pluginName = xml.$bslash("name").text();
            boolean cache = this.whitelistedPluginNames().contains((Object)pluginName);
            if (cache) {
                logger$1.debug(new StringBuilder(31).append("Compiler plugin ").append(pluginName).append(" is whitelisted").toString(), (DebugFilter)this.debug());
            } else {
                logger$1.debug(new StringBuilder(52).append("Disabling plugin caching because ").append(pluginName).append(" is not whitelisted").toString(), (DebugFilter)this.debug());
            }
            bl = cache;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            logger$1.trace(t);
            logger$1.debug(new StringBuilder(48).append("Disable plugin caching because ").append(pluginPath).append(" couldn't be read").toString(), (DebugFilter)this.debug());
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ boolean $anonfun$enablePluginCaching$4(CompilerPluginWhitelist$ $this, String flag$1, Logger logger$1) {
        block7: {
            block4: {
                block6: {
                    block5: {
                        jarList = new StringOps(Predef$.MODULE$.augmentString(flag$1)).stripPrefix("-Xplugin:");
                        var6_4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jarList.split(File.pathSeparator))).headOption();
                        if (!(var6_4 instanceof Some)) break block4;
                        var7_5 = (Some)var6_4;
                        mainPluginJar = (String)var7_5.value();
                        pluginPath = Paths.get(mainPluginJar, new String[0]);
                        if (Files.exists(pluginPath, new LinkOption[0])) break block5;
                        logger$1.debug(new StringBuilder(45).append("Disable plugin caching because ").append(pluginPath).append(" doesn't exist").toString(), (DebugFilter)CompilerPluginWhitelist$.MODULE$.debug());
                        v0 = false;
                        break block6;
                    }
                    attrs = Files.readAttributes(pluginPath, BasicFileAttributes.class, new LinkOption[0]);
                    lastModifiedTime = attrs.lastModifiedTime();
                    var12_10 = Option$.MODULE$.apply(CompilerPluginWhitelist$.MODULE$.cachePluginJar.get(pluginPath));
                    if (!(var12_10 instanceof Some) || (var14_12 = (Tuple2)(var13_11 = (Some)var12_10).value()) == null) ** GOTO lbl-1000
                    prevLastModifiedTime = (FileTime)var14_12._1();
                    cacheClassloader = var14_12._2$mcZ$sp();
                    v1 = prevLastModifiedTime;
                    var17_15 = lastModifiedTime;
                    if (!(v1 != null ? v1.equals(var17_15) == false : var17_15 != null)) {
                        logger$1.debug(new StringBuilder(22).append("Cache hit ").append(cacheClassloader).append(" for plugin ").append(pluginPath).toString(), (DebugFilter)CompilerPluginWhitelist$.MODULE$.debug());
                        var4_16 = cacheClassloader;
                    } else lbl-1000:
                    // 2 sources

                    {
                        logger$1.debug(new StringBuilder(22).append("Cache miss for plugin ").append(pluginPath).toString(), (DebugFilter)CompilerPluginWhitelist$.MODULE$.debug());
                        shouldCache = $this.isPluginWhitelisted$1(pluginPath, logger$1);
                        CompilerPluginWhitelist$.MODULE$.cachePluginJar.put(pluginPath, (Tuple2<FileTime, Object>)new Tuple2((Object)lastModifiedTime, (Object)BoxesRunTime.boxToBoolean((boolean)shouldCache)));
                        var4_16 = shouldCache;
                    }
                    v0 = var4_16;
                }
                var3_18 = v0;
                break block7;
            }
            if (None$.MODULE$.equals(var6_4)) {
                logger$1.debug(new StringBuilder(32).append("Expecting at least one jar in '").append(flag$1).append("'").toString(), (DebugFilter)CompilerPluginWhitelist$.MODULE$.debug());
                var3_18 = false;
            } else {
                throw new MatchError((Object)var6_4);
            }
        }
        return var3_18;
    }

    public static final /* synthetic */ boolean $anonfun$enablePluginCaching$6(boolean x$3) {
        return x$3;
    }

    public static final /* synthetic */ List $anonfun$enablePluginCaching$7(List scalacOptions$1, boolean enableCacheFlag) {
        List list;
        if (!enableCacheFlag) {
            list = scalacOptions$1;
        } else {
            String string = "-Ycache-plugin-class-loader:last-modified";
            list = scalacOptions$1.$colon$colon((Object)string);
        }
        return list;
    }

    private CompilerPluginWhitelist$() {
        MODULE$ = this;
        this.whitelistedPluginNames = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bloop-test-plugin", "clippy", "scalajs", "nir", "macro-paradise-plugin", "semanticdb", "wartremover", "silencer", "scapegoat", "acyclic", "scoverage", "kind-projector", "scalac-profiling", "classpath-shrinker", "bm4", "splain", "deriving"}));
        this.scalaVersionBlacklist = new .colon.colon((Object)"2.10.", (List)new .colon.colon((Object)"2.11.", (List)new .colon.colon((Object)"2.12.1", (List)new .colon.colon((Object)"2.12.2", (List)new .colon.colon((Object)"2.12.3", (List)new .colon.colon((Object)"2.12.4", (List)new .colon.colon((Object)"0.", (List)Nil$.MODULE$)))))));
        this.debug = DebugFilter.Compilation$.MODULE$;
        this.emptyMap = Collections.emptyMap();
        this.cachePluginJar = new ConcurrentHashMap();
    }
}

