/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.bsp.BspServer$;
import bloop.engine.ExecutionContext$;
import bloop.engine.State;
import bloop.io.SourceWatcher$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.Slf4jAdapter;
import bloop.util.monix.FoldLeftAsyncConsumer$;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.DirectoryWatcher;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.reactive.Consumer;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\t\u0012\u0005YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0001\t\u0001B\u0001B\u0003%1\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015A\u0005\u0001\"\u0003J\u0011\u001d\u0001\u0006A1A\u0005\nECa!\u0016\u0001!\u0002\u0013\u0011\u0006b\u0002,\u0001\u0005\u0004%Ya\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002-\t\u000bq\u0003A\u0011A/\t\u000bM\u0004A\u0011\u0001;\b\u000ba\f\u0002\u0012A=\u0007\u000bA\t\u0002\u0012\u0001>\t\u000b!kA\u0011A>\t\u000bqlA\u0011A?\u0003\u001bM{WO]2f/\u0006$8\r[3s\u0015\t\u00112#\u0001\u0002j_*\tA#A\u0003cY>|\u0007o\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-\u0001\u0007qe>TWm\u0019;OC6,7\u000fE\u0002 O)r!\u0001I\u0013\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r*\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\t1\u0013$A\u0004qC\u000e\\\u0017mZ3\n\u0005!J#\u0001\u0002'jgRT!AJ\r\u0011\u0005-zcB\u0001\u0017.!\t\t\u0013$\u0003\u0002/3\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq\u0013$\u0001\u0003eSJ\u001c\bcA\u00105m%\u0011Q'\u000b\u0002\u0004'\u0016\f\bCA\u001c?\u001b\u0005A$BA\u001d;\u0003\u00111\u0017\u000e\\3\u000b\u0005mb\u0014a\u00018j_*\tQ(\u0001\u0003kCZ\f\u0017BA 9\u0005\u0011\u0001\u0016\r\u001e5\u0002\u000b\u0019LG.Z:\u0002\r1|wmZ3s!\t\u0019e)D\u0001E\u0015\t)5#A\u0004m_\u001e<\u0017N\\4\n\u0005\u001d#%A\u0002'pO\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u00152kej\u0014\t\u0003\u0017\u0002i\u0011!\u0005\u0005\u0006;\u0015\u0001\rA\b\u0005\u0006e\u0015\u0001\ra\r\u0005\u0006\u0001\u0016\u0001\ra\r\u0005\u0006\u0003\u0016\u0001\rAQ\u0001\fg24GG\u001b'pO\u001e,'/F\u0001S!\r\u00195KQ\u0005\u0003)\u0012\u0013Ab\u00157gi)\fE-\u00199uKJ\fAb\u001d7gi)dunZ4fe\u0002\n!\u0002\\8h\u0007>tG/\u001a=u+\u0005A\u0006CA\"Z\u0013\tQFIA\u0006EK\n,xMR5mi\u0016\u0014\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\nQa^1uG\"$2A\u00187o!\ryFMZ\u0007\u0002A*\u0011\u0011MY\u0001\u0005KZ\fGNC\u0001d\u0003\u0015iwN\\5y\u0013\t)\u0007M\u0001\u0003UCN\\\u0007CA4k\u001b\u0005A'BA5\u0014\u0003\u0019)gnZ5oK&\u00111\u000e\u001b\u0002\u0006'R\fG/\u001a\u0005\u0006[*\u0001\rAZ\u0001\u0007gR\fG/\u001a\u0019\t\u000b=T\u0001\u0019\u00019\u0002\r\u0005\u001cG/[8o!\u0011A\u0012O\u001a0\n\u0005IL\"!\u0003$v]\u000e$\u0018n\u001c82\u0003-qw\u000e^5gs^\u000bGo\u00195\u0015\u0003U\u0004\"\u0001\u0007<\n\u0005]L\"\u0001B+oSR\fQbU8ve\u000e,w+\u0019;dQ\u0016\u0014\bCA&\u000e'\tiq\u0003F\u0001z\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Qep`A\u0002\u0011\u0015ir\u00021\u0001\u001f\u0011\u0019\t\ta\u0004a\u0001g\u00051\u0001/\u0019;igBBQ!Q\bA\u0002\t\u0003")
public final class SourceWatcher {
    private final List<String> projectNames;
    private final Seq<Path> dirs;
    private final Seq<Path> files;
    private final Logger logger;
    private final Slf4jAdapter<Logger> bloop$io$SourceWatcher$$slf4jLogger;
    private final DebugFilter logContext;

    public static SourceWatcher apply(List<String> list, Seq<Path> seq, Logger logger) {
        return SourceWatcher$.MODULE$.apply(list, seq, logger);
    }

    public Slf4jAdapter<Logger> bloop$io$SourceWatcher$$slf4jLogger() {
        return this.bloop$io$SourceWatcher$$slf4jLogger;
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    public Task<State> watch(State state0, Function1<State, Task<State>> action) {
        PrintStream ngout = state0.commonOptions().ngout();
        Tuple2 tuple2 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.publish(), ExecutionContext$.MODULE$.ioScheduler());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Observer.Sync observer = (Observer.Sync)tuple2._1();
        Observable observable = (Observable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)observer, (Object)observable);
        Tuple2 tuple23 = tuple22;
        Observer.Sync observer2 = (Observer.Sync)tuple23._1();
        Observable observable2 = (Observable)tuple23._2();
        BooleanRef watchingEnabled = BooleanRef.create((boolean)true);
        DirectoryChangeListener listener = new DirectoryChangeListener(this, watchingEnabled, observer2){
            private final /* synthetic */ SourceWatcher $outer;
            private final BooleanRef watchingEnabled$1;
            private final Observer.Sync observer$1;

            public boolean isWatching() {
                return this.watchingEnabled$1.elem;
            }

            public void onException(Exception e) {
                this.$outer.bloop$io$SourceWatcher$$slf4jLogger().error(new StringBuilder(34).append("File watching threw an exception: ").append(e.getMessage()).toString());
            }

            public void onEvent(DirectoryChangeEvent event) {
                block0: {
                    Path targetFile = event.path();
                    String targetPath = targetFile.toFile().getAbsolutePath();
                    if (!Files.isRegularFile(targetFile, new LinkOption[0]) || !targetPath.endsWith(".scala") && !targetPath.endsWith(".java")) break block0;
                    this.observer$1.onNext((Object)event);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.watchingEnabled$1 = watchingEnabled$1;
                this.observer$1 = observer$1;
            }
        };
        DirectoryWatcher watcher = DirectoryWatcher.builder().paths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.dirs).asJava()).files((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.files).asJava()).logger(this.bloop$io$SourceWatcher$$slf4jLogger()).listener(listener).fileHashing(true).build();
        CompletableFuture watcherHandle = watcher.watchAsync((Executor)ExecutionContext$.MODULE$.ioExecutor());
        Task watchController = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                watcherHandle.get();
            }
            finally {
                watcher.close();
            }
            $this.logger.debug("File watcher was successfully closed", this.logContext());
        });
        Cancelable watchCancellation = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            watchingEnabled$1.elem = false;
            watcherHandle.complete(null);
            observer2.onComplete();
            ngout.println(new StringBuilder(74).append("File watching on '").append($this.projectNames.mkString("', '")).append("' and dependent projects has been successfully cancelled").toString());
        });
        Consumer fileEventConsumer = FoldLeftAsyncConsumer$.MODULE$.consume((Function0 & Serializable & scala.Serializable)() -> state0, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Task task;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            State state = (State)tuple2._1();
            DirectoryChangeEvent event = (DirectoryChangeEvent)tuple2._2();
            DirectoryChangeEvent.EventType eventType = event.eventType();
            if (DirectoryChangeEvent.EventType.CREATE.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else if (DirectoryChangeEvent.EventType.MODIFY.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else if (DirectoryChangeEvent.EventType.OVERFLOW.equals(eventType)) {
                task = this.runAction$1(state, event, action);
                return task;
            } else {
                if (!DirectoryChangeEvent.EventType.DELETE.equals(eventType)) throw new MatchError((Object)eventType);
                task = Task$.MODULE$.now((Object)state);
            }
            return task;
        });
        return observable2.consumeWith(fileEventConsumer).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> watchCancellation.cancel()));
    }

    public void notifyWatch() {
        int filesCount = this.files.size();
        int dirsCount = this.dirs.size();
        String andFiles = filesCount == 0 ? "" : new StringBuilder(11).append(" and ").append(filesCount).append(" files").toString();
        this.logger.info(new StringBuilder(52).append("Watching ").append(dirsCount).append(" directories").append(andFiles).append("... (press Ctrl-C to interrupt)").toString());
    }

    private final Task runAction$1(State state, DirectoryChangeEvent event, Function1 action$1) {
        if (!BspServer$.MODULE$.isWindows()) {
            this.logger.info("\u001b[H\u001b[2J");
        }
        this.logger.debug(new StringBuilder(29).append("A ").append(event.eventType()).append(" in ").append(event.path()).append(" has triggered an event").toString(), this.logContext());
        return (Task)action$1.apply((Object)state);
    }

    public SourceWatcher(List<String> projectNames, Seq<Path> dirs, Seq<Path> files, Logger logger) {
        this.projectNames = projectNames;
        this.dirs = dirs;
        this.files = files;
        this.logger = logger;
        this.bloop$io$SourceWatcher$$slf4jLogger = new Slf4jAdapter(logger);
        this.logContext = DebugFilter.FileWatching$.MODULE$;
    }
}

