/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.UniqueCompileInputs;
import bloop.data.Project;
import bloop.engine.ExecutionContext$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ByteHasher$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class SourceHasher$ {
    public static SourceHasher$ MODULE$;
    private final PathMatcher bloop$io$SourceHasher$$sourceMatcher;

    static {
        new SourceHasher$();
    }

    public final PathMatcher bloop$io$SourceHasher$$sourceMatcher() {
        return this.bloop$io$SourceHasher$$sourceMatcher;
    }

    public Task<List<UniqueCompileInputs.HashedSource>> findAndHashSourcesInProject(Project project, int parallelUnits) {
        List sourceFilesAndDirectories = (List)project.sources().distinct();
        HashSet visitedDirs = new HashSet();
        Tuple2 tuple2 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.publish(), ExecutionContext$.MODULE$.ioScheduler());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Observer.Sync observer = (Observer.Sync)tuple2._1();
        Observable observable = (Observable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)observer, (Object)observable);
        Tuple2 tuple23 = tuple22;
        Observer.Sync observer2 = (Observer.Sync)tuple23._1();
        Observable observable2 = (Observable)tuple23._2();
        FileVisitor<Path> discovery = new FileVisitor<Path>(observer2, visitedDirs){
            private final Observer.Sync observer$1;
            private final HashSet visitedDirs$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Object object = !SourceHasher$.MODULE$.bloop$io$SourceHasher$$sourceMatcher().matches(file) ? BoxedUnit.UNIT : this.observer$1.onNext((Object)file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path t, IOException e) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                this.visitedDirs$1.$plus$eq((Object)directory);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
            {
                this.observer$1 = observer$1;
                this.visitedDirs$1 = visitedDirs$1;
            }
        };
        Task discoverFileTree = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            sourceFilesAndDirectories.foreach((Function1 & Serializable & scala.Serializable)sourcePath -> SourceHasher$.$anonfun$findAndHashSourcesInProject$2(visitedDirs, opts, discovery, ((AbsolutePath)sourcePath).underlying()));
        }).doOnFinish((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Task task;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable t = (Throwable)some.value();
                task = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> observer2.onError(t));
            } else if (None$.MODULE$.equals(option)) {
                task = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> observer2.onComplete());
            } else {
                throw new MatchError((Object)option);
            }
            return task;
        });
        Task copyFilesInParallel = ((Observable)observable2.mapAsync(parallelUnits, (Function1 & Serializable & scala.Serializable)source -> Task$.MODULE$.eval((Function0 & Serializable & scala.Serializable)() -> {
            int hash = ByteHasher$.MODULE$.hashFileContents(source.toFile(), ByteHasher$.MODULE$.hashFileContents$default$2());
            return new UniqueCompileInputs.HashedSource(AbsolutePath$.MODULE$.apply(source, AbsolutePath$.MODULE$.workingDirectory()), hash);
        }))).toListL();
        return Task$.MODULE$.mapBoth(discoverFileTree, copyFilesInParallel, (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            List sources;
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List list = sources = (List)tuple2._2();
            return list;
        });
    }

    public static final /* synthetic */ Object $anonfun$findAndHashSourcesInProject$2(HashSet visitedDirs$1, EnumSet opts$1, FileVisitor discovery$1, Path sourcePath) {
        return visitedDirs$1.contains((Object)sourcePath) ? BoxedUnit.UNIT : Files.walkFileTree(sourcePath, opts$1, Integer.MAX_VALUE, discovery$1);
    }

    private SourceHasher$() {
        MODULE$ = this;
        this.bloop$io$SourceHasher$$sourceMatcher = FileSystems.getDefault().getPathMatcher("glob:**.{scala,java}");
    }
}

