/*
 * Decompiled with CFR 0.152.
 */
package bloop.data;

import bloop.data.ClientInfo;
import bloop.data.Project;
import bloop.io.AbsolutePath;
import bloop.io.Paths$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import monix.execution.misc.NonFatal$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSetLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ClientInfo$ {
    public static ClientInfo$ MODULE$;
    private final Regex internalClassesNameFormat;

    static {
        new ClientInfo$();
    }

    public Regex internalClassesNameFormat() {
        return this.internalClassesNameFormat;
    }

    public Option<String> toGenericClassesDir(Path internalClassesDir) {
        None$ none$;
        String internalDirName;
        String string = internalDirName = ((Object)internalClassesDir.getFileName()).toString();
        Option option = this.internalClassesNameFormat().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String genericClassesName = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = new Some((Object)genericClassesName);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String activeSinceMillis(long startMs) {
        Instant start = Instant.ofEpochMilli(startMs);
        Instant now = Instant.ofEpochMilli(System.currentTimeMillis());
        Duration duration = Duration.between(start, now);
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    public void deleteOrphanClientBspDirectories(Function0<Traversable<ClientInfo.BspClientInfo>> currentBspClients, Logger logger, int currentAttempts) {
        if (currentAttempts < 5) {
            Traversable initialBspConnectedClients = (Traversable)currentBspClients.apply();
            ListBuffer connectedBspClientIds = new ListBuffer();
            HashSet projectsToVisit = new HashSet();
            initialBspConnectedClients.foreach((Function1 & Serializable & scala.Serializable)client -> {
                ClientInfo$.$anonfun$deleteOrphanClientBspDirectories$1(connectedBspClientIds, projectsToVisit, client);
                return BoxedUnit.UNIT;
            });
            projectsToVisit.foreach((Function1 & Serializable & scala.Serializable)project -> {
                ClientInfo$.$anonfun$deleteOrphanClientBspDirectories$3(currentBspClients, initialBspConnectedClients, logger, currentAttempts, connectedBspClientIds, project);
                return BoxedUnit.UNIT;
            });
        }
    }

    public int deleteOrphanClientBspDirectories$default$3() {
        return 0;
    }

    public static final /* synthetic */ void $anonfun$deleteOrphanClientBspDirectories$1(ListBuffer connectedBspClientIds$1, HashSet projectsToVisit$1, ClientInfo.BspClientInfo client) {
        Object object = client.hasAnActiveConnection() ? connectedBspClientIds$1.$plus$eq((Object)client.uniqueId()) : BoxedUnit.UNIT;
        ((GenSetLike)JavaConverters$.MODULE$.asScalaSetConverter(client.uniqueDirs().keySet()).asScala()).iterator().foreach((Function1 & Serializable & scala.Serializable)project -> projectsToVisit$1.$plus$eq(project));
    }

    public static final /* synthetic */ void $anonfun$deleteOrphanClientBspDirectories$4(ListBuffer connectedBspClientIds$1, Logger logger$1, Path existingDir) {
        String dirName = ((Object)existingDir.getFileName()).toString();
        boolean isWhitelisted = connectedBspClientIds$1.exists((Function1 & Serializable & scala.Serializable)clientId -> BoxesRunTime.boxToBoolean((boolean)dirName.endsWith(new StringBuilder(1).append("-").append(clientId).toString())));
        if (!isWhitelisted) {
            try {
                logger$1.debug(new StringBuilder(26).append("Deleting orphan directory ").append(new AbsolutePath(existingDir)).toString(), (DebugFilter)DebugFilter.All$.MODULE$);
                Paths$.MODULE$.delete(existingDir);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof NoSuchFileException) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    logger$1.debug(new StringBuilder(55).append("Unexpected error when deleting unused client directory ").append(new AbsolutePath(existingDir)).toString(), (DebugFilter)DebugFilter.Bsp$.MODULE$);
                    logger$1.trace(t);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$deleteOrphanClientBspDirectories$3(Function0 currentBspClients$1, Traversable initialBspConnectedClients$1, Logger logger$1, int currentAttempts$1, ListBuffer connectedBspClientIds$1, Project project) {
        Path bspClientClasses = project.bspClientClassesDirectories();
        try {
            Traversable currentBspConnectedClients;
            Traversable traversable = currentBspConnectedClients = (Traversable)currentBspClients$1.apply();
            Traversable traversable2 = initialBspConnectedClients$1;
            if (traversable == null ? traversable2 != null : !traversable.equals(traversable2)) {
                MODULE$.deleteOrphanClientBspDirectories((Function0<Traversable<ClientInfo.BspClientInfo>>)currentBspClients$1, logger$1, currentAttempts$1 + 1);
            } else {
                Paths$.MODULE$.list(bspClientClasses).foreach((Function1 & Serializable & scala.Serializable)existingDir -> {
                    ClientInfo$.$anonfun$deleteOrphanClientBspDirectories$4(connectedBspClientIds$1, logger$1, ((AbsolutePath)existingDir).underlying());
                    return BoxedUnit.UNIT;
                });
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger$1.debug(new StringBuilder(63).append("Unexpected error when processing unused client directories for ").append(project.name()).toString(), (DebugFilter)DebugFilter.Bsp$.MODULE$);
                logger$1.trace(t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private ClientInfo$() {
        MODULE$ = this;
        this.internalClassesNameFormat = new StringOps(Predef$.MODULE$.augmentString("(.*)-[^-]*-[^-]*-[^-]*$")).r();
    }
}

