/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks.compilation;

import bloop.Compiler;
import bloop.UniqueCompileInputs;
import bloop.data.Project;
import bloop.engine.ExecutionContext$;
import bloop.engine.caches.LastSuccessfulResult;
import bloop.engine.tasks.compilation.CompileBundle;
import bloop.engine.tasks.compilation.CompileDependenciesData;
import bloop.engine.tasks.compilation.CompileDependenciesData$;
import bloop.engine.tasks.compilation.CompileGraph;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ClasspathHasher$;
import bloop.io.SourceHasher$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.LoggerAction;
import bloop.logging.ObservedLogger;
import bloop.reporter.ObservedReporter;
import bloop.reporter.ReporterAction;
import bloop.tracing.BraveTracer;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple13;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Promise;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public final class CompileBundle$
implements scala.Serializable {
    public static CompileBundle$ MODULE$;
    private final DebugFilter.Compilation$ filter;

    static {
        new CompileBundle$();
    }

    public DebugFilter.Compilation$ filter() {
        return this.filter;
    }

    public Task<CompileBundle> computeFrom(CompileGraph.BundleInputs inputs, Path clientExternalClassesDir, ObservedReporter reporter, LastSuccessfulResult lastSuccessful, Compiler.Result lastResult, Promise<BoxedUnit> cancelCompilation, ObservedLogger<Logger> logger, Observable<Either<ReporterAction, LoggerAction>> mirror, BraveTracer tracer2) {
        return tracer2.traceTask(new StringBuilder(17).append("computing bundle ").append(inputs.project().name()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)tracer -> {
            CompileDependenciesData compileDependenciesData = (CompileDependenciesData)tracer.trace("dependency classpath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$1 -> CompileDependenciesData$.MODULE$.compute((AbsolutePath[])inputs.project().rawClasspath().toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), inputs.dependentProducts()));
            Task classpathHashesTask = ClasspathHasher$.MODULE$.hash(compileDependenciesData.dependencyClasspath(), 10, ExecutionContext$.MODULE$.ioScheduler(), (Logger)logger, tracer).executeOn(ExecutionContext$.MODULE$.ioScheduler());
            Task sourceHashesTask = tracer.traceTask("discovering and hashing sources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$2 -> SourceHasher$.MODULE$.findAndHashSourcesInProject(inputs.project(), 20).map((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> AbsolutePath$.MODULE$.syntax$extension(x$4.source()), (Ordering)Ordering.String$.MODULE$)).executeOn(ExecutionContext$.MODULE$.ioScheduler()));
            logger.debug(new StringBuilder(43).append("Computing sources and classpath hashes for ").append(inputs.project().name()).toString(), (DebugFilter)MODULE$.filter());
            return Task$.MODULE$.mapBoth(classpathHashesTask, sourceHashesTask, (Function2 & Serializable & scala.Serializable)(classpathHashes, sourceHashes) -> {
                String originPath = AbsolutePath$.MODULE$.syntax$extension(inputs.project().origin().path());
                int originHash = inputs.project().origin().hash();
                ListBuffer javaSources = new ListBuffer();
                ListBuffer scalaSources = new ListBuffer();
                sourceHashes.foreach((Function1 & Serializable & scala.Serializable)hashed -> {
                    Path source = hashed.source();
                    String sourceName = ((Object)source.getFileName()).toString();
                    return sourceName.endsWith(".scala") ? scalaSources.$plus$eq((Object)new AbsolutePath(source)) : (sourceName.endsWith(".java") ? javaSources.$plus$eq((Object)new AbsolutePath(source)) : BoxedUnit.UNIT);
                });
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaSources.toList()), (Object)scalaSources.toList());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List javaSources2 = (List)tuple2._1();
                List scalaSources2 = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)javaSources2, (Object)scalaSources2);
                Tuple2 tuple23 = tuple22;
                List javaSources3 = (List)tuple23._1();
                List scalaSources3 = (List)tuple23._2();
                Vector scalacOptions = inputs.project().scalacOptions().toVector();
                Vector scalaJars = (Vector)Option$.MODULE$.option2Iterable(inputs.project().scalaInstance()).toVector().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.allJars())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Vector$.MODULE$.canBuildFrom());
                UniqueCompileInputs inputs = new UniqueCompileInputs(sourceHashes.toVector(), classpathHashes.toVector(), scalacOptions, scalaJars, originPath);
                return new CompileBundle(inputs.project(), clientExternalClassesDir, compileDependenciesData, (List<Path>)javaSources3, (List<Path>)scalaSources3, inputs, cancelCompilation, reporter, logger, mirror, lastSuccessful, lastResult, (BraveTracer)tracer);
            });
        });
    }

    public CompileBundle apply(Project project, Path clientClassesDir, CompileDependenciesData dependenciesData, List<Path> javaSources, List<Path> scalaSources, UniqueCompileInputs uniqueInputs, Promise<BoxedUnit> cancelCompilation, ObservedReporter reporter, ObservedLogger<Logger> logger, Observable<Either<ReporterAction, LoggerAction>> mirror, LastSuccessfulResult lastSuccessful, Compiler.Result latestResult, BraveTracer tracer) {
        return new CompileBundle(project, clientClassesDir, dependenciesData, javaSources, scalaSources, uniqueInputs, cancelCompilation, reporter, logger, mirror, lastSuccessful, latestResult, tracer);
    }

    public Option<Tuple13<Project, Path, CompileDependenciesData, List<Path>, List<Path>, UniqueCompileInputs, Promise<BoxedUnit>, ObservedReporter, ObservedLogger<Logger>, Observable<Either<ReporterAction, LoggerAction>>, LastSuccessfulResult, Compiler.Result, BraveTracer>> unapply(CompileBundle x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple13((Object)x$0.project(), (Object)new AbsolutePath(x$0.clientClassesDir()), (Object)x$0.dependenciesData(), x$0.javaSources(), x$0.scalaSources(), (Object)x$0.uniqueInputs(), x$0.cancelCompilation(), (Object)x$0.reporter(), x$0.logger(), x$0.mirror(), (Object)x$0.lastSuccessful(), (Object)x$0.latestResult(), (Object)x$0.tracer()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CompileBundle$() {
        MODULE$ = this;
        this.filter = DebugFilter.Compilation$.MODULE$;
    }
}

