/*
 * Decompiled with CFR 0.152.
 */
package bloop.data;

import bloop.data.WorkspaceSettings;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.RelativePath;
import bloop.io.RelativePath$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.ObjectEncoder;
import io.circe.ParsingFailure;
import io.circe.Printer$;
import io.circe.derivation.DerivedDecoder;
import io.circe.parser.package$;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class WorkspaceSettings$
implements Serializable {
    public static WorkspaceSettings$ MODULE$;
    private final Path settingsFileName;
    private final ObjectEncoder<WorkspaceSettings> settingsEncoder;
    private final Decoder<WorkspaceSettings> settingsDecoder;

    static {
        new WorkspaceSettings$();
    }

    public Path settingsFileName() {
        return this.settingsFileName;
    }

    private ObjectEncoder<WorkspaceSettings> settingsEncoder() {
        return this.settingsEncoder;
    }

    private Decoder<WorkspaceSettings> settingsDecoder() {
        return this.settingsDecoder;
    }

    public Option<WorkspaceSettings> readFromFile(Path configPath, Logger logger) {
        None$ none$;
        Path settingsPath = AbsolutePath$.MODULE$.resolve$extension0(configPath, this.settingsFileName());
        if (!AbsolutePath$.MODULE$.isFile$extension(settingsPath)) {
            none$ = None$.MODULE$;
        } else {
            byte[] bytes = Files.readAllBytes(settingsPath);
            logger.debug(new StringBuilder(32).append("Loading workspace settings from ").append(new RelativePath(this.settingsFileName())).toString(), (DebugFilter)DebugFilter.All$.MODULE$);
            String contents = new String(bytes, StandardCharsets.UTF_8);
            Either either = package$.MODULE$.parse(contents);
            if (either instanceof Left) {
                Left left = (Left)either;
                ParsingFailure e = (ParsingFailure)left.value();
                throw e;
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Json json = (Json)right.value();
            Option option = Option$.MODULE$.apply((Object)this.fromJson(json));
            none$ = option;
        }
        return none$;
    }

    public Path writeToFile(Path configDir, WorkspaceSettings settings, Logger logger) {
        Path settingsFile = AbsolutePath$.MODULE$.resolve$extension0(configDir, this.settingsFileName());
        logger.debug(new StringBuilder(30).append("Writing workspace settings to ").append(new AbsolutePath(settingsFile)).toString(), (DebugFilter)DebugFilter.All$.MODULE$);
        Json jsonObject = this.settingsEncoder().apply((Object)settings);
        boolean x$1 = true;
        boolean x$2 = Printer$.MODULE$.spaces4().copy$default$1();
        String x$3 = Printer$.MODULE$.spaces4().copy$default$3();
        String x$4 = Printer$.MODULE$.spaces4().copy$default$4();
        String x$5 = Printer$.MODULE$.spaces4().copy$default$5();
        String x$6 = Printer$.MODULE$.spaces4().copy$default$6();
        String x$7 = Printer$.MODULE$.spaces4().copy$default$7();
        String x$8 = Printer$.MODULE$.spaces4().copy$default$8();
        String x$9 = Printer$.MODULE$.spaces4().copy$default$9();
        String x$10 = Printer$.MODULE$.spaces4().copy$default$10();
        String x$11 = Printer$.MODULE$.spaces4().copy$default$11();
        String x$12 = Printer$.MODULE$.spaces4().copy$default$12();
        String x$13 = Printer$.MODULE$.spaces4().copy$default$13();
        String x$14 = Printer$.MODULE$.spaces4().copy$default$14();
        String x$15 = Printer$.MODULE$.spaces4().copy$default$15();
        String x$16 = Printer$.MODULE$.spaces4().copy$default$16();
        String x$17 = Printer$.MODULE$.spaces4().copy$default$17();
        String x$18 = Printer$.MODULE$.spaces4().copy$default$18();
        boolean x$19 = Printer$.MODULE$.spaces4().copy$default$19();
        boolean x$20 = Printer$.MODULE$.spaces4().copy$default$20();
        boolean x$21 = Printer$.MODULE$.spaces4().copy$default$21();
        String output = Printer$.MODULE$.spaces4().copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21).pretty(jsonObject);
        Files.write(settingsFile, output.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return settingsFile;
    }

    public WorkspaceSettings fromJson(Json json) {
        WorkspaceSettings settings;
        Either either = this.settingsDecoder().decodeJson(json);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                DecodingFailure failure = (DecodingFailure)left.value();
                throw failure;
            }
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        WorkspaceSettings workspaceSettings = settings = (WorkspaceSettings)right.value();
        return workspaceSettings;
    }

    public WorkspaceSettings apply(String semanticDBVersion, List<String> supportedScalaVersions) {
        return new WorkspaceSettings(semanticDBVersion, supportedScalaVersions);
    }

    public Option<Tuple2<String, List<String>>> unapply(WorkspaceSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.semanticDBVersion(), x$0.supportedScalaVersions()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private WorkspaceSettings$() {
        MODULE$ = this;
        this.settingsFileName = RelativePath$.MODULE$.apply("bloop.settings.json");
        this.settingsEncoder = new ObjectEncoder<WorkspaceSettings>(){
            private final Encoder<String> encoder0;
            private final Encoder<List<String>> encoder1;

            public final Json apply(Object a) {
                return ObjectEncoder.apply$((ObjectEncoder)this, (Object)a);
            }

            public final <B> ObjectEncoder<B> contramapObject(Function1<B, WorkspaceSettings> f) {
                return ObjectEncoder.contramapObject$((ObjectEncoder)this, f);
            }

            public final ObjectEncoder<WorkspaceSettings> mapJsonObject(Function1<JsonObject, JsonObject> f) {
                return ObjectEncoder.mapJsonObject$((ObjectEncoder)this, f);
            }

            public final <B> Encoder<B> contramap(Function1<B, WorkspaceSettings> f) {
                return Encoder.contramap$((Encoder)this, f);
            }

            public final Encoder<WorkspaceSettings> mapJson(Function1<Json, Json> f) {
                return Encoder.mapJson$((Encoder)this, f);
            }

            public final JsonObject encodeObject(WorkspaceSettings a) {
                return JsonObject$.MODULE$.fromIterable((Iterable)new .colon.colon((Object)new Tuple2((Object)"semanticDBVersion", (Object)this.encoder0.apply((Object)a.semanticDBVersion())), (List)new .colon.colon((Object)new Tuple2((Object)"supportedScalaVersions", (Object)this.encoder1.apply(a.supportedScalaVersions())), (List)Nil$.MODULE$)));
            }
            {
                Encoder.$init$((Encoder)this);
                ObjectEncoder.$init$((ObjectEncoder)this);
                this.encoder0 = Encoder$.MODULE$.encodeString();
                this.encoder1 = Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString());
            }
        };
        this.settingsDecoder = new DerivedDecoder<WorkspaceSettings>(){
            private final Decoder<String> decoder0;
            private final Decoder<List<String>> decoder1;

            /*
             * WARNING - void declaration
             */
            public final Either<DecodingFailure, WorkspaceSettings> apply(HCursor c) {
                Either either;
                Either res = this.decoder0.tryDecode(c.downField("semanticDBVersion"));
                if (res.isRight()) {
                    String res1 = (String)((Right)res).value();
                    Either res2 = this.decoder1.tryDecode(c.downField("supportedScalaVersions"));
                    if (res2.isRight()) {
                        List res22 = (List)((Right)res2).value();
                        either = new Right((Object)new WorkspaceSettings(res1, (List<String>)res22));
                    } else {
                        either = res2;
                    }
                } else {
                    void var2_2;
                    either = var2_2;
                }
                return either;
            }

            public final Validated<NonEmptyList<DecodingFailure>, WorkspaceSettings> decodeAccumulating(HCursor c) {
                Validated res2;
                Validated res1 = this.decoder0.tryDecodeAccumulating(c.downField("semanticDBVersion"));
                List dfs = this.errors((List)new .colon.colon((Object)res1, (List)new .colon.colon((Object)(res2 = this.decoder1.tryDecodeAccumulating(c.downField("supportedScalaVersions"))), (List)Nil$.MODULE$)));
                return dfs.isEmpty() ? Validated$.MODULE$.valid((Object)new WorkspaceSettings((String)((Validated.Valid)res1).a(), (List<String>)((List)((Validated.Valid)res2).a()))) : Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(dfs));
            }
            {
                this.decoder0 = Decoder$.MODULE$.decodeString();
                this.decoder1 = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString());
            }
        };
    }
}

