/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.ScalaInstance;
import bloop.data.LoadedProject;
import bloop.data.Origin;
import bloop.data.Origin$;
import bloop.data.Project;
import bloop.data.Project$;
import bloop.data.WorkspaceSettings;
import bloop.data.WorkspaceSettings$;
import bloop.data.WorkspaceSettings$SemanticDBVersionChange$;
import bloop.engine.Build;
import bloop.engine.ExecutionContext$;
import bloop.engine.Feedback$;
import bloop.engine.caches.SemanticDBCache$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ByteHasher$;
import bloop.io.Paths;
import bloop.io.Paths$;
import bloop.io.RelativePath$;
import bloop.logging.DebugFilter;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Coeval;
import monix.eval.Coeval$;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import xsbti.Logger;

public final class BuildLoader$ {
    public static BuildLoader$ MODULE$;
    private final String JsonFilePattern;

    static {
        new BuildLoader$();
    }

    public final String JsonFilePattern() {
        return this.JsonFilePattern;
    }

    public List<Paths.AttributedPath> readConfigurationFilesInBase(Path base, bloop.logging.Logger logger) {
        String workspaceFileName = RelativePath$.MODULE$.toFile$extension(WorkspaceSettings$.MODULE$.settingsFileName()).getName();
        return (List)Paths$.MODULE$.attributedPathFilesUnder(base, this.JsonFilePattern(), (Logger)logger, 1).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BuildLoader$.$anonfun$readConfigurationFilesInBase$1(workspaceFileName, x$1)));
    }

    public Task<List<LoadedProject>> loadBuildIncrementally(Path configDir, List<Build.ReadConfiguration> configs, List<Build.InvalidatedInMemoryProject> inMemoryChanged, Option<WorkspaceSettings> settingsForLoad, bloop.logging.Logger logger) {
        Task incrementalLoadTask = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String loadMsg = new StringBuilder(28).append("Loading ").append(configs.length()).append(" projects from '").append(AbsolutePath$.MODULE$.syntax$extension(configDir)).append("'...").toString();
            logger.debug(loadMsg, (DebugFilter)DebugFilter.All$.MODULE$);
            List rawProjects = (List)configs.map((Function1 & Serializable & scala.Serializable)f -> Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.loadProject(f.bytes(), f.origin(), logger)), List$.MODULE$.canBuildFrom());
            List groupTasks = rawProjects.grouped(10).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((TraversableOnce)group)).toList();
            Task newOrModifiedRawProjects = Task$.MODULE$.sequence((TraversableOnce)groupTasks, List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)fp -> (List)fp.flatten((Function1)Predef$.MODULE$.$conforms()));
            return newOrModifiedRawProjects.flatMap((Function1 & Serializable & scala.Serializable)projects -> {
                Task task;
                List projectsRequiringMetalsTransformation = (List)projects.$plus$plus((GenTraversableOnce)inMemoryChanged.collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Build.InvalidatedInMemoryProject, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            Project project = A1.project();
                            List<WorkspaceSettings.DetectedChange> changes = A1.changes();
                            if (changes.contains((Object)WorkspaceSettings$SemanticDBVersionChange$.MODULE$)) {
                                object = project;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Build.InvalidatedInMemoryProject x1) {
                        List<WorkspaceSettings.DetectedChange> changes;
                        Build.InvalidatedInMemoryProject invalidatedInMemoryProject = x1;
                        boolean bl = invalidatedInMemoryProject != null && (changes = invalidatedInMemoryProject.changes()).contains((Object)WorkspaceSettings$SemanticDBVersionChange$.MODULE$);
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                Option option = settingsForLoad;
                if (None$.MODULE$.equals(option)) {
                    task = Task$.MODULE$.now(projectsRequiringMetalsTransformation.map((Function1 & Serializable & scala.Serializable)x$2 -> new LoadedProject.RawProject((Project)x$2), List$.MODULE$.canBuildFrom()));
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    WorkspaceSettings settings = (WorkspaceSettings)some.value();
                    task = MODULE$.resolveSemanticDBForProjects((List<Project>)projectsRequiringMetalsTransformation, configDir, settings.semanticDBVersion(), settings.supportedScalaVersions(), logger).map((Function1 & Serializable & scala.Serializable)transformedProjects -> (List)transformedProjects.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        void var2_7;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Project project = (Project)tuple2._1();
                            Option option = (Option)tuple2._2();
                            if (None$.MODULE$.equals(option)) {
                                LoadedProject.RawProject rawProject = new LoadedProject.RawProject(project);
                                return var2_7;
                            }
                        }
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        Project project = (Project)tuple2._1();
                        Option option = (Option)tuple2._2();
                        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
                        Some some = (Some)option;
                        Project original = (Project)some.value();
                        LoadedProject.ConfiguredProject configuredProject = new LoadedProject.ConfiguredProject(project, original, settings);
                        return var2_7;
                    }, List$.MODULE$.canBuildFrom()));
                } else {
                    throw new MatchError((Object)option);
                }
                return task;
            });
        });
        return incrementalLoadTask.flatten(Predef$.MODULE$.$conforms()).executeOn(ExecutionContext$.MODULE$.ioScheduler());
    }

    private Task<List<Tuple2<Project, Option<Project>>>> resolveSemanticDBForProjects(List<Project> rawProjects, Path configDir, String semanticDBVersion, List<String> supportedScalaVersions, bloop.logging.Logger logger) {
        ListBuffer projectsWithNoScalaConfig = new ListBuffer();
        HashMap groupedProjectsPerScalaVersion = new HashMap();
        rawProjects.foreach((Function1 & Serializable & scala.Serializable)project -> {
            ListBuffer listBuffer;
            Option<ScalaInstance> option = project.scalaInstance();
            if (None$.MODULE$.equals(option)) {
                listBuffer = projectsWithNoScalaConfig.$plus$eq(project);
            } else if (option instanceof Some) {
                Option option2;
                Some some = (Some)option;
                ScalaInstance instance = (ScalaInstance)some.value();
                String scalaVersion = instance.version();
                Option option3 = groupedProjectsPerScalaVersion.get((Object)scalaVersion);
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    List projects = (List)some2.value();
                    Project project2 = project;
                    option2 = groupedProjectsPerScalaVersion.put((Object)scalaVersion, (Object)projects.$colon$colon((Object)project2));
                } else if (None$.MODULE$.equals(option3)) {
                    Project project3 = project;
                    option2 = groupedProjectsPerScalaVersion.put((Object)scalaVersion, (Object)Nil$.MODULE$.$colon$colon((Object)project3));
                } else {
                    throw new MatchError((Object)option3);
                }
                listBuffer = option2;
            } else {
                throw new MatchError(option);
            }
            return listBuffer;
        });
        List enableMetalsInProjectsTask = (List)groupedProjectsPerScalaVersion.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String scalaVersion = (String)tuple2._1();
            List projects = (List)tuple2._2();
            Coeval coeval = MODULE$.tryEnablingSemanticDB((List<Project>)projects, configDir, scalaVersion, semanticDBVersion, supportedScalaVersions, logger, (Function1 & Serializable & scala.Serializable)plugin -> (List)projects.map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Project$.MODULE$.enableMetalsSettings((Project)p, configDir, (Option<Path>)plugin, logger)), (Object)new Some(p)), List$.MODULE$.canBuildFrom()));
            Task task = coeval.task();
            return task;
        }, List$.MODULE$.canBuildFrom());
        return Task$.MODULE$.gatherUnordered((TraversableOnce)enableMetalsInProjectsTask).map((Function1 & Serializable & scala.Serializable)pps -> (List)((List)pps.flatten((Function1)Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)projectsWithNoScalaConfig.toList().map((Function1 & Serializable & scala.Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)None$.MODULE$), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()));
    }

    public List<LoadedProject> loadSynchronously(Path configDir, bloop.logging.Logger logger) {
        Option<WorkspaceSettings> settings = WorkspaceSettings$.MODULE$.readFromFile(configDir, logger);
        List configFiles = (List)this.readConfigurationFilesInBase(configDir, logger).map((Function1 & Serializable & scala.Serializable)ap -> {
            byte[] bytes = AbsolutePath$.MODULE$.readAllBytes$extension(ap.path());
            int hash = ByteHasher$.MODULE$.hashBytes(bytes);
            return new Build.ReadConfiguration(Origin$.MODULE$.apply((Paths.AttributedPath)ap, hash), bytes);
        }, List$.MODULE$.canBuildFrom());
        logger.debug(new StringBuilder(28).append("Loading ").append(configFiles.length()).append(" projects from '").append(AbsolutePath$.MODULE$.syntax$extension(configDir)).append("'...").toString(), (DebugFilter)DebugFilter.All$.MODULE$);
        return (List)configFiles.map((Function1 & Serializable & scala.Serializable)f -> {
            LoadedProject.RawProject rawProject;
            Project project = MODULE$.loadProject(f.bytes(), f.origin(), logger);
            Option option = settings;
            if (None$.MODULE$.equals(option)) {
                rawProject = new LoadedProject.RawProject(project);
            } else if (option instanceof Some) {
                Product product;
                Some some = (Some)option;
                WorkspaceSettings settings = (WorkspaceSettings)some.value();
                Option<ScalaInstance> option2 = project.scalaInstance();
                if (None$.MODULE$.equals(option2)) {
                    product = new LoadedProject.RawProject(project);
                } else if (option2 instanceof Some) {
                    LoadedProject.ConfiguredProject value;
                    Some some2 = (Some)option2;
                    ScalaInstance instance = (ScalaInstance)some2.value();
                    String scalaVersion = instance.version();
                    Coeval coeval = MODULE$.tryEnablingSemanticDB((List<Project>)new .colon.colon((Object)project, (List)Nil$.MODULE$), configDir, scalaVersion, settings.semanticDBVersion(), settings.supportedScalaVersions(), logger, (Function1 & Serializable & scala.Serializable)plugin -> new LoadedProject.ConfiguredProject(Project$.MODULE$.enableMetalsSettings(project, configDir, (Option<Path>)plugin, logger), project, settings));
                    Either either = coeval.run();
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable value2 = (Throwable)left.value();
                        throw value2;
                    }
                    if (!(either instanceof Right)) {
                        throw new MatchError((Object)either);
                    }
                    Right right = (Right)either;
                    LoadedProject.ConfiguredProject configuredProject = value = (LoadedProject.ConfiguredProject)right.value();
                    product = configuredProject;
                } else {
                    throw new MatchError(option2);
                }
                rawProject = product;
            } else {
                throw new MatchError((Object)option);
            }
            return rawProject;
        }, List$.MODULE$.canBuildFrom());
    }

    private <T> Coeval<T> tryEnablingSemanticDB(List<Project> projects, Path configDir, String scalaVersion, String semanticDBVersion, List<String> supportedScalaVersions, bloop.logging.Logger logger, Function1<Option<Path>, T> enableMetals) {
        Coeval coeval;
        boolean isUnsupportedVersion;
        boolean bl = isUnsupportedVersion = !supportedScalaVersions.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)scalaVersion.startsWith(x$6)));
        if (isUnsupportedVersion) {
            logger.debug(Feedback$.MODULE$.skippedUnsupportedScalaMetals(scalaVersion), (DebugFilter)DebugFilter.All$.MODULE$);
            coeval = Coeval$.MODULE$.now(enableMetals.apply((Object)None$.MODULE$));
        } else {
            coeval = Coeval$.MODULE$.eval((Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                Either<String, Path> either = SemanticDBCache$.MODULE$.fetchPlugin(scalaVersion, semanticDBVersion, logger);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Path path = ((AbsolutePath)right.value()).underlying();
                    logger.debug(Feedback$.MODULE$.configuredMetalsProjects((Traversable<Project>)projects), (DebugFilter)DebugFilter.All$.MODULE$);
                    object = enableMetals.apply((Object)new Some((Object)new AbsolutePath(path)));
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    String cause = (String)left.value();
                    logger.displayWarningToUser(Feedback$.MODULE$.failedMetalsConfiguration(scalaVersion, cause));
                    object = enableMetals.apply((Object)None$.MODULE$);
                } else {
                    throw new MatchError(either);
                }
                return object;
            });
        }
        return coeval;
    }

    private Project loadProject(byte[] bytes, Origin origin, bloop.logging.Logger logger) {
        return Project$.MODULE$.fromBytesAndOrigin(bytes, origin, logger);
    }

    public static final /* synthetic */ boolean $anonfun$readConfigurationFilesInBase$1(String workspaceFileName$1, Paths.AttributedPath x$1) {
        String string = AbsolutePath$.MODULE$.toFile$extension(x$1.path()).getName();
        String string2 = workspaceFileName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private BuildLoader$() {
        MODULE$ = this;
        this.JsonFilePattern = "glob:**.json";
    }
}

