/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks;

import bloop.CompileBackgroundTasks;
import bloop.CompileExceptions;
import bloop.CompileInputs;
import bloop.CompileMode;
import bloop.CompileOutPaths;
import bloop.CompileOutPaths$;
import bloop.CompileProducts;
import bloop.Compiler;
import bloop.Compiler$;
import bloop.Compiler$Result$Empty$;
import bloop.CompilerCache;
import bloop.ScalaInstance;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.data.ClientInfo;
import bloop.data.Project;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.Dag;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Feedback$;
import bloop.engine.State;
import bloop.engine.caches.LastSuccessfulResult;
import bloop.engine.caches.LastSuccessfulResult$;
import bloop.engine.caches.ResultsCache;
import bloop.engine.tasks.CompileTask;
import bloop.engine.tasks.compilation.CompileBundle;
import bloop.engine.tasks.compilation.CompileBundle$;
import bloop.engine.tasks.compilation.CompileClientStore;
import bloop.engine.tasks.compilation.CompileDefinitions;
import bloop.engine.tasks.compilation.CompileGraph;
import bloop.engine.tasks.compilation.CompileGraph$;
import bloop.engine.tasks.compilation.CompileSourcesAndInstance;
import bloop.engine.tasks.compilation.CompilerPluginWhitelist$;
import bloop.engine.tasks.compilation.FinalCompileResult;
import bloop.engine.tasks.compilation.FinalNormalCompileResult;
import bloop.engine.tasks.compilation.FinalNormalCompileResult$HasException$;
import bloop.engine.tasks.compilation.PartialCompileResult;
import bloop.engine.tasks.compilation.PartialCompileResult$;
import bloop.engine.tasks.compilation.ResultBundle;
import bloop.engine.tasks.compilation.SuccessfulCompileBundle;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ParallelOps;
import bloop.io.ParallelOps$;
import bloop.io.Paths$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.LoggerAction;
import bloop.logging.ObservedLogger;
import bloop.logging.ObservedLogger$;
import bloop.reporter.ObservedReporter;
import bloop.reporter.Reporter;
import bloop.reporter.ReporterAction;
import bloop.reporter.ReporterInputs;
import bloop.reporter.ZincReporter;
import bloop.tracing.BraveTracer;
import bloop.tracing.BraveTracer$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import xsbti.compile.Signature;

public final class CompileTask$ {
    public static CompileTask$ MODULE$;
    private final DebugFilter logContext;

    static {
        new CompileTask$();
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    public <UseSiteLogger extends Logger> Task<State> compile(State state, Dag<Project> dag, Function1<ReporterInputs<UseSiteLogger>, Reporter> createReporter, boolean pipeline, boolean excludeRoot, Promise<BoxedUnit> cancelCompilation, CompileClientStore store, UseSiteLogger rawLogger) {
        String string;
        Path originUri = state.build().origin();
        Path cwd = AbsolutePath$.MODULE$.getParent$extension(originUri);
        String topLevelTargets = Dag$.MODULE$.directDependencies(new .colon.colon(dag, (List)Nil$.MODULE$)).mkString(", ");
        ClientInfo clientInfo = state.client();
        if (clientInfo instanceof ClientInfo.CliClientInfo) {
            ClientInfo.CliClientInfo cliClientInfo = (ClientInfo.CliClientInfo)clientInfo;
            string = cliClientInfo.id();
        } else if (clientInfo instanceof ClientInfo.BspClientInfo) {
            ClientInfo.BspClientInfo bspClientInfo = (ClientInfo.BspClientInfo)clientInfo;
            string = bspClientInfo.uniqueId();
        } else {
            throw new MatchError((Object)clientInfo);
        }
        String clientName = string;
        BraveTracer rootTracer = BraveTracer$.MODULE$.apply(new StringBuilder(23).append("compile ").append(topLevelTargets).append(" (transitively)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bloop.version"), (Object)BuildInfo$.MODULE$.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zinc.version"), (Object)BuildInfo$.MODULE$.zincVersion()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"build.uri"), (Object)AbsolutePath$.MODULE$.syntax$extension(originUri)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compile.target"), (Object)topLevelTargets), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client"), (Object)clientName)}));
        BraveTracer bgTracer = rootTracer.toIndependentTracer(new StringBuilder(50).append("background IO work after compiling ").append(topLevelTargets).append(" (transitively)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bloop.version"), (Object)BuildInfo$.MODULE$.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zinc.version"), (Object)BuildInfo$.MODULE$.zincVersion()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"build.uri"), (Object)AbsolutePath$.MODULE$.syntax$extension(originUri)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compile.target"), (Object)topLevelTargets), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client"), (Object)clientName)}));
        ClientInfo client = state.client();
        return CompileGraph$.MODULE$.traverse(dag, client, store, (Function1<CompileDefinitions.BundleInputs, Task<CompileBundle>>)(Function1 & Serializable & scala.Serializable)x$8 -> CompileTask$.setup$1(x$8, pipeline, state, rootTracer, cancelCompilation, rawLogger, createReporter, cwd), (Function1<CompileGraph.Inputs, Task<ResultBundle>>)(Function1 & Serializable & scala.Serializable)x$9 -> this.compile$1((CompileGraph.Inputs)x$9, rootTracer, state, (Promise)cancelCompilation, bgTracer, rawLogger), pipeline).flatMap((Function1 & Serializable & scala.Serializable)pdag -> {
            List partialResults = Dag$.MODULE$.dfs(pdag);
            List finalResults = (List)partialResults.map((Function1 & Serializable & scala.Serializable)r -> PartialCompileResult$.MODULE$.toFinalResult((PartialCompileResult)r), List$.MODULE$.canBuildFrom());
            return Task$.MODULE$.gatherUnordered((TraversableOnce)finalResults).map((Function1 & Serializable & scala.Serializable)x$10 -> (List)x$10.flatten((Function1)Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)results -> {
                State state;
                List<Task<BoxedUnit>> cleanUpTasksToRunInBackground = MODULE$.markUnusedClassesDirAndCollectCleanUpTasks((List<FinalCompileResult>)results, rawLogger);
                List failures = (List)results.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Nil$ nil$;
                    FinalCompileResult finalCompileResult = x0$1;
                    if (finalCompileResult instanceof FinalNormalCompileResult) {
                        Compiler.Result$.Success success;
                        FinalNormalCompileResult finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult;
                        Project p = finalNormalCompileResult.project();
                        ResultBundle results = finalNormalCompileResult.result();
                        Compiler.Result result = results.fromCompiler();
                        Option option = Compiler.Result$.NotOk$.MODULE$.unapply(result);
                        Object object = !option.isEmpty() ? new .colon.colon((Object)p, (List)Nil$.MODULE$) : (result instanceof Compiler.Result$.Success && (success = (Compiler.Result$.Success)result).reportedFatalWarnings() ? new .colon.colon((Object)p, (List)Nil$.MODULE$) : Nil$.MODULE$);
                        nil$ = object;
                    } else {
                        nil$ = Nil$.MODULE$;
                    }
                    return nil$;
                }, List$.MODULE$.canBuildFrom());
                ResultsCache x$1 = state.results().addFinalResults((List<FinalCompileResult>)results);
                Build x$2 = state.copy$default$1();
                CompilerCache x$3 = state.copy$default$3();
                ClientInfo x$4 = state.copy$default$4();
                ClientPool x$5 = state.copy$default$5();
                CommonOptions x$6 = state.copy$default$6();
                ExitStatus x$7 = state.copy$default$7();
                Logger x$8 = state.copy$default$8();
                State stateWithResults = state.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
                if (failures.isEmpty()) {
                    ExitStatus x$9 = ExitStatus$.MODULE$.Ok();
                    Build x$10 = stateWithResults.copy$default$1();
                    ResultsCache x$112 = stateWithResults.copy$default$2();
                    CompilerCache x$122 = stateWithResults.copy$default$3();
                    ClientInfo x$13 = stateWithResults.copy$default$4();
                    ClientPool x$14 = stateWithResults.copy$default$5();
                    CommonOptions x$15 = stateWithResults.copy$default$6();
                    Logger x$16 = stateWithResults.copy$default$8();
                    state = stateWithResults.copy(x$10, x$112, x$122, x$13, x$14, x$15, x$9, x$16);
                } else {
                    results.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        CompileTask$.$anonfun$compile$22(rawLogger, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    ClientInfo clientInfo = client;
                    if (clientInfo instanceof ClientInfo.CliClientInfo) {
                        List projectsFailedToCompile = ((List)failures.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("'").append(p.name()).append("'").toString(), List$.MODULE$.canBuildFrom())).reverse();
                        String failureMessage = failures.size() <= 2 ? projectsFailedToCompile.mkString(",") : new StringBuilder(19).append(projectsFailedToCompile.take(2).mkString(", ")).append(" and ").append(projectsFailedToCompile.size() - 2).append(" more projects").toString();
                        rawLogger.error(new StringBuilder(18).append("Failed to compile ").append(failureMessage).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (clientInfo instanceof ClientInfo.BspClientInfo) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)clientInfo);
                    }
                    ExitStatus x$17 = ExitStatus$.MODULE$.CompilationError();
                    Build x$18 = stateWithResults.copy$default$1();
                    ResultsCache x$19 = stateWithResults.copy$default$2();
                    CompilerCache x$20 = stateWithResults.copy$default$3();
                    ClientInfo x$21 = stateWithResults.copy$default$4();
                    ClientPool x$22 = stateWithResults.copy$default$5();
                    CommonOptions x$23 = stateWithResults.copy$default$6();
                    Logger x$24 = stateWithResults.copy$default$8();
                    state = stateWithResults.copy(x$18, x$19, x$20, x$21, x$22, x$23, x$17, x$24);
                }
                State newState = state;
                MODULE$.runIOTasksInParallel((Traversable)cleanUpTasksToRunInBackground, MODULE$.runIOTasksInParallel$default$2());
                Task runningTasksRequiredForCorrectness = Task$.MODULE$.sequence((TraversableOnce)results.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Nil$ nil$;
                    FinalCompileResult finalCompileResult = x0$3;
                    if (finalCompileResult instanceof FinalNormalCompileResult) {
                        FinalNormalCompileResult finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult;
                        ResultBundle result = finalNormalCompileResult.result();
                        Task tasksAtEndOfBuildCompilation = Task$.MODULE$.fromFuture(result.runningBackgroundTasks());
                        nil$ = new .colon.colon((Object)tasksAtEndOfBuildCompilation, (List)Nil$.MODULE$);
                    } else {
                        nil$ = Nil$.MODULE$;
                    }
                    return nil$;
                }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                return runningTasksRequiredForCorrectness.executeOn(ExecutionContext$.MODULE$.ioScheduler()).map((Function1 & Serializable & scala.Serializable)x$11 -> newState).doOnFinish((Function1 & Serializable & scala.Serializable)x$12 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> rootTracer.terminate()));
            });
        });
    }

    private CompileTask.ConfiguredCompilation configureCompilation(Project project, CompileGraph.Inputs graphInputs, CompileOutPaths out) {
        CompileTask.ConfiguredCompilation configuredCompilation;
        Option<CompileDefinitions.PipelineInputs> option = graphInputs.pipelineInputs();
        if (option instanceof Some) {
            Some some = (Some)option;
            CompileDefinitions.PipelineInputs inputs = (CompileDefinitions.PipelineInputs)some.value();
            List<String> scalacOptions = project.scalacOptions();
            CompileMode.Pipelined newMode = new CompileMode.Pipelined(inputs.completeJava(), inputs.finishedCompilation(), inputs.transitiveJavaSignal(), graphInputs.oracle(), inputs.separateJavaAndScala());
            configuredCompilation = new CompileTask.ConfiguredCompilation((CompileMode)newMode, scalacOptions);
        } else if (None$.MODULE$.equals(option)) {
            CompileMode.Sequential newMode = new CompileMode.Sequential(graphInputs.oracle());
            configuredCompilation = new CompileTask.ConfiguredCompilation((CompileMode)newMode, project.scalacOptions());
        } else {
            throw new MatchError(option);
        }
        return configuredCompilation;
    }

    private void runPipeliningBookkeeping(CompileGraph.Inputs inputs, Compiler.Result result, boolean javaOnly, Logger logger) {
        String projectName = inputs.bundle().project().name();
        Option<CompileDefinitions.PipelineInputs> option = inputs.pipelineInputs();
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            CompileDefinitions.PipelineInputs pipelineInputs = (CompileDefinitions.PipelineInputs)some.value();
            Compiler.Result result2 = result;
            Option option2 = Compiler.Result$.NotOk$.MODULE$.unapply(result2);
            if (!option2.isEmpty()) {
                pipelineInputs.irPromise().tryFailure((Throwable)CompileExceptions.FailedOrCancelledPromise$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                Boolean bl;
                Compiler.Result result3 = result2;
                if (result3 instanceof Compiler.Result$.Success) {
                    Compiler.Result$.Success success = (Compiler.Result$.Success)result3;
                    bl = pipelineInputs.finishedCompilation().success((Object)new Some((Object)success.products()));
                } else {
                    bl = Compiler$Result$Empty$.MODULE$.equals(result3) ? BoxesRunTime.boxToBoolean((boolean)pipelineInputs.finishedCompilation().trySuccess((Object)None$.MODULE$)) : BoxesRunTime.boxToBoolean((boolean)pipelineInputs.finishedCompilation().tryFailure((Throwable)CompileExceptions.CompletePromise$.MODULE$));
                }
                boolean completed = pipelineInputs.irPromise().tryFailure((Throwable)CompileExceptions.CompletePromise$.MODULE$);
                if (completed && !javaOnly) {
                    logger.warn(new StringBuilder(46).append("The project ").append(projectName).append(" didn't use pipelined compilation.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private Task<BoxedUnit> populateNewReadOnlyClassesDir(CompileProducts products, BraveTracer tracer, Logger logger) {
        Task task;
        Path path = products.readOnlyClassesDir();
        Path path2 = products.newClassesDir();
        if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
            logger.warn(new StringBuilder(52).append("Running `populateNewReadOnlyClassesDir` on same dir ").append(products.newClassesDir()).toString());
            task = Task$.MODULE$.unit();
        } else {
            Set blacklist = products.invalidatedCompileProducts().iterator().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toPath()).toSet();
            ParallelOps.CopyConfiguration config = ParallelOps.CopyConfiguration$.MODULE$.apply(5, (ParallelOps.CopyMode)ParallelOps.CopyMode$.NoReplace$.MODULE$, blacklist);
            Task task2 = tracer.traceTask("preparing new read-only classes directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$14 -> ParallelOps$.MODULE$.copyDirectories(config, products.readOnlyClassesDir(), products.newClassesDir(), ExecutionContext$.MODULE$.ioScheduler(), logger, false));
            task = task2.map((Function1 & Serializable & scala.Serializable)rs -> {
                CompileTask$.$anonfun$populateNewReadOnlyClassesDir$3(rs);
                return BoxedUnit.UNIT;
            }).memoize();
        }
        return task;
    }

    private List<Task<BoxedUnit>> markUnusedClassesDirAndCollectCleanUpTasks(List<FinalCompileResult> results, Logger logger) {
        ListBuffer cleanUpTasksToSpawnInBackground = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1 & Serializable & scala.Serializable)finalResult -> {
            Task task;
            ResultBundle resultBundle = finalResult.result();
            Option<LastSuccessfulResult> newSuccessful = resultBundle.successful();
            Compiler.Result compilerResult = resultBundle.fromCompiler();
            Task populateNewProductsTask = (Task)newSuccessful.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.populatingProducts()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Task$.MODULE$.unit());
            Option<LastSuccessfulResult> option = resultBundle.previous();
            if (None$.MODULE$.equals(option)) {
                task = populateNewProductsTask;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                LastSuccessfulResult previousSuccessful = (LastSuccessfulResult)some.value();
                task = previousSuccessful.populatingProducts().flatMap((Function1 & Serializable & scala.Serializable)previousPopulate -> populateNewProductsTask.flatMap((Function1 & Serializable & scala.Serializable)populate -> MODULE$.cleanUpPreviousResult(previousSuccessful, compilerResult, logger).map((Function1 & Serializable & scala.Serializable)_ -> {
                    CompileTask$.$anonfun$markUnusedClassesDirAndCollectCleanUpTasks$6(_);
                    return BoxedUnit.UNIT;
                })));
            } else {
                throw new MatchError(option);
            }
            Task cleanUpPreviousLastSuccessful = task;
            return cleanUpTasksToSpawnInBackground.$plus$eq((Object)cleanUpPreviousLastSuccessful);
        });
        return cleanUpTasksToSpawnInBackground.toList();
    }

    public <T> void runIOTasksInParallel(Traversable<Task<T>> tasks, int parallelUnits) {
        Task aggregatedTask = Task$.MODULE$.sequence((TraversableOnce)tasks.toList().grouped(parallelUnits).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((TraversableOnce)group)), (CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom());
        aggregatedTask.map((Function1 & Serializable & scala.Serializable)x$16 -> {
            CompileTask$.$anonfun$runIOTasksInParallel$2(x$16);
            return BoxedUnit.UNIT;
        }).runAsync(ExecutionContext$.MODULE$.ioScheduler());
    }

    public <T> int runIOTasksInParallel$default$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Task<BoxedUnit> cleanUpPreviousResult(LastSuccessfulResult previousSuccessful, Compiler.Result compilerResult, Logger logger) {
        Task task;
        None$ previousReadOnlyToDelete;
        None$ none$;
        Path previousClassesDir = previousSuccessful.classesDir();
        int currentlyUsedCounter = previousSuccessful.counterForClassesDir().decrementAndGet(1);
        Compiler.Result result = compilerResult;
        if (result instanceof Compiler.Result$.Success) {
            None$ none$2;
            Compiler.Result$.Success success = (Compiler.Result$.Success)result;
            CompileProducts products = success.products();
            boolean isNoOp = success.isNoOp();
            if (isNoOp) {
                logger.debug(new StringBuilder(48).append("Skipping delete of ").append(new AbsolutePath(previousClassesDir)).append(" associated with no-op result").toString(), this.logContext());
                none$2 = None$.MODULE$;
            } else if (CompileOutPaths$.MODULE$.hasEmptyClassesDir(previousClassesDir)) {
                logger.debug(new StringBuilder(37).append("Skipping delete of empty classes dir ").append(new AbsolutePath(previousClassesDir)).toString(), this.logContext());
                none$2 = None$.MODULE$;
            } else if (currentlyUsedCounter != 0) {
                logger.debug(new StringBuilder(32).append("Skipping delete of ").append(new AbsolutePath(previousClassesDir)).append(", counter is ").append(currentlyUsedCounter).toString(), this.logContext());
                none$2 = None$.MODULE$;
            } else {
                Path newClassesDir = products.newClassesDir();
                logger.debug(new StringBuilder(36).append("Scheduling to delete ").append(new AbsolutePath(previousClassesDir)).append(" superseded by ").append(newClassesDir).toString(), this.logContext());
                none$2 = new Some((Object)new AbsolutePath(previousClassesDir));
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        None$ none$3 = previousReadOnlyToDelete = none$;
        if (None$.MODULE$.equals(none$3)) {
            task = Task$.MODULE$.unit();
        } else if (none$3 instanceof Some) {
            Some some = (Some)none$3;
            Path classesDir = ((AbsolutePath)some.value()).underlying();
            task = Task$.MODULE$.fork(Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                logger.debug(new StringBuilder(32).append("Deleting contents of orphan dir ").append(new AbsolutePath(classesDir)).toString(), MODULE$.logContext());
                Paths$.MODULE$.delete(classesDir);
            }));
        } else {
            throw new MatchError((Object)none$3);
        }
        return task;
    }

    public static final /* synthetic */ void $anonfun$compile$1(Project project$1, ObservedLogger logger$1, List missing) {
        Feedback$.MODULE$.detectMissingDependencies(project$1.name(), (List<String>)missing).foreach((Function1 & Serializable & scala.Serializable)msg -> {
            logger$1.warn(msg);
            return BoxedUnit.UNIT;
        });
    }

    private static final CancelableFuture runPostCompilationTasks$1(CompileBackgroundTasks backgroundTasks, Path externalUserClassesDir$1, ObservedReporter reporter$1, BraveTracer compileProjectTracer$1) {
        Task postCompilationTasks = backgroundTasks.trigger(externalUserClassesDir$1, reporter$1.underlying(), compileProjectTracer$1).doOnFinish((Function1 & Serializable & scala.Serializable)x$4 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> compileProjectTracer$1.terminate()));
        return postCompilationTasks.runAsync(ExecutionContext$.MODULE$.ioScheduler());
    }

    public static final /* synthetic */ void $anonfun$compile$14(BoxedUnit _) {
    }

    private final Task compile$1(CompileGraph.Inputs graphInputs, BraveTracer rootTracer$1, State state$1, Promise cancelCompilation$1, BraveTracer bgTracer$1, Logger rawLogger$1) {
        Right right;
        CompileSourcesAndInstance compileSourcesAndInstance;
        Task task;
        SuccessfulCompileBundle bundle = graphInputs.bundle();
        Project project = bundle.project();
        ObservedLogger<Logger> logger = bundle.logger();
        ObservedReporter reporter = bundle.reporter();
        Compiler.Result previousResult = bundle.latestResult();
        CompileOutPaths compileOut = bundle.out();
        LastSuccessfulResult lastSuccessful = bundle.lastSuccessful();
        BraveTracer compileProjectTracer = rootTracer$1.startNewChildTracer(new StringBuilder(8).append("compile ").append(project.name()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compile.target"), (Object)project.name())}));
        Either<ResultBundle, CompileSourcesAndInstance> either = bundle.prepareSourcesAndInstance();
        if (either instanceof Left) {
            Object object;
            Left left = (Left)either;
            ResultBundle earlyResultBundle = (ResultBundle)left.value();
            Option<CompileDefinitions.PipelineInputs> option = graphInputs.pipelineInputs();
            if (None$.MODULE$.equals(option)) {
                object = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                CompileDefinitions.PipelineInputs inputs = (CompileDefinitions.PipelineInputs)some.value();
                inputs.irPromise().trySuccess((Object)new Signature[0]);
                inputs.finishedCompilation().trySuccess((Object)None$.MODULE$);
                object = BoxesRunTime.boxToBoolean((boolean)inputs.completeJava().trySuccess((Object)BoxedUnit.UNIT));
            } else {
                throw new MatchError(option);
            }
            compileProjectTracer.terminate();
            task = Task$.MODULE$.now((Object)earlyResultBundle);
        } else if (either instanceof Right && (compileSourcesAndInstance = (CompileSourcesAndInstance)(right = (Right)either).value()) != null) {
            List<Path> sources = compileSourcesAndInstance.sources();
            ScalaInstance instance = compileSourcesAndInstance.instance();
            boolean javaOnly = compileSourcesAndInstance.javaOnly();
            Path externalUserClassesDir = bundle.clientClassesDir();
            Path readOnlyClassesDir = lastSuccessful.classesDir();
            Path newClassesDir = compileOut.internalNewClassesDir();
            AbsolutePath[] classpath = bundle.dependenciesData().buildFullCompileClasspathFor(project, readOnlyClassesDir, newClassesDir);
            state$1.build().hasMissingDependencies(project).foreach((Function1 & Serializable & scala.Serializable)missing -> {
                CompileTask$.$anonfun$compile$1(project, logger, missing);
                return BoxedUnit.UNIT;
            });
            CompileTask.ConfiguredCompilation configuration = this.configureCompilation(project, graphInputs, compileOut);
            Task<List<String>> newScalacOptions2 = CompilerPluginWhitelist$.MODULE$.enableCachingInScalacOptions(instance.version(), configuration.scalacOptions(), (Logger)logger, compileProjectTracer, 5);
            Task inputs = newScalacOptions2.map((Function1 & Serializable & scala.Serializable)newScalacOptions -> new CompileInputs(instance, state$1.compilerCache(), (AbsolutePath[])sources.toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), classpath, bundle.uniqueInputs(), compileOut, project.out(), (String[])newScalacOptions.toArray(ClassTag$.MODULE$.apply(String.class)), (String[])project.javacOptions().toArray(ClassTag$.MODULE$.apply(String.class)), project.jdkConfig().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.javacBin()), project.compileOrder(), project.classpathOptions(), lastSuccessful.previous(), previousResult, (ZincReporter)reporter, logger, configuration.mode(), graphInputs.dependentResults(), cancelCompilation$1, compileProjectTracer, ExecutionContext$.MODULE$.ioScheduler(), (Executor)ExecutionContext$.MODULE$.ioExecutor(), bundle.dependenciesData().allInvalidatedClassFiles(), bundle.dependenciesData().allGeneratedClassFilePaths()));
            Task waitOnReadClassesDir = compileProjectTracer.traceTask("wait on populating products", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$2 -> lastSuccessful.populatingProducts());
            task = waitOnReadClassesDir.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> inputs.flatMap((Function1 & Serializable & scala.Serializable)inputs -> Compiler$.MODULE$.compile(inputs)).map((Function1 & Serializable & scala.Serializable)result -> {
                ResultBundle resultBundle;
                MODULE$.runPipeliningBookkeeping(graphInputs, (Compiler.Result)result, javaOnly, (Logger)logger);
                Compiler.Result result2 = result;
                if (result2 instanceof Compiler.Result$.Success) {
                    Compiler.Result$.Success success = (Compiler.Result$.Success)result2;
                    CancelableFuture runningTasks = CompileTask$.runPostCompilationTasks$1(success.backgroundTasks(), externalUserClassesDir, reporter, compileProjectTracer);
                    Task blockingOnRunningTasks = Task$.MODULE$.fromFuture((Future)runningTasks).executeOn(ExecutionContext$.MODULE$.ioScheduler());
                    Task populatingTask = success.isNoOp() ? blockingOnRunningTasks : blockingOnRunningTasks.flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.populateNewReadOnlyClassesDir(success.products(), bgTracer$1, rawLogger$1).doOnFinish((Function1 & Serializable & scala.Serializable)x$5 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bgTracer$1.terminate())).map((Function1 & Serializable & scala.Serializable)_ -> {
                        CompileTask$.$anonfun$compile$14(_);
                        return BoxedUnit.UNIT;
                    }));
                    LastSuccessfulResult newSuccessful = LastSuccessfulResult$.MODULE$.apply(bundle.uniqueInputs(), success.products(), (Task<BoxedUnit>)populatingTask.memoize());
                    resultBundle = new ResultBundle((Compiler.Result)success, (Option<LastSuccessfulResult>)new Some((Object)newSuccessful), (Option<LastSuccessfulResult>)new Some((Object)lastSuccessful), (CancelableFuture<BoxedUnit>)runningTasks);
                } else if (result2 instanceof Compiler.Result$.Failed) {
                    Compiler.Result$.Failed failed = (Compiler.Result$.Failed)result2;
                    CancelableFuture runningTasks = CompileTask$.runPostCompilationTasks$1(failed.backgroundTasks(), externalUserClassesDir, reporter, compileProjectTracer);
                    resultBundle = new ResultBundle((Compiler.Result)result, (Option<LastSuccessfulResult>)None$.MODULE$, (Option<LastSuccessfulResult>)new Some((Object)lastSuccessful), (CancelableFuture<BoxedUnit>)runningTasks);
                } else if (result2 instanceof Compiler.Result$.Cancelled) {
                    Compiler.Result$.Cancelled cancelled = (Compiler.Result$.Cancelled)result2;
                    CancelableFuture runningTasks = CompileTask$.runPostCompilationTasks$1(cancelled.backgroundTasks(), externalUserClassesDir, reporter, compileProjectTracer);
                    resultBundle = new ResultBundle((Compiler.Result)result, (Option<LastSuccessfulResult>)None$.MODULE$, (Option<LastSuccessfulResult>)new Some((Object)lastSuccessful), (CancelableFuture<BoxedUnit>)runningTasks);
                } else {
                    boolean bl = result2 instanceof Compiler.Result$.Blocked ? true : (Compiler$Result$Empty$.MODULE$.equals(result2) ? true : result2 instanceof Compiler.Result.GlobalError);
                    if (bl) {
                        resultBundle = new ResultBundle((Compiler.Result)result, (Option<LastSuccessfulResult>)None$.MODULE$, (Option<LastSuccessfulResult>)None$.MODULE$, (CancelableFuture<BoxedUnit>)CancelableFuture$.MODULE$.unit());
                    } else {
                        throw new MatchError((Object)result2);
                    }
                }
                return resultBundle;
            }));
        } else {
            throw new MatchError(either);
        }
        return task;
    }

    private static final Task setup$1(CompileDefinitions.BundleInputs inputs, boolean pipeline$1, State state$1, BraveTracer rootTracer$1, Promise cancelCompilation$1, Logger rawLogger$1, Function1 createReporter$1, Path cwd$1) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.replay(), ExecutionContext$.MODULE$.ioScheduler());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Observer.Sync observer = (Observer.Sync)tuple23._1();
        Observable obs = (Observable)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)observer, (Object)obs);
        Tuple2 tuple25 = tuple24;
        Observer.Sync observer2 = (Observer.Sync)tuple25._1();
        Observable obs2 = (Observable)tuple25._2();
        if (pipeline$1) {
            LastSuccessfulResult emptySuccessful = LastSuccessfulResult$.MODULE$.empty(inputs.project());
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Compiler$Result$Empty$.MODULE$), (Object)emptySuccessful);
        } else {
            Compiler.Result latestResult = state$1.results().latestResult(inputs.project());
            LastSuccessfulResult lastSuccessful = state$1.results().lastSuccessfulResultOrEmpty(inputs.project());
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)latestResult), (Object)lastSuccessful);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Compiler.Result prev = (Compiler.Result)tuple2._1();
        LastSuccessfulResult last = (LastSuccessfulResult)tuple2._2();
        Tuple2 tuple26 = new Tuple2((Object)prev, (Object)last);
        Tuple2 tuple27 = tuple26;
        Compiler.Result prev2 = (Compiler.Result)tuple27._1();
        LastSuccessfulResult last2 = (LastSuccessfulResult)tuple27._2();
        BraveTracer t = rootTracer$1;
        CommonOptions o = state$1.commonOptions();
        Promise cancel = cancelCompilation$1;
        ObservedLogger logger = ObservedLogger$.MODULE$.apply(rawLogger$1, (Observer)observer2);
        Path dir = state$1.client().getUniqueClassesDirFor(inputs.project(), true);
        Reporter underlying = (Reporter)createReporter$1.apply(new ReporterInputs<Logger>(inputs.project(), cwd$1, rawLogger$1));
        ObservedReporter reporter = new ObservedReporter(logger, underlying);
        return CompileBundle$.MODULE$.computeFrom(inputs, dir, reporter, last2, prev2, (Promise<BoxedUnit>)cancel, (ObservedLogger<Logger>)logger, (Observable<Either<ReporterAction, LoggerAction>>)obs2, t, o);
    }

    public static final /* synthetic */ void $anonfun$compile$22(Logger rawLogger$1, FinalCompileResult x0$2) {
        FinalNormalCompileResult finalNormalCompileResult;
        Option<Tuple2<Project, Throwable>> option;
        FinalCompileResult finalCompileResult = x0$2;
        if (finalCompileResult instanceof FinalNormalCompileResult && !(option = FinalNormalCompileResult$HasException$.MODULE$.unapply(finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult)).isEmpty()) {
            Project project = (Project)((Tuple2)option.get())._1();
            Throwable t = (Throwable)((Tuple2)option.get())._2();
            rawLogger$1.error(new StringBuilder(36).append("Unexpected error when compiling ").append(project.name()).append(": '").append(t.getMessage()).append("'").toString());
            rawLogger$1.trace(t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$populateNewReadOnlyClassesDir$3(ParallelOps.FileWalk rs) {
    }

    public static final /* synthetic */ void $anonfun$markUnusedClassesDirAndCollectCleanUpTasks$6(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$runIOTasksInParallel$2(Iterator x$16) {
    }

    private CompileTask$() {
        MODULE$ = this;
        this.logContext = DebugFilter.Compilation$.MODULE$;
    }
}

