/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.UniqueCompileInputs;
import bloop.data.Project;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ByteHasher$;
import bloop.util.monix.FoldLeftAsyncConsumer$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import monix.execution.cancelables.AssignableCancelable;
import monix.reactive.Consumer;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Right;

public final class SourceHasher$ {
    public static SourceHasher$ MODULE$;
    private final PathMatcher sourceMatcher;

    static {
        new SourceHasher$();
    }

    private final PathMatcher sourceMatcher() {
        return this.sourceMatcher;
    }

    public Task<Either<BoxedUnit, List<UniqueCompileInputs.HashedSource>>> findAndHashSourcesInProject(Project project, int parallelUnits, Promise<BoxedUnit> cancelCompilation, Scheduler scheduler2) {
        AtomicBoolean isCancelled = AtomicBoolean$.MODULE$.apply(false);
        List sourceFilesAndDirectories = (List)project.sources().distinct();
        HashSet visitedDirs = new HashSet();
        Tuple2 tuple2 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.publish(), scheduler2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Observer.Sync observer = (Observer.Sync)tuple2._1();
        Observable observable = (Observable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)observer, (Object)observable);
        Tuple2 tuple23 = tuple22;
        Observer.Sync observer2 = (Observer.Sync)tuple23._1();
        Observable observable2 = (Observable)tuple23._2();
        Promise subscribed = Promise$.MODULE$.apply();
        Task discoverFileTree = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FileVisitor discovery = SourceHasher$.fileVisitor$1((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SourceHasher$.$anonfun$findAndHashSourcesInProject$2(x$1)), isCancelled, observer2, visitedDirs);
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            sourceFilesAndDirectories.foreach((Function1 & Serializable & scala.Serializable)sourcePath -> SourceHasher$.$anonfun$findAndHashSourcesInProject$3(visitedDirs, isCancelled, opts, discovery, ((AbsolutePath)sourcePath).underlying()));
            project.sourcesGlobs().foreach((Function1 & Serializable & scala.Serializable)glob -> {
                FileVisitor discovery = SourceHasher$.fileVisitor$1((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)glob.matches(path)), isCancelled, observer2, visitedDirs);
                return isCancelled.get() ? BoxedUnit.UNIT : Files.walkFileTree(glob.directory(), opts, glob.walkDepth(), discovery);
            });
        }).doOnFinish((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Task task;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable t = (Throwable)some.value();
                task = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> observer2.onError(t));
            } else if (None$.MODULE$.equals(option)) {
                task = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> observer2.onComplete());
            } else {
                throw new MatchError((Object)option);
            }
            return task;
        });
        ListBuffer empty = (ListBuffer)ListBuffer$.MODULE$.empty();
        Consumer collectHashesConsumer = FoldLeftAsyncConsumer$.MODULE$.consume((Function0 & Serializable & scala.Serializable)() -> empty, (Function2 & Serializable & scala.Serializable)(buffer, source) -> Task$.MODULE$.now((Object)buffer.$plus$eq(source)));
        Task collectAllSources = Task$.MODULE$.create((Function2 & Serializable & scala.Serializable)(scheduler, cb) -> {
            Cancelable cancelable;
            if (isCancelled.get()) {
                cb.onSuccess((Object)ListBuffer$.MODULE$.empty());
                subscribed.success((Object)BoxedUnit.UNIT);
                observer2.onComplete();
                cancelable = Cancelable$.MODULE$.empty();
            } else {
                Tuple2 tuple2 = collectHashesConsumer.createSubscriber(cb, scheduler);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Subscriber out = (Subscriber)tuple2._1();
                AssignableCancelable consumerSubscription = (AssignableCancelable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)out, (Object)consumerSubscription);
                Tuple2 tuple23 = tuple22;
                Subscriber out2 = (Subscriber)tuple23._1();
                AssignableCancelable consumerSubscription2 = (AssignableCancelable)tuple23._2();
                Observable hashSourcesInParallel = (Observable)observable2.mapAsync(parallelUnits, (Function1 & Serializable & scala.Serializable)source -> Task$.MODULE$.eval((Function0 & Serializable & scala.Serializable)() -> {
                    int hash = ByteHasher$.MODULE$.hashFileContents(source.toFile(), ByteHasher$.MODULE$.hashFileContents$default$2());
                    return new UniqueCompileInputs.HashedSource(AbsolutePath$.MODULE$.apply(source, AbsolutePath$.MODULE$.workingDirectory()), hash);
                }));
                Cancelable sourceSubscription = hashSourcesInParallel.subscribe(out2);
                subscribed.success((Object)BoxedUnit.UNIT);
                cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    isCancelled.compareAndSet(false, true);
                    try {
                        consumerSubscription2.cancel();
                    }
                    finally {
                        sourceSubscription.cancel();
                    }
                });
            }
            return cancelable;
        });
        Task orderlyDiscovery = Task$.MODULE$.fromFuture(subscribed.future()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> discoverFileTree);
        return Task$.MODULE$.mapBoth(orderlyDiscovery, collectAllSources, (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Right right;
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 != null) {
                ListBuffer sources = (ListBuffer)tuple2._2();
                if (!isCancelled.get()) {
                    right = package$.MODULE$.Right().apply(sources.toList().distinct());
                } else {
                    cancelCompilation.trySuccess((Object)BoxedUnit.UNIT);
                    right = package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Right right2 = right;
            return right2;
        }).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> isCancelled.compareAndSet(false, true)));
    }

    private static final FileVisitor fileVisitor$1(Function1 matches, AtomicBoolean isCancelled$1, Observer.Sync observer$1, HashSet visitedDirs$1) {
        return new FileVisitor<Path>(isCancelled$1, matches, observer$1, visitedDirs$1){
            private final AtomicBoolean isCancelled$1;
            private final Function1 matches$1;
            private final Observer.Sync observer$1;
            private final HashSet visitedDirs$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                FileVisitResult fileVisitResult;
                if (this.isCancelled$1.get()) {
                    fileVisitResult = FileVisitResult.TERMINATE;
                } else {
                    Object object = !BoxesRunTime.unboxToBoolean((Object)this.matches$1.apply((Object)file)) ? BoxedUnit.UNIT : this.observer$1.onNext((Object)file);
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }

            public FileVisitResult visitFileFailed(Path t, IOException e) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                FileVisitResult fileVisitResult;
                if (this.isCancelled$1.get()) {
                    fileVisitResult = FileVisitResult.TERMINATE;
                } else {
                    this.visitedDirs$1.$plus$eq((Object)directory);
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
            {
                this.isCancelled$1 = isCancelled$1;
                this.matches$1 = matches$1;
                this.observer$1 = observer$1;
                this.visitedDirs$1 = visitedDirs$1;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$findAndHashSourcesInProject$2(Path x$1) {
        return MODULE$.sourceMatcher().matches(x$1);
    }

    public static final /* synthetic */ Object $anonfun$findAndHashSourcesInProject$3(HashSet visitedDirs$1, AtomicBoolean isCancelled$1, EnumSet opts$1, FileVisitor discovery$1, Path sourcePath) {
        return visitedDirs$1.contains((Object)sourcePath) ? BoxedUnit.UNIT : (isCancelled$1.get() ? BoxedUnit.UNIT : Files.walkFileTree(sourcePath, opts$1, Integer.MAX_VALUE, discovery$1));
    }

    private SourceHasher$() {
        MODULE$ = this;
        this.sourceMatcher = FileSystems.getDefault().getPathMatcher("glob:**.{scala,java}");
    }
}

