/*
 * Decompiled with CFR 0.152.
 */
package bloop.dap;

import bloop.ScalaInstance;
import bloop.config.Config;
import bloop.dap.AttachRemoteDebugAdapter;
import bloop.dap.MainClassDebugAdapter;
import bloop.dap.TestSuiteDebugAdapter;
import bloop.data.ClientInfo;
import bloop.data.JdkConfig;
import bloop.data.Platform;
import bloop.data.Project;
import bloop.engine.Dag;
import bloop.engine.Dag$;
import bloop.engine.State;
import bloop.engine.caches.ExpressionCompilerCache$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.RelativePath$;
import bloop.logging.Logger;
import ch.epfl.scala.bsp.ScalaMainClass;
import ch.epfl.scala.debugadapter.ClassPathEntry;
import ch.epfl.scala.debugadapter.DebuggeeRunner;
import ch.epfl.scala.debugadapter.JavaRuntime;
import ch.epfl.scala.debugadapter.JavaRuntime$;
import ch.epfl.scala.debugadapter.SourceDirectory;
import ch.epfl.scala.debugadapter.SourceJar;
import ch.epfl.scala.debugadapter.StandaloneSourceFile;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import monix.execution.Scheduler;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BloopDebuggeeRunner$ {
    public static BloopDebuggeeRunner$ MODULE$;

    static {
        new BloopDebuggeeRunner$();
    }

    public Either<String, DebuggeeRunner> forMainClass(Seq<Project> projects, ScalaMainClass mainClass, State state, Scheduler ioScheduler) {
        Left left;
        Seq<Project> seq = projects;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(40).append("No projects specified for main class: [").append(mainClass).append("]").toString());
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                Left left2;
                Project project = (Project)((SeqLike)some2.get()).apply(0);
                Platform platform = project.platform();
                if (platform instanceof Platform.Jvm) {
                    Platform.Jvm jvm = (Platform.Jvm)platform;
                    Seq<ClassPathEntry> classPathEntries = this.getClassPathEntries(state, project);
                    Option<ClassLoader> evaluationClassLoader = this.getEvaluationClassLoader(project, state);
                    Seq<Path> classpath = this.getClasspath(state, project);
                    left2 = package$.MODULE$.Right().apply((Object)new MainClassDebugAdapter(project, mainClass, classPathEntries, evaluationClassLoader, jvm.config(), state, ioScheduler, classpath));
                } else {
                    left2 = package$.MODULE$.Left().apply((Object)new StringBuilder(22).append("Unsupported platform: ").append(platform.getClass().getSimpleName()).toString());
                }
                left = left2;
            } else {
                left = package$.MODULE$.Left().apply((Object)new StringBuilder(47).append("Multiple projects specified for main class [").append(mainClass).append("]: ").append(seq).toString());
            }
        }
        return left;
    }

    public Either<String, DebuggeeRunner> forTestSuite(Seq<Project> projects, List<String> filters, State state, Scheduler ioScheduler) {
        Right right;
        Seq<Project> seq = projects;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            right = package$.MODULE$.Left().apply((Object)new StringBuilder(45).append("No projects specified for the test suites: [").append(filters.sorted((Ordering)Ordering.String$.MODULE$)).append("]").toString());
        } else {
            Project project;
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (project = (Project)((SeqLike)some2.get()).apply(0)).platform() instanceof Platform.Jvm) {
                JdkConfig config;
                Platform platform = project.platform();
                if (!(platform instanceof Platform.Jvm)) {
                    throw new MatchError((Object)platform);
                }
                Platform.Jvm jvm = (Platform.Jvm)platform;
                JdkConfig jdkConfig = config = jvm.config();
                JdkConfig config2 = jdkConfig;
                Seq<ClassPathEntry> classPathEntries = this.getClassPathEntries(state, project);
                Option javaRuntime = JavaRuntime$.MODULE$.apply(config2.javaHome());
                Option<ClassLoader> evaluationClassLoader = this.getEvaluationClassLoader(project, state);
                Seq<Path> classpath = this.getClasspath(state, project);
                right = package$.MODULE$.Right().apply((Object)new TestSuiteDebugAdapter(projects, filters, classPathEntries, (Option<JavaRuntime>)javaRuntime, evaluationClassLoader, state, ioScheduler, classpath));
            } else {
                right = package$.MODULE$.Right().apply((Object)new TestSuiteDebugAdapter(projects, filters, (Seq<ClassPathEntry>)((Seq)Nil$.MODULE$), (Option<JavaRuntime>)None$.MODULE$, (Option<ClassLoader>)None$.MODULE$, state, ioScheduler, (Seq<Path>)((Seq)Nil$.MODULE$)));
            }
        }
        return right;
    }

    public DebuggeeRunner forAttachRemote(State state, Scheduler ioScheduler, Seq<Project> projects) {
        AttachRemoteDebugAdapter attachRemoteDebugAdapter;
        Project project;
        Seq<Project> seq = projects;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (project = (Project)((SeqLike)some.get()).apply(0)).platform() instanceof Platform.Jvm) {
            JdkConfig config;
            Platform platform = project.platform();
            if (!(platform instanceof Platform.Jvm)) {
                throw new MatchError((Object)platform);
            }
            Platform.Jvm jvm = (Platform.Jvm)platform;
            JdkConfig jdkConfig = config = jvm.config();
            JdkConfig config2 = jdkConfig;
            Seq<ClassPathEntry> classPathEntries = this.getClassPathEntries(state, project);
            Option javaRuntime = JavaRuntime$.MODULE$.apply(config2.javaHome());
            Option<ClassLoader> evaluationClassLoader = this.getEvaluationClassLoader(project, state);
            Seq<Path> classpath = this.getClasspath(state, project);
            attachRemoteDebugAdapter = new AttachRemoteDebugAdapter(classPathEntries, (Option<JavaRuntime>)javaRuntime, evaluationClassLoader, state, ioScheduler, classpath);
        } else {
            attachRemoteDebugAdapter = new AttachRemoteDebugAdapter((Seq<ClassPathEntry>)((Seq)Nil$.MODULE$), (Option<JavaRuntime>)None$.MODULE$, (Option<ClassLoader>)None$.MODULE$, state, ioScheduler, (Seq<Path>)((Seq)Nil$.MODULE$));
        }
        return attachRemoteDebugAdapter;
    }

    private Seq<ClassPathEntry> getClassPathEntries(State state, Project project) {
        Dag<Project> dag = state.build().getDagFor(project);
        return (Seq)this.getLibraries(dag).$plus$plus(this.getClassDirectories(dag, state.client()), Seq$.MODULE$.canBuildFrom());
    }

    private Option<ClassLoader> getEvaluationClassLoader(Project project, State state) {
        return project.scalaInstance().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.getEvaluationClassLoader((ScalaInstance)x$5, state.logger()));
    }

    private Option<ClassLoader> getEvaluationClassLoader(ScalaInstance scalaInstance, Logger logger) {
        None$ none$;
        Either<String, AbsolutePath> either = ExpressionCompilerCache$.MODULE$.fetch(scalaInstance.version(), logger);
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            logger.warn(error);
            logger.warn("Expression evaluation will not work.");
            none$ = None$.MODULE$;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Path expressionCompilerJar = ((AbsolutePath)right.value()).underlying();
            URLClassLoader evaluationClassLoader = new URLClassLoader((URL[])((Object[])new URL[]{AbsolutePath$.MODULE$.toFile$extension(expressionCompilerJar).toURI().toURL()}), scalaInstance.loader());
            none$ = new Some((Object)evaluationClassLoader);
        } else {
            throw new MatchError(either);
        }
        return none$;
    }

    private Seq<ClassPathEntry> getLibraries(Dag<Project> dag) {
        return (Seq)((SeqLike)((List)((SeqLike)((List)Dag$.MODULE$.dfs(dag).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Option$.MODULE$.option2Iterable(x$6.resolution()), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.modules(), List$.MODULE$.canBuildFrom())).distinct()).flatMap((Function1 & Serializable & scala.Serializable)module -> Option$.MODULE$.option2Iterable(module.artifacts().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)BloopDebuggeeRunner$.$anonfun$getLibraries$4(x$8))).flatMap((Function1 & Serializable & scala.Serializable)classJar -> module.artifacts().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)BloopDebuggeeRunner$.$anonfun$getLibraries$6(x$9))).map((Function1 & Serializable & scala.Serializable)sourceJar -> {
            SourceJar sourceEntry = new SourceJar(sourceJar.path());
            return new ClassPathEntry(classJar.path(), (Seq)new .colon.colon((Object)sourceEntry, (List)Nil$.MODULE$));
        }))), List$.MODULE$.canBuildFrom())).distinct();
    }

    private Seq<Path> getClasspath(State state, Project project) {
        Dag<Project> dag = state.build().getDagFor(project);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)project.fullClasspath(dag, state.client())).map((Function1 & Serializable & scala.Serializable)x$10 -> ((AbsolutePath)x$10).underlying(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toSeq();
    }

    private Seq<ClassPathEntry> getClassDirectories(Dag<Project> dag, ClientInfo client) {
        return (Seq)Dag$.MODULE$.dfs(dag).map((Function1 & Serializable & scala.Serializable)project -> {
            Buffer sourceBuffer = (Buffer)Buffer$.MODULE$.empty();
            project.sources().foreach((Function1 & Serializable & scala.Serializable)sourcePath -> BloopDebuggeeRunner$.$anonfun$getClassDirectories$2(sourceBuffer, ((AbsolutePath)sourcePath).underlying()));
            project.sourcesGlobs().foreach((Function1 & Serializable & scala.Serializable)glob -> {
                glob.walkThrough((Function1<AbsolutePath, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
                    sourceBuffer$1.$plus$eq((Object)new StandaloneSourceFile(((AbsolutePath)file).underlying(), RelativePath$.MODULE$.toString$extension(AbsolutePath$.MODULE$.toRelative$extension(((AbsolutePath)file).underlying(), glob.directory()))));
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            Path classDir = client.getUniqueClassesDirFor((Project)project, true);
            return new ClassPathEntry(classDir, (Seq)sourceBuffer);
        }, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$getLibraries$4(Config.Artifact x$8) {
        return x$8.classifier().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getLibraries$6(Config.Artifact x$9) {
        return x$9.classifier().contains((Object)"sources");
    }

    public static final /* synthetic */ Buffer $anonfun$getClassDirectories$2(Buffer sourceBuffer$1, Path sourcePath) {
        return AbsolutePath$.MODULE$.isDirectory$extension(sourcePath) ? sourceBuffer$1.$plus$eq((Object)new SourceDirectory(sourcePath)) : sourceBuffer$1.$plus$eq((Object)new StandaloneSourceFile(sourcePath, ((Object)sourcePath.getFileName()).toString()));
    }

    private BloopDebuggeeRunner$() {
        MODULE$ = this;
    }
}

