/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.caches;

import bloop.DependencyResolution;
import bloop.DependencyResolution$;
import bloop.SemanticDBCacheLock$;
import bloop.engine.ExecutionContext$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.Paths$;
import bloop.logging.Logger;
import coursierapi.error.CoursierError;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.internal.inc.BloopComponentCompiler$;
import sbt.internal.inc.BloopComponentManager;
import sbt.internal.inc.IfMissing;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import xsbti.ComponentProvider;
import xsbti.GlobalLock;

public final class SemanticDBCache$ {
    public static SemanticDBCache$ MODULE$;
    private volatile Path latestResolvedScalaSemanticDB;
    private volatile Path latestResolvedJavaSemanticDB;

    static {
        new SemanticDBCache$();
    }

    private Either<String, AbsolutePath> fetchPlugin(DependencyResolution.Artifact artifact, Logger logger) {
        Either either;
        String string = artifact.version();
        String string2 = "latest.release";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            either = SemanticDBCache$.attemptResolution$1(artifact, logger);
        } else {
            Either either2;
            String semanticDBId;
            ComponentProvider provider = BloopComponentCompiler$.MODULE$.getComponentProvider(Paths$.MODULE$.getCacheDirectory("semanticdb"));
            BloopComponentManager manager = new BloopComponentManager((GlobalLock)SemanticDBCacheLock$.MODULE$, provider, (Option)None$.MODULE$);
            Try try_ = Try$.MODULE$.apply(() -> SemanticDBCache$.$anonfun$fetchPlugin$3(manager, semanticDBId = new StringBuilder(2).append(artifact.organization()).append(".").append(artifact.module()).append(".").append(artifact.version()).toString()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                File pluginPath = (File)success.value();
                either2 = package$.MODULE$.Right().apply((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply(pluginPath, AbsolutePath$.MODULE$.workingDirectory())));
            } else if (try_ instanceof Failure) {
                Either resolvedPlugin = SemanticDBCache$.attemptResolution$1(artifact, logger);
                resolvedPlugin.foreach((Function1 & Serializable & scala.Serializable)plugin -> {
                    manager.define(semanticDBId, (Iterable)new .colon.colon((Object)AbsolutePath$.MODULE$.toFile$extension(((AbsolutePath)plugin).underlying()), (List)Nil$.MODULE$));
                    return BoxedUnit.UNIT;
                });
                either2 = resolvedPlugin;
            } else {
                throw new MatchError((Object)try_);
            }
            either = either2;
        }
        return either;
    }

    private Path latestResolvedScalaSemanticDB() {
        return this.latestResolvedScalaSemanticDB;
    }

    private void latestResolvedScalaSemanticDB_$eq(Path x$1) {
        this.latestResolvedScalaSemanticDB = x$1;
    }

    public Either<String, AbsolutePath> fetchScalaPlugin(String scalaVersion, String version, Logger logger) {
        Right right;
        String organization = "org.scalameta";
        String module = new StringBuilder(18).append("semanticdb-scalac_").append(scalaVersion).toString();
        DependencyResolution.Artifact artifact = new DependencyResolution.Artifact(organization, module, version);
        String string = artifact.version();
        String string2 = "latest.release";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Path path = this.latestResolvedScalaSemanticDB();
            synchronized (path) {
                Right right2;
                if (this.latestResolvedScalaSemanticDB() != null) {
                    right2 = package$.MODULE$.Right().apply((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply(this.latestResolvedScalaSemanticDB(), AbsolutePath$.MODULE$.workingDirectory())));
                } else {
                    Right latestResolvedPlugin = this.fetchPlugin(artifact, logger);
                    latestResolvedPlugin.foreach((Function1 & Serializable & scala.Serializable)plugin -> {
                        SemanticDBCache$.MODULE$.latestResolvedScalaSemanticDB_$eq(((AbsolutePath)plugin).underlying());
                        return BoxedUnit.UNIT;
                    });
                    right2 = latestResolvedPlugin;
                }
                Right right3 = right2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var8_8
                right = right3;
            }
        } else {
            right = this.fetchPlugin(artifact, logger);
        }
        return right;
    }

    private Path latestResolvedJavaSemanticDB() {
        return this.latestResolvedJavaSemanticDB;
    }

    private void latestResolvedJavaSemanticDB_$eq(Path x$1) {
        this.latestResolvedJavaSemanticDB = x$1;
    }

    public Either<String, AbsolutePath> fetchJavaPlugin(String version, Logger logger) {
        Right right;
        String organization = "com.sourcegraph";
        String module = "semanticdb-javac";
        DependencyResolution.Artifact artifact = new DependencyResolution.Artifact(organization, module, version);
        String string = artifact.version();
        String string2 = "latest.release";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Path path = this.latestResolvedJavaSemanticDB();
            synchronized (path) {
                Right right2;
                if (this.latestResolvedJavaSemanticDB() != null) {
                    right2 = package$.MODULE$.Right().apply((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply(this.latestResolvedJavaSemanticDB(), AbsolutePath$.MODULE$.workingDirectory())));
                } else {
                    Right latestResolvedPlugin = this.fetchPlugin(artifact, logger);
                    latestResolvedPlugin.foreach((Function1 & Serializable & scala.Serializable)plugin -> {
                        SemanticDBCache$.MODULE$.latestResolvedJavaSemanticDB_$eq(((AbsolutePath)plugin).underlying());
                        return BoxedUnit.UNIT;
                    });
                    right2 = latestResolvedPlugin;
                }
                Right right3 = right2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var7_7
                right = right3;
            }
        } else {
            right = this.fetchPlugin(artifact, logger);
        }
        return right;
    }

    public static final /* synthetic */ boolean $anonfun$fetchPlugin$1(DependencyResolution.Artifact artifact$1, Path x$1) {
        return AbsolutePath$.MODULE$.syntax$extension(x$1).contains(artifact$1.module());
    }

    private static final Either attemptResolution$1(DependencyResolution.Artifact artifact$1, Logger logger$1) {
        Left left;
        Either either = DependencyResolution$.MODULE$.resolveWithErrors((List)new .colon.colon((Object)artifact$1, (List)Nil$.MODULE$), logger$1, DependencyResolution$.MODULE$.resolveWithErrors$default$3(), DependencyResolution$.MODULE$.resolveWithErrors$default$4(), (ExecutionContext)ExecutionContext$.MODULE$.ioScheduler());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            CoursierError error = (CoursierError)left2.value();
            left = package$.MODULE$.Left().apply((Object)error.getMessage());
        } else if (either instanceof Right) {
            Right right;
            Right right2 = (Right)either;
            AbsolutePath[] paths = (AbsolutePath[])right2.value();
            Option option = Predef$.MODULE$.genericArrayOps((Object)paths).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SemanticDBCache$.$anonfun$fetchPlugin$1(artifact$1, ((AbsolutePath)x$1).underlying())));
            if (option instanceof Some) {
                Some some = (Some)option;
                Path pluginPath = ((AbsolutePath)some.value()).underlying();
                right = package$.MODULE$.Right().apply((Object)new AbsolutePath(pluginPath));
            } else if (None$.MODULE$.equals(option)) {
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(33).append("Missing ").append(artifact$1.module()).append(" plugin in resolved jars ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)paths).map((Function1 & Serializable & scala.Serializable)x$2 -> AbsolutePath$.MODULE$.syntax$extension(((AbsolutePath)x$2).underlying()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).toString());
            } else {
                throw new MatchError((Object)option);
            }
            left = right;
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    public static final /* synthetic */ File $anonfun$fetchPlugin$3(BloopComponentManager manager$1, String semanticDBId$1) {
        return manager$1.file(semanticDBId$1, (IfMissing)IfMissing.Fail$.MODULE$);
    }

    private SemanticDBCache$() {
        MODULE$ = this;
        this.latestResolvedScalaSemanticDB = null;
        this.latestResolvedJavaSemanticDB = null;
    }
}

