/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks.compilation;

import bloop.engine.ExecutionContext$;
import bloop.engine.tasks.compilation.CompilerPluginWhitelist;
import bloop.engine.tasks.compilation.CompilerPluginWhitelist$WorkItem$2$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.tracing.BraveTracer;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Consumer;
import monix.reactive.Consumer$;
import monix.reactive.Observable$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.XML$;

public final class CompilerPluginWhitelist$ {
    public static CompilerPluginWhitelist$ MODULE$;
    private final List<String> whitelistedPluginNames;
    private final List<String> scalaVersionBlacklist;
    private final DebugFilter.Compilation$ debug;
    private final Map<String, String> emptyMap;
    private final ConcurrentHashMap<String, Promise<Object>> pluginPromises;
    private final ConcurrentHashMap<Path, Tuple2<FileTime, Object>> cachePluginJar;

    static {
        new CompilerPluginWhitelist$();
    }

    public List<String> whitelistedPluginNames() {
        return this.whitelistedPluginNames;
    }

    public List<String> scalaVersionBlacklist() {
        return this.scalaVersionBlacklist;
    }

    private DebugFilter.Compilation$ debug() {
        return this.debug;
    }

    private Map<String, String> emptyMap() {
        return this.emptyMap;
    }

    public Task<List<String>> enableCachingInScalacOptions(String scalaVersion, List<String> scalacOptions, Logger logger, BraveTracer tracer, int parallelUnits) {
        return Task$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            Task task;
            LazyRef WorkItem$module = new LazyRef();
            Option actualScalaVersion = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(scalaVersion)).split('-'))).headOption();
            Option blacklistedVersions = MODULE$.scalaVersionBlacklist().find((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)actualScalaVersion.exists((Function1 & Serializable & scala.Serializable)userVersion -> BoxesRunTime.boxToBoolean((boolean)CompilerPluginWhitelist$.$anonfun$enableCachingInScalacOptions$3(v, userVersion)))));
            Option option = blacklistedVersions;
            if (option instanceof Some) {
                Some some = (Some)option;
                String blacklistedVersion = (String)some.value();
                logger.debug(new StringBuilder(54).append("Disabled compiler plugin classloading, unsupported in ").append(blacklistedVersion).toString(), (DebugFilter)MODULE$.debug());
                task = Task$.MODULE$.now((Object)scalacOptions);
            } else if (None$.MODULE$.equals(option)) {
                Task task2;
                if (scalacOptions.contains((Object)"-Ycache-plugin-class-loader:none")) {
                    task2 = Task$.MODULE$.now((Object)scalacOptions);
                } else {
                    String[] pluginCompilerFlags = (String[])scalacOptions.iterator().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-Xplugin:"))).toArray(ClassTag$.MODULE$.apply(String.class));
                    boolean[] cachePluginResults = new boolean[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pluginCompilerFlags)).size()];
                    task2 = tracer.traceTaskVerbose("enabling plugin caching", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)tracer -> {
                        public class Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1
                        implements Product,
                        scala.Serializable {
                            private final String pluginFlag;
                            private final int idx;
                            private final Promise<Object> result;

                            public String pluginFlag() {
                                return this.pluginFlag;
                            }

                            public int idx() {
                                return this.idx;
                            }

                            public Promise<Object> result() {
                                return this.result;
                            }

                            public Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1 copy(String pluginFlag, int idx, Promise<Object> result) {
                                return new Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1(pluginFlag, idx, result);
                            }

                            public String copy$default$1() {
                                return this.pluginFlag();
                            }

                            public int copy$default$2() {
                                return this.idx();
                            }

                            public Promise<Object> copy$default$3() {
                                return this.result();
                            }

                            public String productPrefix() {
                                return "WorkItem";
                            }

                            public int productArity() {
                                return 3;
                            }

                            public Object productElement(int x$1) {
                                Object object;
                                int n = x$1;
                                switch (n) {
                                    case 0: {
                                        object = this.pluginFlag();
                                        break;
                                    }
                                    case 1: {
                                        object = BoxesRunTime.boxToInteger((int)this.idx());
                                        break;
                                    }
                                    case 2: {
                                        object = this.result();
                                        break;
                                    }
                                    default: {
                                        throw new IndexOutOfBoundsException(Integer.toString(x$1));
                                    }
                                }
                                return object;
                            }

                            public Iterator<Object> productIterator() {
                                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                            }

                            public boolean canEqual(Object x$1) {
                                return x$1 instanceof Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1;
                            }

                            public int hashCode() {
                                int n = -889275714;
                                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pluginFlag()));
                                n = Statics.mix((int)n, (int)this.idx());
                                n = Statics.mix((int)n, (int)Statics.anyHash(this.result()));
                                return Statics.finalizeHash((int)n, (int)3);
                            }

                            public String toString() {
                                return ScalaRunTime$.MODULE$._toString((Product)this);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public boolean equals(Object x$1) {
                                if (this == x$1) return true;
                                Object object = x$1;
                                if (!(object instanceof Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1)) return false;
                                boolean bl = true;
                                if (!bl) return false;
                                Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1 var4_4 = (Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1)x$1;
                                String string = this.pluginFlag();
                                String string2 = var4_4.pluginFlag();
                                if (string == null) {
                                    if (string2 != null) {
                                        return false;
                                    }
                                } else if (!string.equals(string2)) return false;
                                if (this.idx() != var4_4.idx()) return false;
                                Promise<Object> promise = this.result();
                                Promise<Object> promise2 = var4_4.result();
                                if (promise == null) {
                                    if (promise2 != null) {
                                        return false;
                                    }
                                } else if (!promise.equals(promise2)) return false;
                                if (!var4_4.canEqual(this)) return false;
                                return true;
                            }

                            public Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1(String pluginFlag, int idx, Promise<Object> result) {
                                this.pluginFlag = pluginFlag;
                                this.idx = idx;
                                this.result = result;
                                Product.$init$((Product)this);
                            }
                        }
                        Consumer parallelConsumer = Consumer$.MODULE$.foreachParallelAsync(parallelUnits, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Bloop_engine_tasks_compilation_CompilerPluginWhitelist$WorkItem$1 var5_4 = x0$1;
                            if (var5_4 == null) {
                                throw new MatchError((Object)var5_4);
                            }
                            String pluginCompilerFlag = var5_4.pluginFlag();
                            int idx = var5_4.idx();
                            Promise<Object> p = var5_4.result();
                            Task task = MODULE$.shouldCachePlugin(pluginCompilerFlag, (BraveTracer)tracer, logger).materialize().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                CompilerPluginWhitelist$.$anonfun$enableCachingInScalacOptions$7(p, pluginCompilerFlag, cachePluginResults, idx, x0$2);
                                return BoxedUnit.UNIT;
                            });
                            return task;
                        });
                        ListBuffer acquiredByOtherTasks = new ListBuffer();
                        ListBuffer acquiredByThisInvocation = new ListBuffer();
                        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pluginCompilerFlags)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            Tuple2 tuple2 = x0$3;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String pluginCompilerFlag = (String)tuple2._1();
                            int idx = tuple2._2$mcI$sp();
                            Promise shouldCachePromise = Promise$.MODULE$.apply();
                            Promise<Object> promise = CompilerPluginWhitelist$.MODULE$.pluginPromises.putIfAbsent(pluginCompilerFlag, (Promise<Object>)shouldCachePromise);
                            ListBuffer listBuffer = promise != null ? acquiredByOtherTasks.$plus$eq((Object)Task$.MODULE$.fromFuture(promise.future()).map((Function1 & Serializable & scala.Serializable)cache -> {
                                cachePluginResults[idx] = BoxesRunTime.unboxToBoolean((Object)cache);
                                return BoxedUnit.UNIT;
                            })) : acquiredByThisInvocation.$plus$eq((Object)this.WorkItem$3(WorkItem$module).apply(pluginCompilerFlag, idx, (Promise<Object>)shouldCachePromise));
                            return listBuffer;
                        });
                        return Observable$.MODULE$.fromIterable((Iterable)acquiredByThisInvocation.toList()).consumeWith(parallelConsumer).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                            Iterator blockingBatches = acquiredByOtherTasks.toList().grouped(parallelUnits).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((TraversableOnce)group));
                            return Task$.MODULE$.sequence((TraversableOnce)blockingBatches, (CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom()).map((Function1 & Serializable & scala.Serializable)x$3 -> TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)x$3, (Function1)Predef$.MODULE$.$conforms()).flatten()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                                List list;
                                boolean enableCacheFlag = new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(cachePluginResults)).forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CompilerPluginWhitelist$.$anonfun$enableCachingInScalacOptions$14(BoxesRunTime.unboxToBoolean((Object)x$5))));
                                if (!enableCacheFlag) {
                                    list = scalacOptions;
                                } else {
                                    String string = "-Ycache-plugin-class-loader:last-modified";
                                    list = scalacOptions.$colon$colon((Object)string);
                                }
                                return list;
                            });
                        });
                    });
                }
                task = task2;
            } else {
                throw new MatchError((Object)option);
            }
            Task enableTask = task;
            return enableTask.executeOn(ExecutionContext$.MODULE$.ioScheduler()).materialize().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                List list;
                Try try_ = x0$4;
                if (try_ instanceof Success) {
                    List options;
                    Success success = (Success)try_;
                    list = options = (List)success.value();
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable f = failure.exception();
                    logger.debug("Enabling the plugin whitelist failed! Disabling it.", (DebugFilter)MODULE$.debug());
                    logger.trace(f);
                    list = scalacOptions;
                } else {
                    throw new MatchError((Object)try_);
                }
                return list;
            });
        });
    }

    private Task<Object> shouldCachePlugin(String pluginCompilerFlag, BraveTracer tracer, Logger logger) {
        return Task$.MODULE$.eval((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> CompilerPluginWhitelist$.$anonfun$shouldCachePlugin$1(pluginCompilerFlag, logger, tracer)));
    }

    private boolean isPluginWhitelisted(Path pluginPath, Logger logger) {
        boolean bl;
        URI uriZipFile = URI.create(new StringBuilder(9).append("jar:file:").append(pluginPath.toUri().getRawPath()).toString());
        try (FileSystem fs = FileSystems.newFileSystem(uriZipFile, this.emptyMap());){
            Path pluginDeclarationFile = fs.getPath("/scalac-plugin.xml", new String[0]);
            Elem xml = (Elem)XML$.MODULE$.load(Files.newInputStream(pluginDeclarationFile, new OpenOption[0]));
            String pluginName = xml.$bslash("name").text();
            boolean cache = this.whitelistedPluginNames().contains((Object)pluginName);
            if (cache) {
                logger.debug(new StringBuilder(31).append("Compiler plugin ").append(pluginName).append(" is whitelisted").toString(), (DebugFilter)this.debug());
            } else {
                logger.debug(new StringBuilder(52).append("Disabling plugin caching because ").append(pluginName).append(" is not whitelisted").toString(), (DebugFilter)this.debug());
            }
            bl = cache;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            logger.trace(t);
            logger.debug(new StringBuilder(48).append("Disable plugin caching because ").append(pluginPath).append(" couldn't be read").toString(), (DebugFilter)this.debug());
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    private static final /* synthetic */ CompilerPluginWhitelist$WorkItem$2$ WorkItem$lzycompute$1(LazyRef WorkItem$module$1) {
        CompilerPluginWhitelist$WorkItem$2$ compilerPluginWhitelist$WorkItem$2$;
        LazyRef lazyRef = WorkItem$module$1;
        synchronized (lazyRef) {
            compilerPluginWhitelist$WorkItem$2$ = WorkItem$module$1.initialized() ? (CompilerPluginWhitelist$WorkItem$2$)((Object)WorkItem$module$1.value()) : (CompilerPluginWhitelist$WorkItem$2$)((Object)WorkItem$module$1.initialize((Object)new CompilerPluginWhitelist$WorkItem$2$()));
        }
        return compilerPluginWhitelist$WorkItem$2$;
    }

    private final CompilerPluginWhitelist$WorkItem$2$ WorkItem$3(LazyRef WorkItem$module$1) {
        return WorkItem$module$1.initialized() ? (CompilerPluginWhitelist$WorkItem$2$)((Object)WorkItem$module$1.value()) : CompilerPluginWhitelist$.WorkItem$lzycompute$1(WorkItem$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$enableCachingInScalacOptions$3(String v$1, String userVersion) {
        boolean bl;
        if (v$1.endsWith(".")) {
            bl = userVersion.startsWith(v$1);
        } else {
            String string = userVersion;
            String string2 = v$1;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableCachingInScalacOptions$7(Promise p$1, String pluginCompilerFlag$1, boolean[] cachePluginResults$1, int idx$1, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean cache = BoxesRunTime.unboxToBoolean((Object)success.value());
            p$1.success((Object)BoxesRunTime.boxToBoolean((boolean)cache));
            CompilerPluginWhitelist$.MODULE$.pluginPromises.remove(pluginCompilerFlag$1);
            cachePluginResults$1[idx$1] = cache;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            p$1.failure(t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ boolean $anonfun$enableCachingInScalacOptions$14(boolean x$5) {
        return x$5;
    }

    public static final /* synthetic */ boolean $anonfun$shouldCachePlugin$2(Logger logger$2, Path pluginPath$1, FileTime lastModifiedTime$1, BraveTracer x$7) {
        logger$2.debug(new StringBuilder(22).append("Cache miss for plugin ").append(pluginPath$1).toString(), (DebugFilter)MODULE$.debug());
        boolean shouldCache = MODULE$.isPluginWhitelisted(pluginPath$1, logger$2);
        CompilerPluginWhitelist$.MODULE$.cachePluginJar.put(pluginPath$1, (Tuple2<FileTime, Object>)new Tuple2((Object)lastModifiedTime$1, (Object)BoxesRunTime.boxToBoolean((boolean)shouldCache)));
        return shouldCache;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ boolean $anonfun$shouldCachePlugin$1(String pluginCompilerFlag$2, Logger logger$2, BraveTracer tracer$3) {
        block7: {
            block4: {
                block6: {
                    block5: {
                        jarList = new StringOps(Predef$.MODULE$.augmentString(pluginCompilerFlag$2)).stripPrefix("-Xplugin:");
                        var6_4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(jarList)).split(File.pathSeparatorChar))).headOption();
                        if (!(var6_4 instanceof Some)) break block4;
                        var7_5 = (Some)var6_4;
                        mainPluginJar = (String)var7_5.value();
                        pluginPath = Paths.get(mainPluginJar, new String[0]);
                        if (Files.exists(pluginPath, new LinkOption[0])) break block5;
                        logger$2.debug(new StringBuilder(45).append("Disable plugin caching because ").append(pluginPath).append(" doesn't exist").toString(), (DebugFilter)CompilerPluginWhitelist$.MODULE$.debug());
                        v0 = false;
                        break block6;
                    }
                    attrs = Files.readAttributes(pluginPath, BasicFileAttributes.class, new LinkOption[0]);
                    lastModifiedTime = attrs.lastModifiedTime();
                    var12_10 = Option$.MODULE$.apply(CompilerPluginWhitelist$.MODULE$.cachePluginJar.get(pluginPath));
                    if (!(var12_10 instanceof Some) || (var14_12 = (Tuple2)(var13_11 = (Some)var12_10).value()) == null) ** GOTO lbl-1000
                    prevLastModifiedTime = (FileTime)var14_12._1();
                    cacheClassloader = var14_12._2$mcZ$sp();
                    v1 = prevLastModifiedTime;
                    var17_15 = lastModifiedTime;
                    if (!(v1 != null ? v1.equals(var17_15) == false : var17_15 != null)) {
                        logger$2.debug(new StringBuilder(22).append("Cache hit ").append(cacheClassloader).append(" for plugin ").append(pluginPath).toString(), (DebugFilter)CompilerPluginWhitelist$.MODULE$.debug());
                        var4_16 = cacheClassloader;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var4_16 = BoxesRunTime.unboxToBoolean((Object)tracer$3.trace(new StringBuilder(18).append("check whitelisted ").append(pluginPath).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldCachePlugin$2$adapted(bloop.logging.Logger java.nio.file.Path java.nio.file.attribute.FileTime bloop.tracing.BraveTracer ), (Lbloop/tracing/BraveTracer;)Ljava/lang/Object;)((Logger)logger$2, (Path)pluginPath, (FileTime)lastModifiedTime)));
                    }
                    v0 = var4_16;
                }
                var3_17 = v0;
                break block7;
            }
            if (None$.MODULE$.equals(var6_4)) {
                logger$2.debug(new StringBuilder(32).append("Expecting at least one jar in '").append(pluginCompilerFlag$2).append("'").toString(), (DebugFilter)CompilerPluginWhitelist$.MODULE$.debug());
                var3_17 = false;
            } else {
                throw new MatchError((Object)var6_4);
            }
        }
        return var3_17;
    }

    private CompilerPluginWhitelist$() {
        MODULE$ = this;
        this.whitelistedPluginNames = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bloop-test-plugin", "clippy", "scalajs", "nir", "macro-paradise-plugin", "semanticdb", "wartremover", "silencer", "scapegoat", "acyclic", "scoverage", "kind-projector", "scalac-profiling", "classpath-shrinker", "bm4", "splain", "deriving"}));
        this.scalaVersionBlacklist = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.10.", "2.11.", "2.12.1", "2.12.2", "2.12.3", "2.12.4", "0.", "3."}));
        this.debug = DebugFilter.Compilation$.MODULE$;
        this.emptyMap = Collections.emptyMap();
        this.pluginPromises = new ConcurrentHashMap();
        this.cachePluginJar = new ConcurrentHashMap();
    }

    public static final /* synthetic */ Object $anonfun$shouldCachePlugin$2$adapted(Logger logger$2, Path pluginPath$1, FileTime lastModifiedTime$1, BraveTracer x$7) {
        return BoxesRunTime.boxToBoolean((boolean)CompilerPluginWhitelist$.$anonfun$shouldCachePlugin$2(logger$2, pluginPath$1, lastModifiedTime$1, x$7));
    }
}

