/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks.compilation;

import bloop.Compiler;
import bloop.UniqueCompileInputs;
import bloop.cli.CommonOptions;
import bloop.engine.ExecutionContext$;
import bloop.engine.caches.LastSuccessfulResult;
import bloop.engine.tasks.compilation.CancelledCompileBundle$;
import bloop.engine.tasks.compilation.CompileBundle;
import bloop.engine.tasks.compilation.CompileDefinitions;
import bloop.engine.tasks.compilation.CompileDependenciesData;
import bloop.engine.tasks.compilation.CompileDependenciesData$;
import bloop.engine.tasks.compilation.SuccessfulCompileBundle;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ClasspathHasher$;
import bloop.io.SourceHasher$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.LoggerAction;
import bloop.logging.ObservedLogger;
import bloop.reporter.ObservedReporter;
import bloop.reporter.ReporterAction;
import bloop.tracing.BraveTracer;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Promise;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CompileBundle$ {
    public static CompileBundle$ MODULE$;
    private final DebugFilter.Compilation$ filter;

    static {
        new CompileBundle$();
    }

    public DebugFilter.Compilation$ filter() {
        return this.filter;
    }

    public Task<CompileBundle> computeFrom(CompileDefinitions.BundleInputs inputs, Path clientExternalClassesDir, ObservedReporter reporter, LastSuccessfulResult lastSuccessful, Compiler.Result lastResult, Promise<BoxedUnit> cancelCompilation, ObservedLogger<Logger> logger, Observable<Either<ReporterAction, LoggerAction>> mirror, BraveTracer tracer2, CommonOptions options) {
        return tracer2.traceTaskVerbose(new StringBuilder(17).append("computing bundle ").append(inputs.project().name()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)tracer -> {
            CompileDependenciesData compileDependenciesData = (CompileDependenciesData)tracer.traceVerbose("dependency classpath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$1 -> CompileDependenciesData$.MODULE$.compute((AbsolutePath[])inputs.project().rawClasspath().toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), inputs.dependentProducts()));
            PrintStream out = options.ngout();
            Task classpathHashesTask = ClasspathHasher$.MODULE$.hash(compileDependenciesData.dependencyClasspath(), 10, cancelCompilation, ExecutionContext$.MODULE$.ioScheduler(), (Logger)logger, tracer, out).executeOn(ExecutionContext$.MODULE$.ioScheduler());
            Task sourceHashesTask = tracer.traceTaskVerbose("discovering and hashing sources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$2 -> SourceHasher$.MODULE$.findAndHashSourcesInProject(inputs.project(), 20, cancelCompilation, ExecutionContext$.MODULE$.ioScheduler()).map((Function1 & Serializable & scala.Serializable)res -> res.map((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> AbsolutePath$.MODULE$.syntax$extension(x$4.source()), (Ordering)Ordering.String$.MODULE$))).executeOn(ExecutionContext$.MODULE$.ioScheduler()));
            logger.debug(new StringBuilder(43).append("Computing sources and classpath hashes for ").append(inputs.project().name()).toString(), (DebugFilter)MODULE$.filter());
            return Task$.MODULE$.mapBoth(classpathHashesTask, sourceHashesTask, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Either either;
                void var12_17;
                Either either2;
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null && (either2 = (Either)tuple2._1()) instanceof Left) {
                    CancelledCompileBundle$ cancelledCompileBundle$ = CancelledCompileBundle$.MODULE$;
                    return var12_17;
                } else if (tuple2 != null && (either = (Either)tuple2._2()) instanceof Left) {
                    CancelledCompileBundle$ cancelledCompileBundle$ = CancelledCompileBundle$.MODULE$;
                    return var12_17;
                } else {
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    Either either3 = (Either)tuple2._1();
                    Either either4 = (Either)tuple2._2();
                    if (!(either3 instanceof Right)) throw new MatchError((Object)tuple2);
                    Right right = (Right)either3;
                    Vector classpathHashes = (Vector)right.value();
                    if (!(either4 instanceof Right)) throw new MatchError((Object)tuple2);
                    Right right2 = (Right)either4;
                    List sourceHashes = (List)right2.value();
                    String originPath = AbsolutePath$.MODULE$.syntax$extension(inputs.project().origin().path());
                    int originHash = inputs.project().origin().hash();
                    ListBuffer javaSources = new ListBuffer();
                    ListBuffer scalaSources = new ListBuffer();
                    sourceHashes.foreach((Function1 & Serializable & scala.Serializable)hashed -> {
                        Path source = hashed.source();
                        String sourceName = ((Object)source.getFileName()).toString();
                        return sourceName.endsWith(".scala") ? scalaSources.$plus$eq((Object)new AbsolutePath(source)) : (sourceName.endsWith(".java") ? javaSources.$plus$eq((Object)new AbsolutePath(source)) : BoxedUnit.UNIT);
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaSources.toList()), (Object)scalaSources.toList());
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    List javaSources2 = (List)tuple22._1();
                    List scalaSources2 = (List)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)javaSources2, (Object)scalaSources2);
                    Tuple2 tuple24 = tuple23;
                    List javaSources3 = (List)tuple24._1();
                    List scalaSources3 = (List)tuple24._2();
                    Vector scalacOptions = inputs.project().scalacOptions().toVector();
                    Vector scalaJars = (Vector)Option$.MODULE$.option2Iterable(inputs.project().scalaInstance()).toVector().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.allJars())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Vector$.MODULE$.canBuildFrom());
                    UniqueCompileInputs inputs = new UniqueCompileInputs(sourceHashes.toVector(), classpathHashes, scalacOptions, scalaJars, originPath);
                    SuccessfulCompileBundle successfulCompileBundle = new SuccessfulCompileBundle(inputs.project(), clientExternalClassesDir, compileDependenciesData, (List<Path>)javaSources3, (List<Path>)scalaSources3, inputs, cancelCompilation, reporter, logger, mirror, lastSuccessful, lastResult, (BraveTracer)tracer);
                }
                return var12_17;
            });
        });
    }

    private CompileBundle$() {
        MODULE$ = this;
        this.filter = DebugFilter.Compilation$.MODULE$;
    }
}

