/*
 * Decompiled with CFR 0.152.
 */
package bloop.exec;

import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.dap.DebugSessionLogger$;
import bloop.engine.ExecutionContext$;
import bloop.exec.Forker;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.DebugFilter;
import bloop.logging.DebugFilter$All$;
import bloop.logging.Logger;
import bloop.util.CrossPlatform$;
import com.zaxxer.nuprocess.NuAbstractProcessHandler;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import com.zaxxer.nuprocess.NuProcessHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;

public final class Forker$ {
    public static Forker$ MODULE$;
    private final DebugFilter bloop$exec$Forker$$logContext;

    static {
        new Forker$();
    }

    public DebugFilter bloop$exec$Forker$$logContext() {
        return this.bloop$exec$Forker$$logContext;
    }

    private final int EXIT_OK() {
        return 0;
    }

    private final int EXIT_ERROR() {
        return 1;
    }

    public ExitStatus exitStatus(int exitCode) {
        return exitCode == 0 ? ExitStatus$.MODULE$.Ok() : ExitStatus$.MODULE$.RunError();
    }

    public Task<Object> run(Path cwd, Seq<String> cmd, Logger logger, CommonOptions opts) {
        ObjectRef consumeInput = ObjectRef.create(null);
        VolatileBooleanRef shutdownInput = VolatileBooleanRef.create((boolean)false);
        public final class Bloop_exec_Forker$ProcessHandler$1
        extends NuAbstractProcessHandler {
            private final StringBuilder outBuilder;
            private final StringBuilder errBuilder;
            private final Logger logger$1;
            private final Path cwd$1;
            private final Seq cmd$1;
            private final ObjectRef consumeInput$1;

            private StringBuilder outBuilder() {
                return this.outBuilder;
            }

            private StringBuilder errBuilder() {
                return this.errBuilder;
            }

            public void onStart(NuProcess nuProcess) {
                this.logger$1.debug(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(132).append("Starting forked process:\n                        |  cwd = '").append(new AbsolutePath(this.cwd$1)).append("'\n                        |  pid = '").append(nuProcess.getPID()).append("'\n                        |  cmd = '").append(this.cmd$1.mkString(" ")).append("'").toString())).stripMargin(), Forker$.MODULE$.bloop$exec$Forker$$logContext());
            }

            public void onExit(int statusCode) {
                this.logger$1.debug(new java.lang.StringBuilder(33).append("Forked process exited with code: ").append(statusCode).toString(), Forker$.MODULE$.bloop$exec$Forker$$logContext());
            }

            public void onStdout(ByteBuffer buffer, boolean closed) {
                if (closed) {
                    if ((Cancelable)this.consumeInput$1.elem != null) {
                        ((Cancelable)this.consumeInput$1.elem).cancel();
                    }
                    this.logger$1.debug("The process is closed. Emptying buffer...", Forker$.MODULE$.bloop$exec$Forker$$logContext());
                    String remaining = this.outBuilder().mkString();
                    if (!remaining.isEmpty()) {
                        this.logger$1.info(remaining);
                    }
                } else {
                    Forker$.MODULE$.onEachLine(buffer, this.outBuilder(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                        Bloop_exec_Forker$ProcessHandler$1.$anonfun$onStdout$1(this, x$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }

            public void onStderr(ByteBuffer buffer, boolean closed) {
                if (closed) {
                    String remaining = this.errBuilder().mkString();
                    if (!remaining.isEmpty()) {
                        this.logger$1.error(remaining);
                    }
                } else {
                    Forker$.MODULE$.onEachLine(buffer, this.errBuilder(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                        Bloop_exec_Forker$ProcessHandler$1.$anonfun$onStderr$1(this, x$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }

            public static final /* synthetic */ void $anonfun$onStdout$1(Bloop_exec_Forker$ProcessHandler$1 $this, String x$1) {
                $this.logger$1.info(x$1);
            }

            public static final /* synthetic */ void $anonfun$onStderr$1(Bloop_exec_Forker$ProcessHandler$1 $this, String x$1) {
                $this.logger$1.error(x$1);
            }

            public Bloop_exec_Forker$ProcessHandler$1(Logger logger$1, Path cwd$1, Seq cmd$1, ObjectRef consumeInput$1) {
                this.logger$1 = logger$1;
                this.cwd$1 = cwd$1;
                this.cmd$1 = cmd$1;
                this.consumeInput$1 = consumeInput$1;
                this.outBuilder = package$.MODULE$.StringBuilder().newBuilder();
                this.errBuilder = package$.MODULE$.StringBuilder().newBuilder();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onStdout$1$adapted(bloop.exec.Forker$ProcessHandler$1 java.lang.String ), $anonfun$onStderr$1$adapted(bloop.exec.Forker$ProcessHandler$1 java.lang.String )}, serializedLambda);
            }
        }
        return this.run(cwd, cmd, new Bloop_exec_Forker$ProcessHandler$1(logger, cwd, cmd, consumeInput), opts.env().toMap()).flatMap((Function1 & Serializable & scala.Serializable)process -> Forker$.gobbleInput$1(process, consumeInput, shutdownInput, opts, logger)).onErrorRecover((PartialFunction)new scala.Serializable(logger){
            public static final long serialVersionUID = 0L;
            private final Logger logger$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.logger$1.error(A1.getMessage());
                Integer n = BoxesRunTime.boxToInteger((int)1);
                return (B1)n;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.logger$1 = logger$1;
            }
        });
    }

    public Task<NuProcess> run(Path cwd, Seq<String> cmd, NuAbstractProcessHandler handler, scala.collection.immutable.Map<String, String> env) {
        Task task;
        if (AbsolutePath$.MODULE$.exists$extension(cwd)) {
            NuProcessBuilder builder = new NuProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter(cmd).asJava(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(env).asJava());
            builder.setProcessListener((NuProcessHandler)handler);
            builder.setCwd(cwd);
            task = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> builder.start());
        } else {
            String message = new java.lang.StringBuilder(35).append("Working directory '").append(new AbsolutePath(cwd)).append("' does not exist").toString();
            task = Task$.MODULE$.raiseError((Throwable)new FileNotFoundException(message));
        }
        return task;
    }

    public void onEachLine(ByteBuffer input, StringBuilder carry, Function1<String, BoxedUnit> op) {
        block0: {
            byte[] bytes = new byte[input.remaining()];
            input.get(bytes);
            String newMessage = new String(bytes, StandardCharsets.UTF_8);
            if (!new StringOps(Predef$.MODULE$.augmentString(newMessage)).nonEmpty()) break block0;
            StringBuilder msg = new StringBuilder().append(carry).append(newMessage);
            carry.clear();
            this.traverseLines$1(0, msg, op, carry);
        }
    }

    private boolean containsFullJdiNotification(StringBuilder msg) {
        int jdiIdx = msg.indexOf(DebugSessionLogger$.MODULE$.JDINotificationPrefix());
        int jdiNewLine = msg.indexOf("\n", jdiIdx);
        return jdiIdx >= 0 && jdiNewLine >= 0;
    }

    private static final Task gobbleInput$1(NuProcess process, ObjectRef consumeInput$1, VolatileBooleanRef shutdownInput$1, CommonOptions opts$1, Logger logger$1) {
        FiniteDuration duration = FiniteDuration$.MODULE$.apply(50L, TimeUnit.MILLISECONDS);
        consumeInput$1.elem = Scheduler.Extensions$.MODULE$.scheduleWithFixedDelay$extension(Scheduler$.MODULE$.Extensions(ExecutionContext$.MODULE$.ioScheduler()), duration, duration, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte[] buffer = new byte[4096];
            if (shutdownInput$1.elem) {
                if ((Cancelable)consumeInput$1.elem != null) {
                    ((Cancelable)consumeInput$1.elem).cancel();
                }
            } else {
                try {
                    int read;
                    if (opts$1.in().available() > 0 && (read = opts$1.in().read(buffer, 0, buffer.length)) != -1 && process.isRunning()) {
                        process.writeStdin(ByteBuffer.wrap(buffer));
                    }
                }
                catch (IOException t) {
                    logger$1.debug(new java.lang.StringBuilder(26).append("Error from input gobbler: ").append(t.getMessage()).toString(), MODULE$.bloop$exec$Forker$$logContext());
                    logger$1.trace((Throwable)t);
                    throw t;
                }
            }
        });
        return Task$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int n;
            try {
                int exitCode = process.waitFor(0L, TimeUnit.SECONDS);
                logger$1.debug(new java.lang.StringBuilder(27).append("Process ").append(process.getPID()).append(" exited with code: ").append(exitCode).toString(), MODULE$.bloop$exec$Forker$$logContext());
                n = exitCode;
            }
            finally {
                shutdownInput$1.elem = true;
                ((Cancelable)consumeInput$1.elem).cancel();
            }
            return n;
        }).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            shutdownInput$1.elem = true;
            ((Cancelable)consumeInput$1.elem).cancel();
            try {
                process.closeStdin(true);
            }
            finally {
                process.destroy(false);
                process.waitFor(200L, TimeUnit.MILLISECONDS);
                process.destroy(true);
                process.waitFor(200L, TimeUnit.MILLISECONDS);
                if (process.isRunning()) {
                    String msg = new java.lang.StringBuilder(43).append("The cancellation could not destroy process ").append(process.getPID()).toString();
                    opts$1.ngout().println(msg);
                    logger$1.debug(msg, MODULE$.bloop$exec$Forker$$logContext());
                } else {
                    String msg = new java.lang.StringBuilder(32).append("The run process ").append(process.getPID()).append(" has been closed").toString();
                    opts$1.ngout().println(msg);
                    logger$1.debug(msg, MODULE$.bloop$exec$Forker$$logContext());
                }
            }
        }));
    }

    private final void traverseLines$1(int start, StringBuilder msg$1, Function1 op$1, StringBuilder carry$1) {
        block4: {
            BoxedUnit boxedUnit;
            while (start < msg$1.length()) {
                int lineEnd = msg$1.indexOf(System.lineSeparator(), start);
                if (lineEnd < 0) {
                    if (CrossPlatform$.MODULE$.isWindows() && this.containsFullJdiNotification(msg$1)) {
                        boxedUnit = (BoxedUnit)op$1.apply((Object)msg$1.stripLineEnd());
                    } else {
                        String remaining = msg$1.substring(start);
                        carry$1.append(remaining);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    break block4;
                }
                String line = msg$1.substring(start, lineEnd);
                op$1.apply((Object)line);
                start = lineEnd + System.lineSeparator().length();
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Forker$() {
        MODULE$ = this;
        this.bloop$exec$Forker$$logContext = DebugFilter$All$.MODULE$;
    }
}

