/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks;

import bloop.CompilerCache;
import bloop.ScalaInstance;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.data.ClientInfo;
import bloop.data.JdkConfig;
import bloop.data.Project;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.Dag;
import bloop.engine.Dag$;
import bloop.engine.State;
import bloop.engine.caches.ResultsCache;
import bloop.engine.tasks.RunMode;
import bloop.engine.tasks.Tasks$;
import bloop.engine.tasks.TestTask$;
import bloop.exec.Forker$;
import bloop.exec.JvmProcessForker;
import bloop.exec.JvmProcessForker$;
import bloop.io.AbsolutePath;
import bloop.logging.DebugFilter;
import bloop.logging.DebugFilter$All$;
import bloop.testing.LoggingEventHandler;
import bloop.testing.TestSuiteEvent;
import bloop.testing.TestSuiteEventHandler;
import bloop.util.JavaCompat$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.classpath.ClasspathUtilities$;
import sbt.testing.Event;
import sbt.testing.Status;
import sbt.util.Logger;
import sbt.util.Logger$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction1;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.CompileAnalysis;

public final class Tasks$ {
    public static Tasks$ MODULE$;
    private final Set<Status> TestFailedStatus;

    static {
        new Tasks$();
    }

    public Set<Status> TestFailedStatus() {
        return this.TestFailedStatus;
    }

    public Task<State> clean(State state, List<Project> targets, boolean includeDeps) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ResultsCache newResults;
            List allTargetsToClean = !includeDeps ? targets : (List)((SeqLike)targets.flatMap((Function1 & Serializable & scala.Serializable)t -> Dag$.MODULE$.dfs(state.build().getDagFor((Project)t)), List$.MODULE$.canBuildFrom())).distinct();
            ResultsCache x$1 = newResults = state.results().cleanSuccessful((List<Project>)allTargetsToClean);
            Build x$2 = state.copy$default$1();
            CompilerCache x$3 = state.copy$default$3();
            ClientInfo x$4 = state.copy$default$4();
            ClientPool x$5 = state.copy$default$5();
            CommonOptions x$6 = state.copy$default$6();
            ExitStatus x$7 = state.copy$default$7();
            bloop.logging.Logger x$8 = state.copy$default$8();
            return state.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
        });
    }

    public Task<State> console(State state, Project project, boolean noRoot) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option<ScalaInstance> option = project.scalaInstance();
            if (option instanceof Some) {
                Some some = (Some)option;
                ScalaInstance instance = (ScalaInstance)some.value();
                Dag<Project> dag = state.build().getDagFor(project);
                AbsolutePath[] classpath = project.fullRuntimeClasspath(dag, state.client());
                Seq entries = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)classpath).map((Function1 & Serializable & scala.Serializable)x$1 -> ((AbsolutePath)x$1).underlying().toFile(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).toSeq();
                state.logger().debug(new StringBuilder(38).append("Setting up the console classpath with ").append(entries.mkString(", ")).toString(), (DebugFilter)DebugFilter$All$.MODULE$);
                Option javacBin = project.runtimeJdkConfig().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.javacBin());
                ClassLoader loader = ClasspathUtilities$.MODULE$.makeLoader(entries, (xsbti.compile.ScalaInstance)instance);
                AnalyzingCompiler compiler = (AnalyzingCompiler)state.compilerCache().get(instance, javacBin).scalac();
                ClasspathOptions opts = ClasspathOptionsUtil.repl();
                List options = (List)project.scalacOptions().$colon$plus((Object)"-Xnojline", List$.MODULE$.canBuildFrom());
                Seq x$12 = entries;
                List x$22 = options;
                ClasspathOptions x$3 = opts;
                String x$4 = "";
                String x$5 = "";
                Logger x$6 = Logger$.MODULE$.xlog2Log((xsbti.Logger)state.logger());
                Some x$7 = new Some((Object)loader);
                Seq x$8 = compiler.console$default$8(x$12, (Seq)x$22, x$3, x$4, x$5, x$6);
                compiler.console(x$12, (Seq)x$22, x$3, x$4, x$5, x$6, (Option)x$7, x$8);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                state.logger().error(new StringBuilder(41).append("Missing Scala configuration on project '").append(project.name()).append("'").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            return state;
        });
    }

    public Task<State> test(State state, List<Project> projectsToTest, List<String> userTestOptions, Function1<String, Object> testFilter, TestSuiteEventHandler testEventHandler, boolean runInParallel, RunMode mode) {
        DebugFilter.Test$ logContext = DebugFilter.Test$.MODULE$;
        BooleanRef failure = BooleanRef.create((boolean)false);
        List testTasks = (List)projectsToTest.map((Function1 & Serializable & scala.Serializable)project -> {
            LoggingEventHandler failureHandler = new LoggingEventHandler(state, testEventHandler, failure){
                private final TestSuiteEventHandler testEventHandler$1;
                private final BooleanRef failure$1;

                public void report() {
                    this.testEventHandler$1.report();
                }

                public void handle(TestSuiteEvent event) {
                    TestSuiteEvent.Results results;
                    List<Event> ev;
                    this.testEventHandler$1.handle(event);
                    TestSuiteEvent testSuiteEvent = event;
                    if (testSuiteEvent instanceof TestSuiteEvent.Results && (ev = (results = (TestSuiteEvent.Results)testSuiteEvent).events()).exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$handle$1(e)))) {
                        this.failure$1.elem = true;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }

                public static final /* synthetic */ boolean $anonfun$handle$1(Event e) {
                    return Tasks$.MODULE$.TestFailedStatus().contains((Object)e.status());
                }
                {
                    this.testEventHandler$1 = testEventHandler$1;
                    this.failure$1 = failure$1;
                    super(state$3.logger());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handle$1$adapted(sbt.testing.Event )}, serializedLambda);
                }
            };
            Path cwd = project.workingDirectory();
            return TestTask$.MODULE$.runTestSuites(state, (Project)project, cwd, userTestOptions, testFilter, failureHandler, mode);
        }, List$.MODULE$.canBuildFrom());
        Function1 & Serializable & scala.Serializable runAll = runInParallel ? (Function1 & Serializable & scala.Serializable)in -> Task$.MODULE$.gather((TraversableOnce)in, List$.MODULE$.canBuildFrom()) : (Function1 & Serializable & scala.Serializable)in -> Task$.MODULE$.sequence((TraversableOnce)in, List$.MODULE$.canBuildFrom());
        return ((Task)runAll.apply((Object)testTasks)).map(arg_0 -> Tasks$.$anonfun$test$4(testEventHandler, state, failure, (DebugFilter)logContext, arg_0));
    }

    public boolean test$default$6() {
        return false;
    }

    public Task<State> runJVM(State state, Project project, JdkConfig config, Path cwd, String fqn, String[] args, boolean skipJargs, List<String> envVars, RunMode mode) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = skipJargs ? new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Object)args) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.startsWith("-J")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] userJvmOptions = (String[])tuple2._1();
        String[] userArgs = (String[])tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)userJvmOptions, (Object)userArgs);
        Tuple2 tuple24 = tuple23;
        String[] userJvmOptions2 = (String[])tuple24._1();
        String[] userArgs2 = (String[])tuple24._2();
        String[] jvmOptions = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userJvmOptions2)).map((Function1 & Serializable & scala.Serializable)x$6 -> new StringOps(Predef$.MODULE$.augmentString(x$6)).stripPrefix("-J"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return this.runJVM(state, project, config, cwd, fqn, userArgs2, jvmOptions, envVars, mode);
    }

    public Task<State> runJVM(State state, Project project, JdkConfig config, Path cwd, String fqn, String[] args, String[] jvmOptions, List<String> envVars, RunMode mode) {
        Dag<Project> dag = state.build().getDagFor(project);
        AbsolutePath[] classpath = project.fullRuntimeClasspath(dag, state.client());
        JvmProcessForker forker = JvmProcessForker$.MODULE$.apply(config, classpath, mode);
        Task runTask = forker.runMain(cwd, fqn, args, jvmOptions, envVars, state.logger(), state.commonOptions(), forker.runMain$default$8());
        return runTask.map((Function1 & Serializable & scala.Serializable)exitCode -> Tasks$.$anonfun$runJVM$3(state, BoxesRunTime.unboxToInt((Object)exitCode)));
    }

    public Task<State> runNativeOrJs(State state, Project project, Path cwd, String fqn, String[] args) {
        return Forker$.MODULE$.run(cwd, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), state.logger(), state.commonOptions()).map((Function1 & Serializable & scala.Serializable)exitCode -> Tasks$.$anonfun$runNativeOrJs$1(state, BoxesRunTime.unboxToInt((Object)exitCode)));
    }

    public List<String> findMainClasses(State state, Project project) {
        Nil$ nil$;
        Some some;
        CompileAnalysis analysis;
        Option option = JavaCompat$.MODULE$.EnrichOptional(state.results().lastSuccessfulResultOrEmpty(project).previous().analysis()).toOption();
        if (option instanceof Some && (analysis = (CompileAnalysis)(some = (Some)option).value()) instanceof Analysis) {
            Analysis analysis2 = (Analysis)analysis;
            List mainClasses = ((TraversableOnce)analysis2.infos().allInfos().values().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7.getMainClasses())), Iterable$.MODULE$.canBuildFrom())).toList();
            state.logger().debug(new StringBuilder(22).append("Found ").append(mainClasses.size()).append(" main classes: ").append(mainClasses.mkString(", ")).append(".").toString(), (DebugFilter)DebugFilter$All$.MODULE$);
            nil$ = mainClasses;
        } else {
            state.logger().debug(new StringBuilder(67).append("Cannot find main classes in '").append(project.name()).append("'. No successful compilation detected.").toString(), (DebugFilter)DebugFilter$All$.MODULE$);
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public Option<String> reasonOfInvalidPath(Path output) {
        return Files.isDirectory(output, new LinkOption[0]) ? new Some((Object)new StringBuilder(42).append("The output path ").append(output).append(" does not point to a file.").toString()) : (!Files.isWritable(output.getParent()) ? new Some((Object)new StringBuilder(35).append("The output path ").append(output.getParent()).append(" cannot be created.").toString()) : None$.MODULE$);
    }

    public Option<String> reasonOfInvalidPath(Path output, String extension) {
        return this.reasonOfInvalidPath(output).orElse((Function0 & Serializable & scala.Serializable)() -> !((Object)output).toString().endsWith(extension) ? new Some((Object)new StringBuilder(44).append("The output path ").append(output).append(" must have the extension '").append(extension).append("'.").toString()) : None$.MODULE$);
    }

    public Option<Project> pickTestProject(String projectName, State state) {
        return state.build().getProjectFor(new StringBuilder(5).append(projectName).append("-test").toString()).orElse((Function0 & Serializable & scala.Serializable)() -> state.build().getProjectFor(projectName));
    }

    public static final /* synthetic */ State $anonfun$test$4(TestSuiteEventHandler testEventHandler$1, State state$3, BooleanRef failure$1, DebugFilter logContext$1, List exitCodes) {
        State state;
        boolean isOk;
        testEventHandler$1.report();
        state$3.logger().debug(new StringBuilder(20).append("Test suites failed: ").append(failure$1.elem).toString(), logContext$1);
        boolean bl = isOk = !failure$1.elem && exitCodes.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 == 0);
        if (isOk) {
            state = state$3.mergeStatus(ExitStatus$.MODULE$.Ok());
        } else {
            ExitStatus x$1 = ExitStatus$.MODULE$.TestExecutionError();
            Build x$2 = state$3.copy$default$1();
            ResultsCache x$32 = state$3.copy$default$2();
            CompilerCache x$4 = state$3.copy$default$3();
            ClientInfo x$5 = state$3.copy$default$4();
            ClientPool x$6 = state$3.copy$default$5();
            CommonOptions x$7 = state$3.copy$default$6();
            bloop.logging.Logger x$8 = state$3.copy$default$8();
            state = state$3.copy(x$2, x$32, x$4, x$5, x$6, x$7, x$1, x$8);
        }
        return state;
    }

    public static final /* synthetic */ State $anonfun$runJVM$3(State state$4, int exitCode) {
        ExitStatus exitStatus = Forker$.MODULE$.exitStatus(exitCode);
        return state$4.mergeStatus(exitStatus);
    }

    public static final /* synthetic */ State $anonfun$runNativeOrJs$1(State state$5, int exitCode) {
        ExitStatus exitStatus = Forker$.MODULE$.exitStatus(exitCode);
        return state$5.mergeStatus(exitStatus);
    }

    private Tasks$() {
        MODULE$ = this;
        this.TestFailedStatus = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Status[]{Status.Failure, Status.Error, Status.Canceled}));
    }
}

