/*
 * Decompiled with CFR 0.152.
 */
package bloop.bsp;

import bloop.bsp.BloopBspServices;
import bloop.bsp.BloopLanguageClient;
import bloop.bsp.BloopLanguageServer;
import bloop.bsp.BspServer;
import bloop.cli.Commands;
import bloop.data.ClientInfo;
import bloop.data.ClientInfo$;
import bloop.data.Project;
import bloop.engine.ExecutionContext$;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.State$XState$;
import bloop.io.Paths$;
import bloop.io.ServerHandle;
import bloop.io.ServerHandle$Tcp$;
import bloop.logging.BspClientLogger;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.AssignableCancelable;
import monix.execution.cancelables.AssignableCancelable$;
import monix.execution.cancelables.CompositeCancelable$;
import monix.execution.misc.NonFatal$;
import monix.reactive.Consumer;
import monix.reactive.Consumer$;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.BehaviorSubject;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.meta.jsonrpc.BaseProtocolMessage;
import scala.meta.jsonrpc.BaseProtocolMessage$;
import scala.meta.jsonrpc.Response;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;

public final class BspServer$ {
    public static BspServer$ MODULE$;
    private final DebugFilter logContext;
    private final ConcurrentHashMap<ClientInfo.BspClientInfo, Path> connectedBspClients;

    static {
        new BspServer$();
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    private Task<ServerSocket> initServer(ServerHandle handle, State state) {
        state.logger().debug(new StringBuilder(31).append("Waiting for a connection at ").append(handle).append("...").toString(), this.logContext());
        ServerSocket openSocket = handle.server();
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> openSocket).doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> openSocket.close()));
    }

    private final ConcurrentHashMap<ClientInfo.BspClientInfo, Path> connectedBspClients() {
        return this.connectedBspClients;
    }

    public Task<State> run(Commands.ValidatedBsp cmd, State state, Path config, Option<Promise<BoxedUnit>> promiseWhenStarted, Option<BehaviorSubject<State>> externalObserver, Scheduler scheduler, Scheduler ioScheduler) {
        ServerHandle serverHandle;
        Commands.ValidatedBsp validatedBsp = cmd;
        if (validatedBsp instanceof Commands.WindowsLocalBsp) {
            Commands.WindowsLocalBsp windowsLocalBsp = (Commands.WindowsLocalBsp)validatedBsp;
            String pipeName = windowsLocalBsp.pipeName();
            serverHandle = new ServerHandle.WindowsLocal(pipeName);
        } else if (validatedBsp instanceof Commands.UnixLocalBsp) {
            Commands.UnixLocalBsp unixLocalBsp = (Commands.UnixLocalBsp)validatedBsp;
            Path socketFile = unixLocalBsp.socket();
            serverHandle = new ServerHandle.UnixLocal(socketFile);
        } else if (validatedBsp instanceof Commands.TcpBsp) {
            Commands.TcpBsp tcpBsp = (Commands.TcpBsp)validatedBsp;
            InetAddress address = tcpBsp.host();
            int portNumber = tcpBsp.port();
            serverHandle = ServerHandle$Tcp$.MODULE$.apply(address, portNumber, 10);
        } else {
            throw new MatchError((Object)validatedBsp);
        }
        ServerHandle.WindowsLocal handle = serverHandle;
        return this.initServer(handle, state).materialize().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Failure failure;
            Throwable t;
            Task task;
            Success success;
            ServerSocket socket;
            Try try_ = x0$1;
            if (try_ instanceof Success && (socket = (ServerSocket)(success = (Success)try_).value()) != null) {
                ServerSocket serverSocket = socket;
                task = this.listenToConnection$1(handle, serverSocket, state, promiseWhenStarted, config, externalObserver, scheduler, ioScheduler).onErrorRecoverWith((PartialFunction)new scala.Serializable(state){
                    public static final long serialVersionUID = 0L;
                    private final State state$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Task task = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension1(State$.MODULE$.XState(this.state$1), new StringBuilder(24).append("Exiting BSP server with ").append(A1.getMessage()).toString(), A1));
                        return (B1)task;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.state$1 = state$1;
                    }
                });
            } else if (try_ instanceof Failure && (t = (failure = (Failure)try_).exception()) != null) {
                Throwable throwable = t;
                promiseWhenStarted.foreach((Function1 & Serializable & scala.Serializable)p -> !p.isCompleted() ? p.failure(throwable) : BoxedUnit.UNIT);
                task = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension1(State$.MODULE$.XState(state), new StringBuilder(38).append("BSP server failed to open a socket: '").append(throwable.getMessage()).append("'").toString(), throwable));
            } else {
                throw new MatchError((Object)try_);
            }
            return task;
        });
    }

    public void closeCommunication(Option<BehaviorSubject<State>> externalObserver, State latestState, Socket socket, ServerSocket serverSocket) {
        block14: {
            try {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block14;
                        }
                        throw throwable;
                    }
                }
                finally {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable3);
                        if (!option.isEmpty()) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                List deleteExternalDirsTasks = (List)latestState.build().loadedProjects().map((Function1 & Serializable & scala.Serializable)loadedProject -> {
                    Task task;
                    block3: {
                        Project project = loadedProject.project();
                        try {
                            boolean skipDirectoryManagement;
                            Path externalClientClassesDir;
                            Path path = externalClientClassesDir = latestState.client().getUniqueClassesDirFor(project, false);
                            Path path2 = project.genericClassesDir();
                            boolean bl = !(path == null ? path2 != null : !((Object)path).equals(path2)) || latestState.client().hasManagedClassesDirectories() ? true : (skipDirectoryManagement = false);
                            if (skipDirectoryManagement) {
                                task = Task$.MODULE$.now((Object)BoxedUnit.UNIT);
                                break block3;
                            }
                            task = Task$.MODULE$.fork(Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Paths$.MODULE$.delete(externalClientClassesDir))).materialize();
                        }
                        catch (NoSuchFileException noSuchFileException) {
                            task = Task$.MODULE$.now((Object)BoxedUnit.UNIT);
                        }
                    }
                    return task;
                }, List$.MODULE$.canBuildFrom());
                Iterator groups = deleteExternalDirsTasks.grouped(4).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((TraversableOnce)group));
                Task$.MODULE$.sequence((TraversableOnce)groups, (CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom()).map((Function1 & Serializable & scala.Serializable)x$11 -> TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)x$11, (Function1)Predef$.MODULE$.$conforms()).flatten()).map((Function1 & Serializable & scala.Serializable)x$12 -> {
                    BspServer$.$anonfun$closeCommunication$5(x$12);
                    return BoxedUnit.UNIT;
                }).runAsync(ExecutionContext$.MODULE$.ioScheduler());
            }
        }
    }

    private static final void error$1(String msg, BloopBspServices provider$1) {
        provider$1.stateAfterExecution().logger().error(msg);
    }

    public static final Set bloop$bsp$BspServer$$askCurrentBspClients$1(Option initializedClientInfo$1) {
        Set set;
        Set clients0 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(MODULE$.connectedBspClients().keySet()).asScala()).toSet();
        Option option = initializedClientInfo$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            ClientInfo.BspClientInfo bspInfo = (ClientInfo.BspClientInfo)some.value();
            set = (Set)clients0.$plus((Object)bspInfo);
        } else if (None$.MODULE$.equals(option)) {
            set = clients0;
        } else {
            throw new MatchError((Object)option);
        }
        return set;
    }

    private static final Task onFinishOrCancel$1(boolean cancelled, Option result, AtomicBoolean isCommunicationActive$1, BloopBspServices provider$1, AssignableCancelable cancelable$1, BloopLanguageServer server$1, Scheduler ioScheduler$1, State state$1, Option externalObserver$1, Socket socket$1, ServerSocket serverSocket$1) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block4: {
                if (!isCommunicationActive$1.getAndSet(false)) break block4;
                State latestState = provider$1.stateAfterExecution();
                Option<ClientInfo.BspClientInfo> initializedClientInfo = provider$1.unregisterClient();
                try {
                    if (cancelled) {
                        BspServer$.error$1("BSP server cancelled, closing socket...", provider$1);
                    } else {
                        result.foreach((Function1 & Serializable & scala.Serializable)t -> {
                            BspServer$.error$1(new StringBuilder(22).append("BSP server stopped by ").append(t.getMessage()).toString(), provider$1);
                            return BoxedUnit.UNIT;
                        });
                    }
                    cancelable$1.cancel();
                    server$1.cancelAllRequests();
                }
                catch (Throwable throwable) {
                    ioScheduler$1.scheduleOnce(100L, TimeUnit.MILLISECONDS, new Runnable(state$1, initializedClientInfo){
                        private final State state$1;
                        private final Option initializedClientInfo$1;

                        public void run() {
                            PrintStream ngout = this.state$1.commonOptions().ngout();
                            PrintStream ngerr = this.state$1.commonOptions().ngerr();
                            ClientInfo$.MODULE$.deleteOrphanClientBspDirectories((Function0<Traversable<ClientInfo.BspClientInfo>>)(Function0 & Serializable & scala.Serializable)() -> BspServer$.bloop$bsp$BspServer$$askCurrentBspClients$1($this.initializedClientInfo$1), ngout, ngerr);
                        }
                        {
                            this.state$1 = state$1;
                            this.initializedClientInfo$1 = initializedClientInfo$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$5(bloop.bsp.BspServer$$anon$1 )}, serializedLambda);
                        }
                    });
                    MODULE$.closeCommunication((Option<BehaviorSubject<State>>)externalObserver$1, latestState, socket$1, serverSocket$1);
                    throw throwable;
                }
                ioScheduler$1.scheduleOnce(100L, TimeUnit.MILLISECONDS, new /* invalid duplicate definition of identical inner class */);
                MODULE$.closeCommunication((Option<BehaviorSubject<State>>)externalObserver$1, latestState, socket$1, serverSocket$1);
            }
        });
    }

    public static final /* synthetic */ void $anonfun$run$8(Ack x$4) {
    }

    private final Task listenToConnection$1(ServerHandle handle, ServerSocket serverSocket, State state$1, Option promiseWhenStarted$1, Path config$1, Option externalObserver$1, Scheduler scheduler$1, Scheduler ioScheduler$1) {
        AtomicBoolean isCommunicationActive = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(true, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        String connectionURI = handle.uri();
        state$1.logger().info(new StringBuilder(55).append("The server is listening for incoming connections at ").append(connectionURI).append("...").toString());
        promiseWhenStarted$1.foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.success((Object)BoxedUnit.UNIT));
        Socket socket = serverSocket.accept();
        state$1.logger().info(new StringBuilder(43).append("Accepted incoming BSP client connection at ").append(connectionURI).toString());
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        BspClientLogger<Logger> bspLogger = new BspClientLogger<Logger>(state$1.logger());
        BloopLanguageClient client = new BloopLanguageClient(out, bspLogger);
        Observable messages = BaseProtocolMessage$.MODULE$.fromInputStream(in, bspLogger);
        AssignableCancelable stopBspConnection = AssignableCancelable$.MODULE$.single();
        BloopBspServices provider = new BloopBspServices(state$1, client, config$1, (Cancelable)stopBspConnection, (Option<BehaviorSubject<State>>)externalObserver$1, isCommunicationActive, this.connectedBspClients(), scheduler$1, ioScheduler$1);
        BloopLanguageServer server = new BloopLanguageServer((Observable<BaseProtocolMessage>)messages, client, provider.services(), ioScheduler$1, bspLogger);
        Tuple2 tuple2 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.publish(), ioScheduler$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Observer.Sync bufferedObserver = (Observer.Sync)tuple2._1();
        Observable endObservable = (Observable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)bufferedObserver, (Object)endObservable);
        Tuple2 tuple23 = tuple22;
        Observer.Sync bufferedObserver2 = (Observer.Sync)tuple23._1();
        Observable endObservable2 = (Observable)tuple23._2();
        ObjectRef completeSubscribers = ObjectRef.create((Object)Cancelable$.MODULE$.empty());
        ListBuffer cancelables = new ListBuffer();
        AssignableCancelable cancelable = AssignableCancelable$.MODULE$.multi((Cancelable & Serializable)() -> {
            List list;
            ListBuffer listBuffer = cancelables;
            synchronized (listBuffer) {
                list = cancelables.toList();
            }
            List tasksToCancel = list;
            Cancelable cancelable = (Cancelable)completeSubscribers$1.elem;
            Cancelable$.MODULE$.cancelAll((Iterable)tasksToCancel.$colon$colon((Object)cancelable));
        });
        Consumer singleMessageConsumer = Consumer$.MODULE$.foreachAsync((Function1 & Serializable & scala.Serializable)msg2 -> {
            Task taskToRun = server.handleMessage((BaseProtocolMessage)msg2).flatMap((Function1 & Serializable & scala.Serializable)msg -> Task$.MODULE$.fromFuture(client.serverRespond((Response)msg)).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                BspServer$.$anonfun$run$8(x$4);
                return BoxedUnit.UNIT;
            })).onErrorRecover((PartialFunction)new scala.Serializable(bspLogger){
                public static final long serialVersionUID = 0L;
                private final BspClientLogger bspLogger$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    Option option = NonFatal$.MODULE$.unapply(A1);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.bspLogger$1.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & Serializable & scala.Serializable)() -> "Unhandled error", (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)e), "/home/runner/work/bloop/bloop/frontend/src/main/scala/bloop/bsp/BspServer.scala", "bloop.bsp.BspServer.$anonfun", (Option)new Some((Object)"applyOrElse"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)168)), LogRecord$.MODULE$.apply$default$10(), LogRecord$.MODULE$.apply$default$11()));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    Option option = NonFatal$.MODULE$.unapply(throwable);
                    boolean bl = !option.isEmpty();
                    return bl;
                }
                {
                    this.bspLogger$1 = bspLogger$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
                }
            });
            CancelableFuture cancelable = taskToRun.runAsync(ioScheduler$1);
            ListBuffer listBuffer = cancelables;
            synchronized (listBuffer) {
                cancelables.$plus$eq((Object)cancelable);
            }
            return Task$.MODULE$.fromFuture((Future)cancelable).doOnFinish((Function1 & Serializable & scala.Serializable)x$5 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ListBuffer listBuffer = cancelables;
                synchronized (listBuffer) {
                    cancelables.$minus$eq((Object)cancelable);
                }
            }));
        });
        Promise startedSubscription = Promise$.MODULE$.apply();
        Task consumingWithBalancedForeach = Task$.MODULE$.create((Function2 & Serializable & scala.Serializable)(scheduler, cb) -> {
            Cancelable cancelable;
            if (!isCommunicationActive.get()) {
                cb.onSuccess((Object)Nil$.MODULE$);
                startedSubscription.success((Object)BoxedUnit.UNIT);
                cancelable = Cancelable$.MODULE$.empty();
            } else {
                Consumer parallelConsumer = Consumer$.MODULE$.loadBalance(4, singleMessageConsumer);
                Tuple2 tuple2 = parallelConsumer.createSubscriber(cb, scheduler);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Subscriber out = (Subscriber)tuple2._1();
                AssignableCancelable consumerSubscription = (AssignableCancelable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)out, (Object)consumerSubscription);
                Tuple2 tuple23 = tuple22;
                Subscriber out2 = (Subscriber)tuple23._1();
                AssignableCancelable consumerSubscription2 = (AssignableCancelable)tuple23._2();
                Cancelable cancelOut = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out2.onComplete());
                completeSubscribers$1.elem = CompositeCancelable$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Cancelable[]{cancelOut}));
                Cancelable sourceSubscription = endObservable2.subscribe(out2);
                startedSubscription.success((Object)BoxedUnit.UNIT);
                cancelable = CompositeCancelable$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Cancelable[]{sourceSubscription, consumerSubscription2}));
            }
            return cancelable;
        });
        Task consumingTask = consumingWithBalancedForeach.doOnCancel(BspServer$.onFinishOrCancel$1(true, (Option)None$.MODULE$, isCommunicationActive, provider, cancelable, server, ioScheduler$1, state$1, externalObserver$1, socket, serverSocket)).doOnFinish((Function1 & Serializable & scala.Serializable)result -> BspServer$.onFinishOrCancel$1(false, result, isCommunicationActive, provider, cancelable, server, ioScheduler$1, state$1, externalObserver$1, socket, serverSocket)).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> server.awaitRunningTasks().map((Function1 & Serializable & scala.Serializable)x$8 -> provider.stateAfterExecution()));
        CancelableFuture consumerFuture = consumingTask.runAsync(ioScheduler$1);
        stopBspConnection.$colon$eq(Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> consumerFuture.cancel()));
        Task cancelWhenStreamIsClosed = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (provider.exited().get()) break block0;
                consumerFuture.cancel();
            }
        });
        Task startListeningToMessages = messages.liftByOperator(new BspServer.PumpOperator(bufferedObserver2, (Cancelable)consumerFuture)).completedL().doOnFinish((Function1 & Serializable & scala.Serializable)x$9 -> cancelWhenStreamIsClosed).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> Task$.MODULE$.fromFuture((Future)consumerFuture));
        return Task$.MODULE$.fromFuture(startedSubscription.future()).executeOn(ioScheduler$1).flatMap((Function1 & Serializable & scala.Serializable)_ -> startListeningToMessages.executeOn(ioScheduler$1).map((Function1 & Serializable & scala.Serializable)latestState -> latestState));
    }

    public static final /* synthetic */ void $anonfun$closeCommunication$5(Iterator x$12) {
    }

    private BspServer$() {
        MODULE$ = this;
        this.logContext = DebugFilter.Bsp$.MODULE$;
        this.connectedBspClients = new ConcurrentHashMap();
    }
}

