/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.data.JavaSemanticdbSettings;
import bloop.data.LoadedProject;
import bloop.data.Origin;
import bloop.data.Origin$;
import bloop.data.Project;
import bloop.data.Project$;
import bloop.data.ScalaSemanticdbSettings;
import bloop.data.SemanticdbSettings;
import bloop.data.WorkspaceSettings;
import bloop.data.WorkspaceSettings$;
import bloop.data.WorkspaceSettings$SemanticDBVersionChange$;
import bloop.engine.Build;
import bloop.engine.ExecutionContext$;
import bloop.engine.Feedback$;
import bloop.engine.caches.SemanticDBCache$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ByteHasher$;
import bloop.io.Paths;
import bloop.io.Paths$;
import bloop.io.RelativePath$;
import bloop.logging.DebugFilter;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Coeval;
import monix.eval.Coeval$;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import xsbti.Logger;

public final class BuildLoader$ {
    public static BuildLoader$ MODULE$;
    private final String JsonFilePattern;

    static {
        new BuildLoader$();
    }

    public final String JsonFilePattern() {
        return this.JsonFilePattern;
    }

    public List<Paths.AttributedPath> readConfigurationFilesInBase(Path base, bloop.logging.Logger logger) {
        String workspaceFileName = RelativePath$.MODULE$.toFile$extension(WorkspaceSettings$.MODULE$.settingsFileName()).getName();
        return (List)Paths$.MODULE$.attributedPathFilesUnder(base, this.JsonFilePattern(), (Logger)logger, 1, true).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BuildLoader$.$anonfun$readConfigurationFilesInBase$1(workspaceFileName, x$1)));
    }

    public Task<List<LoadedProject>> loadBuildIncrementally(Path configDir, List<Build.ReadConfiguration> configs, List<Build.InvalidatedInMemoryProject> inMemoryChanged, Option<WorkspaceSettings> settingsForLoad, bloop.logging.Logger logger) {
        Task incrementalLoadTask = Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String loadMsg = new StringBuilder(28).append("Loading ").append(configs.length()).append(" projects from '").append(AbsolutePath$.MODULE$.syntax$extension(configDir)).append("'...").toString();
            logger.debug(loadMsg, (DebugFilter)DebugFilter.All$.MODULE$);
            List rawProjects = (List)configs.map((Function1 & Serializable & scala.Serializable)f -> Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.loadProject(f.bytes(), f.origin(), logger)), List$.MODULE$.canBuildFrom());
            List groupTasks = rawProjects.grouped(10).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((TraversableOnce)group)).toList();
            Task newOrModifiedRawProjects = Task$.MODULE$.sequence((TraversableOnce)groupTasks, List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)fp -> (List)fp.flatten((Function1)Predef$.MODULE$.$conforms()));
            return newOrModifiedRawProjects.flatMap((Function1 & Serializable & scala.Serializable)projects -> {
                Some some;
                Tuple2 tuple2;
                Task task;
                List projectsRequiringMetalsTransformation = (List)projects.$plus$plus((GenTraversableOnce)inMemoryChanged.collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Build.InvalidatedInMemoryProject, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            Project project = A1.project();
                            List<WorkspaceSettings.DetectedChange> changes = A1.changes();
                            if (changes.contains((Object)WorkspaceSettings$SemanticDBVersionChange$.MODULE$)) {
                                object = project;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Build.InvalidatedInMemoryProject x1) {
                        List<WorkspaceSettings.DetectedChange> changes;
                        Build.InvalidatedInMemoryProject invalidatedInMemoryProject = x1;
                        boolean bl = invalidatedInMemoryProject != null && (changes = invalidatedInMemoryProject.changes()).contains((Object)WorkspaceSettings$SemanticDBVersionChange$.MODULE$);
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                Option option = settingsForLoad.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.withSemanticdbSettings());
                if (None$.MODULE$.equals(option)) {
                    task = Task$.MODULE$.now(projectsRequiringMetalsTransformation.map((Function1 & Serializable & scala.Serializable)x$3 -> new LoadedProject.RawProject((Project)x$3), List$.MODULE$.canBuildFrom()));
                } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    WorkspaceSettings settings = (WorkspaceSettings)tuple2._1();
                    SemanticdbSettings semanticdb = (SemanticdbSettings)tuple2._2();
                    task = MODULE$.resolveSemanticDBForProjects((List<Project>)projectsRequiringMetalsTransformation, configDir, semanticdb.javaSemanticdbSettings(), semanticdb.scalaSemanticdbSettings(), logger).map((Function1 & Serializable & scala.Serializable)transformedProjects -> (List)transformedProjects.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        void var2_7;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Project project = (Project)tuple2._1();
                            Option option = (Option)tuple2._2();
                            if (None$.MODULE$.equals(option)) {
                                LoadedProject.RawProject rawProject = new LoadedProject.RawProject(project);
                                return var2_7;
                            }
                        }
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        Project project = (Project)tuple2._1();
                        Option option = (Option)tuple2._2();
                        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
                        Some some = (Some)option;
                        Project original = (Project)some.value();
                        LoadedProject.ConfiguredProject configuredProject = new LoadedProject.ConfiguredProject(project, original, settings);
                        return var2_7;
                    }, List$.MODULE$.canBuildFrom()));
                } else {
                    throw new MatchError((Object)option);
                }
                return task;
            });
        });
        return incrementalLoadTask.flatten(Predef$.MODULE$.$conforms()).executeOn(ExecutionContext$.MODULE$.ioScheduler());
    }

    private Task<List<Tuple2<Project, Option<Project>>>> resolveSemanticDBForProjects(List<Project> rawProjects, Path configDir, Option<JavaSemanticdbSettings> javaSemanticSettings, Option<ScalaSemanticdbSettings> scalaSemanticdbSettings, bloop.logging.Logger logger) {
        Map projectsByScalaVersion = rawProjects.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.scalaInstance().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.version()));
        List enableMetalsInProjectsTask = (List)projectsByScalaVersion.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option scalaVersionOpt = (Option)tuple2._1();
            List projects = (List)tuple2._2();
            Task task = MODULE$.tryEnablingSemanticDB((List<Project>)projects, javaSemanticSettings, (Option<Tuple2<String, ScalaSemanticdbSettings>>)scalaVersionOpt.flatMap((Function1 & Serializable & scala.Serializable)scalaVersion -> scalaSemanticdbSettings.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(scalaVersion, f))), logger, (Function2 & Serializable & scala.Serializable)(scalaPlugin, javaPlugin) -> (List)projects.map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Project$.MODULE$.enableMetalsSettings((Project)p, configDir, (Option<AbsolutePath>)scalaPlugin, (Option<AbsolutePath>)javaPlugin, logger)), (Object)new Some(p)), List$.MODULE$.canBuildFrom())).task();
            return task;
        }, List$.MODULE$.canBuildFrom());
        return Task$.MODULE$.gatherUnordered((TraversableOnce)enableMetalsInProjectsTask).map((Function1 & Serializable & scala.Serializable)x$6 -> (List)x$6.flatten((Function1)Predef$.MODULE$.$conforms()));
    }

    public List<LoadedProject> loadSynchronously(Path configDir, bloop.logging.Logger logger) {
        Option<WorkspaceSettings> settings = WorkspaceSettings$.MODULE$.readFromFile(configDir, logger);
        List configFiles = (List)this.readConfigurationFilesInBase(configDir, logger).map((Function1 & Serializable & scala.Serializable)ap -> {
            byte[] bytes = AbsolutePath$.MODULE$.readAllBytes$extension(ap.path());
            int hash = ByteHasher$.MODULE$.hashBytes(bytes);
            return new Build.ReadConfiguration(Origin$.MODULE$.apply((Paths.AttributedPath)ap, hash), bytes);
        }, List$.MODULE$.canBuildFrom());
        logger.debug(new StringBuilder(28).append("Loading ").append(configFiles.length()).append(" projects from '").append(AbsolutePath$.MODULE$.syntax$extension(configDir)).append("'...").toString(), (DebugFilter)DebugFilter.All$.MODULE$);
        return (List)configFiles.map((Function1 & Serializable & scala.Serializable)f -> {
            void var4_8;
            Project project = MODULE$.loadProject(f.bytes(), f.origin(), logger);
            Option option = settings.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.withSemanticdbSettings());
            if (None$.MODULE$.equals(option)) {
                LoadedProject.RawProject rawProject = new LoadedProject.RawProject(project);
                return var4_8;
            } else {
                LoadedProject.ConfiguredProject value;
                Some some;
                Tuple2 tuple2;
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) throw new MatchError((Object)option);
                WorkspaceSettings settings = (WorkspaceSettings)tuple2._1();
                SemanticdbSettings semanticdb = (SemanticdbSettings)tuple2._2();
                if (semanticdb == null) throw new MatchError((Object)option);
                SemanticdbSettings semanticdbSettings = semanticdb;
                Option scalaSemanticdbVersionAndSettings = project.scalaInstance().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.version()).flatMap((Function1 & Serializable & scala.Serializable)version -> semanticdbSettings.scalaSemanticdbSettings().map((Function1 & Serializable & scala.Serializable)settings -> new Tuple2(version, settings)));
                Coeval coeval = MODULE$.tryEnablingSemanticDB((List<Project>)new .colon.colon((Object)project, (List)Nil$.MODULE$), semanticdbSettings.javaSemanticdbSettings(), (Option<Tuple2<String, ScalaSemanticdbSettings>>)scalaSemanticdbVersionAndSettings, logger, (Function2 & Serializable & scala.Serializable)(scalaPlugin, javaPlugin) -> new LoadedProject.ConfiguredProject(Project$.MODULE$.enableMetalsSettings(project, configDir, (Option<AbsolutePath>)scalaPlugin, (Option<AbsolutePath>)javaPlugin, logger), project, settings));
                Either either = coeval.run();
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable value2 = (Throwable)left.value();
                    throw value2;
                }
                if (!(either instanceof Right)) {
                    throw new MatchError((Object)either);
                }
                Right right = (Right)either;
                LoadedProject.ConfiguredProject configuredProject = value = (LoadedProject.ConfiguredProject)right.value();
                LoadedProject.ConfiguredProject configuredProject2 = configuredProject;
            }
            return var4_8;
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<AbsolutePath> tryEnablingJavaSemanticDB(List<Project> projects, JavaSemanticdbSettings javaSemanticSettings, bloop.logging.Logger logger) {
        None$ none$;
        Either<String, AbsolutePath> either = SemanticDBCache$.MODULE$.fetchJavaPlugin(javaSemanticSettings.semanticDBVersion(), logger);
        if (either instanceof Right) {
            Right right = (Right)either;
            Path path = ((AbsolutePath)right.value()).underlying();
            logger.debug(Feedback$.MODULE$.configuredMetalsJavaProjects((Traversable<Project>)projects), (DebugFilter)DebugFilter.All$.MODULE$);
            none$ = new Some((Object)new AbsolutePath(path));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            String cause = (String)left.value();
            logger.displayWarningToUser(Feedback$.MODULE$.failedMetalsJavaConfiguration(cause));
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(either);
        }
        return none$;
    }

    private Option<AbsolutePath> tryEnablingScalaSemanticDB(List<Project> projects, Tuple2<String, ScalaSemanticdbSettings> scalaSemanticdbVersionAndSettings, bloop.logging.Logger logger) {
        None$ none$;
        boolean isUnsupportedVersion;
        Tuple2<String, ScalaSemanticdbSettings> tuple2 = scalaSemanticdbVersionAndSettings;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String scalaVersion = (String)tuple2._1();
        ScalaSemanticdbSettings scalaSemanticdbSettings = (ScalaSemanticdbSettings)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)scalaVersion, (Object)scalaSemanticdbSettings);
        Tuple2 tuple23 = tuple22;
        String scalaVersion2 = (String)tuple23._1();
        ScalaSemanticdbSettings scalaSemanticdbSettings2 = (ScalaSemanticdbSettings)tuple23._2();
        boolean bl = isUnsupportedVersion = !scalaSemanticdbSettings2.supportedScalaVersions().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)scalaVersion2.startsWith(x$10)));
        if (isUnsupportedVersion) {
            if (!scalaVersion2.startsWith("3.")) {
                logger.debug(Feedback$.MODULE$.skippedUnsupportedScalaMetals(scalaVersion2), (DebugFilter)DebugFilter.All$.MODULE$);
            }
            none$ = None$.MODULE$;
        } else {
            None$ none$2;
            Either<String, AbsolutePath> either = SemanticDBCache$.MODULE$.fetchScalaPlugin(scalaVersion2, scalaSemanticdbSettings2.semanticDBVersion(), logger);
            if (either instanceof Right) {
                Right right = (Right)either;
                Path path = ((AbsolutePath)right.value()).underlying();
                logger.debug(Feedback$.MODULE$.configuredMetalsScalaProjects((Traversable<Project>)projects), (DebugFilter)DebugFilter.All$.MODULE$);
                none$2 = new Some((Object)new AbsolutePath(path));
            } else if (either instanceof Left) {
                Left left = (Left)either;
                String cause = (String)left.value();
                logger.displayWarningToUser(Feedback$.MODULE$.failedMetalsScalaConfiguration(scalaVersion2, cause));
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError(either);
            }
            none$ = none$2;
        }
        return none$;
    }

    private <T> Coeval<T> tryEnablingSemanticDB(List<Project> projects, Option<JavaSemanticdbSettings> javaSemanticSettings, Option<Tuple2<String, ScalaSemanticdbSettings>> scalaSemanticdbVersionAndSettings, bloop.logging.Logger logger, Function2<Option<AbsolutePath>, Option<AbsolutePath>, T> enableMetals) {
        return Coeval$.MODULE$.eval((Function0 & Serializable & scala.Serializable)() -> {
            Option javaSemanticdbPath = javaSemanticSettings.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.tryEnablingJavaSemanticDB(projects, (JavaSemanticdbSettings)x$11, logger));
            Option scalaSemanticdbPath = scalaSemanticdbVersionAndSettings.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.tryEnablingScalaSemanticDB(projects, (Tuple2<String, ScalaSemanticdbSettings>)x$12, logger));
            return enableMetals.apply((Object)scalaSemanticdbPath, (Object)javaSemanticdbPath);
        });
    }

    private Project loadProject(byte[] bytes, Origin origin, bloop.logging.Logger logger) {
        return Project$.MODULE$.fromBytesAndOrigin(bytes, origin, logger);
    }

    public static final /* synthetic */ boolean $anonfun$readConfigurationFilesInBase$1(String workspaceFileName$1, Paths.AttributedPath x$1) {
        String string = AbsolutePath$.MODULE$.toFile$extension(x$1.path()).getName();
        String string2 = workspaceFileName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private BuildLoader$() {
        MODULE$ = this;
        this.JsonFilePattern = "glob:**.json";
    }
}

