/*
 * Decompiled with CFR 0.152.
 */
package bloop.testing;

import bloop.DependencyResolution;
import bloop.DependencyResolution$;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus$;
import bloop.config.Config;
import bloop.engine.ExecutionContext$;
import bloop.exec.Forker$;
import bloop.exec.JvmProcessForker;
import bloop.io.AbsolutePath;
import bloop.logging.DebugFilter;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.testing.BloopTestSuiteEventHandler;
import bloop.testing.FingerprintInfo;
import bloop.testing.LoggingEventHandler;
import bloop.testing.TestServer;
import ch.epfl.scala.debugadapter.testing.TestSuiteEvent;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.regex.Pattern;
import monix.execution.CancelableFuture;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import sbt.ForkMain;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.classpath.ClassFilter;
import sbt.internal.inc.classpath.FilteredLoader;
import sbt.internal.inc.classpath.IncludePackagesFilter;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Logger;
import sbt.testing.Runner;
import sbt.testing.SubclassFingerprint;
import sbt.testing.TaskDef;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;
import xsbt.api.Discovered;
import xsbti.api.ClassLike;
import xsbti.api.Companions;
import xsbti.api.Definition;
import xsbti.compile.CompileAnalysis;

public final class TestInternals$ {
    public static TestInternals$ MODULE$;
    private FilteredLoader filteredLoader;
    private final DebugFilter logContext;
    private volatile Option<Path[]> testAgentFiles;
    private volatile boolean bitmap$0;

    static {
        new TestInternals$();
    }

    private final String sbtOrg() {
        return "org.scala-sbt";
    }

    private final String testAgentId() {
        return "test-agent";
    }

    private final String testAgentVersion() {
        return "1.8.0";
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    private Option<Path[]> testAgentFiles() {
        return this.testAgentFiles;
    }

    private void testAgentFiles_$eq(Option<Path[]> x$1) {
        this.testAgentFiles = x$1;
    }

    private FilteredLoader filteredLoader$lzycompute() {
        TestInternals$ testInternals$ = this;
        synchronized (testInternals$) {
            if (!this.bitmap$0) {
                IncludePackagesFilter filter = new IncludePackagesFilter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdk.", "java.", "javax.", "sun.", "sbt.testing.", "org.scalatools.testing.", "org.xml.sax."})));
                this.filteredLoader = new FilteredLoader(this.getClass().getClassLoader(), (ClassFilter)filter);
                this.bitmap$0 = true;
            }
        }
        return this.filteredLoader;
    }

    public FilteredLoader filteredLoader() {
        if (!this.bitmap$0) {
            return this.filteredLoader$lzycompute();
        }
        return this.filteredLoader;
    }

    public Function1<String, Object> parseFilters(List<String> filters) {
        Tuple2 tuple2 = filters.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List exclusionFilters = (List)tuple2._1();
        List inclusionFilters = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exclusionFilters, (Object)inclusionFilters);
        List exclusionFilters2 = (List)tuple22._1();
        List inclusionFilters2 = (List)tuple22._2();
        List inc = (List)inclusionFilters2.map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.toPattern((String)filter), List$.MODULE$.canBuildFrom());
        List exc = (List)exclusionFilters2.map((Function1 & Serializable & scala.Serializable)f -> MODULE$.toPattern((String)new StringOps(Predef$.MODULE$.augmentString(f)).tail()), List$.MODULE$.canBuildFrom());
        Tuple2 tuple23 = new Tuple2((Object)inc, (Object)exc);
        if (tuple23 != null) {
            List list = (List)tuple23._1();
            List list2 = (List)tuple23._2();
            if (Nil$.MODULE$.equals(list) && Nil$.MODULE$.equals(list2)) {
                return (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$parseFilters$4(x$3));
            }
        }
        if (tuple23 != null) {
            List inc2 = (List)tuple23._1();
            List list = (List)tuple23._2();
            if (Nil$.MODULE$.equals(list)) {
                return (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)inc2.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$parseFilters$6(s, x$4))));
            }
        }
        if (tuple23 != null) {
            List list = (List)tuple23._1();
            List exc2 = (List)tuple23._2();
            if (Nil$.MODULE$.equals(list)) {
                return (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$parseFilters$7(exc2, s));
            }
        }
        if (tuple23 != null) {
            List inc3 = (List)tuple23._1();
            List exc3 = (List)tuple23._2();
            return (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$parseFilters$9(inc3, exc3, s));
        }
        throw new MatchError((Object)tuple23);
    }

    public AbsolutePath[] lazyTestAgents(bloop.logging.Logger logger) {
        Option<Path[]> option = this.testAgentFiles();
        if (option instanceof Some) {
            Some some = (Some)option;
            AbsolutePath[] paths = (AbsolutePath[])some.value();
            return paths;
        }
        if (None$.MODULE$.equals(option)) {
            AbsolutePath[] paths = DependencyResolution$.MODULE$.resolve((List)new .colon.colon((Object)new DependencyResolution.Artifact("org.scala-sbt", "test-agent", "1.8.0"), (List)Nil$.MODULE$), logger, DependencyResolution$.MODULE$.resolve$default$3(), DependencyResolution$.MODULE$.resolve$default$4());
            this.testAgentFiles_$eq((Option<Path[]>)new Some((Object)paths));
            return paths;
        }
        throw new MatchError(option);
    }

    public Task<Object> execute(Path cwd, JvmProcessForker forker, ClassLoader classLoader, Map<Framework, List<TaskDef>> discovered, List<Config.TestArgument> args, List<String> jvmOptions, List<String> envVariables, BloopTestSuiteEventHandler testEventHandler, bloop.logging.Logger logger, CommonOptions opts) {
        logger.debug("Starting forked test execution...", this.logContext());
        AbsolutePath[] agentFiles = this.lazyTestAgents(logger);
        TestServer server = new TestServer(logger, testEventHandler, classLoader, discovered, args, opts);
        String forkMain = ForkMain.class.getCanonicalName();
        String[] arguments = (String[])((Object[])new String[]{Integer.toString(server.port())});
        AbsolutePath[] testAgentJars = (AbsolutePath[])Predef$.MODULE$.genericArrayOps((Object)agentFiles).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$execute$1(((AbsolutePath)x$8).underlying())));
        logger.debug(new StringBuilder(17).append("Test agent JARs: ").append(Predef$.MODULE$.genericArrayOps((Object)testAgentJars).mkString(", ")).toString(), this.logContext());
        AtomicBoolean cancelled = AtomicBoolean$.MODULE$.apply(false);
        TestServer.TestOrchestrator listener = server.listenToTests();
        Task runTask = forker.runMain(cwd, forkMain, arguments, (String[])jvmOptions.toArray(ClassTag$.MODULE$.apply(String.class)), envVariables, logger, opts, testAgentJars);
        Task runner = runTask.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)exitCode -> Forker$.MODULE$.exitStatus(exitCode).code());
        CancelableFuture listenerHandle = listener.reporter().runAsync(ExecutionContext$.MODULE$.ioScheduler());
        return listener.startServer().$times$greater((Function0 & Serializable & scala.Serializable)() -> runner.executeOn(ExecutionContext$.MODULE$.ioScheduler(), runner.executeOn$default$2()).doOnCancel((Function0 & Serializable & scala.Serializable)() -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TestInternals$.cancel$1(cancelled, listenerHandle))));
    }

    public Task<Object> runJsTestsInProcess(Map<Framework, List<TaskDef>> discovered0, List<Config.TestArgument> args, LoggingEventHandler failureHandler, Function0<Object> checkCancelled, bloop.logging.Logger logger) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            List discovered = (List)discovered0.toList().sortBy((Function1 & Serializable & scala.Serializable)x$9 -> ((Framework)x$9._1()).name(), (Ordering)Ordering.String$.MODULE$);
            discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TestInternals$.$anonfun$runJsTestsInProcess$3(args, checkCancelled, logger, failureHandler, x0$1);
                return BoxedUnit.UNIT;
            });
            return ExitStatus$.MODULE$.Ok().code();
        });
    }

    public Option<Framework> loadFramework(ClassLoader l, List<String> fqns, bloop.logging.Logger logger) {
        List<String> list = fqns;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String head = (String)colon2.head();
            List tail = colon2.tl$access$1();
            return this.loadFramework(l, head, logger).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.loadFramework(l, (List<String>)tail, logger));
        }
        if (Nil$.MODULE$.equals(list)) {
            return None$.MODULE$;
        }
        throw new MatchError(list);
    }

    public Tuple2<List<FingerprintInfo<SubclassFingerprint>>, List<FingerprintInfo<AnnotatedFingerprint>>> getFingerprints(Seq<Framework> frameworks) {
        LinkedHashSet subclasses = LinkedHashSet$.MODULE$.empty();
        LinkedHashSet annotated = LinkedHashSet$.MODULE$.empty();
        frameworks.foreach((Function1 & Serializable & scala.Serializable)framework -> {
            TestInternals$.$anonfun$getFingerprints$1(subclasses, annotated, framework);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)subclasses.toList(), (Object)annotated.toList());
    }

    public List<FingerprintInfo<Fingerprint>> matchingFingerprints(List<FingerprintInfo<SubclassFingerprint>> subclassPrints, List<FingerprintInfo<AnnotatedFingerprint>> annotatedPrints, Discovered d) {
        return (List)this.defined(subclassPrints, (Set<String>)d.baseClasses(), d.isModule()).$plus$plus(this.defined(annotatedPrints, (Set<String>)d.annotations(), d.isModule()), List$.MODULE$.canBuildFrom());
    }

    public Runner getRunner(Framework framework, List<Config.TestArgument> args0, ClassLoader testClassLoader) {
        String[] args = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args0.toArray(ClassTag$.MODULE$.apply(Config.TestArgument.class)))).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.args(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return framework.runner(args, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), testClassLoader);
    }

    public Seq<ClassLike> potentialTests(CompileAnalysis analysis) {
        Seq<Definition> all = this.allDefs(analysis);
        return (Seq)all.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Definition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ClassLike classLike;
                A1 A1 = x1;
                if (A1 instanceof ClassLike && (classLike = (ClassLike)A1).topLevel()) {
                    return (B1)classLike;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Definition x1) {
                ClassLike classLike;
                Definition definition = x1;
                return definition instanceof ClassLike && (classLike = (ClassLike)definition).topLevel();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Definition> allDefs(CompileAnalysis analysis) {
        CompileAnalysis compileAnalysis = analysis;
        if (compileAnalysis instanceof Analysis) {
            Analysis analysis2 = (Analysis)compileAnalysis;
            Vector acs = analysis2.apis().internal().values().toVector();
            return (Seq)acs.flatMap((Function1 & Serializable & scala.Serializable)ac -> {
                Companions companions = ac.api();
                Seq all = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon((Object)companions.classApi(), (List)new .colon.colon((Object)companions.objectApi(), (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])companions.classApi().structure().declared())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])companions.classApi().structure().inherited())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])companions.objectApi().structure().declared())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])companions.objectApi().structure().inherited())), Seq$.MODULE$.canBuildFrom());
                return all;
            }, Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)compileAnalysis);
    }

    private <T extends Fingerprint> List<FingerprintInfo<T>> defined(List<FingerprintInfo<T>> in, Set<String> names, boolean IsModule) {
        return (List)in.collect((PartialFunction)new scala.Serializable(IsModule, names){
            public static final long serialVersionUID = 0L;
            private final boolean IsModule$1;
            private final Set names$1;

            public final <A1 extends FingerprintInfo<T>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String name = A1.name();
                    boolean bl = A1.isModule();
                    if (this.IsModule$1 == bl && this.names$1.apply((Object)name)) {
                        return (B1)A1;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FingerprintInfo<T> x1) {
                FingerprintInfo<T> fingerprintInfo = x1;
                if (fingerprintInfo != null) {
                    String name = fingerprintInfo.name();
                    boolean bl = fingerprintInfo.isModule();
                    if (this.IsModule$1 == bl && this.names$1.apply((Object)name)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.IsModule$1 = IsModule$1;
                this.names$1 = names$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<Framework> loadFramework(ClassLoader loader, String fqn, bloop.logging.Logger logger) {
        None$ none$;
        block6: {
            try {
                Object obj = Class.forName(fqn, true, loader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj instanceof Framework) {
                    Object obj2 = obj;
                    none$ = new Some(obj2);
                    break block6;
                }
                if (obj instanceof org.scalatools.testing.Framework) {
                    logger.warn(new StringBuilder(34).append("Old frameworks are not supported: ").append(fqn).toString());
                    none$ = None$.MODULE$;
                    break block6;
                }
                throw new MatchError(obj);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ClassNotFoundException) {
                    none$ = None$.MODULE$;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    logger.report(new StringBuilder(40).append("Initialisation of test framework ").append(fqn).append(" failed").toString(), t);
                    none$ = None$.MODULE$;
                }
                throw throwable;
            }
        }
        return none$;
    }

    private Pattern toPattern(String filter) {
        String[] parts = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.split("\\*", -1))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            if ("".equals(string)) {
                return "";
            }
            return Pattern.quote(string);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return Pattern.compile(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).mkString(".*"));
    }

    public static final /* synthetic */ boolean $anonfun$parseFilters$4(String x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parseFilters$6(String s$1, Pattern x$4) {
        return x$4.matcher(s$1).matches();
    }

    public static final /* synthetic */ boolean $anonfun$parseFilters$8(String s$2, Pattern x$5) {
        return x$5.matcher(s$2).matches();
    }

    public static final /* synthetic */ boolean $anonfun$parseFilters$7(List exc$1, String s) {
        return !exc$1.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$parseFilters$8(s, x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$parseFilters$10(String s$3, Pattern x$6) {
        return x$6.matcher(s$3).matches();
    }

    public static final /* synthetic */ boolean $anonfun$parseFilters$11(String s$3, Pattern x$7) {
        return x$7.matcher(s$3).matches();
    }

    public static final /* synthetic */ boolean $anonfun$parseFilters$9(List inc$2, List exc$2, String s) {
        return inc$2.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$parseFilters$10(s, x$6))) && !exc$2.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$parseFilters$11(s, x$7)));
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(Path x$8) {
        return ((Object)x$8).toString().endsWith(".jar");
    }

    private static final void cancel$1(AtomicBoolean cancelled$1, CancelableFuture listenerHandle$1) {
        if (!cancelled$1.getAndSet(true)) {
            listenerHandle$1.cancel();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$runJsTestsInProcess$4(String frameworkClass$1, Config.TestArgument arg) {
        Option option = arg.framework();
        if (option instanceof Some) {
            Some some = (Some)option;
            Config.TestFramework f = (Config.TestFramework)some.value();
            return f.names().contains((Object)frameworkClass$1);
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$runJsTestsInProcess$5(Function0 checkCancelled$1, Framework framework$1, List fargs$1, bloop.logging.Logger logger$1, LoggingEventHandler failureHandler$1, TaskDef testSuite) {
        if (!checkCancelled$1.apply$mcZ$sp()) {
            Runner runner = MODULE$.getRunner(framework$1, (List<Config.TestArgument>)fargs$1, null);
            ListBuffer events0 = new ListBuffer();
            ListBuffer tasks = new ListBuffer();
            tasks.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])runner.tasks((TaskDef[])((Object[])new TaskDef[]{testSuite})))));
            while (tasks.nonEmpty()) {
                sbt.testing.Task t = (sbt.testing.Task)tasks.head();
                tasks.remove(0);
                sbt.testing.Task[] next = t.execute(e -> events0.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Event[]{e})), (Logger[])((Object[])new Logger[]{logger$1}));
                tasks.prependAll((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])next)));
            }
            String summary = runner.done();
            if (new StringOps(Predef$.MODULE$.augmentString(summary)).nonEmpty()) {
                String summaryToPrint = logger$1.ansiCodesSupported() ? summary : summary.replaceAll("\u001b\\[[;\\d]*m", "");
                logger$1.info(new StringBuilder(9).append("Summary: ").append(summaryToPrint).toString());
            }
            List events = events0.toList();
            failureHandler$1.handle((TestSuiteEvent)new TestSuiteEvent.Results(testSuite.fullyQualifiedName(), events));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$runJsTestsInProcess$3(List args$1, Function0 checkCancelled$1, bloop.logging.Logger logger$1, LoggingEventHandler failureHandler$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Framework framework = (Framework)tuple2._1();
            List testSuites = (List)tuple2._2();
            String frameworkClass = framework.getClass().getName();
            List fargs = (List)args$1.filter((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToBoolean((boolean)TestInternals$.$anonfun$runJsTestsInProcess$4(frameworkClass, arg)));
            if (!checkCancelled$1.apply$mcZ$sp()) {
                testSuites.foreach((Function1 & Serializable & scala.Serializable)testSuite -> {
                    TestInternals$.$anonfun$runJsTestsInProcess$5(checkCancelled$1, framework, fargs, logger$1, failureHandler$1, testSuite);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getFingerprints$1(LinkedHashSet subclasses$1, LinkedHashSet annotated$1, Framework framework) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])framework.fingerprints())).foreach((Function1 & Serializable & scala.Serializable)fingerprint -> {
            Fingerprint fingerprint2 = fingerprint;
            if (fingerprint2 instanceof SubclassFingerprint) {
                SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint2;
                return subclasses$1.$plus$eq(new FingerprintInfo<SubclassFingerprint>(subclassFingerprint.superclassName(), subclassFingerprint.isModule(), framework, subclassFingerprint));
            }
            if (fingerprint2 instanceof AnnotatedFingerprint) {
                AnnotatedFingerprint annotatedFingerprint = (AnnotatedFingerprint)fingerprint2;
                return annotated$1.$plus$eq(new FingerprintInfo<AnnotatedFingerprint>(annotatedFingerprint.annotationName(), annotatedFingerprint.isModule(), framework, annotatedFingerprint));
            }
            throw new MatchError((Object)fingerprint2);
        });
    }

    private TestInternals$() {
        MODULE$ = this;
        this.logContext = DebugFilter.Test$.MODULE$;
        this.testAgentFiles = None$.MODULE$;
    }
}

